/* $Id$ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __EXIT_STAT_HPP_INCLUDED
#define __EXIT_STAT_HPP_INCLUDED

#include "frontend/ast/ConditionedStat.hpp"
#include "frontend/ast/SimpleName.hpp"
#include "frontend/ast/LoopStat.hpp"

namespace ast {

//! a VHDL exit statement.
/** This class represent a VHDL exit statement. */
class ExitStat : public ConditionedStat {
public:
	//! c'tor
	/** @param optLoopLbl optional label referring to the enclosing loop
	 *  @param optCond optional condition.
	 *  @param loc location of the ExitStat.
	 */
	ExitStat(
		SimpleName *optLoopLbl,
		Expression *optCond,
		Location loc
		) : 	ConditionedStat(optCond, loc), 
			loopLabel(optLoopLbl),
			referredLoop(NULL) {}

	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor& visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		stream << "EXIT";
		if (this->loopLabel) {
			stream << ' ' << this->loopLabel;
		}
		if (this->condition) {
			stream << " if " << this->condition;
		}
	}


	/** label referring to the loop */
	SimpleName *loopLabel;

	/** loop statement being referred to */
	LoopStat *referredLoop;

protected:
	/** Destructor */
	virtual ~ExitStat() {
		util::MiscUtil::terminate(loopLabel);
		//FIXME cycle!
		util::MiscUtil::terminate(referredLoop);
	}
};

}; /* namespace ast */

#endif /* __EXIT_STAT_HPP_INCLUDED */
