/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#ifndef __console_iterator
#define __console_iterator

#include <console.h>
#include <string>

struct console_iterator {

  console& con;
  char delim;

  console_iterator (console& c, char delim = ' ');

  console_iterator& operator* ();
  console_iterator& operator++ ();
  console_iterator& operator++ (int);

  template <typename T> console_iterator& operator= (const T& t) {
    con << t;
    return *this;
  }

};

#endif
