/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/unittest/test_system/list_test_suite_traversal.cpp
 *
 * @brief [LEVEL: beta] Implementation of @ref diagnostics::unittest::List_Test_Suite_Traversal class
 *
 * $Id: list_test_suite_traversal.cpp,v 1.7 2005/06/23 09:54:26 esdentem Exp $
 * 
 * @author Christian Schallhart
 */

#include <diagnostics/unittest/test_system/list_test_suite_traversal.hpp>

#include <diagnostics/unittest/test_case.hpp>
#include <diagnostics/unittest/test_system/test_list_result.hpp>
#include <diagnostics/unittest/name_separators.hpp>

DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;

List_Test_Suite_Traversal::~List_Test_Suite_Traversal()
{
}

List_Test_Suite_Traversal::List_Test_Suite_Traversal(Test_List_Results_t & results)
    : m_results(results)
{
}


void List_Test_Suite_Traversal::visit_hook(Test_Case const & test_case,
					  Path_t const & path,
					  Level_t const level)
{
    ::std::string test_case_path;
    Path_t::const_iterator current(path.begin());
    Path_t::const_iterator const end(path.end());
    
    // take care of empty name in the root suite.
    if(current->size()!=0) test_case_path+=DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR;
    
    for(;current!=end;++current) test_case_path+= (*current) + DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR;
    test_case_path+=test_case.name();

    m_results.push_back(new Test_List_Result(test_case_path,
					     test_case.timeout(),
					     test_case.is_rerunable(),
					     test_case.is_testable_at(LEVEL_PROD),
					     test_case.is_testable_at(LEVEL_DEBUG),
					     test_case.is_testable_at(LEVEL_AUDIT)));
}


UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;
// vim:ts=4:sw=4
