import dataclasses
import typing
from collections.abc import Sequence

from debian.deb822 import PkgRelation

from debputy.manifest_conditions import ManifestCondition
from debputy.manifest_parser.base_types import FileSystemMode
from debputy.manifest_parser.util import AttributePath


@dataclasses.dataclass(slots=True)
class DebputyCapability:
    capabilities: str
    capability_mode: FileSystemMode
    definition_source: str


class MatchedBuiltUsingRelation(typing.NamedTuple):
    is_first: bool
    relationship: "PkgRelation.ParsedRelation"


class BuiltUsingItem(typing.NamedTuple):
    matched_packages: Sequence[MatchedBuiltUsingRelation]
    conditional: ManifestCondition | None
    attribute_path: AttributePath


class StaticBuiltUsing(tuple[BuiltUsingItem, ...]):
    pass


class BuiltUsing(tuple[BuiltUsingItem, ...]):
    pass
