Cura Documentation
====
Welcome to the Cura documentation pages.

Objective
----
The goal of this documentation is to give an overview of the architecture of Cura's source code. The purpose of this overview is to make programmers familiar with Cura's source code so that they may contribute more easily, write plug-ins more easily or get started within the Cura team more quickly.

There are some caveats though. These are *not* within the scope of this documentation:
* There is no documentation on individual functions or classes of the code here. For that, refer to the Doxygen documentation and Python Docstrings in the source code itself, or generate the documentation locally using Doxygen.
* It's virtually impossible and indeed not worth the effort or money to keep this 100% up to date.
* There are no example plug-ins here. There are a number of example plug-ins in the Ultimaker organisation on Github.com to draw from.
* The slicing process is not documented here. Refer to CuraEngine for that.

This documentation will touch on the inner workings of Uranium as well though, due to the nature of the architecture.

Index
----
The following chapters are available in this documentation:
* [Repositories](repositories.md): An overview of the repositories that together make up the Cura application.
* [Profiles](profiles/profiles.md): About the setting and profile system of Cura.
* [Scene](scene/scene.md): How Cura's 3D scene looks.