/*
 * Copyright (c) 2019 Uber Technologies, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "jaegertracing/thrift-gen/BaggageRestrictionManager.h"
#include "jaegertracing/thrift-gen/sampling_types.h"

namespace jaegertracing {

// trivial constructors of BaggageRestrictionManager thrift generated code are not generated by MSVC
#ifdef _MSC_VER

namespace thrift {

BaggageRestrictionManager_getBaggageRestrictions_args::
    BaggageRestrictionManager_getBaggageRestrictions_args(
        const BaggageRestrictionManager_getBaggageRestrictions_args& that)
    : serviceName(that.serviceName)
{
}

BaggageRestrictionManager_getBaggageRestrictions_args&
BaggageRestrictionManager_getBaggageRestrictions_args::
operator=(const BaggageRestrictionManager_getBaggageRestrictions_args& that)
{
    this->serviceName = that.serviceName;
    return *this;
}

BaggageRestrictionManager_getBaggageRestrictions_result::
    BaggageRestrictionManager_getBaggageRestrictions_result(
        const BaggageRestrictionManager_getBaggageRestrictions_result& that)
    : success(that.success)
    , __isset(that.__isset)
{
}
BaggageRestrictionManager_getBaggageRestrictions_result&
BaggageRestrictionManager_getBaggageRestrictions_result::
operator=(const BaggageRestrictionManager_getBaggageRestrictions_result& that)
{
    this->success = that.success;
    return *this;
}

}  // namespace thrift

#endif // MSVC

namespace sampling_manager {
namespace thrift {

const std::map<int, const char*>& samplingStrategyType_VALUES_TO_NAMES()
{
    return _SamplingStrategyType_VALUES_TO_NAMES;
}

}  // namespace thrift
}  // namespace sampling_manager
}  // namespace jaegertracing
