/*
   Bacula(R) - The Network Backup Solution

   Copyright (C) 2000-2020 Kern Sibbald

   The original author of Bacula is Kern Sibbald, with contributions
   from many others, a complete list can be found in the file AUTHORS.

   You may use this file and others of this release according to the
   license defined in the LICENSE file, which includes the Affero General
   Public License, v3.0 ("AGPLv3") and some additional permissions and
   terms pursuant to its AGPLv3 Section 7.

   This notice must be preserved when any source code is
   conveyed and/or propagated.

   Bacula(R) is a registered trademark of Kern Sibbald.
*/

import QtQuick 2.10
import QtQuick.Window 2.10
import QtQuick.Layouts 1.3
import QtQuick.Controls 2.3
import QtQuick.Controls.Material 2.1
import QtQuick.Dialogs 1.2
import io.qt.bmob.traycontroller 1.0

Page {
   id: configTutorialPage
   visible: true

   // Our C++ component
   TrayUiController {
      id: controller

      // Events triggered by our c++ code
      onClientsChanged: {
         //
      }

      onDirectorsChanged: {
         //
      }

      onStoragesChanged: {
         //
      }

      onInfoDialogTextChanged: {
         infoDialog.text = controller.infoDialogText
         infoDialog.open()
      }

      onFdTraceChanged: {
         //
      }

      Component.onCompleted: {
         //
      }
   }

   background: Rectangle {
      color: "#d32f2f"
   }

   GridLayout {
       id: configGrid
       columns: 2
       anchors.left: parent.left
       anchors.right: parent.right
       anchors.top: parent.top
       anchors.bottom: configText.top
       anchors.topMargin: 24
       anchors.bottomMargin: 24
       anchors.leftMargin: 16
       anchors.rightMargin: 16

       Image {
          source: "images/ss_trayconf.jpg"
          Layout.preferredWidth: configGrid.width / 2
          Layout.preferredHeight:  configGrid.height / 2

          Rectangle {
             anchors.fill: parent
             anchors.margins: -border.width
             z: -1
             border.width: 1
             color: "#000"
          }
       }

       Image {
          source: "images/ss_resconf.jpg"
          Layout.preferredWidth: configGrid.width / 2
          Layout.preferredHeight:  configGrid.height / 2

          Rectangle {
             anchors.fill: parent
             anchors.margins: -border.width
             z: -1
             border.width: 1
             color: "#000"
          }
       }

       Image {
          source: "images/ss_fdconf.jpg"
          Layout.preferredWidth: configGrid.width / 2
          Layout.preferredHeight:  configGrid.height / 2

          Rectangle {
             anchors.fill: parent
             anchors.margins: -border.width
             z: -1
             border.width: 1
             color: "#000"
          }
       }

       Image {
          source: "images/ss_qrcode.jpg"
          Layout.preferredWidth: configGrid.width / 2
          Layout.preferredHeight: configGrid.height / 2

          Rectangle {
             anchors.fill: parent
             anchors.margins: -border.width
             z: -1
             border.width: 1
             color: "#000"
          }
       }
    }

   Text {
      id: configText
      text: "It's possible to automatically configure Bacula resources by scanning a QRCode generated by BWeb. Alternatively, those resources can be added manually."
      wrapMode: TextEdit.WordWrap
      font.pixelSize: 18
      color: "white"

      anchors.bottom: nextButton.top
      anchors.left: parent.left
      anchors.right: parent.right
      anchors.bottomMargin: 16
      anchors.leftMargin: 16
      anchors.rightMargin: 16
   }

   ToolButton {
      id: prevButton
      onClicked: {
         tutorialSwipe.currentIndex = 0
      }
      anchors.left: parent.left
      anchors.bottom: parent.bottom
      anchors.leftMargin: 16
      anchors.bottomMargin: 16

      contentItem: Text {
         text: qsTr("<")
         font.pixelSize: 28
         opacity: enabled ? 1.0 : 0.3
         color: "white"
      }

      background: Rectangle {
         color: parent.down ? "#b71c1c" : "#d32f2f"
      }
   }

   ToolButton {
      id: nextButton
      onClicked: {
         stackView.push(Qt.resolvedUrl("MainMenuPage.qml"))
      }
      anchors.right: parent.right
      anchors.bottom: parent.bottom
      anchors.rightMargin: 16
      anchors.bottomMargin: 16

      contentItem: Text {
         text: qsTr(">")
         font.pixelSize: 28
         opacity: enabled ? 1.0 : 0.3
         color: "white"
      }

      background: Rectangle {
         color: parent.down ? "#b71c1c" : "#d32f2f"
      }
   }

   Rectangle {
      visible: IS_ENTERPRISE
      id: scanButton
      height: childrenRect.height
      width: childrenRect.width
      anchors.horizontalCenter: parent.horizontalCenter
      anchors.bottom: parent.bottom
      anchors.bottomMargin: 17
      color: clickArea.pressed ? "#6d6d6d" : "#000"

      Text {
         text: qsTr("Scan QRCode")
         padding: 12
         anchors.horizontalCenter: parent.horizontalCenter
         verticalAlignment: Text.AlignVCenter
         font.pixelSize: 18
         color: "white"
      }
   }

   MouseArea {
      visible: IS_ENTERPRISE
      id: clickArea
      anchors.left: scanButton.left
      anchors.right: scanButton.right
      anchors.top: scanButton.top
      anchors.bottom: scanButton.bottom

      onClicked: controller.startQRCodeReader()
   }

   MessageDialog {
      id: infoDialog
      modality: Qt.ApplicationModal
      standardButtons: StandardButton.Ok
      visible: false

      onAccepted: {
         stackView.push(Qt.resolvedUrl("MainMenuPage.qml"))
      }
   }
}
