# Print Mono libraries required by given package.
# USAGE: dependencies_mono_list $package
dependencies_mono_list() {
	local package
	package="$1"

	local dependencies_mono
	dependencies_mono=$(context_value "${package}_DEPENDENCIES_MONO_LIBRARIES")

	printf '%s' "$dependencies_mono" | list_clean
}

# Print native packages providing Mono libraries required by given package.
# USAGE: dependencies_mono_list_packages $package
dependencies_mono_list_packages() {
	local package
	package="$1"

	local dependencies_mono
	dependencies_mono=$(dependencies_mono_list "$package")
	# Return early if current package does not require any Mono library.
	if [ -z "$dependencies_mono" ]; then
		return 0
	fi

	local option_package
	option_package=$(option_value 'package')
	case "$option_package" in
		('arch')
			dependencies_mono_list_archlinux "$dependencies_mono"
		;;
		('deb')
			dependencies_mono_list_debian "$dependencies_mono"
		;;
		('gentoo')
			dependencies_mono_list_gentoo "$dependencies_mono"
		;;
	esac
}

# Print the path to a temporary files used for unknown Mono libraries listing
# USAGE: dependencies_unknown_mono_libraries_file
dependencies_unknown_mono_libraries_file() {
	printf '%s/unknown_mono_libraries_list' "$PLAYIT_WORKDIR"
}

# Print a list of unknown Mono libraries
# USAGE: dependencies_unknown_mono_libraries_list
dependencies_unknown_mono_libraries_list() {
	local unknown_library unknown_libraries_list
	unknown_libraries_list=$(dependencies_unknown_mono_libraries_file)

	# Return early if there is no unknown library
	if [ ! -e "$unknown_libraries_list" ]; then
		return 0
	fi

	list_clean < "$unknown_libraries_list"
}

# Clear the list of unknown Mono libraries
# USAGE: dependencies_unknown_mono_libraries_clear
dependencies_unknown_mono_libraries_clear() {
	local unknown_library unknown_libraries_list
	unknown_libraries_list=$(dependencies_unknown_mono_libraries_file)

	rm --force "$unknown_libraries_list"
}

# Add a Mono library to the list of unknown ones
# USAGE: dependencies_unknown_mono_libraries_add $unknown_library
dependencies_unknown_mono_libraries_add() {
	local unknown_library unknown_libraries_list
	unknown_library="$1"
	unknown_libraries_list=$(dependencies_unknown_mono_libraries_file)

	# Do nothing if this library is already included in the list
	if
		[ -e "$unknown_libraries_list" ] &&
		grep --quiet --fixed-strings --word-regexp "$unknown_library" "$unknown_libraries_list"
	then
		return 0
	fi

	printf '%s\n' "$unknown_library" >> "$unknown_libraries_list"
}
