#include "translation/common.h"
#include "translation/translation.h"

static translation_string all_strings[] = {
    {TR_NO_PATCH_TITLE, "Patch 1.0.1.0 nie jest zainstalowany"},
    {TR_NO_PATCH_MESSAGE,
        "Twoja instalacja Cezara 3 nie ma zainstalowanej łatki 1.0.1.0."
        "Łatkę możesz pobrać z:\n."
        URL_PATCHES "\n"
        "Kontynuujesz na własne ryzyko."},
    {TR_MISSING_FONTS_TITLE, "Brakuje czcionek"},
    {TR_MISSING_FONTS_MESSAGE,
        "Twoja instalacja Cezara 3 wymaga dodatkowych czcionek."
        "Możesz je pobrać dla własnego języka z:\n"
        URL_PATCHES},
    {TR_NO_EDITOR_TITLE, "Edytor nie jest zainstalowany"},
    {TR_NO_EDITOR_MESSAGE,
        "Twoja instalacja Cezara 3 nie ma plików edytora"
        "Możesz je pobrać z:\n"
        URL_EDITOR},
    {TR_INVALID_LANGUAGE_TITLE, "Nieprawidłowy folder językowy"},
    {TR_INVALID_LANGUAGE_MESSAGE,
        "Wybrany folder nie zawiera poprawnego pakietu językowego"
        "Proszę sprawdzić błędy w pliku log"},
    {TR_AUTO_CYCLE_TEMPLES, "Całość"},
    {TR_BUTTON_OK, "OK"},
    {TR_BUTTON_CANCEL, "Anuluj"},
    {TR_BUTTON_RESET_DEFAULTS, "Ustaw domyślne"},
    {TR_BUTTON_CONFIGURE_HOTKEYS, "Skróty klawiszowe"},
    {TR_CONFIG_LANGUAGE_LABEL, "Język:"},
    {TR_CONFIG_LANGUAGE_DEFAULT, "(domyślny)"},
    {TR_CONFIG_DISPLAY_SCALE, "Skala wyświetlacza:"},
    {TR_CONFIG_CURSOR_SCALE, "Skala kursora:"},
    {TR_CONFIG_HEADER_UI_CHANGES, "Zmiany interfejsu użytkownika"},
    {TR_CONFIG_HEADER_GAMEPLAY_CHANGES, "Poziom trudności"},
    {TR_CONFIG_SHOW_INTRO_VIDEO, "Odgrywaj film wprowadzający"},
    {TR_CONFIG_SIDEBAR_INFO, "Dodatkowe informacje w panelu sterowania"},
    {TR_CONFIG_SMOOTH_SCROLLING, "Płynne przewijanie"},
    {TR_CONFIG_DISABLE_RIGHT_CLICK_MAP_DRAG, "Wyłącz przeciąganie mapy prawym przyciskiem"},
    {TR_CONFIG_DISABLE_MOUSE_EDGE_SCROLLING, "Wyłącz przewijanie mapy na krawędzi okna"},
    {TR_CONFIG_VISUAL_FEEDBACK_ON_DELETE, "Pokaż wybrany obszar przy oczyszczaniu terenu"},
    {TR_CONFIG_ALLOW_CYCLING_TEMPLES, "Pozwól na budowę kolejno każdej ze świątyń"},
    {TR_CONFIG_SHOW_WATER_STRUCTURE_RANGE, "Pokaż zasięg przy budowie rezerwuarów, fontann i studni"},
    {TR_CONFIG_SHOW_CONSTRUCTION_SIZE, "Pokaż rozmiar budowy przy przeciąganiu kursorem"},
    {TR_CONFIG_HIGHLIGHT_LEGIONS, "Podświetl legion przy najechaniu kursorem"},
    {TR_CONFIG_SHOW_MILITARY_SIDEBAR, "Włącz boczny panel wojskowy"},
    {TR_CONFIG_FIX_IMMIGRATION_BUG, "Napraw błąd z imigracją na najwyższym poziomie trudności"},
    {TR_CONFIG_FIX_100_YEAR_GHOSTS, "Napraw 100-letnie duchy"},
    {TR_CONFIG_FIX_EDITOR_EVENTS, "Napraw zmianę imperatora i czas przetrwania w konstruktorze miast"},
    {TR_HOTKEY_TITLE, "Augustus - konfiguracja skrótów klawiszowych"},
    {TR_HOTKEY_LABEL, "Skrót klawiszowy"},
    {TR_HOTKEY_ALTERNATIVE_LABEL, "Alternatywny"},
    {TR_HOTKEY_HEADER_ARROWS, "Strzałki kierunkowe"},
    {TR_HOTKEY_HEADER_GLOBAL, "Globalne skróty klawiszowe"},
    {TR_HOTKEY_HEADER_CITY, "Miejskie skróty klawiszowe"},
    {TR_HOTKEY_HEADER_ADVISORS, "Doradcy"},
    {TR_HOTKEY_HEADER_OVERLAYS, "Widoki"},
    {TR_HOTKEY_HEADER_BOOKMARKS, "Miejskie miejsca skoku"},
    {TR_HOTKEY_HEADER_EDITOR, "Edytor"},
    {TR_HOTKEY_HEADER_BUILD, "Skróty klawiszowe budynków"},
    {TR_HOTKEY_ARROW_UP, "Góra"},
    {TR_HOTKEY_ARROW_DOWN, "Dół"},
    {TR_HOTKEY_ARROW_LEFT, "Lewo"},
    {TR_HOTKEY_ARROW_RIGHT, "Prawo"},
    {TR_HOTKEY_TOGGLE_FULLSCREEN, "Przełącz pełny ekran"},
    {TR_HOTKEY_CENTER_WINDOW, "Wycentruj okno"},
    {TR_HOTKEY_RESIZE_TO_640, "Zmień rozmiar okna do 640x480"},
    {TR_HOTKEY_RESIZE_TO_800, "Zmień rozmiar okna do 800x600"},
    {TR_HOTKEY_RESIZE_TO_1024, "Zmień rozmiar okna do 1024x768"},
    {TR_HOTKEY_SAVE_SCREENSHOT, "Zapisz zrzut ekranu"},
    {TR_HOTKEY_SAVE_CITY_SCREENSHOT, "Zapisz zrzut ekranu miasta"},
    {TR_HOTKEY_SAVE_MINIMAP_SCREENSHOT, "Zapisz zrzut ekranu minimapy"},
    {TR_HOTKEY_BUILD_CLONE, "Sklonuj budynek pod kursorem"},
    {TR_HOTKEY_LOAD_FILE, "Wczytaj plik"},
    {TR_HOTKEY_SAVE_FILE, "Zapisz plik"},
    {TR_HOTKEY_INCREASE_GAME_SPEED, "Zwiększ prędkość gry"},
    {TR_HOTKEY_DECREASE_GAME_SPEED, "Zmniejsz prędkość gry"},
    {TR_HOTKEY_TOGGLE_PAUSE, "Pauza"},
    {TR_HOTKEY_CYCLE_LEGION, "Przełącz między legionami"},
    {TR_HOTKEY_ROTATE_MAP_LEFT, "Obróć mapę w lewo"},
    {TR_HOTKEY_ROTATE_MAP_RIGHT, "Obróć mapę w prawo"},
    {TR_HOTKEY_SHOW_ADVISOR_LABOR, "Doradca zatrudnienia"},
    {TR_HOTKEY_SHOW_ADVISOR_MILITARY, "Doradca legionów"},
    {TR_HOTKEY_SHOW_ADVISOR_IMPERIAL, "Doradca imperialny"},
    {TR_HOTKEY_SHOW_ADVISOR_RATINGS, "Doradca wyników"},
    {TR_HOTKEY_SHOW_ADVISOR_TRADE, "Doradca handlowy"},
    {TR_HOTKEY_SHOW_ADVISOR_POPULATION, "Doradca populacji"},
    {TR_HOTKEY_SHOW_ADVISOR_HEALTH, "Doradca zdrowia"},
    {TR_HOTKEY_SHOW_ADVISOR_EDUCATION, "Doradca edukacji"},
    {TR_HOTKEY_SHOW_ADVISOR_ENTERTAINMENT, "Doradca rozrywki"},
    {TR_HOTKEY_SHOW_ADVISOR_RELIGION, "Doradca religijny"},
    {TR_HOTKEY_SHOW_ADVISOR_FINANCIAL, "Doradca finansowy"},
    {TR_HOTKEY_SHOW_ADVISOR_CHIEF, "Główny doradca"},
    {TR_HOTKEY_TOGGLE_OVERLAY, "Przełącz między widokami"},
    {TR_HOTKEY_SHOW_OVERLAY_WATER, "Pokaż widok wody"},
    {TR_HOTKEY_SHOW_OVERLAY_FIRE, "Pokaż widok pożarów"},
    {TR_HOTKEY_SHOW_OVERLAY_DAMAGE, "Pokaż widok zniszczenia"},
    {TR_HOTKEY_SHOW_OVERLAY_CRIME, "Pokaż widok zbrodni"},
    {TR_HOTKEY_SHOW_OVERLAY_PROBLEMS, "Pokaż widok problemów"},
    {TR_HOTKEY_GO_TO_BOOKMARK_1, "Przejdź do punktu skoku 1"},
    {TR_HOTKEY_GO_TO_BOOKMARK_2, "Przejdź do punktu skoku 2"},
    {TR_HOTKEY_GO_TO_BOOKMARK_3, "Przejdź do punktu skoku 3"},
    {TR_HOTKEY_GO_TO_BOOKMARK_4, "Przejdź do punktu skoku 4"},
    {TR_HOTKEY_SET_BOOKMARK_1, "Ustaw punkt skoku 1"},
    {TR_HOTKEY_SET_BOOKMARK_2, "Ustaw punkt skoku 2"},
    {TR_HOTKEY_SET_BOOKMARK_3, "Ustaw punkt skoku 3"},
    {TR_HOTKEY_SET_BOOKMARK_4, "Ustaw punkt skoku 4"},
    {TR_HOTKEY_EDITOR_TOGGLE_BATTLE_INFO, "Przełącz informacje o bitwach"},
    {TR_HOTKEY_EDIT_TITLE, "Wprowadź skrót"},
    {TR_BUILDING_ROADBLOCK, "Blokada drogi"},
    {TR_BUILDING_ROADBLOCK_DESC, "Blokada drogi zatrzymuje przechodniów bez celu."},
    {TR_HEADER_HOUSING, "Domy"},
    {TR_ADVISOR_HOUSING_ROOM, "W miejskich domach jest miejsce dla"},
    {TR_ADVISOR_HOUSING_NO_ROOM, "Brak miejsca w miejskich domach."},
    {TR_ADVISOR_RESIDENCES_USING_POTTERY, "Domy wymagające garnków"},
    {TR_ADVISOR_RESIDENCES_USING_FURNITURE, "Domy wymagające mebli"},
    {TR_ADVISOR_RESIDENCES_USING_OIL, "Domy wymagające oliwy"},
    {TR_ADVISOR_RESIDENCES_USING_WINE, "Domy wymagające wina"},
    {TR_ADVISOR_TOTAL_NUM_HOUSES, "Razem domów:"},
    {TR_ADVISOR_AVAILABLE_HOUSING_CAPACITY, "Dostępne zakwaterowanie:"},
    {TR_ADVISOR_TOTAL_HOUSING_CAPACITY, "Całkowite zakwaterowanie:"},
    {TR_ADVISOR_ADVISOR_HEADER_HOUSING, "Populacja - domy"},
    {TR_ADVISOR_BUTTON_GRAPHS, "Wykresy"},
    {TR_ADVISOR_HOUSING_PROSPERITY_RATING, "Bogactwo domów"},
    {TR_ADVISOR_PERCENTAGE_IN_VILLAS_PALACES, "Procent populacji w willach i pałacach"},
    {TR_ADVISOR_PERCENTAGE_IN_TENTS_SHACKS, "Procent populacji w namiotach i szałasach"},
    {TR_ADVISOR_AVERAGE_TAX, "Średni podatek na głowę"},
    {TR_ADVISOR_AVERAGE_AGE, "Średnia wieku populacji"},
    {TR_ADVISOR_PERCENT_IN_WORKFORCE, "Procent populacji w sile roboczej"},
    {TR_ADVISOR_BIRTHS_LAST_YEAR, "Narodzin w zeszłym roku:"},
    {TR_ADVISOR_DEATHS_LAST_YEAR, "Śmierci w zeszłym roku:"},
    {TR_ADVISOR_TOTAL_POPULATION, "Razem mieszkańców"},
    { TR_CONFIG_TITLE, "Augustus - konfiguracja" },
    { TR_CONFIG_ROTATE_MANUALLY, "Obróć bramy i łuk triumfalny skrótem klawiszowym" },
    { TR_CONFIG_COMPLETE_RATING_COLUMNS, "Pokaż całe kolumny przy niskich poziomach wyników" },
    { TR_CONFIG_GRANDFESTIVAL, "Wielkie festiwale pozwalają na dodatkowe błogosławieństwo" },
    { TR_CONFIG_JEALOUS_GODS, "Wyłącz zazdrość bogów" },
    { TR_CONFIG_GLOBAL_LABOUR, "Włącz globalne zatrudnienie" },
    { TR_CONFIG_SCHOOL_WALKERS, "Wydłuż drogę uczniów szkół" },
    { TR_CONFIG_RETIRE_AT_60, "Zmień wiek emerytalny z 50 na 60" },
    { TR_CONFIG_FIXED_WORKERS, "Stały procent zatrudnionych - 38%" },
    { TR_CONFIG_EXTRA_FORTS, "Zezwól na budowę dodatkowych 4 fortów" },
    { TR_CONFIG_WOLVES_BLOCK, "Zablokuj budowę w pobliżu wilków" },
    { TR_CONFIG_DYNAMIC_GRANARIES, "Zablokuj niepołączenie drogi spichlerzy" },
    { TR_CONFIG_MORE_STOCKPILE, "Domy gromadzą więcej dóbr ze straganu" },
    { TR_CONFIG_NO_SUPPLIER_DISTRIBUTION, "Kupujące panie ze straganu nie rozdają dóbr" },
    { TR_CONFIG_IMMEDIATELY_DELETE_BUILDINGS, "Natychmiast niszcz budynki" },
    { TR_CONFIG_GETTING_GRANARIES_GO_OFFROAD, "Popychacze wozów ze zbierających spichlrzy mogą schodzić z dróg" },
    { TR_CONFIG_GRANARIES_GET_DOUBLE, "Podwój pojemność zbierająych popychaczy wozów ze spichlerzy" },
    { TR_CONFIG_TOWER_SENTRIES_GO_OFFROAD, "Setnicy z wież mogą schodzić z dróg" },
    { TR_CONFIG_FARMS_DELIVER_CLOSE, "Farmy i przystanie dostarczają żywność tylko do pobliskich spichlerzy" },
    { TR_CONFIG_DELIVER_ONLY_TO_ACCEPTING_GRANARIES, "Jedzenie nie jest dostarczane do zbierających spichlerzy" },
    { TR_CONFIG_ALL_HOUSES_MERGE, "Wszystkie domy mogą się łączyć" },
    { TR_CONFIG_WINE_COUNTS_IF_OPEN_TRADE_ROUTE, "Otwarty szlak handlowy liczy się jako nowy rodzaj wina" },
    { TR_CONFIG_RANDOM_COLLAPSES_TAKE_MONEY, "Losowo upadające glinianki i kopalnie żelaza zabierają zamiast tego trochę pieniędzy" },
    { TR_CONFIG_MULTIPLE_BARRACKS, "Zezwól na budowę wielu koszar" },
    { TR_CONFIG_NOT_ACCEPTING_WAREHOUSES, "Hurtownie nie akceptują żadnych dóbr przy zbudowaniu" },
    { TR_CONFIG_HOUSES_DONT_EXPAND_INTO_GARDENS, "Domy nie zajmują ogrodów przy powiększaniu" },
    { TR_BUILDING_ARCHITECT_GUILD, "Gildia inżynierów" },
    { TR_BUILDING_ARCHITECT_GUILD_DESC, "Inżynierowie niestrudzenie pracują, by zbudować monumenty ku chwale Rzymu." },
    { TR_BUILDING_GRAND_TEMPLE_ADD_MODULE, "Nadaj epitet świątyni" },
    { TR_BUILDING_GRAND_TEMPLE_CERES, "Dom Ceres" },
    { TR_BUILDING_GRAND_TEMPLE_NEPTUNE, "Dom Neptuna" },
    { TR_BUILDING_GRAND_TEMPLE_MERCURY, "Dom Merkurego" },
    { TR_BUILDING_GRAND_TEMPLE_MARS, "Dom Marsa" },
    { TR_BUILDING_GRAND_TEMPLE_VENUS, "Dom Wenus" },
    { TR_BUILDING_PANTHEON, "Panteon" },
    { TR_BUILDING_GRAND_TEMPLE_CERES_DESC, "Wielka świątynia Ceres" },
    { TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC, "Wielka świątynia Neptuna" },
    { TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC, "Wielka świątynia Merkurego" },
    { TR_BUILDING_GRAND_TEMPLE_MARS_DESC, "Wielka świątynia Marsa" },
    { TR_BUILDING_GRAND_TEMPLE_VENUS_DESC, "Wielka świątynia Wenus" },
    { TR_BUILDING_PANTHEON_DESC, "Panteon" },
    { TR_BUILDING_GRAND_TEMPLE_CERES_BONUS_DESC, "Popychacze wozów z farm poruszają się o 50% szybciej." },
    { TR_BUILDING_GRAND_TEMPLE_NEPTUNE_BONUS_DESC, "Zwiększa zasięg fontann, studni i rezerwuarów. Zatrudnienie budowli wodnych zmniejszone o połowę. Statki handlowe poruszają się 25% szybciej." },
    { TR_BUILDING_GRAND_TEMPLE_MERCURY_BONUS_DESC, "Handlarze lądowi i morscy mają zwiększoną pojemność o 50%. Handlarze lądowi poruszają się o 25% szybciej" },
    { TR_BUILDING_GRAND_TEMPLE_MARS_BONUS_DESC, "Szkoli żołnierzy jak koszary. Zezwala na budowę dodatkowych czterech fortów" },
    { TR_BUILDING_GRAND_TEMPLE_VENUS_BONUS_DESC, "Ogrody, świątynie i pomniki błyszczą dodatkowych pięknem, zwiększając atrakcyjność. Domy gromadzą więcej dóbr i wolniej dewoluują." },
    { TR_BUILDING_PANTHEON_BONUS_DESC, "Zapewnia dostęp do wszystkich bogów. Organizuje coroczne festiwale i redukuje żołd świątyń o 25%" },
    { TR_BUILDING_GRAND_TEMPLE_CERES_MODULE_1_DESC, "Kapłani zmniejszają konsumpcję żywności o 20%." },
    { TR_BUILDING_GRAND_TEMPLE_NEPTUNE_MODULE_1_DESC, "Świątynia wysyła woźniców do hipodromu." },
    { TR_BUILDING_GRAND_TEMPLE_MERCURY_MODULE_1_DESC, "Kapłani redukują konsumpcję mebli i garnków o 20%." },
    { TR_BUILDING_GRAND_TEMPLE_MARS_MODULE_1_DESC, "Świątynie generują żywność odwiedzając domy i wysyłają ją do punktu zaopatrzeniowego." },
    { TR_BUILDING_GRAND_TEMPLE_VENUS_MODULE_1_DESC, "Wielka świątynia produkuje wino zależne od rozmiaru miasta z dostępem do Wenus. Kapłani zbierają i rozdają to wino." },
    { TR_BUILDING_GRAND_TEMPLE_CERES_MODULE_2_DESC, "Kapłani zbierają i rozdają oliwę i jeden typ żywności." },
    { TR_BUILDING_GRAND_TEMPLE_NEPTUNE_MODULE_2_DESC, "Kapłani zwiększają pojemność domów o 5%. Wielka świątynia działa jak wypełniony rezerwuar." },
    { TR_BUILDING_GRAND_TEMPLE_MERCURY_MODULE_2_DESC, "Kapłani redukują zużycie oliwy i wina o 20%." },
    { TR_BUILDING_GRAND_TEMPLE_MARS_MODULE_2_DESC, "Kapłani redukują zużycie wszystkich dóbr o 10%." },
    { TR_BUILDING_GRAND_TEMPLE_VENUS_MODULE_2_DESC, "Kapłani zapewniają rozrywkę i zwiększają piękno domów, pozwalając ograniczyć potrzebę dodatkowych upiększeń." },
    { TR_BUILDING_PANTHEON_MODULE_1_DESC, "Wszystkie świątynie wysyłają swoich kapłanów do panteonu, szerząc wiarę w swoich bogów." },
    { TR_BUILDING_PANTHEON_MODULE_2_DESC, "Domy z dostępem do panteonu mogą rozwinąć się o dodatkowy krok." },
    { TR_BUILDING_GRAND_TEMPLE_CERES_DESC_MODULE_1, "Świątynia Ceres Promitor" },
    { TR_BUILDING_GRAND_TEMPLE_CERES_DESC_MODULE_2, "Świątynia Ceres Reparator" },
    { TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC_MODULE_1, "Świątynia Neptunus Equester" },
    { TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC_MODULE_2, "Świątynia Neptunus Adiutor" },
    { TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC_MODULE_1, "Świątynia Mercurius Fortunus" },
    { TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC_MODULE_2, "Świątynia Mercurius Abundantia" },
    { TR_BUILDING_GRAND_TEMPLE_MARS_DESC_MODULE_1, "Świątynia Mars Ultor" },
    { TR_BUILDING_GRAND_TEMPLE_MARS_DESC_MODULE_2, "Świątynia Mars Quirinus" },
    { TR_BUILDING_GRAND_TEMPLE_VENUS_DESC_MODULE_1, "Świątynia Venus Verticordia" },
    { TR_BUILDING_GRAND_TEMPLE_VENUS_DESC_MODULE_2, "Świątynia Venus Genetrix" },
    { TR_BUILDING_PANTHEON_DESC_MODULE_1, "Pantheum Ara Maxima" },
    { TR_BUILDING_PANTHEON_DESC_MODULE_2, "Pantheum Roma Aeterna" },
    { TR_BUILDING_GRAND_TEMPLE_MENU, "Wielka świątynia" },
    { TR_BUILDING_WORK_CAMP, "Obóz pracy" },
    { TR_BUILDING_WORK_CAMP_DESC, "Pracownicy zbierają się tutaj, by dostarczać materiałów do konstrukcji monumentów." },
    { TR_REQUIRED_RESOURCES, "Surowce potrzebne do ukończenia obecnej fazy:" },
    { TR_BUILDING_GRAND_TEMPLE_CONSTRUCTION_DESC, "Budowa wielkiej świątyni wymaga materiałów zgromadzonych w magazynie, pracowników z obozu pracy i inżynierów z obozu inżynierów." },
    { TR_CONSTRUCTION_PHASE, "Faza konstrukcji:" },
    { TR_ADD_MODULE, "Poświęcić świątynię?" },
    { TR_BUILDING_TEMPLE_MODULE_CONSTRUCTED, "Epitet nadany." },
    { TR_BUILDING_CERES_TEMPLE_QUOTE, "Pierwsza w skiby lemieszem kraje krzywym ziemię\nCeres i pierwsza zbożem darzy ludzkie plemię,\nPierwsza nadaje prawa. Jej to wszystko dary,\n Ja w śpiewie czcić, jej składać powinnam ofiary.\n-Owidiusz, Przemiany, Księga V" },
    { TR_BUILDING_NEPTUNE_TEMPLE_QUOTE, "I gniew morza ustaje. Neptun trójząb złożył,\nBystre wiatry uciszył i wody ukorzył.\nWoła Trytona — Tryton, wyższy nad bałwany\nPrzypływa; grzbiet ma siwy muszlami nadziany.\nPan morza w brzmiącą konchę dąć mu każe silnie\n-Owidiusz, Przemiany, Ksiegą I" },
    { TR_BUILDING_MERCURY_TEMPLE_QUOTE, "Można ci bowiem zabierać i woły i paśne bydlęta,\nŁupem pozyskać trójnogi i płowogrzywiaste rumaki,\nŻycie atoli człowieka zaborem napowrót nie wróci,\nAni też łupem, jak tylko uciecze przez zębów zaporę.\nMatka mi bowiem Thetyda o srebrnych nóżkach mówiła,\n-Homer, Iliada, księga IX" },
    { TR_BUILDING_MARS_TEMPLE_QUOTE, "Wtedy Mars, władny w boju, wlał ogień i siły,\nW Latynów serca, które wnet żywiej zabiły,\nZaś popłoch i strach zgubny rzucił w Teukrów rzędy.\nZyskawszy pole bitwy, wróg kupi się wszędy\nZa sprawą boga wojny.\n-Wirgliusz, Eneida, Księga IX" },
    { TR_BUILDING_VENUS_TEMPLE_QUOTE, "Wtedy niebian zjednawszy Wenus przymileniem,\nI Jowisza pieszczonem objąwszy ramieniem:\nOjcze, który me prośby wypełniałeś zawsze\n - Rzekła - dziś okaż dla mnie serce najłaskawsze\n-Owidiusz, Przemiany" },
    { TR_BUILDING_PANTHEON_QUOTE, "Tymczasem dom potężny Olimpu się budzi.\nZebranie zwoła niebian ojciec i król ludzi.\nDo gwieździstej siedziby, skąd cała kraina\nWidna, obóz Dardanów i ludy Latyna.,\nZasiędą przy otwartych bramach, on zaś zacznie.\n-Wirgiliusz, Eneida, Księga X" },
    { TR_BUILDING_GRAND_TEMPLE_PHASE_1, "(Podium)" },
    { TR_BUILDING_GRAND_TEMPLE_PHASE_2, "(Portico)" },
    { TR_BUILDING_GRAND_TEMPLE_PHASE_3, "(Cella)" },
    { TR_BUILDING_GRAND_TEMPLE_PHASE_4, "(Praecinctum)" },
    { TR_BUILDING_GRAND_TEMPLE_PHASE_5, "(Dedicatio)" },
    { TR_BUILDING_GRAND_TEMPLE_PHASE_1_TEXT, "Pracownicy konstruują podium, które wyniesie świątynie i zapewni trwałe fundamenty pozwalające znieść upływ czasu." },
    { TR_BUILDING_GRAND_TEMPLE_PHASE_2_TEXT, "Rzemieślnicy tworzą portico, w którym znajdzie się świątynny ołtarz." },
    { TR_BUILDING_GRAND_TEMPLE_PHASE_3_TEXT, "Inżynierowie tworzą cella, wnętrze świątyni które będzie domem do świętych obrazów." },
    { TR_BUILDING_GRAND_TEMPLE_PHASE_4_TEXT, "Rozpoczęły się prace nad świątynnym praecinctum, gdzie wyznawcy będą się zbierać do rytuałów." },
    { TR_BUILDING_GRAND_TEMPLE_PHASE_5_TEXT, "Prace nad świątynią są prawie gotowe, kapłani zbierają się do konsekracji świątyni." },
    { TR_BUILDING_MENU_TREES, "Drzwi" },
    { TR_BUILDING_MENU_PATHS, "Ścieżki" },
    { TR_BUILDING_MENU_PARKS, "Parki" },
    { TR_BUILDING_SMALL_POND, "Mały staw" },
    { TR_BUILDING_LARGE_POND, "Duży staw" },
    { TR_BUILDING_PINE_TREE, "Sosna" },
    { TR_BUILDING_FIR_TREE, "Jodła" },
    { TR_BUILDING_OAK_TREE, "Dąb" },
    { TR_BUILDING_ELM_TREE, "Wiąz" },
    { TR_BUILDING_FIG_TREE, "Figowiec" },
    { TR_BUILDING_PLUM_TREE, "Śliwa" },
    { TR_BUILDING_PALM_TREE, "Palma" },
    { TR_BUILDING_DATE_TREE, "Daktyl" },
    { TR_BUILDING_PINE_PATH, "Ścieżka z sosanmi" },
    { TR_BUILDING_FIR_PATH, "Ścieżka z jodłami" },
    { TR_BUILDING_OAK_PATH, "Ścieżka z dębami" },
    { TR_BUILDING_ELM_PATH, "Ścieżka z więzami" },
    { TR_BUILDING_FIG_PATH, "Ścieżka z figami" },
    { TR_BUILDING_PLUM_PATH, "Ścieżka ze śliwami" },
    { TR_BUILDING_PALM_PATH, "Ścieżka z palmami" },
    { TR_BUILDING_DATE_PATH, "Ścieżka z daktylami" },
    { TR_BUILDING_BLUE_PAVILION, "Niebieski pawilon" },
    { TR_BUILDING_RED_PAVILION, "Czerwony pawilon" },
    { TR_BUILDING_ORANGE_PAVILION, "Pomarańczowy pawilon" },
    { TR_BUILDING_YELLOW_PAVILION, "Żółty pawilon" },
    { TR_BUILDING_GREEN_PAVILION, "Zielony pawilon" },
    { TR_BUILDING_SMALL_STATUE_ALT, "Posąg bogini" },
    { TR_BUILDING_SMALL_STATUE_ALT_B, "Posąg senatora" },
    { TR_BUILDING_OBELISK, "Obelisk" },
    { TR_BUILDING_POND_DESC, "Staw napełniony jest wodą z miejskich rezerwuarów i zapewnia wodą dla roślin i zwierząt, a także miejsce relaksu dla mieszkańców." },
    { TR_BUILDING_WINDOW_POND, "Staw" },
    { TR_BUILDING_OBELISK_DESC, "Wspaniały monument, wzniesiony przez starożytnego króla nilu. Egipcjanie z niego nie korzystali." },
    { TR_ADVISOR_FINANCE_LEVIES, "Żołd budynków" },
    { TR_CONFIRM_DELETE_MONUMENT, "Zniszczyć ten monument" },
    { TR_SELECT_EPITHET_PROMPT_HEADER, "Wybierz epitet do nadania" },
    { TR_SELECT_EPITHET_PROMPT_TEXT, "Nadanie epitetu trwale poświęci tę światynię temu aspektowi boga, nadając kapłanom boską moc." },
    { TR_BUILDING_INFO_MONTHLY_LEVY, "/miesiąc" },
    { TR_BUILDING_MESS_HALL, "Punkt zaopatrzenia" },
    { TR_BUILDING_MESS_HALL_DESC, "Punkt zaopatrzeniowy zabiera jedzenie ze spichlerzy by zapewniż pożywienie żołnierzom w miejskich fortach. Brak żywności spowolni rekrutację i osłabi morale." },
    { TR_BUILDING_MESS_HALL_FULFILLMENT, "Stan zaopatrzenia w zeszłym miesiącu:" },
    { TR_BUILDING_MESS_HALL_TROOP_HUNGER, "Żołnierze są: " },
    { TR_BUILDING_MESS_HALL_TROOP_HUNGER_1, "Dobrze odżywieni" },
    { TR_BUILDING_MESS_HALL_TROOP_HUNGER_2, "Odżywieni" },
    { TR_BUILDING_MESS_HALL_TROOP_HUNGER_3, "Głodni" },
    { TR_BUILDING_MESS_HALL_TROOP_HUNGER_4, "Bardzo głodni" },
    { TR_BUILDING_MESS_HALL_TROOP_HUNGER_5, "Umierają z głodu" },
    { TR_BUILDING_MESS_HALL_FOOD_TYPES_BONUS_1, "Zróżnicowana dieta znacznie poprawia morale." },
    { TR_BUILDING_MESS_HALL_FOOD_TYPES_BONUS_2, "Pożywna i wielce zróżnicowana dieta ma wspaniały efekt na morale." },
    { TR_BUILDING_MESS_HALL_NO_SOLDIERS, "Nie masz żołnierzy do nakarmienia." },
    { TR_BUILDING_MESS_HALL_MONTHS_FOOD_STORED, "Zaopatrzenia starczy na miesięcy:" },
    { TR_BUILDING_BARRACKS_FOOD_WARNING, "Braki w żywności w punkcie zaopatrzeniowym spowalniają rekrutację." },
    { TR_BUILDING_BARRACKS_FOOD_WARNING_2, "Krytyczne braki w pożywieni w punkcie zaopatrzeniowym wielce spowalniają rekrutację." },
    { TR_BUILDING_LEGION_FOOD_WARNING_1, "Niedawne braki żywności osłabiły morale" },
    { TR_BUILDING_LEGION_FOOD_WARNING_2, "Niedawne braki żywności wielce osłabiły morale" },
    { TR_BUILDING_LEGION_STARVING, "Brak żywności" },
    { TR_ADVISOR_LEGION_FOOD_SATISFIED, "Twoi żołnierze mają jedzenie którego potrzebują." },
    { TR_ADVISOR_LEGION_FOOD_NEEDED, "Twoi żołnierze potrzebują więcej żywności." },
    { TR_ADVISOR_LEGION_FOOD_CRITICAL, "Twoi żołnierze umierają z głodu!" },
    { TR_ADVISOR_LEGION_MONTHS_FOOD_STORED, "Miesiące zaopatrzenia w żywność:" },
    { TR_CITY_MESSAGE_TITLE_MESS_HALL_NEEDS_FOOD, "Żołnierze są głodni" },
    { TR_CITY_MESSAGE_TEXT_MESS_HALL_NEEDS_FOOD, "Twój punkt zaopatrzeniowy krytycznie potrzebuje żywności. Zapewnij, aby miał dostęp do pełnego spichlerza." },
    { TR_CITY_MESSAGE_TEXT_MESS_HALL_MISSING, "Twoje miasto straciło punkt zaopatrzeniowy i twoi żołnierze głodują. Natychmiast zbuduj nowy." },
    { TR_MARKET_SPECIAL_ORDERS_HEADER, "Dobra do zebrania" },
    { TR_WARNING_NO_MESS_HALL, "Wpierw zbuduj punkt zaopatrzeniowy dla żołnierzy." },
    { TR_WARNING_MAX_GRAND_TEMPLES, "Można postawić tylko dwie wielkie świątynie." },
    { TR_CITY_MESSAGE_TITLE_GRAND_TEMPLE_COMPLETE, "Wielka świątynia ukończona" },
    { TR_CITY_MESSAGE_TEXT_GRAND_TEMPLE_COMPLETE, "Kapłani i wyznawcy tłumnie gromadzą się do nowej wielkiej świątyni na ryty poświęcenia. Mieszkańcy są w podziwie majestatu twojej pracy, a wybrane bóstwo obdarza cię swoją łaską." },
    { TR_CITY_MESSAGE_TITLE_MERCURY_BLESSING, "Błogosławieństwo Merkurego" },
    { TR_CITY_MESSAGE_TEXT_MERCURY_BLESSING, "Uradowany twoim oddaniem, Merkury zapewnił twoim rzemieślnikom materiały do produkcji dóbr." },
    { TR_FIGURE_TYPE_WORK_CAMP_WORKER, "Brygadzista" },
    { TR_FIGURE_TYPE_WORK_CAMP_SLAVE, "Tragarz" },
    { TR_FIGURE_TYPE_WORK_CAMP_ARCHITECT, "Architekt" },
    { TR_FIGURE_TYPE_MESS_HALL_SUPPLIER, "Kwartermistrz" },
    { TR_FIGURE_TYPE_MESS_HALL_COLLECTOR, "Sługa obozowy" },
    { TR_BUILDING_CERES_TEMPLE_MODULE_DESC, "Wielka świątynia organizuje kapłanów Ceres by doręczali żywność i oliwę głodnym mieszkańcom." },
    { TR_BUILDING_VENUS_TEMPLE_MODULE_DESC, "Wielka świątynia pozwala kapłanom Wenus dostarczać święte wino." },
    { TR_BUILDING_MARS_TEMPLE_MODULE_DESC, "Wielka świątynia organizuje kapłanów Marsa by dostaczali żywność do punktu zaopatrzeniowego." },
    { TR_BUILDING_SMALL_TEMPLE_CERES_NAME, "Świątynia Ceres" },
    { TR_BUILDING_SMALL_TEMPLE_NEPTUNE_NAME, "Świątynia Neptuna" },
    { TR_BUILDING_SMALL_TEMPLE_MERCURY_NAME, "Świątynia Merkurego" },
    { TR_BUILDING_SMALL_TEMPLE_MARS_NAME, "Świątynia Marsa" },
    { TR_BUILDING_SMALL_TEMPLE_VENUS_NAME, "Świątynia Wenus" },
    { TR_FIGURE_TYPE_PRIEST_SUPPLIER, "Kapłan" },
        // Transcription of mission_exact4.wav
    { TR_PHRASE_FIGURE_MISSIONARY_EXACT_4, "\"Zrobię co mogę by uspokoić tych barbarzyńców. Jestem pewny, że przestaną atakować miasto kiedy zamienię z nimi słowo.\"" },
    { TR_CITY_MESSAGE_TITLE_PANTHEON_FESTIVAL, "Coroczny festiwal" },
    { TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_CERES, "Wierni zbierają się do świętowania Cereliów, ku chwale Ceres. Rolnicy składają ofiary, licząc na obfite zbiory w nadchodzących latach."},
    { TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_NEPTUNE, "Dziś rozpoczynają się obchody Neptunaliów, ku chwale Neptuna. Wierni budują szałasy z gałęzi i radują się, schowani przed gorącem śłońca środku lata."},
    { TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_MERCURY, "Kupcy i handlarze tłumnie zbierają się do świętowania Merkuraliów. Statki i magazyny pokrapiane są świętą wodą, licząć na boską ochronę Merkurego."},
    { TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_MARS, "Obywatele zbierają się na świętowanie Ekwirii, szukając łaski Marsa. Tętęt kopyt i odgłosy rydwanów przepełniają otoczenie, gdy wierni ściagają się ku chwale swojego boga."},
    { TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_VENUS, "Wierni zbierają się na weneralia, dzień poświęcony Wenus. Obywatele szukają jej błogosławieństwa w sprawach sercowych." },
    { TR_TOOLTIP_BUTTON_DELETE_READ_MESSAGES, "Usuń przeczytane wiadomości" },
    { TR_TOOLTIP_BUTTON_MOTHBALL_ON, "Wyłącz ten budynek." },
    { TR_TOOLTIP_BUTTON_MOTHBALL_OFF, "Włącz ten budynek." },
    { TR_TOOLTIP_BUTTON_ACCEPT_MARKET_LADIES, "Zezwól paniom ze straganu na kupowanie tutaj" },
    { TR_TOOLTIP_BUTTON_ACCEPT_TRADE_CARAVAN, "Zezwól karawanom na handel tutaj" },
    { TR_TOOLTIP_BUTTON_ACCEPT_TRADE_SHIPS, "Zezwól statkom handlowym na handel tutaj" },
    { TR_CONFIG_HEADER_CITY_MANAGEMENT_CHANGES, "Zarządzanie miastem" },
    { TR_BUILDING_LIGHTHOUSE, "Latarnia" },
    { TR_BUILDING_LIGHTHOUSE_PHASE_1, "(Fundamenty)" },
    { TR_BUILDING_LIGHTHOUSE_PHASE_2, "(Pedestał)" },
    { TR_BUILDING_LIGHTHOUSE_PHASE_3, "(Wieża)" },
    { TR_BUILDING_LIGHTHOUSE_PHASE_4, "(Korona)" },
    { TR_BUILDING_LIGHTHOUSE_PHASE_1_TEXT, "Inżynierowie stawiają solidne fundamenty, zdolne utrzymać wagę wielkiej wieży z kamienia." },
    { TR_BUILDING_LIGHTHOUSE_PHASE_2_TEXT, "Kamieniarze konstruują pedestał, który wzniesie ogień latarni wysoko ponad horyzont." },
    { TR_BUILDING_LIGHTHOUSE_PHASE_3_TEXT, "Wieża latarni wzrasta każdego dnia, podczas gdy kamieniarze ostrożnie praktykują swoją rzemiosło." },
    { TR_BUILDING_LIGHTHOUSE_PHASE_4_TEXT, "Inżynierowie wykańczają latarnię. Niedługo będzie świecić wiele mil, zapewniając statkom drogę do domu." },
    { TR_BUILDING_LIGHTHOUSE_CONSTRUCTION_DESC, "Konstrukcja latarni wymaga materiałów zgromadzonych w magazynie, pracowników z obozu pracy i inżynierów z gildii inżynierów." },
    { TR_BUILDING_LIGHTHOUSE_BONUS_DESC, "Statki rybackie poruszają się o 10% szybciej. Sztormy morskie trwają o połowę krócej." },
    { TR_EDITOR_ALLOWED_BUILDINGS_MONUMENTS, "Monumenty" },
    { TR_CITY_MESSAGE_TEXT_LIGHTHOUSE_COMPLETE, "Latarnia, potężna wieża z kamienia wznosi się nad horyzontem. Niech jej blask prowadzi statki do domu aż do końca czasów." },
    { TR_CITY_MESSAGE_TEXT_PANTHEON_COMPLETE, "Panteon ukończony. It stands unrivaled as a monument to the awesome power of the gods and people of Rome." },
    { TR_CITY_MESSAGE_TITLE_MONUMENT_COMPLETE, "Monument ukończony" },
    { TR_CITY_MESSAGE_TITLE_NEPTUNE_BLESSING, "Błogosławieństwo Neptuna" },
    { TR_CITY_MESSAGE_TEXT_NEPTUNE_BLESSING, "Nagradzają pobożność twego miasta, Neptun zapewnia bezpieczną podróż handlarzom przez dwanaście miesięcy, podczas których będziesz mógł sprzedawać towary za połowę więcej." },
    { TR_CITY_MESSAGE_TITLE_VENUS_BLESSING, "Błogosławieństwo Wenus" },
    { TR_CITY_MESSAGE_TEXT_VENUS_BLESSING, "Uradowana twoim oddanie, Venus nagradza twoich mieszkańców zdrowiem, szczęściem i młodością, zwiększając liczbę pracujących mieszkańców." },
    { TR_BUILDING_MENU_STATUES, "Posągi" },
    { TR_BUILDING_MENU_GOV_RES, "Domy guberantora" },
    { TR_OVERLAY_ROADS, "Drogi" },
    { TR_NO_EXTRA_ASSETS_TITLE, "Nie można znaleźć folderu z modami" },
    { TR_NO_EXTRA_ASSETS_MESSAGE,
        "Twoja instalacja Cezara 3 nie posiada odpowiednio zainstalowanego folderu z modami. "
        "Nowe obiekty mogą nie wyświetlać się prawidłowo.\n"
        "Zapewnij aby folder '/assets' istniał w katalogu w którym jest zainstalowany Cezar 3. " },
    { TR_WARNING_WATER_NEEDED_FOR_BUILDING, "Latarnia musi być zbudowana blisko wody" },
    { TR_TOOLTIP_OVERLAY_PANTHEON_ACCESS, "Ten dom ma dostęp do wszystkich bogów z panteonu." },
    { TR_BUILDING_LEGION_FOOD_BONUS, "Liczne jedzenie wzmaga morale" },
    { TR_BUILDING_LEGION_FOOD_STATUS, "Status jedzenia" },
    { TR_TOOLTIP_BUTTON_ACCEPT_QUARTERMASTER, "Zezwól kwartermistrzowi na zbieranie stąd żywności" },
    { TR_WARNING_RESOURCES_NOT_AVAILABLE, "Nie możesz pozyskać niezbędnych materiałów" },
    { TR_CONFIG_GP_CH_MONUMENTS_BOOST_CULTURE_RATING, "Ukońcczone wielkie świątynie dają +8 do kultury" },
    { TR_BUTTON_BACK_TO_MAIN_MENU, "Wróć na główne menu" },
    { TR_LABEL_PAUSE_MENU, "Pauza" },
    { TR_OVERLAY_LEVY, "Żołd" },
    { TR_TOOLTIP_OVERLAY_LEVY, " denarów płaconych miesięcznie jako żołd." },
    { TR_MAP_EDITOR_OPTIONS, "Ustawienia scenariusza" },
    { TR_BUTTON_GO_TO_SITE, "Idź do lokacji" },
    { TR_RETURN_ALL_TO_FORT, "Całość" },
    { TR_OPTION_MENU_COST, "Będzie kosztować" },
    { TR_ADVISOR_CHIEF_NO_IMMIGRATION_SQUALOR, "Nędzne mieszkania i slumsy uniemożliwiają imigrację " },
    { TR_ADVISOR_DISPATCHING_FOOD_FROM_GRANARIES_TITLE, "Wysyłanie jedzenie ze spichlerza"},
    { TR_ADVISOR_DISPATCHING_FOOD_FROM_GRANARIES_TEXT, "Jesteś pewien?" },
    { TR_ADVISOR_IN_STORAGE, "przechowywane" },
    { TR_ADVISOR_FROM_GRANARIES, "ze spichlerzy" },
    { TR_ADVISOR_KEEP_STOCKPILING, "Nadal zbieraj surowiec" },
    { TR_ADVISOR_MAX_ATTAINABLE_PROSPERITY_IS, "Maksymalny poziom dobrobytu dla tego poziomu mieszkanie jest" },
    { TR_ADVISOR_POPULATION_AGE, "Wiek" },
    { TR_ADVISOR_POPULATION_RESIDENTS, "mieszkańców" },
    { TR_ADVISOR_POPULATION_DWELLERS, "mieszkańców" },
    { TR_ADVISOR_OPEN_TO_IMPORT, "Otwórz drogę handlową na import" },
    { TR_ADVISOR_OPEN_TO_EXPORT, "Otwórz drogę handlową na eksport" },
    { TR_ADVISOR_TRADE_MAX, "Maks" },
    { TR_ADVISOR_TRADE_NO_LIMIT, "maks" },
    { TR_ADVISOR_TRADE_IMPORTABLE, "Importowalne" },
    { TR_ADVISOR_TRADE_EXPORTABLE, "Eksportowalne" },
    { TR_ADVISOR_TRADE_NO_BUYERS, "Nie ma kupców dla tego surowca" },
    { TR_ADVISOR_TRADE_NO_SELLERS, "Nie ma sprzedających dla tego surowca" },
    { TR_ADVISOR_TRADE_NOT_IMPORTING, "Nie importuje" },
    { TR_ADVISOR_TRADE_NOT_EXPORTING, "Nie eksportuje" },
    { TR_BUILDING_ARENA, "Arena" },
    { TR_BUILDING_CARAVANSERAI, "Caravanserai" },
    { TR_BUILDING_CARAVANSERAI_DESC, "Merchant caravans shelter here to rest and feed their animals. Land trade disruptions last half as long." },
    { TR_BUILDING_CARAVANSERAI_PHASE_1, "(Fundamenty)" },
    { TR_BUILDING_CARAVANSERAI_PHASE_1_TEXT, "Inżynierowie kładą fundamenty dla schronu dla handlarzy." },
    { TR_BUILDING_CARAVANSERAI_POLICY_TITLE, "Polityka handlu lądowego" },
    { TR_BUILDING_CARAVANSERAI_NO_POLICY, "Brak polityki handlu lądowego." },
    { TR_BUILDING_CARAVANSERAI_POLICY_TEXT, "Wybierz politykę handlu lądowego dla Twojego miasta. Możesz zmienić na inną politykę w każdym czasie." },
    { TR_BUILDING_CARAVANSERAI_POLICY_1_TITLE, "Consilium venditor terrae" },
    { TR_BUILDING_CARAVANSERAI_POLICY_1, "Polityka lądowego sprzedawcy: Eksport lądowy zarabia 20% więcej, ale import lądowy jest o 10% droższy." },
    { TR_BUILDING_CARAVANSERAI_POLICY_2_TITLE, "Consilium emptor terrae" },
    { TR_BUILDING_CARAVANSERAI_POLICY_2, "Polityka lądowego kupcy: Import lądowy kosztuje 20% mniej, ale eksport lądowy zarabia o 10% mniej." },
    { TR_BUILDING_CARAVANSERAI_POLICY_3_TITLE, "Consilium quantitas terrae" },
    { TR_BUILDING_CARAVANSERAI_POLICY_3, "Polityka lądowa ilościowa: Karawany handlowe przewożą 4 towary więcej, ale poruszają się o 10% wolniej." },
    { TR_BUILDING_COLONNADE, "Kolonnada" },
    { TR_BUILDING_COLOSSEUM_PHASE_1, "(Hypogeum)" },
    { TR_BUILDING_COLOSSEUM_PHASE_2, "(Fundamenty" },
    { TR_BUILDING_COLOSSEUM_PHASE_3, "(Arkady}" },
    {TR_BUILDING_COLOSSEUM_PHASE_4, "(Galeria)" },
    {TR_BUILDING_COLOSSEUM_PHASE_1_TEXT, "Pracownicy kopią podziemne hypogeum - tunele i maszyny, z których pojawią się wielkie spektakle." },
    {TR_BUILDING_COLOSSEUM_PHASE_2_TEXT, "Mury Koloseum nabierają kształtu, gdy kładzione są rzędy miejsc siedzących zarówno dla plebsu, jak i cesarzy." },
    {TR_BUILDING_COLOSSEUM_PHASE_3_TEXT, "Pełne wdzięku łuki wznoszą się ku niebu, utrzymując potężne Koloseum." },
    {TR_BUILDING_COLOSSEUM_PHASE_4_TEXT, "Gdy Koloseum sięga ku niebu, jego ściany są pokryte błyszczącym marmurem i posągami." },
    {TR_BUILDING_DECORATIVE_COLUMN, "Marmurowa kolumna" },
    {TR_BUILDING_DOCK_CITIES_CONFIG_DESC, "Miasta z otwartym handlem morskim:" },
    {TR_BUILDING_DOCK_CITIES_NO_ROUTES, "Nie ma otwartego handlu morskiego" },
    {TR_BUILDING_DOLPHIN_FOUNTAIN, "Fontanna z delfinem" },
    {TR_BUILDING_GARDEN_PATH, "Ścieżka ogrodowa" },
    {TR_BUILDING_GARDEN_WALL, "Zapętlona ściana ogrodowa" },
    {TR_BUILDING_GRAND_GARDEN, "Wielki ogród" },
    {TR_BUILDING_HEDGE_DARK, "Zielenisty krzew" },
    {TR_BUILDING_HEDGE_LIGHT, "Naświetlony krzew" },
    {TR_BUILDING_HIPPODROME_PHASE_1, "(Tor)" },
    {TR_BUILDING_HIPPODROME_PHASE_2, "(Fundamenty)" },
    {TR_BUILDING_HIPPODROME_PHASE_3, "(Trybuny)" },
    {TR_BUILDING_HIPPODROME_PHASE_4, "(Fasada)" },
    {TR_BUILDING_HIPPODROME_PHASE_1_TEXT, "To ogromne miejsce jest skrupulatnie badane i przygotowywane dla projektu na bezprecedensową skalę." },
    {TR_BUILDING_HIPPODROME_PHASE_2_TEXT, "Wokół toru budowane są dojścia i konstrukcje wsporcze." },
    {TR_BUILDING_HIPPODROME_PHASE_3_TEXT, "Masoni rzeźbią kamienne siedzenia dla dziesiątek tysięcy widzów." },
    {TR_BUILDING_HIPPODROME_PHASE_4_TEXT, "Rzemieślnicy tworzą coś więcej niż zwykły tor wyścigowy, jest to  pomnik godny bogów i ludu Rzymu." },
    {TR_BUILDING_HORSE_STATUE, "Pomnik konny" },
    {TR_BUILDING_INFO_TOURISM, "(podróżnicy)" },
    {TR_BUILDING_LARARIUM, "Lararium" },
    {TR_BUILDING_LARGE_MAUSOLEUM, "Duże Mauzoleum"},
    {TR_BUILDING_LARGE_MAUSOLEUM_DESC, "Wypolerowane marmurowe ściany i posągi tej wspaniałej budowli odzwierciedlają wielkie czyny patrycjuszy, którzy zasłużyli na przywilej spoczynku tutaj ." },
    {TR_BUILDING_LEGION_STATUE, "Pomnik legionu" },
    {TR_BUILDING_LIBRARY_UPGRADE_DESC, "Ta biblioteka już działa. Rozwój lokalny pozwolił twoim obywatelom na rozbudowę budynku, dostarczając dodatkowe zwoje i kąciki do czytania." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_TITLE, "Polityka handlu morskiego" },
    {TR_BUILDING_LIGHTHOUSE_NO_POLICY, "Brak polityki handlu morskiego." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_TEXT, "Wybierz politykę handlu morskiego dla Twojego miasta. Możesz zmienić na inną politykę w każdym czasie." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_1_TITLE, "Consilium venditor maritimae" },
    {TR_BUILDING_LIGHTHOUSE_POLICY_1, "Polityka morskiego sprzedawcy: Eksport morski zarabia 20% więcej, ale import morski jest o 10% droższy." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_2_TITLE, "Consilium emptor maritimae" },
    {TR_BUILDING_LIGHTHOUSE_POLICY_2, "Polityka morskiego kupcy: Import morski kosztuje 20% mniej, ale eksport morski zarabia o 10% mniej." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_3_TITLE, "Consilium quantitas maritimae" },
    {TR_BUILDING_LIGHTHOUSE_POLICY_3, "Polityka morska ilościowa: Statki handlowe przewożą 4 towary więcej, ale poruszają się o 10% wolniej." },
    {TR_BUILDING_MONUMENT_CONSTRUCTION_ARCHITECT_NEEDED, "Ten pomnik ma wszystkie materiały potrzebne do tej fazy.Pracownicy czekają na wykwalifikowanego architekta z gildii architektów, który będzie nadzorować dalszą budowę." },
    {TR_BUILDING_MONUMENT_CONSTRUCTION_DESC, "Budowa pomnika wymaga materiałów przechowywanych w magazynie, robotników z obozu pracy i architektów z cechu architektów ." },
    {TR_BUILDING_MONUMENT_CONSTRUCTION_HALTED, "Budowa wstrzymana." },
    {TR_BUILDING_NYMPHAEUM, "Nymphaeum"},
    {TR_BUILDING_NYMPHAEUM_DESC, "Ta wielka świątynia poświęcona jest nimfom wodnym - pomniejszym bóstwom wiosny, rzeki i morza. Obiecuje piękno i dostatek okolicznej ziemi oraz boską łaskę dla miasta." },
    {TR_BUILDING_SCHOOL_UPGRADE_DESC, "Ta szkoła działa. Rozwój lokalny pozwolił twoim mieszkańcom na rozbudowę budynku, zapewniając miejsce dla większej liczby dzieci."},
    {TR_BUILDING_SMALL_MAUSOLEUM, "Małe Mauzoleum"},
    {TR_BUILDING_SMALL_MAUSOLEUM_DESC, "Ten budynek jest miejscem spoczynku minionych pokoleń dumnych rodzin z Twojego miasta i jest źródłem zazdrości wielu nadal żyjących." },
    {TR_BUILDING_SMALL_TEMPLE_CONSTRUCTION_DESC, "Budowa tej świątyni będzie wymagała materiałów przechowywanych w magazynie, robotników z obozu pracy i architektów z gildii architektów ." },
    {TR_BUILDING_SMALL_TEMPLE_PHASE_1, "(Budowa)" },
    {TR_BUILDING_SMALL_TEMPLE_PHASE_1_TEXT, "Masoni i inżynierowie budują tą świętą budowlę z lśniącego marmuru." },
    {TR_BUILDING_TAVERN, "Tawerna" },
    {TR_BUILDING_TAVERN_DESC_1, "Ta tawerna nie ma pracowników, więc nie może się otworzyć." },
    {TR_BUILDING_TAVERN_DESC_2, "Ta tawerna nie ma wina, więc nie może się otworzyć." },
    {TR_BUILDING_TAVERN_DESC_3, "Ta tawerna zapewnia rozrywkę tak długo, aż otrzymuje dostawy wina. Dostawy mięsa zwiększyłyby efektywność lokalu." },
    {TR_BUILDING_TAVERN_DESC_4, "Obfite wino i zapach pieczonego mięsa przyciągają do tej tawerny żywy tłum, do hazardu, muzyki i radości." },
    {TR_BUILDING_THEATRE_UPGRADE_DESC, "Ten teatr działa. Rozwój lokalny pozwolił twoim mieszkańcom na rozbudowę budynku, zapewniając więcej miejsc dla widowni." },
    {TR_BUILDING_WATCHTOWER, "Wieża wartownicza"},
    {TR_BUILDING_WATCHTOWER_DESC, "Łucznicy na krenelażach tej wieży czujnie obserwują, szukając najeźdźców, podczas gdy strażnicy patrolują ulice poniżej." },
    {TR_BUILDING_WINDOW_HOUSE_RECENT_EVENT_POSITIVE, "Mieszkańcy zostali podniesieni na duchu przez ostatnie wydarzenie." },
    {TR_BUILDING_WINDOW_HOUSE_RECENT_EVENT_NEGATIVE, "Mieszkańcy utracili ducha przez ostatnie wydarzenie." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_1, "Mieszkańcy nienawidzę Twoję imię."},
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_2, "Mieszkańcy są wobec Ciebie bardzo wściekli." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_3, "Mieszkańcy są wobec Ciebie wściekli." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_4, "Mieszkańcy są wobec Ciebie bardzo niezadowoleni." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_5, "Mieszkańcy są wobec Ciebie niezadowoleni." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_6, "Mieszkańcy są na Ciebie zdnenerwowani." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_7, "Mieszkańcy są wobec Ciebie obojętni." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_8, "Mieszkańcy są wobec Ciebie zadwoloeni." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_9, "Mieszkańcy są wobec Ciebie bardzo zadowoleni." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_10, "Mieszkańcy są wobec Ciebie niezwykle zadowoleni." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_11, "Mieszkańcy kochaję Ciebie." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_12, "Mieszkańcy idolizują Ciebie jako bóstwo." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_HIGH_TAXES, "Mieszkańcy są niezadowoleni wysokimi podatkami." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_LOW_WAGES, "Mieszkańcy są niezadowoleni niskimi płacami." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_UNEMPLOYMENT, "Mieszkańcy są niezadowoleni z powodu braku miejsc pracy." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_SQUALOR, "Mieszkańcy są przygnębieni niskim stanem ich domostwa." },
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_ENTERTAINMENT, "Mieszkańcy doceniliby więcej rozrywki." },
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_FOOD, "Mieszkańcy doceniliby urozmaiconą dietę." },
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_DESIRABILITY, "Mieszkańcy doceniliby większą pożądalność terenu." },
    {TR_BUTTON_HALT_MONUMENT_CONSTRUCTION, "Wstrzymaj budowlę" },
    {TR_BUTTON_RESUME_MONUMENT_CONSTRUCTION, "wznów budowlę" },
    {TR_CARAVANSERAI_SPECIAL_ORDERS_HEADER, "Instrukcje dla Caravanserai"},
    {TR_CITY_MESSAGE_TEXT_COLOSSEUM_WORKING, "Inauguracyjne rozgrwyki w Twoim koloseum się rozpoczęły. Po Twoim rozkazie, ten monument będzie konsekrowany krwią walecznych!" },
    {TR_CITY_MESSAGE_TITLE_COLOSSEUM_WORKING, "Inauguracyjne rozgrwyki" },
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_PLANNING, "Woda ze zbiorników Twojego miasta powoli wypełnia Koloseum. Stolarze zaczynają składać realistyczne miniaturowe statki wojenne, podczas gdy gladiatorzy trenują do walki na wodzie. Wkrótce rozpoczną się Igrzyska Morskie!" },
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_STARTING, "Koloseum stało się sztucznym jeziorem, gdzie gladiatorzy odtwarzają wielkie rzymskie zwycięstwa na morzu. Krew i woda mieszają się, podczas gdy tłum krzyczy z aprobatą. Naumachia - igrzyska morskie - rozpoczęły się!" },
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_ENDING, "Rozpoczyna się długi proces czyszczenia Koloseum, jest ono opróżniane i przygotowywane do normalnego użytku. Twoi obywatele będą mówić o tym wielkim wodnym spektaklu przez wiele lat." },
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_PLANNING, "W Twoim mieście zaczynają pojawiać się dziwne ładunki, gdyż handlarze z najdalszych zakątków ziemi dostarczają przerażające bestie do klatek pod Kolosem. Wkrótce makabryczny spektakl będzie zachwycać Twoich obywateli." },
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_STARTING, "Skazani przestępcy i gladiatorzy poszukujący ostatecznej chwały stają w obliczu śmierci w postaci zębów i pazurów. Igrzyska ze zwierzętami rozpoczęły się z hukiem trąbek!"},
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_ENDING, "Ostatnie z dzikich bestii leżą zabite w piaskach Koloseum, a ich krew zmieszała się z krwią skazańców. Igrzyska ze zwierzętami dobiegły końca." },
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_PLANNING, "Nowy rok powitamy wspaniałą grą ku czci bogów. W zamian prosimy o szczęście, pomyślność i błogosławieństwa w sprawach handlowych." },
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_STARTING, "Igrzyska rozpoczynają się o wschodzie słońca na Kalendach Ianuriusza. Kapłani składają ofiary ze zwierząt, podczas gdy gladiatorzy opasują swoje ramiona, aby umrzeć, szukając łaski bogów." },
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_ENDING, "Wróżby sugerują, że bogowie byli bardzo zadowoleni z naszych wspaniałych gier oraz z okazanych im ofiar i czci. Możemy spodziewać się bardzo dochodowego roku!" },
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_PLANNING, "Wszystkie oczy będą skierowane na Twoje miasto, gdy Igrzyska Olimpijskie przyciągają podróżników, zawodników i rzymskich dostojników z całego świata. Zajmie nie mniej niż cały rok, aby dokończyć wszystkie możliwe przygotowania." },
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_STARTING, "Nadszedł ten dzień. Zapala się święty płomień, a ulice Twojego miasta są opuszczone, gdyż obywatele pakują się do wielkiego hipodromu. Niech rozpoczną się igrzyska!" },
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_ENDING, "Święty płomień gaśnie, a podróżnicy i obywatele udają się do domów w znużonym uniesieniu. Masz wieczną chwałę za pomyślne prowadzenie tego starożytnego święta śmiertelnej siły i honoru." },
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_PLANNING, "Wraz z ogłoszeniem Igrzysk Rzymskich ludzie z najdalszych zakątków gromadzą się w Twoim mieście, a wielu ma nadzieję na wygranie nadchodzących konkursów. Zajmie nie mniej niż cały rok, aby dokończyć wszystkie możliwe przygotowania ." },
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_STARTING, "Rozpoczyna się uroczysta procesja, a wraz z nią igrzyska rzymskie. Niech sam Jowisz wybierze mistrzów wyścigów, walk zapaśniczych i innych zawodów wytrzymałości i zwinności. Koloseum jest wypełnione po brzegi obywatelami oczekującymi na igrzyska i zwyczajowe prezenty w postaci pszenicy i oliwy z oliwek. Niech rozpoczną się igrzyska!" },
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_ENDING, "Kończy się ostatni dzień Igrzysk Rzymskich. Przepełniony ekscytacją i z pełnymi brzuchami, każdy obywatel zasmakował wielkości rzymskiego życia. Chwała bogom, chwała zwycięzcom i chwała gubernatorowi!" },
    {TR_CITY_MESSAGE_TITLE_GREAT_GAMES, "Wielkie Igrzyska"},
    {TR_CITY_MESSAGE_TITLE_LOOTING, "Łupienie w mieście!"},
    {TR_CITY_MESSAGE_TEXT_LOOTING, "Magazyn lub spichlerz został splądrowany przez wściekłych obywateli, a towary zostały skradzione! Niskie zadowolenie mieszkańców zwiększa prawdopodobieństwo wystąpienia takich incydentów ."},
    {TR_CITY_WARNING_GRANARY_BREAKIN, "Spichlerz został złupiony!" },
    {TR_CITY_WARNING_SECESSION, "Plebejusze odmawiają pracy!" },
    {TR_CITY_WARNING_THEFT, "Fundusze zostały ukradzione z forum bądź senatu!" },
    {TR_CITY_WARNING_WAREHOUSE_BREAKIN, "Magazyn został złupiony!" },
    {TR_CONFIG_ALLOW_EXPORTING_FROM_GRANARIES, "Pozwól handlarzom eksportować jedzenie ze spichlerzy"},
    {TR_CONFIG_ARE_YOU_SURE, "Zresetować do domyślnych?"},
    {TR_CONFIG_AUDIO, "Opcje dzwięku"},
    {TR_CONFIG_CITY_SOUNDS, "Włącz dzwięki miasta"},
    {TR_CONFIG_DIFFICULTY, "Poziom trudności:"},
    {TR_CONFIG_MAX_GRAND_TEMPLES, "Maksymalna liczba wielkich świątyń:" },
    {TR_CONFIG_INFINITE, "Bez limitu" },
    {TR_CONFIG_USE_COLOR_CURSORS, "Użyj kolorowych kursorów" },
    {TR_CONFIG_VIDEO_SOUND, "Włącz dźwięk filmów" },
    {TR_CONFIG_EFFECTS, "Włącz efekty dzwiękowe"},

    {TR_CONFIG_ENABLE_AUDIO, "Włącz dźwięk"},
    {TR_CONFIG_FULLSCREEN, "Pełny ekran"},
    {TR_CONFIG_GAME_SPEED, "Prędkość gry:"},
    {TR_CONFIG_GODS_EFFECTS, "Włącz błogosławieństwa i klątwy bogów"},
    {TR_CONFIG_GP_CH_DISABLE_INFINITE_WOLVES_SPAWNING, "Wyłącz nieskończone pojawianie się wilków"},
    {TR_CONFIG_HEADER_GENERAL, "Ustawienia ogólne"},
    {TR_CONFIG_MUSIC, "Włącz muzykę"},
    {TR_CONFIG_ROAMERS_DONT_SKIP_CORNERS, "Wędrujący piesi nie omijają zakrętu"},
    {TR_CONFIG_SCROLL_SPEED, "Prędkość skrolowania:"},
    {TR_CONFIG_SHOW_MAX_POSSIBLE_PROSPERITY, "Wyświetl maksymalną możliwą do osiągnięcia ocenę dobrobytu przy aktualnej zabudowie "},
    {TR_CONFIG_SPEECH, "Włącz mowę"},
    {TR_CONFIG_VIDEO, "Opcje wideo"},
    {TR_CONFIG_VOLUME, "Głośność"},
    {TR_CONFIG_UI_INVERSE_MAP_DRAG, "Odwróć kierunki przy przeciąganiu mapy prawym przyciskiem" },
    {TR_CONFIG_UI_MESSAGE_ALERTS, "Pokazuj nowe wiadomości jako ostrzeżenia zamiast wiadomości" },
    {TR_CONFIG_WINDOWED_RESOLUTION, "Rozdzielność w oknie:"},
    {TR_CONFIG_YOU_WILL_LOSE_YOUR_CONFIGS, "Stracisz wszystkie spersonalizowane konfiguracje."},
    {TR_CONFIG_YOU_WILL_LOSE_YOUR_HOTKEYS, "Stracisz wszystkie spersonalizowane skróty klawiszowe."},
    {TR_DOCK_SPECIAL_ORDERS_HEADER, "Instrukcje dla docku"},
    {TR_FIGURE_TYPE_BARKEEP, "Barman" },
    {TR_FIGURE_TYPE_BARKEEP_SUPPLIER, "Dostawca tawerny " },
    {TR_FIGURE_TYPE_CARAVANSERAI_COLLECTOR, "Kolektor Caravanserai" },
    {TR_FIGURE_TYPE_CARAVANSERAI_SUPPLIER, "Dostawca Caravanserai" },
    {TR_FIGURE_TYPE_LOOTER, "Szabrownik" },
    {TR_FIGURE_TYPE_ROBBER, "Złodziej" },
    {TR_FIGURE_TYPE_TOURIST,  "Podróźnik"},
    {TR_FIGURE_TYPE_WATCHMAN, "Strażnik" },
    {TR_HOTKEY_DUPLICATE_MESSAGE, "Ta kombinacja klawiszowa już jest wyznaczona dla tej czynności:"},
    {TR_HOTKEY_DUPLICATE_TITLE, "Klawisz już użyty"},
    {TR_HOTKEY_ROTATE_BUILDING, "Rotuj budynek"},
    {TR_HOTKEY_ROTATE_BUILDING_BACK, "Poprzednia rotacja budynku" },
    {TR_HOTKEY_SHOW_ADVISOR_HOUSING, "Doradca mieszkalnictwa"},
    {TR_HOTKEY_SHOW_OVERLAY_RELATIVE, "Pokaż nakładkę względną"},
    {TR_MARKET_NOT_TRADING, "Nie handluje"},
    {TR_MARKET_TRADING, "Handluje"},
    {TR_MESS_HALL_SPECIAL_ORDERS_HEADER, "Instrukcje dla messy"},
    {TR_OPTION_MENU_APPLY, "Zastosuj" },
    {TR_OVERLAY_ARENA_COL, "Arena" },
    {TR_OVERLAY_SENTIMENT, "Nastrój" },
    {TR_OVERLAY_EFFICIENCY, "Efektywność"},
    {TR_OVERLAY_TAVERN, "Tawerna" },
    {TR_RESOURCE_FISH, "Ryby" },
    {TR_SAVEGAME_LARGER_VERSION_TITLE, "Niezgodna wersja stanu gry"},
    {TR_SAVEGAME_LARGER_VERSION_MESSAGE, "Zapisana gra, którą próbujesz załadować, jest zapisana w nowszej wersji Augustusa. \nUaktualnij Augustusa do najnowszej wersji." },
    {TR_SAVEGAME_NOT_ABLE_TO_SAVE_TITLE, "Nie można zapisać gry" },
    {TR_SAVEGAME_NOT_ABLE_TO_SAVE_MESSAGE, "Nie można zapisać gry.\nMożliwe, że folder w którym jest zainstalowany Cezar 3 wymaga uprawnień administratora.\nZmień lokalizację folderu Cezara 3 do miejsa, które nie wymaga uprawnień administratora lub uruchom Augustusa jako administrator (Niezalecane)." },
    {TR_SELECT_GAMES_HEADER, "Igrzyska" },
    {TR_SELECT_GAMES_TEXT, "Igrzyska odbędą się w Koloseum, kosztować to będzie Twoje osobiste fundusze i zasoby Twojego miasta ." },
    {TR_SIDEBAR_EXTRA_INVASIONS, "Inwazje" },
    {TR_SIDEBAR_EXTRA_INVASION_UNDERWAY, "Inwazja w toku" },
    {TR_SIDEBAR_EXTRA_NO_INVASIONS, "Brak Inwazji" },
    {TR_SIDEBAR_EXTRA_INVASION_IMMINENT, "Bliska Inwazja" },
    {TR_SIDEBAR_EXTRA_ENEMIES_CLOSING, "Zbliżający się wrogowie" },
    {TR_SIDEBAR_EXTRA_ENEMIES_DISTANT, "Dalecy wrogowie" },
    {TR_SIDEBAR_EXTRA_GODS, "Bogowie" },
    {TR_SIDEBAR_EXTRA_REQUESTS_VIEW_ALL, "Zobacz Wszystko" },
    {TR_SIDEBAR_EXTRA_REQUESTS_SMALL_FORCE, "Mała jednostka"},
    {TR_SIDEBAR_EXTRA_REQUESTS_AVERAGE_FORCE, "Średnia jednostka"},
    {TR_SIDEBAR_EXTRA_REQUESTS_LARGE_FORCE, "Duża jednostka"},
    {TR_SIDEBAR_EXTRA_REQUESTS_SEND, "Spełnij prośbę"},
    {TR_SIDEBAR_EXTRA_REQUESTS_STOCK, "Gromadź"},
    {TR_SIDEBAR_EXTRA_REQUESTS_UNSTOCK, "Przestań gromadzić"},
    {TR_TAVERN_SPECIAL_ORDERS_HEADER, "Instrukcje dla tawerny"},
    {TR_TEMPLE_DISTRIBUTING, "Dystrybuje"},
    {TR_TEMPLE_NOT_DISTRIBUTING, "Nie dystrybuje"},
    {TR_TEMPLE_SPECIAL_ORDERS_HEADER, "Instrukcje dla świątyni"},
    {TR_TOOLTIP_ADVISOR_ENTERTAINMENT_GAMES_BUTTON, "Informacje o igrzyskach" },
    {TR_TOOLTIP_ADVISOR_HOUSING_GRAPH_BUTTON, "Idź do wykresu populacji" },
    {TR_TOOLTIP_ADVISOR_POPULATION_HOUSING_BUTTON, "Odwiedź doradcę mieszkalnictwa" },
    {TR_TOOLTIP_ADVISOR_TRADE_LAND_POLICY, "Wybierz politykę handlu lądowego"},
    {TR_TOOLTIP_ADVISOR_TRADE_LAND_POLICY_REQUIRED, "Caravanserai jest potrzebne by ustalić politykę handlu lądowego"},
    {TR_TOOLTIP_ADVISOR_TRADE_SEA_POLICY, "Wybierz politykę handlu morskiego"},
    {TR_TOOLTIP_ADVISOR_TRADE_SEA_POLICY_REQUIRED, "Latarnia morska jest potrzebna by ustalić politykę handlu morskiego"},
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MAINTENANCE, "Przełączaj dostęp prefektów i inżynierów" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_PRIEST, "Przełączaj dostęp kapłanów" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MARKET, "Przełączaj dostęp pracowników targowisk" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_ENTERTAINER, "Przełączaj dostęp pracownikom rozrywki" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_EDUCATION, "Przełączaj dostęp pracownikom edukacji" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MEDICINE, "Przełączaj dostęp pracownikom zdrowia" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_TAX_COLLECTOR, "Przełączaj dostęp celnikom" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_LABOR_SEEKER, "Przełączaj dostęp poszukiwaczy pracowników" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MISSIONARY, "Przełączaj dostęp misjonarzom" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_WATCHMAN, "Przełączaj dostęp strażnikom" },
    {TR_TOOLTIP_HOLD_GAME, "Urządź igrzyska"},
    {TR_TOOLTIP_NO_GAME, "Nie urządzaj igrzysk"},
    {TR_TOOLTIP_OVERLAY_ARENA_COL_1, "To mieszkanie nie ma dostępu do areny czy koloseum." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_2, "To mieszkanie ma dostęp do areny z jednym widowiskiem." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_3, "To mieszkanie ma dostęp do areny z dwoma widowiskami." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_4, "To mieszkanie ma dostęp do koloseum z jednym widowiskiem." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_5, "To mieszkanie ma dostęp do koloseum z dwoma widowiskami." },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_CARTPUSHER, "Czeka na pchacza wozu" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_MOTHBALLED, "Budynek wyłączony" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_PLAGUE, "Budynek jest zarażony" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_NO_RESOURCES, "Nie ma surowców" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_NO_WATER_ACCESS, "Nie ma dostępu do wody" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_STRIKE, "Pracownicy strajkują" },
    {TR_TOOLTIP_OVERLAY_TAVERN_1, "Ten dom nie ma dostępu do tawerny lub jego zapasy jego tawerny wyschły od wina." },
    {TR_TOOLTIP_OVERLAY_TAVERN_2, "Żaden barman nie przechodził przez jakiś czas. Ten dom wkrótce straci dostęp do swojej tawerny." },
    {TR_TOOLTIP_OVERLAY_TAVERN_3, "Ten dom minął barman z tawerny z winem." },
    {TR_TOOLTIP_OVERLAY_TAVERN_4, "Ten dom minął barman z tawerny z winem i mięsem." },
    {TR_TOOLTIP_OVERLAY_TAVERN_5, "Ten dom przeszedł niedawno przez barmana z tawerny z winem." },
    {TR_TOOLTIP_OVERLAY_TAVERN_6, "Ten dom przeszedł niedawno przez barmana z tawerny z winem i mięsem. Niech rozpocznie się zabawa!" },
    {TR_WARNING_NEARBY_WOLF, "Nie można budować kiedy wilki są w pobliżu" },
    {TR_WARNING_VARIANT_TOGGLE, "Naciśnij klawisz rotacji, aby przełączać się między wariantami tego budynku"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_ARENA_COVERAGE, "Areny" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_FULL_COVERAGE, "Wszyscy" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_BUTTON, "Urządź igrzyska" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_COOLDOWN, "Miesiące aż kolejne igrzyska mogą się odbyć: " },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_COOLDOWN_TEXT, "Wielkie igrzyska były niedawno urządzone." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_DESC, "Sponsoruj wielkie igrzyska w swoim Koloseum, kosztem osobistych funduszy i zasobów Twojego miasta." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_HEADER, "Igrzyska" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_PREPARING, "Trwają przygotowania do Wielkich Igrzysk." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_UNDERWAY, "Wielkie igrzyska są urządzane! Twoje miasto jest przepełnione podróźnikami i radowaniem." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_NO_COVERAGE, "Nikt" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_NG, "Miesiące do Igrzysk Morskich:"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_NG, "Igrzyska morskie trwają. Plusk wody, skrzypienie belek i okrzyki bojowe gladiatorów potęgują ryk tłumu." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_AG, "Miesiące do Igrzysk Zwierząt:"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_AG, "Igrzyska są w toku. Ramię w ramię, tłum krzyczy, gdy dzikie bestie tropią ich ludzką ofiarę." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_KG, "Miesiące do igrzysk Kalends:"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_KG, "Igrzyska Kalendów trwają.Zapach ofiar ze zwierząt i kadzideł pokonuje nawet ostrą krew i pot na arenie." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_OG, "Miesiące do igrzysk olimpijskich:"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_OG, "Igrzyska Olimpijskie trwają.Święty ogień płonie dzień i noc, gdy sportowcy walczą o nieśmiertelną chwałę." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_IG, "Miesiące do Igrzysk Rzymskich:"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_IG, "Trwają Igrzyska Rzymskie.Każdy uczestnik rozlewa krew, pot i łzy, aby udowodnić, że jest najlepszym Rzymianinem." },
    {TR_BUILDING_WINDOW_INDUSTRY_EFFICIENCY, "Efektywność:" },
    {TR_BUILDING_WINDOW_INDUSTRY_EFFICIENCY_TOOLTIP, "Efektywność to stosunek ile budynek wyprodukował do ile mógł wyprodukować poprzedniego roku." },
    {TR_BUILDING_WINDOW_INDUSTRY_LOW_EFFICIENCY_RAW_MATERIALS, "Ten budynek ma niską efektywność. To może być spowodowane dużą odległością od miejsca przeznaczenia" },
    {TR_BUILDING_WINDOW_INDUSTRY_LOW_EFFICIENCY_WORKSHOPS, "Ten budynek ma niską efektywność. To  może być spowodowane brakiem ciągłego dostępu do surowców lub dużą odległością od miejsca przeznaczenia." },
    {TR_BUILDING_WINDOW_INDUSTRY_WHARF_AVERAGE_CATCH, "Średni miesięczny połów:" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_TAVERN_COVERAGE, "Tawerny" },
    {TR_WINDOW_ADVISOR_FINANCE_INTEREST_TRIBUTE, "Trybut/oprocentowanie"},
    {TR_WINDOW_ADVISOR_TOURISM, "Rozmaite"},
    {TR_WINDOW_BUILDING_ARENA_NO_SHOWS, "Na tej arenie nie ma ani lwów, ani gladiatorów i nie zapewnia ona zbyt wiele rozrywki." },
    {TR_WINDOW_BUILDING_ARENA_BOTH_SHOWS, "Na tej arenie odbywają się gladiatorzy i polowania na zwierzęta, ku uciesze mieszkańców." },
    {TR_WINDOW_BUILDING_ARENA_NEEDS_LIONS, "Regularne pokazy gladiatorów zapewniają rozrywkę tłumowi, ale lwy podniosłyby poziom widowiska." },
    {TR_WINDOW_BUILDING_ARENA_NEEDS_GLADIATORS, "Głodne bestie grasują po arenie w poszukiwaniu zdobyczy, ale brak wyszkolonych gladiatorów sprawia, że na krótkie pokazy." },
    {TR_WINDOW_BUILDING_GAMES_REMAINING_DURATION, "Wielkie igrzyska będą kontynuowane przez" }, // ...XX Days, 
    {TR_WINDOW_BUILDING_GOVERNMENT_LARGE_STATUE_WATER_WARNING, "Ten posąg wyglądałby jeszcze wspanialej z działającą fontanną.Zapewnij mu dostęp do wody." },
    {TR_WINDOW_BUILDING_INFO_WARNING_NO_MONUMENT_ROAD_ACCESS, "Ten plac budowy pomnika nie ma dostępu do drogi i nie może przyjmować materiałów. Połącz drogę z jednym ze środkowych kafelków."},
    {TR_WINDOW_BUILDING_LARARIUM_DESC, "Ta mała świątynia poświęcona jest duchom przodków ludu rzymskiego. Można tu składać małe ofiary i modlitwy."},
    {TR_WINDOW_BUILDING_TOURISM_DISABLED, "Zbyt wiele budynków tego typu - podróżni omijają to miejsce." },
    {TR_WINDOW_BUILDING_TOURISM_ANNUAL, "Dochód od podróżników w tym roku:"},
    {TR_WINDOW_BUILDING_WHARF_MOTHBALLED, "Twój doradca handlowy nakazał wstrzymanie produkcji ryb."},
    {TR_WINDOW_BUILDING_WORKSHOP_STRIKING, "Z powodu niskiego nastroju miasta plebejusze tego warsztatu ogłosili secesję i odmawiają pracy!" },
    {TR_WINDOW_FIGURE_TOURIST, "Ten podróźnik wydał: "},
    {TR_WINDOW_GAMES_COST, "Koszt:" },
    {TR_WINDOW_GAMES_NOT_ENOUGH_FUNDS, "Za mało funduszy osobistych." },
    {TR_WINDOW_GAMES_NOT_ENOUGH_RESOURCES, "Za mało przechowywanych zasobów." },
    {TR_WINDOW_GAMES_NO_VENUE, "Scena nie zostało zbudowana lub nie ma pracowników." },
    {TR_WINDOW_GAMES_OPTION_1, "Urządź Igrzyska Morskie" },
    {TR_WINDOW_GAMES_OPTION_2, "Urządź Igrzyska Zwierzęce" },
    {TR_WINDOW_GAMES_OPTION_3, "Urządź Kalendy Januariusza" },
    {TR_WINDOW_GAMES_OPTION_4, "Urządź Igrszyska Olimpijskie" },
    {TR_WINDOW_GAMES_OPTION_5, "Urządź Igrzyska Rzymskie" },
    {TR_WINDOW_GAMES_OPTION_1_DESC, "Koloseum zostanie zalane, aby odtworzyć wielką bitwę morską. Szybkość poruszania się twoich żołnierzy i ich siła w odległych bitwach zostanie zwiększona na następny rok." },
    {TR_WINDOW_GAMES_OPTION_2_DESC, "Koloseum będzie miejscem makabrycznych polowań na zwierzęta i egzekucji dzikich bestii, zachwycając plebejskie masy. Przestępczość, zamieszki i bunty zostaną stłumione na następny rok. Gladiatorzy pomogą obronić miasto przed kolejną inwazją." },
    {TR_WINDOW_GAMES_OPTION_3_DESC, "Koloseum będzie gospodarzem igrzysk ku czci bogów pierwszego dnia przyszłego roku, błagając o szczęście i dobrobyt. W przyszłym roku kwoty handlowe zostaną podwojone." },
    {TR_WINDOW_GAMES_OPTION_4_DESC, "Hipodrom będzie gospodarzem igrzysk olimpijskich. Twoje miasto będzie gościć rzesze odwiedzających, a jeśli Twoi sportowcy będą dobrze szanować Twoje miasto, zyskasz stały wzrost turystyki i przychylności." },
    {TR_WINDOW_GAMES_OPTION_5_DESC, "Koloseum będzie gospodarzem Igrzysk Rzymskich, podczas których ludzie będą podróżować do Twojego miasta z całego imperium, aby rywalizować ze sobą. Taki wielki spektakl z pewnością przyniesie Tobię przychylność zarówno cesarza, jak i zwykłych ludzi na następny rok." },
    {TR_WINDOW_GAMES_PERSONAL_FUNDS, "(fundusze osobiste)" },
    {TR_CITY_MESSAGE_SQUALOR, "Nędza i slumsy stanowią problem." },
    {TR_FIGURE_TYPE_LIGHTHOUSE_SUPPLIER, "Latarnik" },
    {TR_WINDOW_GAMES_NO_WATER_ACCESS, "Budynek nie ma dostępu do rezerwuaru." },
    {TR_HOTKEY_COPY_SETTINGS, "Skopiuj ustawienia budynku" },
    {TR_HOTKEY_PASTE_SETTINGS, "Wklej ustawienia budynku" },
    {TR_WINDOW_ADVISOR_RELIGION_LARARIUMS, "Lararia w mieście" },
    {TR_WINDOW_RACE_BET_BUTTON, "Postaw na konia" },
    {TR_WINDOW_RACE_YOUR_BET, "Postawiono" },
    {TR_WINDOW_IN_PROGRESS_BET_BUTTON, "Wyścig w toku..." },
    {TR_WINDOW_RACE_BET_TITLE, "Postaw zakład na konia" },
    {TR_WINDOW_RACE_BET_AMOUNT, "Stawka" },
    {TR_WINDOW_RACE_BET_DESCRIPTION, "Bet an amount of your personal funds on the chariot team of your choice, and double your stake if your horse wins. Your earnings will even be quadrupled during the Colosseum Games!" },
    {TR_WARNING_BET_VICTORY, "Twój koń wygrał wyścig w miejskim hipodromie." },
    {TR_WARNING_BET_DEFEAT, "Twój koń przegrał wyścig w miejskim hipodromie." },
    {TR_PERSONAL_SAVINGS, "Fundusze :" },
    {TR_WINDOW_RACE_BET_BLUE_HORSE, "Postaw na niebieskiego konia" },
    {TR_WINDOW_RACE_BET_RED_HORSE, "Postaw na czerwonego konia" },
    {TR_WINDOW_RACE_BET_WHITE_HORSE, "Postaw na białego konia" },
    {TR_WINDOW_RACE_BET_GREEN_HORSE, "Postaw na zielonego konia" },
    {TR_BUILDING_GRAND_TEMPLE_NEEDS_WORKERS, "Bez pełnej obsady kapłanów, ta świątynia nie może przeprowadzać wszystkich świąt i rytuałów. Do czasu kiedy to się zmieni, nie możemy oczekiwać boskiego wsparcia." },
    {TR_BUILDING_COLOSSEUM_NEEDS_WORKERS, "Koloseum potrzebuje więcej pracowników, aby obywatele mogli w pełni cieszyć się z igrzysk w naszym mieście." },
    {TR_BUILDING_HIPPODROME_NEEDS_WORKERS, "Bez pełnej obsady pracowników, hipodrom nie może zapewnić spektakularnej rozrywki obywatelom miasta." },
    {TR_BUILDING_LIGHTHOUSE_NEEDS_WORKERS, "Bez wystarczającej liczby pracowników, latarnia nie może utrzymać ognia przez cały dzień. Statki mają problem by znaleźć doki naszego miasta."},
    {TR_BUILDING_CARAVANSERAI_NEEDS_WORKERS, "Caravanserai nie ma wystarczającej liczby pracowników by obsłużyć wszystkie karawany."},
    {TR_BUILDING_ROOFED_GARDEN_WALL, "Zadaszona ściana ogrodowa" },
    {TR_BUILDING_GARDEN_WALL_GATE, "Brama ogrodowa" },
    {TR_BUILDING_GARDEN_WALL_GATE_DESC, "Ta niewielka brama kontroluje przepływ ludzi do ustronnych punktów miasta." },
    {TR_WINDOW_BUILDING_DISTRIBUTION_CART_PUSHER_GETTING, "Pchacz wozu jest w drodze, aby odebrać towary z innego magazynu." },
    {TR_BUILDING_PALISADE, "Palisada" },
    {TR_BUILDING_PALISADE_DESC, "Ten ziemny wał, zakończony zaostrzonymi palami, zabezpieczy miasto przed najeźdźcami i dziki zwierzętami." },
    {TR_OVERLAY_MOTHBALL, "Wyłączone budynki" },
    {TR_OVERLAY_ENEMY, "Wrogowie" },
    {TR_BUILDING_TAVERN_DESC_5, "Obywatele uwielbiają odwiedzać to miejsce w wolnym czasie by porozmawiać nad posiłkiem i winem." },
    {TR_OVERLAY_WAREHOUSES, "Magazyny" },
    {TR_WINDOW_RACE_BLUE_HORSE_DESCRIPTION, "Drużyna niebieska, ulubieńcy Neptuna. Najbardziej obiecujący młodzi rydwaniści, którzy chcą udowodnić swoją odwagę." },
    {TR_WINDOW_RACE_RED_HORSE_DESCRIPTION, "Drużyna czerwona, sławna z najlepszego rydwanisty w historii Rzymu, byłego galernika, który uratował konsula Rzymu." },
    {TR_WINDOW_RACE_WHITE_HORSE_DESCRIPTION, "Drużyna biała, założona przez byłych gladiatorów. Mają walkę w krwi i nawet teraz, jako wolni ludzie wciąż żyją dla wyzwania."},
    {TR_WINDOW_RACE_GREEN_HORSE_DESCRIPTION, "Drużyna zielona, wywodząca się z Celeresów - straży przybocznej z czasów rzymskiej monarchii. Nawet teraz uważają się za najlepszych z najlepszych."},
    {TR_TOOLTIP_BUTTON_REJECT_WORKERS, "Wznów transport zasobów" },
    {TR_BUILDING_MARS_TEMPLE_MODULE_DESC_NO_MESS, "Świątynia zacznie zbierać żywność do punktu zaopatrzeniowego, gdy tylko ten zostanie zbudowany." },
    {TR_BUILDING_WATCHTOWER_DESC_NO_SOLDIERS, "Wieża potrzebuje strażnika z koszar zanim będzie mogła bronić naszego miasta." },
    {TR_CITY_MESSAGE_TEXT_COLOSSEUM_COMPLETE, "Koloseum zbudowane! Niech rozpoczną się igrzyska!" },
    {TR_CITY_MESSAGE_TEXT_HIPPODROME_COMPLETE, "Hipodrom zbudowany! Obywatele nie mogą doczekać się twojego rozkazu by rozpocząć wyścigi!" },
    {TR_CITY_MESSAGE_TEXT_HIPPODROME_WORKING, "Wyścigi rozpoczęte" },
    {TR_TOOLTIP_BUTTON_STOCKPILING_ON, "Włącz bezpośrednie dostawy do magazynu" },
    {TR_TOOLTIP_BUTTON_STOCKPILING_OFF, "Wyłącz dostawy do magazynu" },
    {TR_TOOLTIP_BUTTON_ACCEPT_WORKERS, "Wstrzymaj dostarczanie zasobów z magazynu" },
    {TR_WINDOW_BUILDING_ARENA_CLOSED, "Arena jest zamknięta. Ptaki zakładają gniazda w opuszczonych siedzeniach." },
    {TR_CONFIG_DIGIT_SEPARATOR, "Odstęp między cyframi"},
    {TR_WARNING_SCREENSHOT_SAVED, "Zapisano zrzut ekranu: "}, 
    {TR_TOOLTIP_OVERLAY_PROBLEMS_NO_LABOR, "Brak pracowników" },
    {TR_WINDOW_BUILDING_DISTRIBUTION_GRANARY_CART_PUSHER_GETTING, "Pchacz wozu jest w drodze, aby odebrać żywność z innego spichlerza." },
    {TR_WINDOW_BUILDING_DISTRIBUTION_CART_PUSHER_RETURNING_WITH, "Pchacz wozu wraca z dostawą." },
    {TR_BUTTON_YEARLY_AUTOSAVE_OFF, "Roczny autozapis WYŁ" },
    {TR_BUTTON_YEARLY_AUTOSAVE_ON, "Roczny autozapis WŁ" },
    {TR_BUILDING_DOCK_PLAGUE_DESC, "Statek handlowy przywiózł zarazę. Dok jest w kwarantanncie do czasu odkażenia." },
    {TR_BUILDING_GRANARY_PLAGUE_DESC, "Zarażony pracownik sprowadził tutaj zarazę. Ten spichlerz jest w kwarantannie do czasu odkażenia." },
    {TR_BUILDING_WAREHOUSE_PLAGUE_DESC, "Zarażony pracownik sprowadził tutaj zarazę. Ten magazyn jest w kwarantannie do czasu odkażenia." },
    {TR_BUILDING_HOUSE_DISEASE_DESC, "Wybuchła epidemia! Z powodu braku wystarczającej ochrony zdrowotnej, mieszkańcy tego domostwa zmarli. Domostwo jest zamknięte do czasu odkażenia" },
    {TR_BUILDING_FUMIGATION_DESC, "Ten budynek jest oczyszczany z zarazy. Odymianie powinno potrwać kilka dni." },
    {TR_OVERLAY_SICKNESS, "Choroba" },
    {TR_ADVISOR_SICKNESS_LEVEL_LOW, "Choroby są rzadkim zjawiskiem w tym mieście i handel funkcjonuje bez zarzutu. Wysokie standardy higieny efektywnie powstrzymują epidemię przed rozprzestrzenianiem."},
    {TR_ADVISOR_SICKNESS_LEVEL_MEDIUM, "W mieście występują choroby zakaźne, ale sytuacja jest pod kontrolą. Wysoki poziom opieki zdrowotnej dopilnuje żeby handel nie został zakłócony." },
    {TR_ADVISOR_SICKNESS_LEVEL_HIGH, "Choroby zakaźne rozprzestrzeniają się po mieście. Jeśli sytuacja nie zostanie szybko zażegnana, handel może ucierpieć. Potrzebne jest więcej klinik i szpitali aby skutecznie powstrzymać epidemię przed rozprzestrzenieniem się do innych obszarów." },
    {TR_ADVISOR_SICKNESS_LEVEL_PLAGUE, "Zaraza dotarła do miasta! Wielu obywateli zachorowało i handel jest poważnie ograniczony. Ostatni dostępni lekarze i chirurdzy zostali zaciągnięci do służb odkażających w najbardziej ucierpiałych obszarach. Poważne kroki muszą zostać podjęte!" },
    {TR_TOOLTIP_OVERLAY_SICKNESS_LOW, "Niewiele chorób" },
    {TR_TOOLTIP_OVERLAY_SICKNESS_MEDIUM, "Niewiele chorób zakaźnych" },
    {TR_TOOLTIP_OVERLAY_SICKNESS_HIGH, "Wiele chorób zakaźnych się rozprzestrzenia" },
    {TR_TOOLTIP_OVERLAY_SICKNESS_PLAGUE, "Zaraza nęka miasto" },
    {TR_CITY_MESSAGE_TITLE_SICKNESS, "Zaraza w mieście" },
    {TR_CITY_MESSAGE_TEXT_SICKNESS, "Zaraza wybuchła w mieście! Budynek jest w kwarantannie i lekarze lub chirurdzy zostali zaciągnięci do służby przy odkażaniu." },
    {TR_FIGURES_CARTPUSHER_GOING_TO_ROME, "Dostarcza żądanie do Rzymu" },
    {TR_CITY_WARNING_DATA_COPY_SUCCESS, "Ustawienia skopiowane" },
    {TR_CITY_WARNING_DATA_COPY_NOT_SUPPORTED, "Nie można skopiować ustawień tego budynku" },
    {TR_CITY_WARNING_DATA_PASTE_SUCCESS, "Ustawienia wklejone" },
    {TR_CITY_WARNING_DATA_PASTE_NOT_SUPPORTED, "Nie można wkleić" },
    {TR_HOTKEY_SHOW_OVERLAY_FOOD_STOCKS, "Widok zapasów żywności" },
    {TR_HOTKEY_SHOW_OVERLAY_ENTERTAINMENT, "Widok rozrywki" },
    {TR_HOTKEY_SHOW_OVERLAY_SCHOOL, "Widok szkół" },
    {TR_HOTKEY_SHOW_OVERLAY_LIBRARY, "Widok bibliotek" },
    {TR_HOTKEY_SHOW_OVERLAY_ACADEMY, "Widok akademii" },
    {TR_HOTKEY_SHOW_OVERLAY_BARBER, "Widok fryzjerów" },
    {TR_HOTKEY_SHOW_OVERLAY_BATHHOUSE, "Widok łaźni" },
    {TR_HOTKEY_SHOW_OVERLAY_CLINIC, "Widok klinik" },
    {TR_HOTKEY_SHOW_OVERLAY_SICKNESS, "Widok chorób" },
    {TR_HOTKEY_SHOW_OVERLAY_TAX_INCOME, "Widok podatków" },
    {TR_HOTKEY_SHOW_OVERLAY_RELIGION, "Widok religii" },
    {TR_HOTKEY_SHOW_OVERLAY_ROADS, "Widok dróg" },
    {TR_HOTKEY_ROTATE_MAP_NORTH, "Obróć mapę na północ" },
    {TR_HOTKEY_BUILD_WHEAT_FARM, "Farma zboża" },
    {TR_HOTKEY_SHOW_MESSAGES, "Pokaż wiadomości" },
    {TR_HOTKEY_SHOW_EMPIRE_MAP, "Pokaż mapę imperium" },
    {TR_TOGGLE_GRID, "Przełącz siatkę mapy" },
    {TR_CONFIG_UI_SHOW_GRID, "Pokaż siatkę mapy" },
    {TR_CONFIG_UI_SHOW_PARTIAL_GRID_AROUND_CONSTRUCTION, "Pokaż częściową siatkę mapy przy budowaniu" },
    {TR_OUT_OF_MONEY, "Brak pieniędzy" },
    {TR_CITY_MESSAGE_TITLE_EMPERORS_WRATH, "Gniew Cezara" },
    {TR_CITY_MESSAGE_TEXT_EMPERORS_WRATH, "Wypadłeś z łask Cezara zatem zarządził Twoje aresztowanie. Jeżeli nie dasz rady przywrócić łaski Cezara, jego elitarni legioniści niedługo zaatakują Twoje miasto" },
    {TR_BUILDING_ACADEMY_UPGRADE_DESC, "Akademia jest sprawna. Rozwój okolicy umożliwił Twoim obywatelom poszerzenie akademii, zapewniając więcej przestrzeni na przemówienia i prace badawcze" },
    {TR_BUILDING_PALISADE_GATE, "Brama palisady" },
    {TR_BUILDING_PALISADE_GATE_DESC, "Ta wąska drewniana brama kontroluje ruch obywateli na drugą stronę fortyfikacji." },
    {TR_SAVE_DIALOG_INVALID_FILE, "Niewłaściwy plik" },
    {TR_SAVE_DIALOG_SELECT_FILE, "Wybierz plik" },
    {TR_SAVE_DIALOG_FUNDS, "Fundusze:" },
    {TR_SAVE_DIALOG_POPULATION, "Populacja:" },
    {TR_SAVE_DIALOG_DATE, "Data:" },
    {TR_SAVE_DIALOG_CUSTOM_SCENARIO, "Dodatkowa misja" },
    {TR_SAVE_DIALOG_FIRST_MISSION, "Pierwsze zadanie" },
    {TR_SAVE_DIALOG_MISSION, "Zadanie" },
    {TR_SAVE_DIALOG_MILITARY, "Wojskowe" },
    {TR_SAVE_DIALOG_PEACEFUL, "Pokojowe" },
    {TR_CITY_MESSAGE_TITLE_MARS_MINOR_CURSE_PREVENTED, "Gniew Marsa" },
    {TR_CITY_MESSAGE_TEXT_MARS_MINOR_CURSE_PREVENTED, "Mars jest wściekły! Nie musimy się wiele obawiać w tej pokojowej prowincji, ale ten pokój nie będzie trwać wiecznie!" },
    {TR_TOOLTIP_MONUMENT_PHASE, " faza. " },
    {TR_TOOLTIP_MONUMENT_PHASES, " faz. " },
    {TR_TOOLTIP_MONUMENT_RESOURCE_REQUIREMENTS, "Potrzebne materiały:\n" },
    {TR_BUILDING_GLADIATOR_STATUE, "Posąg gladiatora" },
    {TR_ADVISOR_NO_ACTIVE_COLOSSEUM, "Brak czynnego koloseum w mieście" },
    {TR_ADVISOR_ACTIVE_COLOSSEUM, "Miasto posiada czynne koloseum" },
    {TR_ADVISOR_NO_ACTIVE_HIPPODROME, "Brak czynnego hipodromu" },
    {TR_ADVISOR_ACTIVE_HIPPODROME, "Miasto posiada czynny hipodrom" },
    {TR_WINDOW_ADVISOR_EDUCATION_MISSION_POSTS, "Misje" },
    { TR_ACTION_TYPE_ADJUST_CITY_HEALTH, "Zmień zdrowie miasta" },
    { TR_ACTION_TYPE_ADJUST_FAVOR, "Zmień łaskę" },
    { TR_ACTION_TYPE_ADJUST_MONEY, "Zmień pieniądze" },
    { TR_ACTION_TYPE_ADJUST_ROME_WAGES, "Zmień płace w Rzymie" },
    { TR_ACTION_TYPE_ADJUST_SAVINGS, "Zmień oszczędnośći" },
    { TR_ACTION_TYPE_A_MESSAGE, "Wiadomość" },
    { TR_ACTION_TYPE_BUILDING_FORCE_COLLAPSE, "Wymusz zawalenie budynku" },
    { TR_ACTION_TYPE_CHANGE_ALLOWED_BUILDINGS, "Zezwól lub wyłącz budynki" },
    { TR_ACTION_TYPE_CHANGE_CITY_RATING, "Zmień ocenę miasta" },
    { TR_ACTION_TYPE_CHANGE_CUSTOM_VARIABLE, "Zmień wartość zmiennej niestandardowej" },
    { TR_ACTION_TYPE_CHANGE_RESOURCE_PRODUCED, "Zmień dostępne lokalne surowce" },
    { TR_ACTION_TYPE_CHANGE_RESOURCE_STOCKPILES, "Zmień zapasy surowców" },
    { TR_ACTION_TYPE_EMPIRE_MAP_CONVERT_FUTURE_TRADE_CITY, "Konwertuj przyszłe miasto handlowe imperium" },
    { TR_ACTION_TYPE_GLADIATOR_REVOLT, "Rozpocznij bunt gladiatorów" },
    { TR_ACTION_TYPE_INVASION_IMMEDIATE, "Natychmiastowy początek inwazji" },
    { TR_ACTION_TYPE_REQUEST_IMMEDIATELY_START, "Natychmiastowo rozpocznij prośbę" },
    { TR_ACTION_TYPE_SEND_STANDARD_MESSAGE, "Wyślij standardową wiadomość" },
    { TR_ACTION_TYPE_SHOW_CUSTOM_MESSAGE, "Wyświetl niestandardową wiadomość" },
    { TR_ACTION_TYPE_TAX_RATE_SET, "Ustaw poziom podatków" },
    { TR_ACTION_TYPE_TRADE_ADJUST_PRICE, "Zmień ceny handlowe" },
    { TR_ACTION_TYPE_TRADE_ADJUST_ROUTE_AMOUNT, "Zmień kwotę handlową szlaku handlowego" },
    { TR_ACTION_TYPE_TRADE_ADJUST_ROUTE_OPEN_PRICE, "Zmień koszt otwarcia szlaku handlowego" },
    { TR_ACTION_TYPE_TRADE_PROBLEM_LAND, "Rozpocznij problem lądowego szlaku handlowego" },
    { TR_ACTION_TYPE_TRADE_PROBLEM_SEA, "Rozpocznij problem morskiego szlaku handlowego" },
    { TR_ACTION_TYPE_TRADE_ROUTE_ADD_NEW_RESOURCE, "Szlak handlowy i nowy surowiec" },
    { TR_ACTION_TYPE_TRADE_ROUTE_SET_OPEN, "Otwórz szlak" },
    { TR_ACTION_TYPE_TRADE_SET_BUY_PRICE_ONLY, "Ustaw tylko handlową cenę kupna" },
    { TR_ACTION_TYPE_TRADE_SET_PRICE, "Ustaw cenę handlową" },
    { TR_ACTION_TYPE_TRADE_SET_SELL_PRICE_ONLY, "Ustaw tylko handlową cenę sprzedaży" },
    { TR_ADVISOR_TRADE_RESOURCE_NOT_STORABLE, "Nieprzechowywalne" },
    { TR_ADVISOR_TRADE_RESOURCE_NOT_STORABLE_OR_TRADABLE, "Surowiec nie może być przechowany i handlowany" },
    { TR_BUILDING_BRICKWORKS, "Cegielnia" },
    { TR_BUILDING_BRICKWORKS_COMPLETE, "zakończony." },
    { TR_BUILDING_BRICKWORKS_DESC, "Tutaj, piasek i glina są przerabiane w cegły na budowę pomników." },
    { TR_BUILDING_BRICKWORKS_FEW_EMPLOYEES, "Z powodu braku pracowników, produkcja prawie się zatrzymała. W nadchodzącym roku będzie produkować niewiele cegieł." },
    { TR_BUILDING_BRICKWORKS_FULL_EMPLOYEES, "Ten warsztat ma wszystkich pracowników których potrzebuje, i ciężko pracuje, produkując cegły." },
    { TR_BUILDING_BRICKWORKS_HALF_EMPLOYEES, "Temu warsztatowi brakuje pracowników. Produkcja cegieł trwa dłużej niż powinna." },
    { TR_BUILDING_BRICKWORKS_HALTED, "Twój doradca handlu rozkazał wstrzymanie produkcji cegieł." },
    { TR_BUILDING_BRICKWORKS_MANY_EMPLOYEES, "Ten warsztat pracuje poniżej maksymalnej wydajności. Produkcja cegieł mogłaby być nieco bardziej wydajna przy większej liczbie pracowników." },
    { TR_BUILDING_BRICKWORKS_NO_EMPLOYEES, "Ten warsztat nie ma pracowników. Produkcja została wstrzymana." },
    { TR_BUILDING_BRICKWORKS_NO_RESOURCES, "Temu warsztatu trzeba dostarczać glinę i piasek z magazynu lub piaskowni i glinianki do produkcji cegieł." },
    { TR_BUILDING_BRICKWORKS_PRODUCTION, "Produkcja jest" },
    { TR_BUILDING_BRICKWORKS_SOME_EMPLOYEES, "W tym warsztacie pracuje bardzo mało osób. W rezultacie produkcja cegieł jest powolna." },
    { TR_BUILDING_BRICKWORKS_STORED_CLAY, "Przechowywana glina," },
    { TR_BUILDING_BRICKWORKS_STORED_SAND, "Przechowywany piasek," },
    { TR_BUILDING_CARAVANSERAI_NO_FOOD, "Ten karawanseraj ma pracowników, ale obecnie szukają oni dostępnego źródła pożywienia." },
    { TR_BUILDING_CARAVANSERAI_PHASE_2, "(Colonnade)" },
    { TR_BUILDING_CARAVANSERAI_PHASE_2_TEXT, "Murarze budują prostokątną kolumnadę. Wewnątrz znajdą się schroniska dla handlarzy i ich zwierząt." },
    { TR_BUILDING_CAT_DEPOT, "Skład kotów" },
    { TR_BUILDING_CITY_MINT, "Mennica miejska" },
    { TR_BUILDING_CITY_MINT_CHANGE_PRODUCTION, "Zmienić produkcję mennicy miejskiej?" },
    { TR_BUILDING_CITY_MINT_CONVERT, "Konwertuj:" },
    { TR_BUILDING_CITY_MINT_DESC, "Tutaj złoto jest wybijane na monety, które zapełniają skarbiec Twojego miasta." },
    { TR_BUILDING_CITY_MINT_DESC_ALTERNATIVE, "Tutaj moneta przetapia się na złoto, które można wykorzystać do budowy pomników." },
    { TR_BUILDING_CITY_MINT_DESC_NO_PALACE, "Zbuduj swój pałac, aby zbierać także środki osobiste z mennicy miejskiej." },
    { TR_BUILDING_CITY_MINT_DESC_PALACE, "Ponieważ posiadasz pałac, do Twoich osobistych środków dodawana jest dodatkowa moneta." },
    { TR_BUILDING_CITY_MINT_DN_TO_GOLD, "600 denarów na jeden wóz złota" },
    { TR_BUILDING_CITY_MINT_FEW_EMPLOYEES, "Ponieważ w tym warsztacie nie ma prawie żadnych pracowników, jego produkcja praktycznie stoi w miejscu. W nadchodzącym roku prawie nic nie będzie produkowane." },
    { TR_BUILDING_CITY_MINT_FULL_EMPLOYEES, "Mennica miejska ma wszystkich potrzebnych pracowników. Pracuje bez przerwy, aby wybić monetę lub przetopić ją na złoto." },
    { TR_BUILDING_CITY_MINT_GOLD_TO_DN, "Jeden wóz pełen złota na 500 denarów" },
    { TR_BUILDING_CITY_MINT_HALF_EMPLOYEES, "W mennicy miejskiej brakuje personelu, a wybicie monety lub przetopienie jej na złoto zajmuje więcej czasu, niż powinno." },
    { TR_BUILDING_CITY_MINT_MANY_EMPLOYEES, "Mennica miejska pracuje poniżej maksymalnej wydajności. Bicie monet lub produkcja złota będzie nieco wolniejsza." },
    { TR_BUILDING_CITY_MINT_NO_EMPLOYEES, "Mennica miejska nie zatrudnia pracowników. Produkcja została wstrzymana." },
    { TR_BUILDING_CITY_MINT_NO_GOLD, "Ten warsztat potrzebuje złota dostarczonego do niego z magazynu lub kopalni złota, aby wybić monetę." },
    { TR_BUILDING_CITY_MINT_NO_SENATE, "Budynek wymaga aktywnego senatu do działania. Bez takiego budynku nie można wybić żadnej monety." },
    { TR_BUILDING_CITY_MINT_PHASE_1, "(Fundamenty)" },
    { TR_BUILDING_CITY_MINT_PHASE_1_TEXT, "Inżynierowie kładą fundamenty pod budynek." },
    { TR_BUILDING_CITY_MINT_PROGRESS_WILL_BE_LOST, "Bieżący postęp produkcji zostanie utracony." },
    { TR_BUILDING_CITY_MINT_SOME_EMPLOYEES, "Pracuje tu bardzo mało osób. Bicie monet i produkcja złota jest powolna." },
    { TR_BUILDING_CITY_MINT_STORED_GOLD, "Przechowywane złoto," },
    { TR_BUILDING_CONCRETE_MAKER, "Producent betonu" },
    { TR_BUILDING_CONCRETE_MAKER_COMPLETE, "Zakończone." },
    { TR_BUILDING_CONCRETE_MAKER_DESC, "Tutaj, piasek jest mieszany z betonem na budowę pomników." },
    { TR_BUILDING_CONCRETE_MAKER_FEW_EMPLOYEES, "Przez brak pracowników, produkcja prawie się zatrzymała. W nadchodzącym roku będzie produkowana niewielka ilość betonu." },
    { TR_BUILDING_CONCRETE_MAKER_FULL_EMPLOYEES, "Ten warsztat zatrudnia wszystkich potrzebnych pracowników i pracuje pełną parą przy produkcji betonu." },
    { TR_BUILDING_CONCRETE_MAKER_HALF_EMPLOYEES, "W tym warsztacie brakuje personelu. Produkcja betonu trwa dłużej niż powinna." },
    { TR_BUILDING_CONCRETE_MAKER_HALTED, "Twój doradca handlowy rozkazał wstrzymanie produkcji betonu." },
    { TR_BUILDING_CONCRETE_MAKER_IMPROVE_WATER_ACCESS, "Ten warsztat ma dostęp tylko do studni lub fontanny. Wydobycie by poprawił bezpośredni dostęp do zbiorników." },
    { TR_BUILDING_CONCRETE_MAKER_MANY_EMPLOYEES, "Ten warsztat pracuje poniżej maksymalnej wydajności. Produkcja betonu mogłaby być nieco bardziej wydajna przy większej liczbie pracowników." },
    { TR_BUILDING_CONCRETE_MAKER_NO_EMPLOYEES, "W tym warsztacie nie ma pracowników. Produkcja została wstrzymana." },
    { TR_BUILDING_CONCRETE_MAKER_NO_RESOURCES, "Ten warsztat potrzebuje dostępu do wody ze zbiornika, fontanny czy studni oraz dostarczanego do niego piasku z magazynu lub piaskowni do mieszania betonu." },
    { TR_BUILDING_CONCRETE_MAKER_NO_TARGETS, "Nie ma budynków wymagających betonu. Produkcja została wstrzymana." },
    { TR_BUILDING_CONCRETE_MAKER_PRODUCTION, "Produkcja jest" },
    { TR_BUILDING_CONCRETE_MAKER_SOME_EMPLOYEES, "W tym warsztacie pracuje bardzo mało osób. W rezultacie produkcja betonu jest powolna." },
    { TR_BUILDING_CONCRETE_MAKER_STORED_SAND, "Przechowywany piasek," },
    { TR_BUILDING_DEPOT, "Skład wózków" },
    { TR_BUILDING_DEPOT_DESC, "Skład wózków wysyła wózki do przemieszczania towarów pomiędzy magazynami a spichlerzami na podstawie zamówienia. Po każdej dostawie, wózki muszą wrócić do magazynu." },
    { TR_BUILDING_DEPOT_FEW_EMPLOYEES, "Nie ma tu prawie żadnych pracowników. Nikt nie pamięta, kiedy ten magazyn wysłał swój ostatni wózek." },
    { TR_BUILDING_DEPOT_HALF_EMPLOYEES, "W tym składzie brakuje personelu. W rezultacie towary są przewożone powoli." },
    { TR_BUILDING_DEPOT_MANY_EMPLOYEES, "Skład ten pracuje poniżej maksymalnej wydajności. Przy większej liczbie pracowników towary mogłyby być przesyłane nieco szybciej." },
    { TR_BUILDING_DEPOT_NO_EMPLOYEES, "W tym składzie nie ma pracowników. W pustych wózkach śpią koty." },
    { TR_BUILDING_DEPOT_SOME_EMPLOYEES, "Very few people work in this depot. It takes a while before goods are transferred." },
    { TR_BUILDING_FORMAL_GARDENS, "Ogrody formalne" },
    { TR_BUILDING_GOLD_MINE, "Kopalnia złota" },
    { TR_BUILDING_GOLD_MINE_COMPLETE, "Zakończone." },
    { TR_BUILDING_GOLD_MINE_DESC, "Wydobywaj złoto na handel lub na zaopatrzenie mennicę miejską w celu generowania denarów." },
    { TR_BUILDING_GOLD_MINE_FEW_EMPLOYEES, "Z bardzo małą liczbą górników, wydobycie prawie się zatrzymało. W nadchodzącym roku wydobędzie się niewiele złota." },
    { TR_BUILDING_GOLD_MINE_FULL_EMPLOYEES, "Kopalnia ta zatrudnia wszystkich potrzebnych pracowników i ciężko pracuje, aby wydobyć złoto." },
    { TR_BUILDING_GOLD_MINE_HALF_EMPLOYEES, "W tej kopalni brakuje personelu. Wydobycie złota zajmuje więcej czasu niż powinno." },
    { TR_BUILDING_GOLD_MINE_HALTED, "Twój doradca handlowy nakazał wstrzymanie wydobycia złota." },
    { TR_BUILDING_GOLD_MINE_MANY_EMPLOYEES, "Kopalnia ta pracuje poniżej maksymalnej wydajności. Wydobycie złota byłoby bardziej wydajne przy większej liczbie górników." },
    { TR_BUILDING_GOLD_MINE_NO_EMPLOYEES, "W tej kopalni nie ma pracowników. Produkcja została wstrzymana." },
    { TR_BUILDING_GOLD_MINE_PRODUCTION, "Produkcja jest" },
    { TR_BUILDING_GOLD_MINE_SOME_EMPLOYEES, "W tej kopalni pracuje bardzo mało ludzi. W rezultacie produkcja złota jest powolna." },
    { TR_BUILDING_GRANARY_NO_FOOD, "Nie ma jedzenia przechowywanego w tym spichlerzu." },
    { TR_BUILDING_HIGHWAY, "Autostrada" },
    { TR_BUILDING_HIGHWAY_DESC, "Autostrady umożliwiają obywatelom szybsze dotarcie do celu." },
    { TR_BUILDING_INFO_CARTLOAD, "ładunek wózka." },
    { TR_BUILDING_INFO_CARTLOADS, "łaudnki wózków." },
    { TR_BUILDING_INFO_DEPOT_CONDITION, "Kiedy" },
    { TR_BUILDING_INFO_DEPOT_DELIVER, "Dostarcz" },
    { TR_BUILDING_INFO_DEPOT_DESTINATION, "Cel" },
    { TR_BUILDING_INFO_DEPOT_NO_DESTINATION_AVAILABLE, "Brak możliwego celu" },
    { TR_BUILDING_INFO_DEPOT_NO_SOURCE_AVAILABLE, "Brak źródła" },
    { TR_BUILDING_INFO_DEPOT_ONE_BUILDING_FOR_RESOURCE, "Tylko jeden budynek dostępny"},
    {TR_BUILDING_INFO_DEPOT_SELECT_DESTINATION, "Wybierz cel"},
    {TR_BUILDING_INFO_DEPOT_SELECT_DESTINATION_TITLE, "Wybierz cel przechowywania" },
    {TR_BUILDING_INFO_DEPOT_SELECT_RESOURCE_TITLE, "Wybierz surowiec" },
    {TR_BUILDING_INFO_DEPOT_SELECT_SOURCE, "Wybierz źródło"},
    {TR_BUILDING_INFO_DEPOT_SELECT_SOURCE_TITLE, "Wybierz źródło przechowywania"},
    {TR_BUILDING_INFO_DEPOT_SOURCE, "Źródło" },
    {TR_BUILDING_INFO_MOTHBALL_WARNING, "Ten budynek jest wyłączony." },
    {TR_BUILDING_INFO_TOTAL_FOOD, "Całkowite jedzenie:" },
    {TR_BUILDING_LARGE_MAUSOLEUM_CONSTRUCTION_DESC, "Do budowy tego mauzoleum potrzebne będą materiały zgromadzone w magazynie, robotnicy z obozu pracy i architekci z cechu architektów." },
    {TR_BUILDING_LARGE_MAUSOLEUM_PHASE_1, "Komnata" },
    {TR_BUILDING_LARGE_MAUSOLEUM_PHASE_1_TEXT, "Murarze układają warstwy precyzyjnie rzeźbionych kamieni, tworząc centralne sklepienie tej komnaty." },
    {TR_BUILDING_LARGE_MAUSOLEUM_PHASE_2, "Fasada" },
    {TR_BUILDING_LARGE_MAUSOLEUM_PHASE_2_TEXT, "Wykwalifikowani rzemieślnicy przygotowują fasadę tego mauzoleum, rzeźbiąc lśniące marmurowe posągi, aby upamiętnić tych, którzy tu spoczną." },
    {TR_BUILDING_LOOPED_GARDEN_WALL_GATE, "Zapętlona ogrodowa brama ścienna"},
    {TR_BUILDING_LOOPED_GARDEN_WALL_GATE_DESC, "Ta mała brama kontroluje przepływ ludzi do i z najbardziej odosobnionych miejsc Twojego miasta." },
    {TR_BUILDING_MENU_SHRINES, "Ołtarz" },
    {TR_BUILDING_MESS_HALL_NO_FOOD, "This supply post has employees, but they are currently looking for an available source of food." },
    {TR_BUILDING_OVERGROWN_GARDENS, "Nadrośnięte ogrody" },
    {TR_BUILDING_PANELLED_GARDEN_WALL, "Panelowa ściana ogrodu"},
    {TR_BUILDING_PANELLED_GARDEN_WALL_GATE, "Paneled garden wall gate" },
    {TR_BUILDING_PANELLED_GARDEN_WALL_GATE_DESC, "Ta mała brama kontroluje przepływ ludzi do i z najbardziej odosobnionych miejsc Twojego miasta." },
    {TR_BUILDING_SAND_PIT, "Dołek piaskowy"},
    {TR_BUILDING_SAND_PIT_COMPLETE, "zakończone."},
    {TR_BUILDING_SAND_PIT_DESC, "Kop piasek na budowę pomników."},
    {TR_BUILDING_SAND_PIT_FEW_EMPLOYEES, "Z bardzo małą liczbą pracowników, wydobycie prawie się zatrzymało. W nadchodzącym roku wydobędzie się niewiele piasku."},
    {TR_BUILDING_SAND_PIT_FULL_EMPLOYEES, "Dołek ta zatrudnia wszystkich potrzebnych pracowników i pracuje pełną parą, wydobywając piasek."},
    {TR_BUILDING_SAND_PIT_HALF_EMPLOYEES, "W tym dołku jest za mało personelu. Wydobywanie piasku trwa dłużej niż powinno."},
    {TR_BUILDING_SAND_PIT_HALTED, "Twój doradca handlowy nakazał wstrzymanie wydobycia piasku."},
    {TR_BUILDING_SAND_PIT_MANY_EMPLOYEES, "Dołek ta pracuje poniżej maksymalnej wydajności. Wydobywanie piasku mogłoby być nieco bardziej wydajne przy większej liczbie pracowników."},
    {TR_BUILDING_SAND_PIT_NO_EMPLOYEES, "W tym dołku nie ma pracowników. Produkcja została wstrzymana."},
    {TR_BUILDING_SAND_PIT_PRODUCTION, "Wydobycie jest"},
    {TR_BUILDING_SAND_PIT_SOME_EMPLOYEES, "W tym dołku pracuje bardzo niewiele osób. W rezultacie produkcja piasku jest powolna."},
    {TR_BUILDING_SHRINE_CERES, "Ołtarz Ceresa"},
    {TR_BUILDING_SHRINE_DESC, "Ołtarze są doceniane nie tylko przez sąsiadujących z nimi obywateli, ale także przez bogów tych ołtarzy."},
    {TR_BUILDING_SHRINE_MARS, "Ołtarz Marsa"},
    {TR_BUILDING_SHRINE_MERCURY, "Ołtarz Merkurego"},
    {TR_BUILDING_SHRINE_NEPTUNE, "Ołtarz Neptuna"},
    {TR_BUILDING_SHRINE_VENUS, "Ołtarz Wenusa"},
    {TR_BUILDING_STONE_QUARRY, "Kamieniołom"},
    {TR_BUILDING_STONE_QUARRY_COMPLETE, "zakończone."},
    {TR_BUILDING_STONE_QUARRY_DESC, "Kamień z kamieniołomu na budowę pomników."},
    {TR_BUILDING_STONE_QUARRY_FEW_EMPLOYEES, "Ponieważ prawie nie ma tu pracowników, wydobycie prawie się zatrzymało. W nadchodzącym roku wydobędzie niewiele kamienia."},
    {TR_BUILDING_STONE_QUARRY_FULL_EMPLOYEES, "Ten kamieniołom zatrudnia wszystkich potrzebnych pracowników i ciężko pracuje, aby wydobyć kamień." },
    {TR_BUILDING_STONE_QUARRY_HALF_EMPLOYEES, "W tym kamieniołomie brakuje personelu. Wydobycie kamienia trwa dłużej niż powinna." },
    {TR_BUILDING_STONE_QUARRY_HALTED, "Twój doradca handlowy nakazał wstrzymanie wydobycia kamienia."},
    {TR_BUILDING_STONE_QUARRY_MANY_EMPLOYEES, "Ten kamieniołom pracuje poniżej maksymalnej wydajności. Wydobywanie kamienia mogłoby być nieco bardziej wydajne przy większej liczbie pracowników." },
    {TR_BUILDING_STONE_QUARRY_NO_EMPLOYEES, "W tym kamieniołomie nie ma pracowników. Wydobycie zostało wstrzymana."},
    {TR_BUILDING_STONE_QUARRY_PRODUCTION, "Wydobycie jest"},
    {TR_BUILDING_STONE_QUARRY_SOME_EMPLOYEES, "W tym kamieniołomie pracuje bardzo niewiele osób. W rezultacie produkcja kamienia jest powolna." },
    {TR_BUILDING_WAREHOUSE_NO_GOODS, "W tym magazynie nie są przechowywane żadne towary."},
    {TR_BUILDING_WINDOW_INDUSTRY_NEEDED, " potrzebne)" },
    {TR_CHEAT_ADDED_MONEY, "Dodany pieniądz"},
    {TR_CHEAT_CASTED_BLESSING, "Oddane błogosławieństwo"},
    {TR_CHEAT_FINISHED_MONUMENTS, "Pomniki zbudowane"},
    {TR_CHEAT_INCITED_RIOT, "Wzbudził zamieszkę"},
    {TR_CHEAT_KILLED_ALL_WALKERS, "Zabił wszystkich chodzących"},
    {TR_CHEAT_STARTED_INVASION, "Rozpoczął inwazję"},
    {TR_CHEAT_TOGGLE_TOOLTIPS, "Pokaż podpowiedź"},
    {TR_CHEAT_UNLOCKED_ALL_BUILDINGS, "Wszystkie budynki odblokowane"},
    {TR_CHEAT_UPDATED_MONUMENTS, "Pomniki zaktualizowane"},
    {TR_CHEAT_YEAR_ADVANCED, "Rok dalej"},
    {TR_CITY_MESSAGE_TEXT_ENEMIES_LEAVING, "Humf! Twoje marne miasto nie ma już nic wartego zniszczenia. Na razie wyjeżdżamy, ale uwaga, zawsze możemy wrócić!"},
    {TR_CITY_MESSAGE_TEXT_ROAD_TO_ROME_WARNING, "Droga do Rzymu jest zablokowana. Jeżeli natychmiast nie przywrócimy dostępu do traktu cesarskiego, inżynierowie z Rzymu będą zmuszeni podjąć działania." },
    {TR_CITY_MESSAGE_TEXT_TRADE_ROUTE_PRICE_CHANGE, "Cena za otwarcie szlaku handlowego uległa zmianie." },
    {TR_CITY_MESSAGE_TITLE_ENEMIES_LEAVING, "Wrogowie się wycofują"},
    {TR_CITY_MESSAGE_TITLE_HIPPODROME_WORKING, "Rozpoczęto wyścigi" },
    {TR_CITY_MESSAGE_TITLE_ROAD_TO_ROME_WARNING, "Miasto niedostępne" },
    {TR_CITY_MESSAGE_TITLE_TRADE_ROUTE_PRICE_CHANGE, "Cena szlaku handlowego" },
    {TR_CITY_WARNING_BUILD_GOLD_MINE, "Zbuduj kopalnię złota"},
    {TR_CITY_WARNING_BUILD_SAND_PIT, "Zbuduj dołek piasku"},
    {TR_CITY_WARNING_BUILD_SENATE, "Zbuduj senat"},
    {TR_CITY_WARNING_BUILD_STONE_QUARRY, "Zbuduj kamieniołom"},
    {TR_CITY_WARNING_DATA_MOTHBALL_OFF, "Budynek jest teraz aktywny" },
    {TR_CITY_WARNING_DATA_MOTHBALL_ON, "Budynek jest teraz wyłączony" },
    {TR_CITY_WARNING_GOLD_NEEDED, "Ten budynek potrzebuje złota"},
    {TR_CITY_WARNING_SAND_NEEDED, "Ten budynek potrzebuje piasku"},
    {TR_CITY_WARNING_SENATE_NEEDED, "Ten budynek potrzebuje działającego senatu"},
    {TR_CITY_WARNING_STONE_NEEDED, "Ten budynek potrzebuje kamienia"},
    {TR_CONDITION_TYPE_BUILDING_COUNT_ACTIVE, "Aktywna liczba rodzaju budynku"},
    {TR_CONDITION_TYPE_BUILDING_COUNT_ANY, "Liczba rodzaju budynku"},
    {TR_CONDITION_TYPE_BUILDING_COUNT_AREA, "Budynki w okolicy"},
    {TR_CONDITION_TYPE_CITY_POPULATION, "Populacja miasta"},
    {TR_CONDITION_TYPE_COUNT_OWN_TROOPS, "Liczba własnych żołnierzy"},
    {TR_CONDITION_TYPE_CUSTOM_VARIABLE_CHECK, "Wartość zmiennej niestandardowej"},
    {TR_CONDITION_TYPE_DIFFICULTY, "Poziom trudności"},
    {TR_CONDITION_TYPE_MONEY, "Pieniąze miasta"},
    {TR_CONDITION_TYPE_POPS_UNEMPLOYMENT, "Bezrobocie"},
    {TR_CONDITION_TYPE_REQUEST_IS_ONGOING, "Żądanie jest w toku"},
    {TR_CONDITION_TYPE_RESOURCE_STORAGE_AVAILABLE, "Dostępne składowanie zasobów"},
    {TR_CONDITION_TYPE_RESOURCE_STORED_COUNT, "Liczba przechowywanych surowców"},
    {TR_CONDITION_TYPE_ROME_WAGES, "Wynagrodzenie płacone przez Rzym"},
    {TR_CONDITION_TYPE_SAVINGS, "Osobiste oszczędności"},
    {TR_CONDITION_TYPE_STATS_CITY_HEALTH, "Zdrowie miasta"},
    {TR_CONDITION_TYPE_STATS_CULTURE, "Kultura"},
    {TR_CONDITION_TYPE_STATS_FAVOR, "Łaska"},
    {TR_CONDITION_TYPE_STATS_PEACE, "Pokój"},
    {TR_CONDITION_TYPE_STATS_PROSPERITY, "Dobrobyt"},
    {TR_CONDITION_TYPE_TAX_RATE, "Poziom opodatkowania"},
    {TR_CONDITION_TYPE_TIME_PASSED, "Minięty czas"},
    {TR_CONDITION_TYPE_TRADE_ROUTE_OPEN, "Szlak handlowy jest otwarty"},
    {TR_CONDITION_TYPE_TRADE_ROUTE_PRICE, "Cena otwarcia szlaku handlowego"},
    {TR_CONDITION_TYPE_TRADE_SELL_PRICE, "Cena sprzedaży handlowej"},
    {TR_CONFIG_ASK_CONFIRMATION_ON_FILE_OVERWRITE, "Zapytaj o potwierdzenie podczas nadpisywania pliku"},
    {TR_CONFIG_AUTO_KILL_ANIMALS, "Obywatele będą automatycznie zabijać nieszkodliwe zwierzęta"},
    {TR_CONFIG_DRAW_CLOUD_SHADOWS, "Narysuj cienie chmur"},
    {TR_CONFIG_GATES_DEFAULT_TO_PASS_ALL_WALKERS, "Bramy niemilitarne domyślnie przepuszczają wszystkich obywateli"},
    {TR_CONFIG_SHOW_MARKET_RANGE, "Pokaż zasięg przy budowie nowych targów"},
    {TR_CONFIG_SHOW_ROAMING_PATH, "Podgląd ścieżek przebytych przez wędrujących obywateli"},
    {TR_CONFIG_SHOW_WATER_STRUCTURE_RANGE_HOUSES, "Pokaż zasięg fontann i studni podczas budowy domów"},
    {TR_CONFIG_UI_ALWAYS_SHOW_ROTATION_BUTTONS, "Zawsze pokazuj przyciski rotacji"},
    {TR_EDITOR_CHECK_LOG_MESSAGE, "Aby uzyskać szczegółowe informacje, sprawdź plik augustus-log.txt w katalogu Augustus."},
    {TR_EDITOR_CHOOSE_CUSTOM_EMPIRE, "Wybierz niestandardowe imperium"},
    {TR_EDITOR_CITY_PREVIEW, "Podgląd obrazu miasta: "},
    {TR_EDITOR_CURRENT_COORDS, "Aktualne współrzędne: "},
    {TR_EDITOR_CUSTOM_EMPIRE_TITLE, "Ładuje cesarstwo"},
    {TR_EDITOR_CUSTOM_MESSAGES_CLEAR, "Wyczyść wiadomości"},
    {TR_EDITOR_CUSTOM_MESSAGES_COUNT, "Wszystkie wiadomości" },
    {TR_EDITOR_CUSTOM_MESSAGES_EXPORT_FULL, "Eksportuj niestandardowe wiadomości" },
    {TR_EDITOR_CUSTOM_MESSAGES_IMPORT_FULL, "Importuj niestandardowe wiadomości" },
    {TR_EDITOR_CUSTOM_MESSAGES_TITLE, "Niestandardowe wiadomości" },
    {TR_EDITOR_CUSTOM_VARIABLES_COUNT, "Maksymalne możliwe zmienne" },
    {TR_EDITOR_CUSTOM_VARIABLES_TITLE, "Zmienne niestandardowe" },
    {TR_EDITOR_DELETE, "Usuń"},
    {TR_EDITOR_DELETED, "Usunięte"},
    {TR_EDITOR_FAVOUR_DISFAVOR, "Utrata łaski w potrzebie przedłużenia"},
    {TR_EDITOR_FAVOUR_EXTENSION_MONTHS, "Dozwolone miesiące przedłużenia"},
    {TR_EDITOR_FAVOUR_IGNORED, "Utracona łaska w przypadku zignorowania rządania"},
    {TR_EDITOR_GRID_OFFSET, " offset" },
    {TR_EDITOR_IMPORT_LINE, "Linia: "},
    {TR_EDITOR_MAX_WAGES, "W górę do"},
    {TR_EDITOR_MIN_WAGES, "W dól do"},
    {TR_EDITOR_REFRESH_EMPIRE, "Odśwież (F5)"},
    {TR_EDITOR_SCENARIO_ACTION, "Działanie"},
    {TR_EDITOR_SCENARIO_ACTION_ADD, "Dodaj nowe działanie"},
    {TR_EDITOR_SCENARIO_CONDITION, "Warunek"},
    {TR_EDITOR_SCENARIO_CONDITION_ADD, "Dodaj nowy warunek"},
    {TR_EDITOR_SCENARIO_DESELECT_INTRO, "Odselektuj wstęp do scenariuszu"},
    {TR_EDITOR_SCENARIO_EVENTS_ACTIONS, "działania" },
    {TR_EDITOR_SCENARIO_EVENTS_ADD, "Dodaj nowe wydarzenie"},
    {TR_EDITOR_SCENARIO_EVENTS_CLEAR, "Usuń wszystkie wydarzenia" },
    {TR_EDITOR_SCENARIO_EVENTS_CONDITIONS, "warunki" },
    {TR_EDITOR_SCENARIO_EVENTS_COUNT, "wydarzenia scenariuszu" },
    {TR_EDITOR_SCENARIO_EVENTS_EXPORT, "Eksportuj" },
    {TR_EDITOR_SCENARIO_EVENTS_EXPORT_FULL, "Eksportuj wydarzenia scenariuszu" },
    {TR_EDITOR_SCENARIO_EVENTS_IMPORT, "Importuj" },
    {TR_EDITOR_SCENARIO_EVENTS_IMPORT_FULL, "Importuj wydarzenia scenariuszu" },
    {TR_EDITOR_SCENARIO_EVENTS_TITLE, "Wydarzenia scenariuszu" },
    {TR_EDITOR_SCENARIO_EVENT_DELETED, "Usunięte wydarzenie"},
    {TR_EDITOR_SCENARIO_EVENT_DOES_NOT_REPEAT, "Nie powtarza się."},
    {TR_EDITOR_SCENARIO_EVENT_EXECUTION_COUNT, "Liczba wykonań: "},
    {TR_EDITOR_SCENARIO_EVENT_ID, "ID: "},
    {TR_EDITOR_SCENARIO_EVENT_MAX_NUM_REPEATS, "Maksymalna liczba powtórzeń: "},
    {TR_EDITOR_SCENARIO_EVENT_MONTHS_UNTIL_ACTIVE, "Miesiące do aktywacji: "},
    {TR_EDITOR_SCENARIO_EVENT_REPEATS_FOREVER, "Ciągłe"},
    {TR_EDITOR_SCENARIO_EVENT_REPEAT_MAX_MONTHS, "Maks ilość miesięcy przed powtórzeniem: "},
    {TR_EDITOR_SCENARIO_EVENT_REPEAT_MIN_MONTHS, "Min ilość miesięcy przed powtórzeniem: "},
    {TR_EDITOR_SCENARIO_EVENT_STATE_ACTIVE, "Aktywne"},
    {TR_EDITOR_SCENARIO_EVENT_STATE_DISABLED, "Wyłączone"},
    {TR_EDITOR_SCENARIO_EVENT_STATE_PAUSED, "Zapauzowane"},
    {TR_EDITOR_SCENARIO_EVENT_STATE_UNDEFINED, "Niezdefiniowane"},
    {TR_EDITOR_SCENARIO_SELECT_INTRO, "Wybierz wstęp do scenariuszu"},
    {TR_EDITOR_SELECTED_COORDS, "Wybrane współrzędne: "},
    {TR_EDITOR_SHORT_ROUTE_TEXT, "rt"},
    {TR_EDITOR_TOGGLE_INVASIONS, "Włącz/Wyłącz inwazje"},
    {TR_EDITOR_UNABLE_TO_LOAD_CUSTOM_MESSAGES_TITLE, "Nie ładują się wiadomości niestandardowe"},
    {TR_EDITOR_UNABLE_TO_LOAD_EMPIRE_MESSAGE, "Aby uzyskać szczegółowe informacje, sprawdź plik augustus-log.txt w katalogu Augustus."},
    {TR_EDITOR_UNABLE_TO_LOAD_EMPIRE_TITLE, "Nie wczytuje się niestandardowe cesarstwo"},
    {TR_EDITOR_UNABLE_TO_LOAD_EVENTS_TITLE, "Nie wczytuje się wydarzenie scenariuszu"},
    {TR_EDITOR_UNABLE_TO_SAVE_EVENTS_TITLE, "Błąd w zapisywaniu wydarzeń scenariuszu"},
    {TR_FIGURE_INFO_DEPOT_DELIVER, "Dostarcza" },
    {TR_FIGURE_INFO_DEPOT_FROM, "Z " },
    {TR_FIGURE_INFO_DEPOT_RECALL, "Przywołaj spowrotem" },
    {TR_FIGURE_INFO_DEPOT_RETURNING, "Powraca" },
    {TR_FIGURE_INFO_DEPOT_TO, " do " },
    {TR_HOTKEY_BUILD_HIGHWAY, "Autostrada" },
    {TR_HOTKEY_MOTHBALL_TOGGLE, "Wyłącz/Włącz budynek" },
    {TR_HOTKEY_RESET_ZOOM, "Resetuj zbliżenie"},
    {TR_HOTKEY_SHOW_OVERLAY_DESIRABILITY, "Nakładka pożądania"},
    {TR_HOTKEY_SHOW_OVERLAY_EDUCATION, "Nakładka edukacji" },
    {TR_HOTKEY_SHOW_OVERLAY_EFFICIENCY, "Nakładka efektywności"},
    {TR_HOTKEY_SHOW_OVERLAY_HOSPITAL, "Nakładka szpitali" },
    {TR_HOTKEY_SHOW_OVERLAY_LEVY, "Nakładka żołdu" },
    {TR_HOTKEY_SHOW_OVERLAY_MOTHBALL, "Nakładka wyłączonych budynków" },
    {TR_HOTKEY_SHOW_OVERLAY_RISKS_NATIVE, "Nakładka tubylców"},
    {TR_HOTKEY_SHOW_OVERLAY_SENTIMENT, "Nakładka sentymentu" },
    {TR_HOTKEY_SPECIAL_ORDERS, "Pokaż specjalne rozkazy budynków" },
    {TR_HOTKEY_ZOOM_IN, "Zbliż widok"},
    {TR_HOTKEY_ZOOM_OUT, "Oddal widok"},
    {TR_ORDER_CONDITION_ALWAYS, "Zawsze" },
    {TR_ORDER_CONDITION_DESTINATION_HAS_LESS_THAN, "Cel ma mniej niż" },
    {TR_ORDER_CONDITION_NEVER, "Nigdy" },
    {TR_ORDER_CONDITION_SOURCE_HAS_MORE_THAN, "Źródło ma więcej niż" },
    {TR_OVERLAY_STORAGES, "Magazyny" },
    {TR_PARAMETER_ADD_AS_BUYING, "Dodaj jako kupujące?"},
    {TR_PARAMETER_ALLOWED, "Zezwolone?"},
    {TR_PARAMETER_APPLY_COST, "Stosować otwarty koszt?"},
    {TR_PARAMETER_CHECK_FOR_ONGOING, "Sprawdźić, czy trwa?"},
    {TR_PARAMETER_CHECK_FOR_OPEN, "Sprawdźić, czy trasa jest otwarta?"},
    {TR_PARAMETER_DESTROY_ALL, "Zniszcz wszystkie rodzaje?"},
    {TR_PARAMETER_DISPLAY_ADD_AS_BUYING, "dodaj jako kupujące"},
    {TR_PARAMETER_DISPLAY_ADD_AS_SELLING, "dodaj jako sprzedające"},
    {TR_PARAMETER_DISPLAY_ADD_TO, "dodaj"},
    {TR_PARAMETER_DISPLAY_ALLOWED, "zezwolone"},
    {TR_PARAMETER_DISPLAY_ANYWHERE, "gdziekolwiek"},
    {TR_PARAMETER_DISPLAY_APPLY_COST, "koszt zezwolenia"},
    {TR_PARAMETER_DISPLAY_BETWEEN, "pomiędzy"},
    {TR_PARAMETER_DISPLAY_BUY_PRICE, "cena kupna"},
    {TR_PARAMETER_DISPLAY_DAYS, "dni"},
    {TR_PARAMETER_DISPLAY_DESTROY_ALL_TYPES, "niszcz wszystkie rodzaje"},
    {TR_PARAMETER_DISPLAY_DISALLOWED, "zabronione"},
    {TR_PARAMETER_DISPLAY_DO_NOT_SHOW_MESSAGE, "nie pokazuj wiadomości"},
    {TR_PARAMETER_DISPLAY_FLAT_NUMBER, "płaska liczba"},
    {TR_PARAMETER_DISPLAY_IGNORE_SETTINGS, "ignoruje ustawienia"},
    {TR_PARAMETER_DISPLAY_IN_CITY, "w mieście"},
    {TR_PARAMETER_DISPLAY_MONTHS, "miesiące"},
    {TR_PARAMETER_DISPLAY_NOT_ONGOING, "nie trwa"},
    {TR_PARAMETER_DISPLAY_NO_COST, "brak kosztu"},
    {TR_PARAMETER_DISPLAY_ONGOING, "trwa"},
    {TR_PARAMETER_DISPLAY_PERCENTAGE, "procent"},
    {TR_PARAMETER_DISPLAY_RESPECT_SETTINGS, "zachowując ustawienia"},
    {TR_PARAMETER_DISPLAY_ROUTE_CLOSED, "trasa jest zamknięta"},
    {TR_PARAMETER_DISPLAY_ROUTE_OPEN, "trasa jest otwarta"},
    {TR_PARAMETER_DISPLAY_SELL_PRICE, "cena sprzedaży"},
    {TR_PARAMETER_DISPLAY_SET_TO, "ustaw na"},
    {TR_PARAMETER_DISPLAY_SHOW_MESSAGE, "pokaż wiadomość"},
    {TR_PARAMETER_GRID_OFFSET, "Offset siatki"},
    {TR_PARAMETER_IN_CITY_ONLY, "Licz tylko żołnierzy w mieście?"},
    {TR_PARAMETER_PRODUCED, "Produkowane?"},
    {TR_PARAMETER_RADIUS, "Promień"},
    {TR_PARAMETER_RESPECT_SETTINGS, "Zachowuj usatwienia przechowania?"},
    {TR_PARAMETER_SET_BUY_PRICE, "Ustaw cenę kupna?"},
    {TR_PARAMETER_SET_TO_VALUE, "Ustaw wartość?"},
    {TR_PARAMETER_SHOW_MESSAGE, "Pokaż wiadomość?"},
    {TR_PARAMETER_TYPE_ALLOWED_BUILDING, "Dozwolony rodzaj budynku"},
    {TR_PARAMETER_TYPE_BOOLEAN, "Prawda lub fałsz"},
    {TR_PARAMETER_TYPE_BUILDING_COUNTING, "Rodzaj budynku dla liczenia"},
    {TR_PARAMETER_TYPE_CHECK, "Sprawdzenie porównawcze"},
    {TR_PARAMETER_TYPE_CUSTOM_MESSAGE, "Wiadomość niestandardowa"},
    {TR_PARAMETER_TYPE_CUSTOM_VARIABLE, "Zmienna niestandardowa"},
    {TR_PARAMETER_TYPE_DIFFICULTY, "Poziom trudności"},
    {TR_PARAMETER_TYPE_ENEMY_TYPE, "Rodzaj wroga"},
    {TR_PARAMETER_TYPE_FUTURE_CITY, "Celuj w przyszłe miasto handlowe"},
    {TR_PARAMETER_TYPE_INVASION_POINT, "Punkt inwazji"},
    {TR_PARAMETER_TYPE_INVASION_SIZE, "Rozmiar"},
    {TR_PARAMETER_TYPE_INVASION_TYPE, "Rodzaj ataku"},
    {TR_PARAMETER_TYPE_MIN_MAX_NUMBER_MAX, "Maksymalne"},
    {TR_PARAMETER_TYPE_MIN_MAX_NUMBER_MIN, "Minimalne"},
    {TR_PARAMETER_TYPE_NUMBER, "Liczba"},
    {TR_PARAMETER_TYPE_POP_CLASS, "Klasa ludności"},
    {TR_PARAMETER_TYPE_RATING_TYPE, "Typ oceny"},
    {TR_PARAMETER_TYPE_RESOURCE, "Surowiec"},
    {TR_PARAMETER_TYPE_ROUTE, "Docelowy szlak handlowy"},
    {TR_PARAMETER_TYPE_STANDARD_MESSAGE, "Standardowa wiadomość"},
    {TR_PARAMETER_TYPE_STORAGE_TYPE, "Rodzaj przechowania"},
    {TR_PARAMETER_TYPE_TARGET_TYPE, "Rodzaj celu"},
    {TR_PARAMETER_USE_PERCENTAGE, "Użyj procent?"},
    {TR_PARAMETER_VALUE_BOOLEAN_FALSE, "Fałsz"},
    {TR_PARAMETER_VALUE_BOOLEAN_TRUE, "Prawda"},
    {TR_PARAMETER_VALUE_BUILDING_ANY, "Jakiekolwiek"},
    {TR_PARAMETER_VALUE_BUILDING_LARGE_TEMPLE_CERES, "Duża świątynia Ceresa"},
    {TR_PARAMETER_VALUE_BUILDING_LARGE_TEMPLE_MARS, "Duża świątynia Marsa"},
    {TR_PARAMETER_VALUE_BUILDING_LARGE_TEMPLE_MERCURY, "Duża świątynia Merkurego"},
    {TR_PARAMETER_VALUE_BUILDING_LARGE_TEMPLE_NEPTUNE, "Duża świątynia Neptuna"},
    {TR_PARAMETER_VALUE_BUILDING_LARGE_TEMPLE_VENUS, "Duża świątynia Wenusa"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_FARMS, "Wszystkie farmy"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_GOV_RES, "Wszyskie rezydencje gubernatora"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_GRAND_TEMPLES, "Wszystkie wielkie świątynie"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_LARGE_TEMPLES, "Wszystkie duże świątynie"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_PARKS, "Wszystkie parki dekoracyjne"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_PATHS, "Wszystkie ścieżki dekoracyjne"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_RAW_MATERIALS, "Wszystkie surowce"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_SMALL_TEMPLES, "Wszystkie małe świątynie"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_STATUES, "Wszystkie posągi"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_TREES, "Wszystkie drzewa dekoracyjne"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_WORKSHOPS, "Wszystkie warsztaty"},
    {TR_PARAMETER_VALUE_BUILDING_NATIVE_CROPS, "Rodzime uprawy"},
    {TR_PARAMETER_VALUE_BUILDING_NONE, "Nic"},
    {TR_PARAMETER_VALUE_BUILDING_SMALL_TEMPLE_CERES, "Mała świątynia Ceresa"},
    {TR_PARAMETER_VALUE_BUILDING_SMALL_TEMPLE_MARS, "Mała świątynia Marsa"},
    {TR_PARAMETER_VALUE_BUILDING_SMALL_TEMPLE_MERCURY, "Mała świątynia Merkurego"},
    {TR_PARAMETER_VALUE_BUILDING_SMALL_TEMPLE_NEPTUNE, "Mała świątynia Neptuna"},
    {TR_PARAMETER_VALUE_BUILDING_SMALL_TEMPLE_VENUS, "Mała świątynia Wenusa"},
    {TR_PARAMETER_VALUE_COMPARISON_TYPE_EQUAL, "Równe"},
    {TR_PARAMETER_VALUE_COMPARISON_TYPE_EQUAL_OR_LESS, "Mniej lub równo"},
    {TR_PARAMETER_VALUE_COMPARISON_TYPE_EQUAL_OR_MORE, "Więcej lub równo"},
    {TR_PARAMETER_VALUE_COMPARISON_TYPE_GREATER_THAN, "Więcej niż"},
    {TR_PARAMETER_VALUE_COMPARISON_TYPE_LESS_THAN, "Mniej niż"},
    {TR_PARAMETER_VALUE_COMPARISON_TYPE_NOT_EQUAL, "Nierówne"},
    {TR_PARAMETER_VALUE_DIFFICULTY_EASY, "Łatwe"},
    {TR_PARAMETER_VALUE_DIFFICULTY_HARD, "Trudne"},
    {TR_PARAMETER_VALUE_DIFFICULTY_NORMAL, "Normalne"},
    {TR_PARAMETER_VALUE_DIFFICULTY_VERY_EASY, "Bardzo łatwe"},
    {TR_PARAMETER_VALUE_DIFFICULTY_VERY_HARD, "Bardzo trudne"},
    {TR_PARAMETER_VALUE_DYNAMIC_RESOLVE, "..."},
    {TR_PARAMETER_VALUE_ENEMY_0_BARBARIAN, "Barbarzyńca!"},
    {TR_PARAMETER_VALUE_ENEMY_10_CARTHAGINIAN, "Kartagińczyk"},
    {TR_PARAMETER_VALUE_ENEMY_11_CAESAR, "Cezar"},
    {TR_PARAMETER_VALUE_ENEMY_1_NUMIDIAN, "Numidyjczyk"},
    {TR_PARAMETER_VALUE_ENEMY_2_GAUL, "Galijczyk"},
    {TR_PARAMETER_VALUE_ENEMY_3_CELT, "Celt"},
    {TR_PARAMETER_VALUE_ENEMY_4_GOTH, "Got"},
    {TR_PARAMETER_VALUE_ENEMY_5_PERGAMUM, "Pergamum"},
    {TR_PARAMETER_VALUE_ENEMY_6_SELEUCID, "Seleucyd"},
    {TR_PARAMETER_VALUE_ENEMY_7_ETRUSCAN, "Etruskan"},
    {TR_PARAMETER_VALUE_ENEMY_8_GREEK, "Grek"},
    {TR_PARAMETER_VALUE_ENEMY_9_EGYPTIAN, "Egipcjanin"},
    {TR_PARAMETER_VALUE_ENEMY_UNDEFINED, "Mapa zdefiniowana"},
    {TR_PARAMETER_VALUE_FORMATION_ATTACK_BEST_BUILDINGS, "Najlepsze budynki"},
    {TR_PARAMETER_VALUE_FORMATION_ATTACK_FOOD_CHAIN, "Łańcuch pokarmowy"},
    {TR_PARAMETER_VALUE_FORMATION_ATTACK_GOLD_STORES, "Skarbce złota"},
    {TR_PARAMETER_VALUE_FORMATION_ATTACK_RANDOM, "Losowo"},
    {TR_PARAMETER_VALUE_FORMATION_ATTACK_TROOPS, "Oddziały"},
    {TR_PARAMETER_VALUE_INVASION_TYPE_CAESAR, "Cezar"},
    {TR_PARAMETER_VALUE_INVASION_TYPE_ENEMY_ARMY, "Armia wroga"},
    {TR_PARAMETER_VALUE_INVASION_TYPE_MARS_NATIVES, "Tubylcy Marsa"},
    {TR_PARAMETER_VALUE_INVASION_TYPE_NATIVES, "Tubylcy"},
    {TR_PARAMETER_VALUE_MEDIA_TYPE_SOUND, "Dzwięk"},
    {TR_PARAMETER_VALUE_MEDIA_TYPE_VIDEO, "Obraz"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_CERES, "Błogosławieństwo Ceresa"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_MARS, "Błogosławieństwo Marsa"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_MERCURY, "Błogosławieństwo Merkurego"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_MERCURY_ALTERNATE, "Błogosławieństwo Merkurego alternatywne"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_NEPTUNE, "Błogosławieństwo Neptuna"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_NEPTUNE_ALTERNATE, "Błogosławieństwo Neptuna alternatywne"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_VENUS, "Błogosławieństwo Wenusa"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_VENUS_ALTERNATE, "Błogosławieństwo Wenusa alternatywne"},
    {TR_PARAMETER_VALUE_MESSAGE_CAESAR_ANGER, "Gniew cezara"},
    {TR_PARAMETER_VALUE_MESSAGE_CAESAR_ARMY_CONTINUE, "Armia Cezara kontynuuje"},
    {TR_PARAMETER_VALUE_MESSAGE_CAESAR_ARMY_RETREAT, "Armia Cezara się wycofuje"},
    {TR_PARAMETER_VALUE_MESSAGE_CAESAR_RESPECT_1, "Szacunek Cezara 1"},
    {TR_PARAMETER_VALUE_MESSAGE_CAESAR_RESPECT_2, "Szacunek Cezara 2"},
    {TR_PARAMETER_VALUE_MESSAGE_CAESAR_RESPECT_3, "Szacunek Cezara 3"},
    {TR_PARAMETER_VALUE_MESSAGE_CAESAR_WRATH, "Gniew Cezara"},
    {TR_PARAMETER_VALUE_MESSAGE_CERES_IS_UPSET, "Niezadowolenie Ceresa"},
    {TR_PARAMETER_VALUE_MESSAGE_CITY_IN_DEBT, "Miasto w długach"},
    {TR_PARAMETER_VALUE_MESSAGE_CITY_IN_DEBT_AGAIN, "Miasto znów w długach"},
    {TR_PARAMETER_VALUE_MESSAGE_CITY_STILL_IN_DEBT, "Miasto nadal w długach"},
    {TR_PARAMETER_VALUE_MESSAGE_CONTAMINATED_WATER, "Skażona woda"},
    {TR_PARAMETER_VALUE_MESSAGE_DISTANT_BATTLE, "Odległa bitwa"},
    {TR_PARAMETER_VALUE_MESSAGE_DISTANT_BATTLE_CITY_RETAKEN, "Miasto odbite w odległe bitwie"},
    {TR_PARAMETER_VALUE_MESSAGE_DISTANT_BATTLE_LOST_NO_TROOPS, "Odległa bitwa przgrana (brak oddziałów)"},
    {TR_PARAMETER_VALUE_MESSAGE_DISTANT_BATTLE_LOST_TOO_LATE, "Odległa bitwa przgrana (za późno)"},
    {TR_PARAMETER_VALUE_MESSAGE_DISTANT_BATTLE_LOST_TOO_WEAK, "Odległa bitwa przgrana (zbyt małe wsparcie)"},
    {TR_PARAMETER_VALUE_MESSAGE_DISTANT_BATTLE_WON, "Odległa bitwa wygrana"},
    {TR_PARAMETER_VALUE_MESSAGE_EMIGRATION, "Emigracja"},
    {TR_PARAMETER_VALUE_MESSAGE_EMPEROR_CHANGE, "Zmiana cesarza"},
    {TR_PARAMETER_VALUE_MESSAGE_EMPIRE_HAS_EXPANDED, "Cesarstwo się rozrosło"},
    {TR_PARAMETER_VALUE_MESSAGE_ENEMIES_AT_THE_DOOR, "Wrogowie u drzwi"},
    {TR_PARAMETER_VALUE_MESSAGE_ENEMIES_CLOSING, "Wrogowie się zbliżają"},
    {TR_PARAMETER_VALUE_MESSAGE_ENEMIES_LEAVING, "Wrogowie się oddalają"},
    {TR_PARAMETER_VALUE_MESSAGE_FIRED, "Zwolniony"},
    {TR_PARAMETER_VALUE_MESSAGE_GLADIATOR_REVOLT, "Bunt gladiatorów"},
    {TR_PARAMETER_VALUE_MESSAGE_GLADIATOR_REVOLT_FINISHED, "Koniew buntu gladiatorów"},
    {TR_PARAMETER_VALUE_MESSAGE_GODS_UNHAPPY, "Bogowie niezadowoleni"},
    {TR_PARAMETER_VALUE_MESSAGE_GODS_WRATHFUL, "Bogowie wściekli"},
    {TR_PARAMETER_VALUE_MESSAGE_GRAND_FESTIVAL, "Wielki festiwal"},
    {TR_PARAMETER_VALUE_MESSAGE_HEALTH_DISEASE, "Zdrowie schorzenie"},
    {TR_PARAMETER_VALUE_MESSAGE_HEALTH_ILLNESS, "Zdrowie choroba"},
    {TR_PARAMETER_VALUE_MESSAGE_HEALTH_PESTILENCE, "Zdrowie zaraza"},
    {TR_PARAMETER_VALUE_MESSAGE_LAND_TRADE_DISRUPTED_LANDSLIDES, "Osuwiska w handlu lądowym"},
    {TR_PARAMETER_VALUE_MESSAGE_LAND_TRADE_DISRUPTED_SANDSTORMS, "Burze piaskowe w handlu lądowym"},
    {TR_PARAMETER_VALUE_MESSAGE_LARGE_FESTIVAL, "Duży festiwal"},
    {TR_PARAMETER_VALUE_MESSAGE_MARS_IS_UPSET, "Niezadowolenie Marsa"},
    {TR_PARAMETER_VALUE_MESSAGE_MERCURY_IS_UPSET, "Niezadowolenie Merkurego"},
    {TR_PARAMETER_VALUE_MESSAGE_NEPTUNE_IS_UPSET, "Niezadowolenie Neptuna"},
    {TR_PARAMETER_VALUE_MESSAGE_ROME_LOWERS_WAGES, "Rzym obniża wynagrodzenie"},
    {TR_PARAMETER_VALUE_MESSAGE_ROME_RAISES_WAGES, "Rome podwyższa wynagrodzenie"},
    {TR_PARAMETER_VALUE_MESSAGE_SEA_TRADE_DISRUPTED, "Przerwany handel morski"},
    {TR_PARAMETER_VALUE_MESSAGE_SMALL_FESTIVAL, "Mały festiwal"},
    {TR_PARAMETER_VALUE_MESSAGE_SOLDIERS_STARVING, "Żołnierze głodują"},
    {TR_PARAMETER_VALUE_MESSAGE_VENUS_IS_UPSET, "Niezadowolenie Wenusa"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_CERES, "Gniew Ceresa"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_MARS, "Gniew Marsa"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_MARS_NO_MILITARY, "Gniew Marsa (brak wojska)"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_MARS_NO_NATIVES, "Gniew Marsa (brak tubylców)"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_MERCURY, "Gniew Merkurego"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_NEPTUNE, "Gniew Neptuna"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_NEPTUNE_NO_SEA_TRADE, "Gniew Neptuna (brak handlu morskiego)"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_VENUS, "Gniew Wenusa"},
    {TR_PARAMETER_VALUE_NONE, "Nic"},
    {TR_PARAMETER_VALUE_POP_CLASS_ALL, "Wszystkie"},
    {TR_PARAMETER_VALUE_POP_CLASS_PATRICIAN, "Patrycjusze"},
    {TR_PARAMETER_VALUE_POP_CLASS_PLEBEIAN, "Plebejusze"},
    {TR_PARAMETER_VALUE_POP_CLASS_SLUMS, "Mieszkańcy slumsów"},
    {TR_PARAMETER_VALUE_RATING_TYPE_PEACE, "Pokój"},
    {TR_PARAMETER_VALUE_RATING_TYPE_PROSPERITY, "Dobrobyt"},
    {TR_PARAMETER_VALUE_STORAGE_TYPE_ALL, "Wszystkie"},
    {TR_PARAMETER_VALUE_STORAGE_TYPE_GRANARIES, "Spichlerze"},
    {TR_PARAMETER_VALUE_STORAGE_TYPE_WAREHOUSES, "Magazyny"},
    {TR_RESOURCE_BRICKS, "Cegły"},
    {TR_RESOURCE_CONCRETE, "Beton"},
    {TR_RESOURCE_GOLD, "Złoto"},
    {TR_RESOURCE_SAND, "Piasek"},
    {TR_RESOURCE_STONE, "Kamień"},
    {TR_SAVE_DIALOG_FILTER, "Filtr"},
    {TR_SAVE_DIALOG_INCOMPATIBLE_VERSION, "Niekompatibilna wersja"},
    {TR_SAVE_DIALOG_INVALID_FILE_DESC, "Zapis gry, który próbujesz wczytać, jest nieprawidłowy.\n\nZapis mógł zostać uszkodzony z powodu błędu.\n\nJeśli jesteś pewien, że to powinien być prawidłowy zapis, zgłoś błąd na adres:\n\nhttps ://github.com/Keriew/augustus/issues/new\n\nProszę załączyć również zapis."},
    {TR_SAVE_DIALOG_NEW_FILE, "Nowy plik"},
    {TR_SAVE_DIALOG_OVERWRITE_FILE, "Nadpisać plik?"},
    {TR_SAVE_DIALOG_OVERWRITE_FILE_DESC, "Ten plik juz istnieje. Nadpisać?"},
    {TR_SAVE_DIALOG_OVERWRITE_FILE_DO_NOT_ASK_AGAIN, "Nie pytaj znowu"},
    {TR_SAVE_DIALOG_SORTING_BY_DATE, "Sortuj po dacie"},
    {TR_SAVE_DIALOG_SORTING_BY_NAME, "Sortuj po nazwie"},
    {TR_TAVERN_FETCHING, "Biorący"},
    {TR_TAVERN_NOT_FETCHING, "Niebiorący"},
    {TR_TOOLTIP_BUTTON_CENTER_CAMERA, "Wycentruj kamerę na budynek"},
    {TR_TOOLTIP_OVERLAY_EFFICIENCY_0, "Nikt nie pamięta, kiedy ostatni raz coś produkowano w tym budynku." },
    {TR_TOOLTIP_OVERLAY_EFFICIENCY_1, "Ten budynek prawie nic nie produkuje." },
    {TR_TOOLTIP_OVERLAY_EFFICIENCY_2, "Można by tu wyprodukować znacznie więcej, gdyby wydajność była wyższa." },
    {TR_TOOLTIP_OVERLAY_EFFICIENCY_3, "Prace w tym budynku są często zatrzymywane, a jego wydajność jest niska." },
    {TR_TOOLTIP_OVERLAY_EFFICIENCY_4, "Budynek ten jest produktywny i charakteryzuje się niewielką liczbą przestojów." },
    {TR_TOOLTIP_OVERLAY_EFFICIENCY_5, "Budynek ten produkuje z maksymalną wydajnością." },
    {TR_TOOLTIP_OVERLAY_SICKNESS_NONE, "Brak schorzeń"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_ARENA_COVERAGE_PLURAL, "Areny" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_TAVERN_COVERAGE_PLURAL, "Tawerny" },
    {TR_WINDOW_ASSET_PREVIEWER_ANIMATION_FRAME, "( klatka animacji )"},
    {TR_WINDOW_ASSET_PREVIEWER_ASSET, "Objekt:"},
    {TR_WINDOW_ASSET_PREVIEWER_ASSETS_REFRESHED, "Objekty odświeżone" },
    {TR_WINDOW_ASSET_PREVIEWER_GROUP, "Grupa:"},
    {TR_WINDOW_ASSET_PREVIEWER_NO_ASSETS, "Brak objektów"},
    {TR_WINDOW_ASSET_PREVIEWER_NO_GROUPS, "( brak grup )"},
    {TR_WINDOW_ASSET_PREVIEWER_PLAY_ANIMATIONS, "Graj animacje"},
    {TR_WINDOW_ASSET_PREVIEWER_QUIT, "Wyjdź"},
    {TR_WINDOW_ASSET_PREVIEWER_REFRESH, "Odśwież"},
    {TR_WINDOW_ASSET_PREVIEWER_SHOW_ANIMATION_FRAMES, "Pokaż klatki animacji"},
    {TR_WINDOW_ASSET_PREVIEWER_TERRAIN, "Teren:"},
    {TR_WINDOW_ASSET_PREVIEWER_TERRAIN_CENTRAL, "Centralne"},
    {TR_WINDOW_ASSET_PREVIEWER_TERRAIN_DESERT, "Pustynne"},
    {TR_WINDOW_ASSET_PREVIEWER_TERRAIN_NONE, "Brak" },
    {TR_WINDOW_ASSET_PREVIEWER_TERRAIN_NORTHERN, "Północne"},
    {TR_WINDOW_ASSET_PREVIEWER_TITLE, "Podglądacz objektów"},
    {TR_WINDOW_ASSET_PREVIEWER_UNNAMED_ASSET, "( objekt bez nazwy )"},
    {TR_ZOOM, "Przybliżenie:"},
    {TR_WINDOW_ADVISOR_RELIGION_ALTARS_HEADER, "Ołtarze" }

};

void translation_polish(const translation_string **strings, int *num_strings)
{
    *strings = all_strings;
    *num_strings = sizeof(all_strings) / sizeof(translation_string);
}
