/* arraylist.c generated by valac 0.52.0, the Vala compiler
 * generated from arraylist.vala, do not modify */

/* arraylist.vala
 *
 * Copyright (C) 2004-2005  Novell, Inc
 * Copyright (C) 2005  David Waite
 * Copyright (C) 2007-2008  Jürg Billeter
 * Copyright (C) 2009  Didier Villevalois
 * Copyright (C) 2010-2014  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include "gee.h"
#include <glib-object.h>
#include <glib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE (gee_functions_equal_data_func_closure_get_type ())
#define GEE_FUNCTIONS_EQUAL_DATA_FUNC_CLOSURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE, GeeFunctionsEqualDataFuncClosure))
#define GEE_FUNCTIONS_EQUAL_DATA_FUNC_CLOSURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE, GeeFunctionsEqualDataFuncClosureClass))
#define GEE_FUNCTIONS_IS_EQUAL_DATA_FUNC_CLOSURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE))
#define GEE_FUNCTIONS_IS_EQUAL_DATA_FUNC_CLOSURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE))
#define GEE_FUNCTIONS_EQUAL_DATA_FUNC_CLOSURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE, GeeFunctionsEqualDataFuncClosureClass))

typedef struct _GeeFunctionsEqualDataFuncClosure GeeFunctionsEqualDataFuncClosure;
typedef struct _GeeFunctionsEqualDataFuncClosureClass GeeFunctionsEqualDataFuncClosureClass;
enum  {
	GEE_ARRAY_LIST_0_PROPERTY,
	GEE_ARRAY_LIST_G_TYPE,
	GEE_ARRAY_LIST_G_DUP_FUNC,
	GEE_ARRAY_LIST_G_DESTROY_FUNC,
	GEE_ARRAY_LIST_SIZE_PROPERTY,
	GEE_ARRAY_LIST_READ_ONLY_PROPERTY,
	GEE_ARRAY_LIST_NUM_PROPERTIES
};
static GParamSpec* gee_array_list_properties[GEE_ARRAY_LIST_NUM_PROPERTIES];
#define _gee_functions_equal_data_func_closure_unref0(var) ((var == NULL) ? NULL : (var = (gee_functions_equal_data_func_closure_unref (var), NULL)))

#define GEE_ARRAY_LIST_TYPE_ITERATOR (gee_array_list_iterator_get_type ())
#define GEE_ARRAY_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_ARRAY_LIST_TYPE_ITERATOR, GeeArrayListIterator))
#define GEE_ARRAY_LIST_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_ARRAY_LIST_TYPE_ITERATOR, GeeArrayListIteratorClass))
#define GEE_ARRAY_LIST_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_ARRAY_LIST_TYPE_ITERATOR))
#define GEE_ARRAY_LIST_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_ARRAY_LIST_TYPE_ITERATOR))
#define GEE_ARRAY_LIST_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_ARRAY_LIST_TYPE_ITERATOR, GeeArrayListIteratorClass))

typedef struct _GeeArrayListIterator GeeArrayListIterator;
typedef struct _GeeArrayListIteratorClass GeeArrayListIteratorClass;
typedef struct _GeeFunctionsEqualDataFuncClosurePrivate GeeFunctionsEqualDataFuncClosurePrivate;
typedef struct _GeeArrayListIteratorPrivate GeeArrayListIteratorPrivate;
enum  {
	GEE_ARRAY_LIST_ITERATOR_0_PROPERTY,
	GEE_ARRAY_LIST_ITERATOR_G_TYPE,
	GEE_ARRAY_LIST_ITERATOR_G_DUP_FUNC,
	GEE_ARRAY_LIST_ITERATOR_G_DESTROY_FUNC,
	GEE_ARRAY_LIST_ITERATOR_READ_ONLY_PROPERTY,
	GEE_ARRAY_LIST_ITERATOR_VALID_PROPERTY,
	GEE_ARRAY_LIST_ITERATOR_NUM_PROPERTIES
};
static GParamSpec* gee_array_list_iterator_properties[GEE_ARRAY_LIST_ITERATOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GeeArrayListPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeFunctionsEqualDataFuncClosure* _equal_func;
	gint _stamp;
};

struct _GeeFunctionsEqualDataFuncClosure {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GeeFunctionsEqualDataFuncClosurePrivate * priv;
	GeeEqualDataFunc func;
	gpointer func_target;
	GDestroyNotify func_target_destroy_notify;
};

struct _GeeFunctionsEqualDataFuncClosureClass {
	GTypeClass parent_class;
	void (*finalize) (GeeFunctionsEqualDataFuncClosure *self);
};

struct _GeeArrayListIterator {
	GObject parent_instance;
	GeeArrayListIteratorPrivate * priv;
	GeeArrayList* _list;
	gint _index;
	gboolean _removed;
	gint _stamp;
};

struct _GeeArrayListIteratorClass {
	GObjectClass parent_class;
};

struct _GeeArrayListIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};

static gint GeeArrayList_private_offset;
static gpointer gee_array_list_parent_class = NULL;
static gint GeeArrayListIterator_private_offset;
static gpointer gee_array_list_iterator_parent_class = NULL;
static GeeTraversableIface * gee_array_list_iterator_gee_traversable_parent_iface = NULL;
static GeeIteratorIface * gee_array_list_iterator_gee_iterator_parent_iface = NULL;
static GeeBidirIteratorIface * gee_array_list_iterator_gee_bidir_iterator_parent_iface = NULL;
static GeeListIteratorIface * gee_array_list_iterator_gee_list_iterator_parent_iface = NULL;
static GeeBidirListIteratorIface * gee_array_list_iterator_gee_bidir_list_iterator_parent_iface = NULL;

 G_GNUC_INTERNAL gpointer gee_functions_equal_data_func_closure_ref (gpointer instance);
 G_GNUC_INTERNAL void gee_functions_equal_data_func_closure_unref (gpointer instance);
 G_GNUC_INTERNAL GParamSpec* gee_functions_param_spec_equal_data_func_closure (const gchar* name,
                                                              const gchar* nick,
                                                              const gchar* blurb,
                                                              GType object_type,
                                                              GParamFlags flags);
 G_GNUC_INTERNAL void gee_functions_value_set_equal_data_func_closure (GValue* value,
                                                      gpointer v_object) G_GNUC_UNUSED ;
 G_GNUC_INTERNAL void gee_functions_value_take_equal_data_func_closure (GValue* value,
                                                       gpointer v_object);
 G_GNUC_INTERNAL gpointer gee_functions_value_get_equal_data_func_closure (const GValue* value) G_GNUC_UNUSED ;
 G_GNUC_INTERNAL GType gee_functions_equal_data_func_closure_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
 G_GNUC_INTERNAL GeeFunctionsEqualDataFuncClosure* gee_functions_equal_data_func_closure_new (GType g_type,
                                                                             GBoxedCopyFunc g_dup_func,
                                                                             GDestroyNotify g_destroy_func,
                                                                             GeeEqualDataFunc func,
                                                                             gpointer func_target,
                                                                             GDestroyNotify func_target_destroy_notify);
 G_GNUC_INTERNAL GeeFunctionsEqualDataFuncClosure* gee_functions_equal_data_func_closure_construct (GType object_type,
                                                                                   GType g_type,
                                                                                   GBoxedCopyFunc g_dup_func,
                                                                                   GDestroyNotify g_destroy_func,
                                                                                   GeeEqualDataFunc func,
                                                                                   gpointer func_target,
                                                                                   GDestroyNotify func_target_destroy_notify);
static gpointer* gee_array_list_do_wrap (GType g_type,
                                  GBoxedCopyFunc g_dup_func,
                                  GDestroyNotify g_destroy_func,
                                  gpointer* data,
                                  gint data_length1,
                                  gint* result_length1);
 G_GNUC_INTERNAL GeeArrayList* gee_array_list_new_with_closure (GType g_type,
                                               GBoxedCopyFunc g_dup_func,
                                               GDestroyNotify g_destroy_func,
                                               GeeFunctionsEqualDataFuncClosure* equal_func);
 G_GNUC_INTERNAL GeeArrayList* gee_array_list_construct_with_closure (GType object_type,
                                                     GType g_type,
                                                     GBoxedCopyFunc g_dup_func,
                                                     GDestroyNotify g_destroy_func,
                                                     GeeFunctionsEqualDataFuncClosure* equal_func);
static gboolean gee_array_list_real_foreach (GeeAbstractCollection* base,
                                      GeeForallFunc f,
                                      gpointer f_target);
static GeeIterator* gee_array_list_real_iterator (GeeAbstractCollection* base);
static GeeArrayListIterator* gee_array_list_iterator_new (GType g_type,
                                                   GBoxedCopyFunc g_dup_func,
                                                   GDestroyNotify g_destroy_func,
                                                   GeeArrayList* list);
static GeeArrayListIterator* gee_array_list_iterator_construct (GType object_type,
                                                         GType g_type,
                                                         GBoxedCopyFunc g_dup_func,
                                                         GDestroyNotify g_destroy_func,
                                                         GeeArrayList* list);
static GType gee_array_list_iterator_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GeeListIterator* gee_array_list_real_list_iterator (GeeAbstractList* base);
static GeeBidirListIterator* gee_array_list_real_bidir_list_iterator (GeeAbstractBidirList* base);
static gboolean gee_array_list_real_contains (GeeAbstractCollection* base,
                                       gconstpointer item);
static gint gee_array_list_real_index_of (GeeAbstractList* base,
                                   gconstpointer item);
static gpointer gee_array_list_real_get (GeeAbstractList* base,
                                  gint index);
static void gee_array_list_real_set (GeeAbstractList* base,
                              gint index,
                              gconstpointer item);
static gboolean gee_array_list_real_add (GeeAbstractCollection* base,
                                  gconstpointer item);
static void gee_array_list_grow_if_needed (GeeArrayList* self,
                                    gint new_count);
static void gee_array_list_real_insert (GeeAbstractList* base,
                                 gint index,
                                 gconstpointer item);
static void gee_array_list_shift (GeeArrayList* self,
                           gint start,
                           gint delta);
static gboolean gee_array_list_real_remove (GeeAbstractCollection* base,
                                     gconstpointer item);
static gpointer gee_array_list_real_remove_at (GeeAbstractList* base,
                                        gint index);
static void gee_array_list_real_clear (GeeAbstractCollection* base);
static GeeList* gee_array_list_real_slice (GeeAbstractList* base,
                                    gint start,
                                    gint stop);
static gboolean __lambda47_ (GeeArrayList* self,
                      gpointer item);
static gboolean ___lambda47__gee_forall_func (gpointer g,
                                       gpointer self);
static void gee_array_list_set_capacity (GeeArrayList* self,
                                  gint value);
static gpointer* gee_array_list_wrap_bool (GType g_type,
                                    GBoxedCopyFunc g_dup_func,
                                    GDestroyNotify g_destroy_func,
                                    gboolean* data,
                                    gint data_length1,
                                    gint* result_length1);
static gpointer* gee_array_list_wrap_char (GType g_type,
                                    GBoxedCopyFunc g_dup_func,
                                    GDestroyNotify g_destroy_func,
                                    gchar* data,
                                    gint data_length1,
                                    gint* result_length1);
static gpointer* gee_array_list_wrap_uchar (GType g_type,
                                     GBoxedCopyFunc g_dup_func,
                                     GDestroyNotify g_destroy_func,
                                     guchar* data,
                                     gint data_length1,
                                     gint* result_length1);
static gpointer* gee_array_list_wrap_int (GType g_type,
                                   GBoxedCopyFunc g_dup_func,
                                   GDestroyNotify g_destroy_func,
                                   gint* data,
                                   gint data_length1,
                                   gint* result_length1);
static gpointer* gee_array_list_wrap_uint (GType g_type,
                                    GBoxedCopyFunc g_dup_func,
                                    GDestroyNotify g_destroy_func,
                                    guint* data,
                                    gint data_length1,
                                    gint* result_length1);
static gpointer* gee_array_list_wrap_int64 (GType g_type,
                                     GBoxedCopyFunc g_dup_func,
                                     GDestroyNotify g_destroy_func,
                                     gint64* data,
                                     gint data_length1,
                                     gint* result_length1);
static gpointer* gee_array_list_wrap_uint64 (GType g_type,
                                      GBoxedCopyFunc g_dup_func,
                                      GDestroyNotify g_destroy_func,
                                      guint64* data,
                                      gint data_length1,
                                      gint* result_length1);
static gpointer* gee_array_list_wrap_long (GType g_type,
                                    GBoxedCopyFunc g_dup_func,
                                    GDestroyNotify g_destroy_func,
                                    glong* data,
                                    gint data_length1,
                                    gint* result_length1);
static gpointer* gee_array_list_wrap_ulong (GType g_type,
                                     GBoxedCopyFunc g_dup_func,
                                     GDestroyNotify g_destroy_func,
                                     gulong* data,
                                     gint data_length1,
                                     gint* result_length1);
static gpointer* gee_array_list_wrap_float (GType g_type,
                                     GBoxedCopyFunc g_dup_func,
                                     GDestroyNotify g_destroy_func,
                                     gfloat** data,
                                     gint data_length1,
                                     gint* result_length1);
static gpointer* gee_array_list_wrap_double (GType g_type,
                                      GBoxedCopyFunc g_dup_func,
                                      GDestroyNotify g_destroy_func,
                                      gdouble** data,
                                      gint data_length1,
                                      gint* result_length1);
static void gee_array_list_set_equal_func (GeeArrayList* self,
                                    GeeEqualDataFunc value,
                                    gpointer value_target);
static GeeArrayListIterator* gee_array_list_iterator_new_from_iterator (GType g_type,
                                                                 GBoxedCopyFunc g_dup_func,
                                                                 GDestroyNotify g_destroy_func,
                                                                 GeeArrayListIterator* iter);
static GeeArrayListIterator* gee_array_list_iterator_construct_from_iterator (GType object_type,
                                                                       GType g_type,
                                                                       GBoxedCopyFunc g_dup_func,
                                                                       GDestroyNotify g_destroy_func,
                                                                       GeeArrayListIterator* iter);
static gboolean gee_array_list_iterator_real_next (GeeIterator* base);
static gboolean gee_array_list_iterator_real_has_next (GeeIterator* base);
static gboolean gee_array_list_iterator_real_first (GeeBidirIterator* base);
static gpointer gee_array_list_iterator_real_get (GeeIterator* base);
static void gee_array_list_iterator_real_remove (GeeIterator* base);
static gboolean gee_array_list_iterator_real_previous (GeeBidirIterator* base);
static gboolean gee_array_list_iterator_real_has_previous (GeeBidirIterator* base);
static gboolean gee_array_list_iterator_real_last (GeeBidirIterator* base);
static void gee_array_list_iterator_real_set (GeeListIterator* base,
                                       gconstpointer item);
static void gee_array_list_iterator_real_insert (GeeBidirListIterator* base,
                                          gconstpointer item);
static void gee_array_list_iterator_real_add (GeeListIterator* base,
                                       gconstpointer item);
static gint gee_array_list_iterator_real_index (GeeListIterator* base);
static gboolean gee_array_list_iterator_real_foreach (GeeTraversable* base,
                                               GeeForallFunc f,
                                               gpointer f_target);
static GeeIterator** gee_array_list_iterator_real_tee (GeeTraversable* base,
                                                guint forks,
                                                gint* result_length1);
static void gee_array_list_iterator_finalize (GObject * obj);
static GType gee_array_list_iterator_get_type_once (void);
static void _vala_gee_array_list_iterator_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_gee_array_list_iterator_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static void gee_array_list_finalize (GObject * obj);
static GType gee_array_list_get_type_once (void);
static void _vala_gee_array_list_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_gee_array_list_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static void _vala_array_move (gpointer array,
                       gsize element_size,
                       gint src,
                       gint dest,
                       gint length);

static inline gpointer
gee_array_list_get_instance_private (GeeArrayList* self)
{
	return G_STRUCT_MEMBER_P (self, GeeArrayList_private_offset);
}

/**
 * Constructs a new, empty array list.
 *
 * If not provided, the function parameter is requested to the
 * {@link Functions} function factory methods.
 *
 * @param equal_func an optional element equality testing function
 */
GeeArrayList*
gee_array_list_construct (GType object_type,
                          GType g_type,
                          GBoxedCopyFunc g_dup_func,
                          GDestroyNotify g_destroy_func,
                          GeeEqualDataFunc equal_func,
                          gpointer equal_func_target,
                          GDestroyNotify equal_func_target_destroy_notify)
{
	GeeArrayList * self = NULL;
	GeeEqualDataFunc _tmp3_;
	gpointer _tmp3__target;
	GDestroyNotify _tmp3__target_destroy_notify;
	GeeFunctionsEqualDataFuncClosure* _tmp4_;
	gpointer* _tmp5_;
	self = (GeeArrayList*) gee_abstract_bidir_list_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	if (equal_func == NULL) {
		gpointer _tmp0_ = NULL;
		GDestroyNotify _tmp1_ = NULL;
		GeeEqualDataFunc _tmp2_;
		_tmp2_ = gee_functions_get_equal_func_for (g_type, &_tmp0_, &_tmp1_);
		(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
		equal_func = NULL;
		equal_func_target = NULL;
		equal_func_target_destroy_notify = NULL;
		equal_func = _tmp2_;
		equal_func_target = _tmp0_;
		equal_func_target_destroy_notify = _tmp1_;
	}
	_tmp3_ = equal_func;
	_tmp3__target = equal_func_target;
	_tmp3__target_destroy_notify = equal_func_target_destroy_notify;
	equal_func = NULL;
	equal_func_target = NULL;
	equal_func_target_destroy_notify = NULL;
	_tmp4_ = gee_functions_equal_data_func_closure_new (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, _tmp3_, _tmp3__target, _tmp3__target_destroy_notify);
	_gee_functions_equal_data_func_closure_unref0 (self->priv->_equal_func);
	self->priv->_equal_func = _tmp4_;
	_tmp5_ = g_new0 (gpointer, 4);
	self->_items = (_vala_array_free (self->_items, self->_items_length1, (GDestroyNotify) g_destroy_func), NULL);
	self->_items = _tmp5_;
	self->_items_length1 = 4;
	self->__items_size_ = self->_items_length1;
	self->_size = 0;
	(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
	equal_func = NULL;
	equal_func_target = NULL;
	equal_func_target_destroy_notify = NULL;
	return self;
}

GeeArrayList*
gee_array_list_new (GType g_type,
                    GBoxedCopyFunc g_dup_func,
                    GDestroyNotify g_destroy_func,
                    GeeEqualDataFunc equal_func,
                    gpointer equal_func_target,
                    GDestroyNotify equal_func_target_destroy_notify)
{
	return gee_array_list_construct (GEE_TYPE_ARRAY_LIST, g_type, g_dup_func, g_destroy_func, equal_func, equal_func_target, equal_func_target_destroy_notify);
}

/**
 * Constructs a new array list based on provided array.
 *
 * If not provided, the function parameter is requested to the
 * {@link Functions} function factory methods.
 *
 * @param items initial items to be put into array
 * @param equal_func an optional element equality testing function
 */
GeeArrayList*
gee_array_list_construct_wrap (GType object_type,
                               GType g_type,
                               GBoxedCopyFunc g_dup_func,
                               GDestroyNotify g_destroy_func,
                               gpointer* items,
                               gint items_length1,
                               GeeEqualDataFunc equal_func,
                               gpointer equal_func_target,
                               GDestroyNotify equal_func_target_destroy_notify)
{
	GeeArrayList * self = NULL;
	GeeEqualDataFunc _tmp3_;
	gpointer _tmp3__target;
	GDestroyNotify _tmp3__target_destroy_notify;
	GeeFunctionsEqualDataFuncClosure* _tmp4_;
	gpointer* _tmp5_;
	gint _tmp5__length1;
	gint _tmp6_ = 0;
	gpointer* _tmp7_;
	self = (GeeArrayList*) gee_abstract_bidir_list_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	if (equal_func == NULL) {
		gpointer _tmp0_ = NULL;
		GDestroyNotify _tmp1_ = NULL;
		GeeEqualDataFunc _tmp2_;
		_tmp2_ = gee_functions_get_equal_func_for (g_type, &_tmp0_, &_tmp1_);
		(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
		equal_func = NULL;
		equal_func_target = NULL;
		equal_func_target_destroy_notify = NULL;
		equal_func = _tmp2_;
		equal_func_target = _tmp0_;
		equal_func_target_destroy_notify = _tmp1_;
	}
	_tmp3_ = equal_func;
	_tmp3__target = equal_func_target;
	_tmp3__target_destroy_notify = equal_func_target_destroy_notify;
	equal_func = NULL;
	equal_func_target = NULL;
	equal_func_target_destroy_notify = NULL;
	_tmp4_ = gee_functions_equal_data_func_closure_new (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, _tmp3_, _tmp3__target, _tmp3__target_destroy_notify);
	_gee_functions_equal_data_func_closure_unref0 (self->priv->_equal_func);
	self->priv->_equal_func = _tmp4_;
	self->_size = items_length1;
	_tmp5_ = items;
	_tmp5__length1 = items_length1;
	items = NULL;
	items_length1 = 0;
	_tmp7_ = gee_array_list_do_wrap (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, _tmp5_, (gint) _tmp5__length1, &_tmp6_);
	self->_items = (_vala_array_free (self->_items, self->_items_length1, (GDestroyNotify) g_destroy_func), NULL);
	self->_items = _tmp7_;
	self->_items_length1 = _tmp6_;
	self->__items_size_ = self->_items_length1;
	items = (_vala_array_free (items, items_length1, (GDestroyNotify) g_destroy_func), NULL);
	(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
	equal_func = NULL;
	equal_func_target = NULL;
	equal_func_target_destroy_notify = NULL;
	return self;
}

GeeArrayList*
gee_array_list_new_wrap (GType g_type,
                         GBoxedCopyFunc g_dup_func,
                         GDestroyNotify g_destroy_func,
                         gpointer* items,
                         gint items_length1,
                         GeeEqualDataFunc equal_func,
                         gpointer equal_func_target,
                         GDestroyNotify equal_func_target_destroy_notify)
{
	return gee_array_list_construct_wrap (GEE_TYPE_ARRAY_LIST, g_type, g_dup_func, g_destroy_func, items, items_length1, equal_func, equal_func_target, equal_func_target_destroy_notify);
}

static gpointer
_gee_functions_equal_data_func_closure_ref0 (gpointer self)
{
	return self ? gee_functions_equal_data_func_closure_ref (self) : NULL;
}

 G_GNUC_INTERNAL GeeArrayList*
gee_array_list_construct_with_closure (GType object_type,
                                       GType g_type,
                                       GBoxedCopyFunc g_dup_func,
                                       GDestroyNotify g_destroy_func,
                                       GeeFunctionsEqualDataFuncClosure* equal_func)
{
	GeeArrayList * self = NULL;
	GeeFunctionsEqualDataFuncClosure* _tmp0_;
	gpointer* _tmp1_;
	g_return_val_if_fail (equal_func != NULL, NULL);
	self = (GeeArrayList*) gee_abstract_bidir_list_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = _gee_functions_equal_data_func_closure_ref0 (equal_func);
	_gee_functions_equal_data_func_closure_unref0 (self->priv->_equal_func);
	self->priv->_equal_func = _tmp0_;
	_tmp1_ = g_new0 (gpointer, 4);
	self->_items = (_vala_array_free (self->_items, self->_items_length1, (GDestroyNotify) g_destroy_func), NULL);
	self->_items = _tmp1_;
	self->_items_length1 = 4;
	self->__items_size_ = self->_items_length1;
	self->_size = 0;
	_gee_functions_equal_data_func_closure_unref0 (equal_func);
	return self;
}

 G_GNUC_INTERNAL GeeArrayList*
gee_array_list_new_with_closure (GType g_type,
                                 GBoxedCopyFunc g_dup_func,
                                 GDestroyNotify g_destroy_func,
                                 GeeFunctionsEqualDataFuncClosure* equal_func)
{
	return gee_array_list_construct_with_closure (GEE_TYPE_ARRAY_LIST, g_type, g_dup_func, g_destroy_func, equal_func);
}

/**
 * {@inheritDoc}
 */
static gboolean
gee_array_list_real_foreach (GeeAbstractCollection* base,
                             GeeForallFunc f,
                             gpointer f_target)
{
	GeeArrayList * self;
	gboolean result = FALSE;
	self = (GeeArrayList*) base;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gpointer* _tmp2_;
				gint _tmp2__length1;
				gconstpointer _tmp3_;
				gpointer _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < self->_size)) {
					break;
				}
				_tmp2_ = self->_items;
				_tmp2__length1 = self->_items_length1;
				_tmp3_ = _tmp2_[i];
				_tmp4_ = ((_tmp3_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp3_) : ((gpointer) _tmp3_);
				if (!f (_tmp4_, f_target)) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

/**
 * {@inheritDoc}
 */
static GeeIterator*
gee_array_list_real_iterator (GeeAbstractCollection* base)
{
	GeeArrayList * self;
	GeeArrayListIterator* _tmp0_;
	GeeIterator* result = NULL;
	self = (GeeArrayList*) base;
	_tmp0_ = gee_array_list_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, self);
	result = (GeeIterator*) _tmp0_;
	return result;
}

/**
 * {@inheritDoc}
 */
static GeeListIterator*
gee_array_list_real_list_iterator (GeeAbstractList* base)
{
	GeeArrayList * self;
	GeeArrayListIterator* _tmp0_;
	GeeListIterator* result = NULL;
	self = (GeeArrayList*) base;
	_tmp0_ = gee_array_list_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, self);
	result = (GeeListIterator*) _tmp0_;
	return result;
}

/**
 * {@inheritDoc}
 */
static GeeBidirListIterator*
gee_array_list_real_bidir_list_iterator (GeeAbstractBidirList* base)
{
	GeeArrayList * self;
	GeeArrayListIterator* _tmp0_;
	GeeBidirListIterator* result = NULL;
	self = (GeeArrayList*) base;
	_tmp0_ = gee_array_list_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, self);
	result = (GeeBidirListIterator*) _tmp0_;
	return result;
}

/**
 * {@inheritDoc}
 */
static gboolean
gee_array_list_real_contains (GeeAbstractCollection* base,
                              gconstpointer item)
{
	GeeArrayList * self;
	gboolean result = FALSE;
	self = (GeeArrayList*) base;
	result = gee_abstract_list_index_of ((GeeAbstractList*) self, item) != -1;
	return result;
}

/**
 * {@inheritDoc}
 */
static gint
gee_array_list_real_index_of (GeeAbstractList* base,
                              gconstpointer item)
{
	GeeArrayList * self;
	gint result = 0;
	self = (GeeArrayList*) base;
	{
		gint index = 0;
		index = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GeeEqualDataFunc _tmp2_ = NULL;
				gpointer _tmp2__target = NULL;
				GeeEqualDataFunc _tmp3_;
				gpointer _tmp3__target;
				gpointer* _tmp4_;
				gint _tmp4__length1;
				gconstpointer _tmp5_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = index;
					index = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(index < self->_size)) {
					break;
				}
				_tmp2_ = gee_array_list_get_equal_func (self, &_tmp2__target);
				_tmp3_ = _tmp2_;
				_tmp3__target = _tmp2__target;
				_tmp4_ = self->_items;
				_tmp4__length1 = self->_items_length1;
				_tmp5_ = _tmp4_[index];
				if (_tmp3_ (_tmp5_, item, _tmp3__target)) {
					result = index;
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}

/**
 * {@inheritDoc}
 */
static gpointer
gee_array_list_real_get (GeeAbstractList* base,
                         gint index)
{
	GeeArrayList * self;
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gconstpointer _tmp1_;
	gpointer _tmp2_;
	gpointer result = NULL;
	self = (GeeArrayList*) base;
	_vala_assert (index >= 0, "index >= 0");
	_vala_assert (index < self->_size, "index < _size");
	_tmp0_ = self->_items;
	_tmp0__length1 = self->_items_length1;
	_tmp1_ = _tmp0_[index];
	_tmp2_ = ((_tmp1_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp1_) : ((gpointer) _tmp1_);
	result = _tmp2_;
	return result;
}

/**
 * {@inheritDoc}
 */
static void
gee_array_list_real_set (GeeAbstractList* base,
                         gint index,
                         gconstpointer item)
{
	GeeArrayList * self;
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gpointer _tmp1_;
	self = (GeeArrayList*) base;
	_vala_assert (index >= 0, "index >= 0");
	_vala_assert (index < self->_size, "index < _size");
	_tmp0_ = self->_items;
	_tmp0__length1 = self->_items_length1;
	_tmp1_ = ((item != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) item) : ((gpointer) item);
	((_tmp0_[index] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp0_[index] = (self->priv->g_destroy_func (_tmp0_[index]), NULL));
	_tmp0_[index] = _tmp1_;
}

/**
 * {@inheritDoc}
 */
static gboolean
gee_array_list_real_add (GeeAbstractCollection* base,
                         gconstpointer item)
{
	GeeArrayList * self;
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gpointer* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	gconstpointer _tmp3_;
	gpointer _tmp4_;
	gint _tmp5_;
	gboolean result = FALSE;
	self = (GeeArrayList*) base;
	_tmp0_ = self->_items;
	_tmp0__length1 = self->_items_length1;
	if (self->_size == _tmp0__length1) {
		gee_array_list_grow_if_needed (self, 1);
	}
	_tmp1_ = self->_items;
	_tmp1__length1 = self->_items_length1;
	_tmp2_ = self->_size;
	self->_size = _tmp2_ + 1;
	_tmp3_ = item;
	_tmp4_ = ((_tmp3_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp3_) : ((gpointer) _tmp3_);
	((_tmp1_[_tmp2_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp1_[_tmp2_] = (self->priv->g_destroy_func (_tmp1_[_tmp2_]), NULL));
	_tmp1_[_tmp2_] = _tmp4_;
	_tmp5_ = self->priv->_stamp;
	self->priv->_stamp = _tmp5_ + 1;
	result = TRUE;
	return result;
}

/**
 * {@inheritDoc}
 */
static void
gee_array_list_real_insert (GeeAbstractList* base,
                            gint index,
                            gconstpointer item)
{
	GeeArrayList * self;
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gpointer* _tmp1_;
	gint _tmp1__length1;
	gpointer _tmp2_;
	gint _tmp3_;
	self = (GeeArrayList*) base;
	_vala_assert (index >= 0, "index >= 0");
	_vala_assert (index <= self->_size, "index <= _size");
	_tmp0_ = self->_items;
	_tmp0__length1 = self->_items_length1;
	if (self->_size == _tmp0__length1) {
		gee_array_list_grow_if_needed (self, 1);
	}
	gee_array_list_shift (self, index, 1);
	_tmp1_ = self->_items;
	_tmp1__length1 = self->_items_length1;
	_tmp2_ = ((item != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) item) : ((gpointer) item);
	((_tmp1_[index] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp1_[index] = (self->priv->g_destroy_func (_tmp1_[index]), NULL));
	_tmp1_[index] = _tmp2_;
	_tmp3_ = self->priv->_stamp;
	self->priv->_stamp = _tmp3_ + 1;
}

/**
 * {@inheritDoc}
 */
static gboolean
gee_array_list_real_remove (GeeAbstractCollection* base,
                            gconstpointer item)
{
	GeeArrayList * self;
	gboolean result = FALSE;
	self = (GeeArrayList*) base;
	{
		gint index = 0;
		index = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GeeEqualDataFunc _tmp2_ = NULL;
				gpointer _tmp2__target = NULL;
				GeeEqualDataFunc _tmp3_;
				gpointer _tmp3__target;
				gpointer* _tmp4_;
				gint _tmp4__length1;
				gconstpointer _tmp5_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = index;
					index = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(index < self->_size)) {
					break;
				}
				_tmp2_ = gee_array_list_get_equal_func (self, &_tmp2__target);
				_tmp3_ = _tmp2_;
				_tmp3__target = _tmp2__target;
				_tmp4_ = self->_items;
				_tmp4__length1 = self->_items_length1;
				_tmp5_ = _tmp4_[index];
				if (_tmp3_ (_tmp5_, item, _tmp3__target)) {
					gpointer _tmp6_;
					gpointer _tmp7_;
					_tmp6_ = gee_abstract_list_remove_at ((GeeAbstractList*) self, index);
					_tmp7_ = _tmp6_;
					((_tmp7_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp7_ = (self->priv->g_destroy_func (_tmp7_), NULL));
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}

/**
 * {@inheritDoc}
 */
static gpointer
gee_array_list_real_remove_at (GeeAbstractList* base,
                               gint index)
{
	GeeArrayList * self;
	gpointer item = NULL;
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gconstpointer _tmp1_;
	gpointer _tmp2_;
	gpointer* _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_;
	gpointer result = NULL;
	self = (GeeArrayList*) base;
	_vala_assert (index >= 0, "index >= 0");
	_vala_assert (index < self->_size, "index < _size");
	_tmp0_ = self->_items;
	_tmp0__length1 = self->_items_length1;
	_tmp1_ = _tmp0_[index];
	_tmp2_ = ((_tmp1_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp1_) : ((gpointer) _tmp1_);
	item = _tmp2_;
	_tmp3_ = self->_items;
	_tmp3__length1 = self->_items_length1;
	((_tmp3_[index] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp3_[index] = (self->priv->g_destroy_func (_tmp3_[index]), NULL));
	_tmp3_[index] = NULL;
	gee_array_list_shift (self, index + 1, -1);
	_tmp4_ = self->priv->_stamp;
	self->priv->_stamp = _tmp4_ + 1;
	result = item;
	return result;
}

/**
 * {@inheritDoc}
 */
static void
gee_array_list_real_clear (GeeAbstractCollection* base)
{
	GeeArrayList * self;
	gint _tmp3_;
	self = (GeeArrayList*) base;
	{
		gint index = 0;
		index = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gpointer* _tmp2_;
				gint _tmp2__length1;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = index;
					index = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(index < self->_size)) {
					break;
				}
				_tmp2_ = self->_items;
				_tmp2__length1 = self->_items_length1;
				((_tmp2_[index] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp2_[index] = (self->priv->g_destroy_func (_tmp2_[index]), NULL));
				_tmp2_[index] = NULL;
			}
		}
	}
	self->_size = 0;
	_tmp3_ = self->priv->_stamp;
	self->priv->_stamp = _tmp3_ + 1;
}

/**
 * {@inheritDoc}
 */
static GeeList*
gee_array_list_real_slice (GeeAbstractList* base,
                           gint start,
                           gint stop)
{
	GeeArrayList * self;
	GeeArrayList* slice = NULL;
	GeeFunctionsEqualDataFuncClosure* _tmp0_;
	GeeFunctionsEqualDataFuncClosure* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeList* result = NULL;
	self = (GeeArrayList*) base;
	g_return_val_if_fail (start <= stop, NULL);
	g_return_val_if_fail (start >= 0, NULL);
	g_return_val_if_fail (stop <= self->_size, NULL);
	_tmp0_ = self->priv->_equal_func;
	_tmp1_ = _gee_functions_equal_data_func_closure_ref0 (_tmp0_);
	_tmp2_ = gee_array_list_new_with_closure (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, _tmp1_);
	slice = _tmp2_;
	{
		gint i = 0;
		i = start;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp5_;
				gpointer _tmp6_;
				gpointer _tmp7_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				if (!(i < stop)) {
					break;
				}
				_tmp5_ = slice;
				_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) self, i);
				_tmp7_ = _tmp6_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, _tmp7_);
				((_tmp7_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp7_ = (self->priv->g_destroy_func (_tmp7_), NULL));
			}
		}
	}
	result = (GeeList*) slice;
	return result;
}

/**
 * {@inheritDoc}
 */
static gboolean
__lambda47_ (GeeArrayList* self,
             gpointer item)
{
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	gconstpointer _tmp2_;
	gpointer _tmp3_;
	gboolean result = FALSE;
	_tmp0_ = self->_items;
	_tmp0__length1 = self->_items_length1;
	_tmp1_ = self->_size;
	self->_size = _tmp1_ + 1;
	_tmp2_ = item;
	_tmp3_ = ((_tmp2_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp2_) : ((gpointer) _tmp2_);
	((_tmp0_[_tmp1_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp0_[_tmp1_] = (self->priv->g_destroy_func (_tmp0_[_tmp1_]), NULL));
	_tmp0_[_tmp1_] = _tmp3_;
	result = TRUE;
	((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
	return result;
}

static gboolean
___lambda47__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = __lambda47_ ((GeeArrayList*) self, g);
	return result;
}

gboolean
gee_array_list_add_all (GeeArrayList* self,
                        GeeCollection* collection)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (collection != NULL, FALSE);
	_tmp0_ = gee_collection_get_is_empty (collection);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = gee_collection_get_size (collection);
	_tmp3_ = _tmp2_;
	gee_array_list_grow_if_needed (self, _tmp3_);
	gee_traversable_foreach ((GeeTraversable*) collection, ___lambda47__gee_forall_func, self);
	_tmp4_ = self->priv->_stamp;
	self->priv->_stamp = _tmp4_ + 1;
	result = TRUE;
	return result;
}

static void
gee_array_list_shift (GeeArrayList* self,
                      gint start,
                      gint delta)
{
	g_return_if_fail (self != NULL);
	_vala_assert (start >= 0, "start >= 0");
	_vala_assert (start <= self->_size, "start <= _size");
	_vala_assert (start >= (-delta), "start >= -delta");
	_vala_array_move (self->_items, sizeof (gpointer), start, start + delta, self->_size - start);
	self->_size = self->_size + delta;
}

static void
gee_array_list_grow_if_needed (GeeArrayList* self,
                               gint new_count)
{
	gint minimum_size = 0;
	gpointer* _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_vala_assert (new_count >= 0, "new_count >= 0");
	minimum_size = self->_size + new_count;
	_tmp0_ = self->_items;
	_tmp0__length1 = self->_items_length1;
	if (minimum_size > _tmp0__length1) {
		gint _tmp1_ = 0;
		gpointer* _tmp2_;
		gint _tmp2__length1;
		_tmp2_ = self->_items;
		_tmp2__length1 = self->_items_length1;
		if (new_count > _tmp2__length1) {
			_tmp1_ = minimum_size;
		} else {
			gpointer* _tmp3_;
			gint _tmp3__length1;
			_tmp3_ = self->_items;
			_tmp3__length1 = self->_items_length1;
			_tmp1_ = 2 * _tmp3__length1;
		}
		gee_array_list_set_capacity (self, _tmp1_);
	}
}

static void
gee_array_list_set_capacity (GeeArrayList* self,
                             gint value)
{
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_vala_assert (value >= self->_size, "value >= _size");
	_tmp0_ = value;
	self->_items = g_renew (gpointer, self->_items, value);
	(_tmp0_ > self->_items_length1) ? memset (self->_items + self->_items_length1, 0, sizeof (gpointer) * (_tmp0_ - self->_items_length1)) : NULL;
	self->_items_length1 = _tmp0_;
	self->__items_size_ = _tmp0_;
}

static gpointer*
gee_array_list_do_wrap (GType g_type,
                        GBoxedCopyFunc g_dup_func,
                        GDestroyNotify g_destroy_func,
                        gpointer* data,
                        gint data_length1,
                        gint* result_length1)
{
	GType t = 0UL;
	gpointer* result = NULL;
	t = g_type;
	if (t == G_TYPE_BOOLEAN) {
		gint _tmp0_ = 0;
		gpointer* _tmp1_;
		gpointer* _tmp2_;
		gint _tmp2__length1;
		_tmp1_ = gee_array_list_wrap_bool (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, (gboolean*) data, (gint) data_length1, &_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp2__length1 = _tmp0_;
		if (result_length1) {
			*result_length1 = _tmp2__length1;
		}
		result = _tmp2_;
		data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_destroy_func), NULL);
		return result;
	} else {
		if (t == G_TYPE_CHAR) {
			gint _tmp3_ = 0;
			gpointer* _tmp4_;
			gpointer* _tmp5_;
			gint _tmp5__length1;
			_tmp4_ = gee_array_list_wrap_char (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, (gchar*) data, (gint) data_length1, &_tmp3_);
			_tmp5_ = _tmp4_;
			_tmp5__length1 = _tmp3_;
			if (result_length1) {
				*result_length1 = _tmp5__length1;
			}
			result = _tmp5_;
			data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_destroy_func), NULL);
			return result;
		} else {
			if (t == G_TYPE_UCHAR) {
				gint _tmp6_ = 0;
				gpointer* _tmp7_;
				gpointer* _tmp8_;
				gint _tmp8__length1;
				_tmp7_ = gee_array_list_wrap_uchar (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, (guchar*) data, (gint) data_length1, &_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp8__length1 = _tmp6_;
				if (result_length1) {
					*result_length1 = _tmp8__length1;
				}
				result = _tmp8_;
				data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_destroy_func), NULL);
				return result;
			} else {
				if (t == G_TYPE_INT) {
					gint _tmp9_ = 0;
					gpointer* _tmp10_;
					gpointer* _tmp11_;
					gint _tmp11__length1;
					_tmp10_ = gee_array_list_wrap_int (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, (gint*) data, (gint) data_length1, &_tmp9_);
					_tmp11_ = _tmp10_;
					_tmp11__length1 = _tmp9_;
					if (result_length1) {
						*result_length1 = _tmp11__length1;
					}
					result = _tmp11_;
					data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_destroy_func), NULL);
					return result;
				} else {
					if (t == G_TYPE_UINT) {
						gint _tmp12_ = 0;
						gpointer* _tmp13_;
						gpointer* _tmp14_;
						gint _tmp14__length1;
						_tmp13_ = gee_array_list_wrap_uint (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, (guint*) data, (gint) data_length1, &_tmp12_);
						_tmp14_ = _tmp13_;
						_tmp14__length1 = _tmp12_;
						if (result_length1) {
							*result_length1 = _tmp14__length1;
						}
						result = _tmp14_;
						data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_destroy_func), NULL);
						return result;
					} else {
						if (t == G_TYPE_INT64) {
							gint _tmp15_ = 0;
							gpointer* _tmp16_;
							gpointer* _tmp17_;
							gint _tmp17__length1;
							_tmp16_ = gee_array_list_wrap_int64 (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, (gint64*) data, (gint) data_length1, &_tmp15_);
							_tmp17_ = _tmp16_;
							_tmp17__length1 = _tmp15_;
							if (result_length1) {
								*result_length1 = _tmp17__length1;
							}
							result = _tmp17_;
							data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_destroy_func), NULL);
							return result;
						} else {
							if (t == G_TYPE_UINT64) {
								gint _tmp18_ = 0;
								gpointer* _tmp19_;
								gpointer* _tmp20_;
								gint _tmp20__length1;
								_tmp19_ = gee_array_list_wrap_uint64 (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, (guint64*) data, (gint) data_length1, &_tmp18_);
								_tmp20_ = _tmp19_;
								_tmp20__length1 = _tmp18_;
								if (result_length1) {
									*result_length1 = _tmp20__length1;
								}
								result = _tmp20_;
								data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_destroy_func), NULL);
								return result;
							} else {
								if (t == G_TYPE_LONG) {
									gint _tmp21_ = 0;
									gpointer* _tmp22_;
									gpointer* _tmp23_;
									gint _tmp23__length1;
									_tmp22_ = gee_array_list_wrap_long (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, (glong*) data, (gint) data_length1, &_tmp21_);
									_tmp23_ = _tmp22_;
									_tmp23__length1 = _tmp21_;
									if (result_length1) {
										*result_length1 = _tmp23__length1;
									}
									result = _tmp23_;
									data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_destroy_func), NULL);
									return result;
								} else {
									if (t == G_TYPE_ULONG) {
										gint _tmp24_ = 0;
										gpointer* _tmp25_;
										gpointer* _tmp26_;
										gint _tmp26__length1;
										_tmp25_ = gee_array_list_wrap_ulong (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, (gulong*) data, (gint) data_length1, &_tmp24_);
										_tmp26_ = _tmp25_;
										_tmp26__length1 = _tmp24_;
										if (result_length1) {
											*result_length1 = _tmp26__length1;
										}
										result = _tmp26_;
										data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_destroy_func), NULL);
										return result;
									} else {
										if (t == G_TYPE_FLOAT) {
											gint _tmp27_ = 0;
											gpointer* _tmp28_;
											gpointer* _tmp29_;
											gint _tmp29__length1;
											_tmp28_ = gee_array_list_wrap_float (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, (gfloat**) data, (gint) data_length1, &_tmp27_);
											_tmp29_ = _tmp28_;
											_tmp29__length1 = _tmp27_;
											if (result_length1) {
												*result_length1 = _tmp29__length1;
											}
											result = _tmp29_;
											data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_destroy_func), NULL);
											return result;
										} else {
											if (t == G_TYPE_DOUBLE) {
												gint _tmp30_ = 0;
												gpointer* _tmp31_;
												gpointer* _tmp32_;
												gint _tmp32__length1;
												_tmp31_ = gee_array_list_wrap_double (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, (gdouble**) data, (gint) data_length1, &_tmp30_);
												_tmp32_ = _tmp31_;
												_tmp32__length1 = _tmp30_;
												if (result_length1) {
													*result_length1 = _tmp32__length1;
												}
												result = _tmp32_;
												data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_destroy_func), NULL);
												return result;
											} else {
												gboolean _tmp33_ = FALSE;
												if (G_TYPE_IS_ENUM (t)) {
													_tmp33_ = TRUE;
												} else {
													_tmp33_ = G_TYPE_IS_FLAGS (t);
												}
												if (_tmp33_) {
													gint _tmp34_ = 0;
													gpointer* _tmp35_;
													gpointer* _tmp36_;
													gint _tmp36__length1;
													_tmp35_ = gee_array_list_wrap_int (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, (gint*) data, (gint) data_length1, &_tmp34_);
													_tmp36_ = _tmp35_;
													_tmp36__length1 = _tmp34_;
													if (result_length1) {
														*result_length1 = _tmp36__length1;
													}
													result = _tmp36_;
													data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_destroy_func), NULL);
													return result;
												} else {
													gpointer* _tmp37_;
													gint _tmp37__length1;
													gpointer* _tmp38_;
													gint _tmp38__length1;
													_tmp37_ = data;
													_tmp37__length1 = data_length1;
													data = NULL;
													data_length1 = 0;
													_tmp38_ = _tmp37_;
													_tmp38__length1 = _tmp37__length1;
													if (result_length1) {
														*result_length1 = _tmp38__length1;
													}
													result = _tmp38_;
													data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_destroy_func), NULL);
													return result;
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}

static gpointer*
gee_array_list_wrap_bool (GType g_type,
                          GBoxedCopyFunc g_dup_func,
                          GDestroyNotify g_destroy_func,
                          gboolean* data,
                          gint data_length1,
                          gint* result_length1)
{
	gpointer* arr = NULL;
	gpointer* _tmp0_;
	gint arr_length1;
	gint _arr_size_;
	gpointer* _tmp6_;
	gint _tmp6__length1;
	gpointer* result = NULL;
	_tmp0_ = g_new0 (gpointer, data_length1);
	arr = _tmp0_;
	arr_length1 = data_length1;
	_arr_size_ = arr_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gpointer* _tmp3_;
				gint _tmp3__length1;
				gboolean _tmp4_;
				gpointer _tmp5_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < ((guint) data_length1))) {
					break;
				}
				_tmp3_ = arr;
				_tmp3__length1 = arr_length1;
				_tmp4_ = data[i];
				_tmp5_ = ((_tmp4_ != NULL) && (g_dup_func != NULL)) ? g_dup_func ((gpointer) _tmp4_) : ((gpointer) _tmp4_);
				((_tmp3_[i] == NULL) || (g_destroy_func == NULL)) ? NULL : (_tmp3_[i] = (g_destroy_func (_tmp3_[i]), NULL));
				_tmp3_[i] = _tmp5_;
			}
		}
	}
	_tmp6_ = arr;
	_tmp6__length1 = arr_length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

static gpointer*
gee_array_list_wrap_char (GType g_type,
                          GBoxedCopyFunc g_dup_func,
                          GDestroyNotify g_destroy_func,
                          gchar* data,
                          gint data_length1,
                          gint* result_length1)
{
	gpointer* arr = NULL;
	gpointer* _tmp0_;
	gint arr_length1;
	gint _arr_size_;
	gpointer* _tmp6_;
	gint _tmp6__length1;
	gpointer* result = NULL;
	_tmp0_ = g_new0 (gpointer, data_length1);
	arr = _tmp0_;
	arr_length1 = data_length1;
	_arr_size_ = arr_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gpointer* _tmp3_;
				gint _tmp3__length1;
				gchar _tmp4_;
				gpointer _tmp5_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < ((guint) data_length1))) {
					break;
				}
				_tmp3_ = arr;
				_tmp3__length1 = arr_length1;
				_tmp4_ = data[i];
				_tmp5_ = ((_tmp4_ != NULL) && (g_dup_func != NULL)) ? g_dup_func ((gpointer) _tmp4_) : ((gpointer) _tmp4_);
				((_tmp3_[i] == NULL) || (g_destroy_func == NULL)) ? NULL : (_tmp3_[i] = (g_destroy_func (_tmp3_[i]), NULL));
				_tmp3_[i] = _tmp5_;
			}
		}
	}
	_tmp6_ = arr;
	_tmp6__length1 = arr_length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

static gpointer*
gee_array_list_wrap_uchar (GType g_type,
                           GBoxedCopyFunc g_dup_func,
                           GDestroyNotify g_destroy_func,
                           guchar* data,
                           gint data_length1,
                           gint* result_length1)
{
	gpointer* arr = NULL;
	gpointer* _tmp0_;
	gint arr_length1;
	gint _arr_size_;
	gpointer* _tmp6_;
	gint _tmp6__length1;
	gpointer* result = NULL;
	_tmp0_ = g_new0 (gpointer, data_length1);
	arr = _tmp0_;
	arr_length1 = data_length1;
	_arr_size_ = arr_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gpointer* _tmp3_;
				gint _tmp3__length1;
				guchar _tmp4_;
				gpointer _tmp5_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < ((guint) data_length1))) {
					break;
				}
				_tmp3_ = arr;
				_tmp3__length1 = arr_length1;
				_tmp4_ = data[i];
				_tmp5_ = ((_tmp4_ != NULL) && (g_dup_func != NULL)) ? g_dup_func ((gpointer) _tmp4_) : ((gpointer) _tmp4_);
				((_tmp3_[i] == NULL) || (g_destroy_func == NULL)) ? NULL : (_tmp3_[i] = (g_destroy_func (_tmp3_[i]), NULL));
				_tmp3_[i] = _tmp5_;
			}
		}
	}
	_tmp6_ = arr;
	_tmp6__length1 = arr_length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

static gpointer*
gee_array_list_wrap_int (GType g_type,
                         GBoxedCopyFunc g_dup_func,
                         GDestroyNotify g_destroy_func,
                         gint* data,
                         gint data_length1,
                         gint* result_length1)
{
	gpointer* arr = NULL;
	gpointer* _tmp0_;
	gint arr_length1;
	gint _arr_size_;
	gpointer* _tmp6_;
	gint _tmp6__length1;
	gpointer* result = NULL;
	_tmp0_ = g_new0 (gpointer, data_length1);
	arr = _tmp0_;
	arr_length1 = data_length1;
	_arr_size_ = arr_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gpointer* _tmp3_;
				gint _tmp3__length1;
				gint _tmp4_;
				gpointer _tmp5_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < ((guint) data_length1))) {
					break;
				}
				_tmp3_ = arr;
				_tmp3__length1 = arr_length1;
				_tmp4_ = data[i];
				_tmp5_ = ((_tmp4_ != NULL) && (g_dup_func != NULL)) ? g_dup_func ((gpointer) _tmp4_) : ((gpointer) _tmp4_);
				((_tmp3_[i] == NULL) || (g_destroy_func == NULL)) ? NULL : (_tmp3_[i] = (g_destroy_func (_tmp3_[i]), NULL));
				_tmp3_[i] = _tmp5_;
			}
		}
	}
	_tmp6_ = arr;
	_tmp6__length1 = arr_length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

static gpointer*
gee_array_list_wrap_uint (GType g_type,
                          GBoxedCopyFunc g_dup_func,
                          GDestroyNotify g_destroy_func,
                          guint* data,
                          gint data_length1,
                          gint* result_length1)
{
	gpointer* arr = NULL;
	gpointer* _tmp0_;
	gint arr_length1;
	gint _arr_size_;
	gpointer* _tmp6_;
	gint _tmp6__length1;
	gpointer* result = NULL;
	_tmp0_ = g_new0 (gpointer, data_length1);
	arr = _tmp0_;
	arr_length1 = data_length1;
	_arr_size_ = arr_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gpointer* _tmp3_;
				gint _tmp3__length1;
				guint _tmp4_;
				gpointer _tmp5_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < ((guint) data_length1))) {
					break;
				}
				_tmp3_ = arr;
				_tmp3__length1 = arr_length1;
				_tmp4_ = data[i];
				_tmp5_ = ((_tmp4_ != NULL) && (g_dup_func != NULL)) ? g_dup_func ((gpointer) _tmp4_) : ((gpointer) _tmp4_);
				((_tmp3_[i] == NULL) || (g_destroy_func == NULL)) ? NULL : (_tmp3_[i] = (g_destroy_func (_tmp3_[i]), NULL));
				_tmp3_[i] = _tmp5_;
			}
		}
	}
	_tmp6_ = arr;
	_tmp6__length1 = arr_length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

static gpointer*
gee_array_list_wrap_int64 (GType g_type,
                           GBoxedCopyFunc g_dup_func,
                           GDestroyNotify g_destroy_func,
                           gint64* data,
                           gint data_length1,
                           gint* result_length1)
{
	gpointer* arr = NULL;
	gpointer* _tmp0_;
	gint arr_length1;
	gint _arr_size_;
	gpointer* _tmp6_;
	gint _tmp6__length1;
	gpointer* result = NULL;
	_tmp0_ = g_new0 (gpointer, data_length1);
	arr = _tmp0_;
	arr_length1 = data_length1;
	_arr_size_ = arr_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gpointer* _tmp3_;
				gint _tmp3__length1;
				gint64 _tmp4_;
				gpointer _tmp5_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < ((guint) data_length1))) {
					break;
				}
				_tmp3_ = arr;
				_tmp3__length1 = arr_length1;
				_tmp4_ = data[i];
				_tmp5_ = ((_tmp4_ != NULL) && (g_dup_func != NULL)) ? g_dup_func ((gpointer) _tmp4_) : ((gpointer) _tmp4_);
				((_tmp3_[i] == NULL) || (g_destroy_func == NULL)) ? NULL : (_tmp3_[i] = (g_destroy_func (_tmp3_[i]), NULL));
				_tmp3_[i] = _tmp5_;
			}
		}
	}
	_tmp6_ = arr;
	_tmp6__length1 = arr_length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

static gpointer*
gee_array_list_wrap_uint64 (GType g_type,
                            GBoxedCopyFunc g_dup_func,
                            GDestroyNotify g_destroy_func,
                            guint64* data,
                            gint data_length1,
                            gint* result_length1)
{
	gpointer* arr = NULL;
	gpointer* _tmp0_;
	gint arr_length1;
	gint _arr_size_;
	gpointer* _tmp6_;
	gint _tmp6__length1;
	gpointer* result = NULL;
	_tmp0_ = g_new0 (gpointer, data_length1);
	arr = _tmp0_;
	arr_length1 = data_length1;
	_arr_size_ = arr_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gpointer* _tmp3_;
				gint _tmp3__length1;
				guint64 _tmp4_;
				gpointer _tmp5_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < ((guint) data_length1))) {
					break;
				}
				_tmp3_ = arr;
				_tmp3__length1 = arr_length1;
				_tmp4_ = data[i];
				_tmp5_ = ((_tmp4_ != NULL) && (g_dup_func != NULL)) ? g_dup_func ((gpointer) _tmp4_) : ((gpointer) _tmp4_);
				((_tmp3_[i] == NULL) || (g_destroy_func == NULL)) ? NULL : (_tmp3_[i] = (g_destroy_func (_tmp3_[i]), NULL));
				_tmp3_[i] = _tmp5_;
			}
		}
	}
	_tmp6_ = arr;
	_tmp6__length1 = arr_length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

static gpointer*
gee_array_list_wrap_long (GType g_type,
                          GBoxedCopyFunc g_dup_func,
                          GDestroyNotify g_destroy_func,
                          glong* data,
                          gint data_length1,
                          gint* result_length1)
{
	gpointer* arr = NULL;
	gpointer* _tmp0_;
	gint arr_length1;
	gint _arr_size_;
	gpointer* _tmp6_;
	gint _tmp6__length1;
	gpointer* result = NULL;
	_tmp0_ = g_new0 (gpointer, data_length1);
	arr = _tmp0_;
	arr_length1 = data_length1;
	_arr_size_ = arr_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gpointer* _tmp3_;
				gint _tmp3__length1;
				glong _tmp4_;
				gpointer _tmp5_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < ((guint) data_length1))) {
					break;
				}
				_tmp3_ = arr;
				_tmp3__length1 = arr_length1;
				_tmp4_ = data[i];
				_tmp5_ = ((_tmp4_ != NULL) && (g_dup_func != NULL)) ? g_dup_func ((gpointer) _tmp4_) : ((gpointer) _tmp4_);
				((_tmp3_[i] == NULL) || (g_destroy_func == NULL)) ? NULL : (_tmp3_[i] = (g_destroy_func (_tmp3_[i]), NULL));
				_tmp3_[i] = _tmp5_;
			}
		}
	}
	_tmp6_ = arr;
	_tmp6__length1 = arr_length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

static gpointer*
gee_array_list_wrap_ulong (GType g_type,
                           GBoxedCopyFunc g_dup_func,
                           GDestroyNotify g_destroy_func,
                           gulong* data,
                           gint data_length1,
                           gint* result_length1)
{
	gpointer* arr = NULL;
	gpointer* _tmp0_;
	gint arr_length1;
	gint _arr_size_;
	gpointer* _tmp6_;
	gint _tmp6__length1;
	gpointer* result = NULL;
	_tmp0_ = g_new0 (gpointer, data_length1);
	arr = _tmp0_;
	arr_length1 = data_length1;
	_arr_size_ = arr_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gpointer* _tmp3_;
				gint _tmp3__length1;
				gulong _tmp4_;
				gpointer _tmp5_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < ((guint) data_length1))) {
					break;
				}
				_tmp3_ = arr;
				_tmp3__length1 = arr_length1;
				_tmp4_ = data[i];
				_tmp5_ = ((_tmp4_ != NULL) && (g_dup_func != NULL)) ? g_dup_func ((gpointer) _tmp4_) : ((gpointer) _tmp4_);
				((_tmp3_[i] == NULL) || (g_destroy_func == NULL)) ? NULL : (_tmp3_[i] = (g_destroy_func (_tmp3_[i]), NULL));
				_tmp3_[i] = _tmp5_;
			}
		}
	}
	_tmp6_ = arr;
	_tmp6__length1 = arr_length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

static gpointer*
gee_array_list_wrap_float (GType g_type,
                           GBoxedCopyFunc g_dup_func,
                           GDestroyNotify g_destroy_func,
                           gfloat** data,
                           gint data_length1,
                           gint* result_length1)
{
	gpointer* arr = NULL;
	gpointer* _tmp0_;
	gint arr_length1;
	gint _arr_size_;
	gpointer* _tmp6_;
	gint _tmp6__length1;
	gpointer* result = NULL;
	_tmp0_ = g_new0 (gpointer, data_length1);
	arr = _tmp0_;
	arr_length1 = data_length1;
	_arr_size_ = arr_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gpointer* _tmp3_;
				gint _tmp3__length1;
				gfloat* _tmp4_;
				gpointer _tmp5_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < ((guint) data_length1))) {
					break;
				}
				_tmp3_ = arr;
				_tmp3__length1 = arr_length1;
				_tmp4_ = data[i];
				_tmp5_ = ((_tmp4_ != NULL) && (g_dup_func != NULL)) ? g_dup_func ((gpointer) _tmp4_) : ((gpointer) _tmp4_);
				((_tmp3_[i] == NULL) || (g_destroy_func == NULL)) ? NULL : (_tmp3_[i] = (g_destroy_func (_tmp3_[i]), NULL));
				_tmp3_[i] = _tmp5_;
			}
		}
	}
	_tmp6_ = arr;
	_tmp6__length1 = arr_length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

static gpointer*
gee_array_list_wrap_double (GType g_type,
                            GBoxedCopyFunc g_dup_func,
                            GDestroyNotify g_destroy_func,
                            gdouble** data,
                            gint data_length1,
                            gint* result_length1)
{
	gpointer* arr = NULL;
	gpointer* _tmp0_;
	gint arr_length1;
	gint _arr_size_;
	gpointer* _tmp6_;
	gint _tmp6__length1;
	gpointer* result = NULL;
	_tmp0_ = g_new0 (gpointer, data_length1);
	arr = _tmp0_;
	arr_length1 = data_length1;
	_arr_size_ = arr_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gpointer* _tmp3_;
				gint _tmp3__length1;
				gdouble* _tmp4_;
				gpointer _tmp5_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < ((guint) data_length1))) {
					break;
				}
				_tmp3_ = arr;
				_tmp3__length1 = arr_length1;
				_tmp4_ = data[i];
				_tmp5_ = ((_tmp4_ != NULL) && (g_dup_func != NULL)) ? g_dup_func ((gpointer) _tmp4_) : ((gpointer) _tmp4_);
				((_tmp3_[i] == NULL) || (g_destroy_func == NULL)) ? NULL : (_tmp3_[i] = (g_destroy_func (_tmp3_[i]), NULL));
				_tmp3_[i] = _tmp5_;
			}
		}
	}
	_tmp6_ = arr;
	_tmp6__length1 = arr_length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

static gint
gee_array_list_real_get_size (GeeAbstractCollection* base)
{
	gint result;
	GeeArrayList* self;
	self = (GeeArrayList*) base;
	result = self->_size;
	return result;
}

static gboolean
gee_array_list_real_get_read_only (GeeAbstractCollection* base)
{
	gboolean result;
	GeeArrayList* self;
	self = (GeeArrayList*) base;
	result = FALSE;
	return result;
}

GeeEqualDataFunc
gee_array_list_get_equal_func (GeeArrayList* self,
                               gpointer* result_target)
{
	GeeEqualDataFunc result;
	GeeFunctionsEqualDataFuncClosure* _tmp0_;
	GeeEqualDataFunc _tmp1_;
	gpointer _tmp1__target;
	GeeEqualDataFunc _tmp2_;
	gpointer _tmp2__target;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_equal_func;
	_tmp1_ = _tmp0_->func;
	_tmp1__target = _tmp0_->func_target;
	_tmp2_ = _tmp1_;
	_tmp2__target = _tmp1__target;
	*result_target = _tmp2__target;
	result = _tmp2_;
	return result;
}

static void
gee_array_list_set_equal_func (GeeArrayList* self,
                               GeeEqualDataFunc value,
                               gpointer value_target)
{
	g_return_if_fail (self != NULL);
}

static inline gpointer
gee_array_list_iterator_get_instance_private (GeeArrayListIterator* self)
{
	return G_STRUCT_MEMBER_P (self, GeeArrayListIterator_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GeeArrayListIterator*
gee_array_list_iterator_construct (GType object_type,
                                   GType g_type,
                                   GBoxedCopyFunc g_dup_func,
                                   GDestroyNotify g_destroy_func,
                                   GeeArrayList* list)
{
	GeeArrayListIterator * self = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	g_return_val_if_fail (list != NULL, NULL);
	self = (GeeArrayListIterator*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = _g_object_ref0 (list);
	_g_object_unref0 (self->_list);
	self->_list = _tmp0_;
	_tmp1_ = self->_list;
	self->_stamp = _tmp1_->priv->_stamp;
	return self;
}

static GeeArrayListIterator*
gee_array_list_iterator_new (GType g_type,
                             GBoxedCopyFunc g_dup_func,
                             GDestroyNotify g_destroy_func,
                             GeeArrayList* list)
{
	return gee_array_list_iterator_construct (GEE_ARRAY_LIST_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, list);
}

static GeeArrayListIterator*
gee_array_list_iterator_construct_from_iterator (GType object_type,
                                                 GType g_type,
                                                 GBoxedCopyFunc g_dup_func,
                                                 GDestroyNotify g_destroy_func,
                                                 GeeArrayListIterator* iter)
{
	GeeArrayListIterator * self = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	g_return_val_if_fail (iter != NULL, NULL);
	self = (GeeArrayListIterator*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = iter->_list;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->_list);
	self->_list = _tmp1_;
	self->_index = iter->_index;
	self->_removed = iter->_removed;
	self->_stamp = iter->_stamp;
	return self;
}

static GeeArrayListIterator*
gee_array_list_iterator_new_from_iterator (GType g_type,
                                           GBoxedCopyFunc g_dup_func,
                                           GDestroyNotify g_destroy_func,
                                           GeeArrayListIterator* iter)
{
	return gee_array_list_iterator_construct_from_iterator (GEE_ARRAY_LIST_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, iter);
}

static gboolean
gee_array_list_iterator_real_next (GeeIterator* base)
{
	GeeArrayListIterator * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gboolean result = FALSE;
	self = (GeeArrayListIterator*) base;
	_tmp0_ = self->_list;
	_vala_assert (self->_stamp == _tmp0_->priv->_stamp, "_stamp == _list._stamp");
	_tmp1_ = self->_list;
	if ((self->_index + 1) < _tmp1_->_size) {
		gint _tmp2_;
		_tmp2_ = self->_index;
		self->_index = _tmp2_ + 1;
		self->_removed = FALSE;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
gee_array_list_iterator_real_has_next (GeeIterator* base)
{
	GeeArrayListIterator * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gboolean result = FALSE;
	self = (GeeArrayListIterator*) base;
	_tmp0_ = self->_list;
	_vala_assert (self->_stamp == _tmp0_->priv->_stamp, "_stamp == _list._stamp");
	_tmp1_ = self->_list;
	result = (self->_index + 1) < _tmp1_->_size;
	return result;
}

static gboolean
gee_array_list_iterator_real_first (GeeBidirIterator* base)
{
	GeeArrayListIterator * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean result = FALSE;
	self = (GeeArrayListIterator*) base;
	_tmp0_ = self->_list;
	_vala_assert (self->_stamp == _tmp0_->priv->_stamp, "_stamp == _list._stamp");
	_tmp1_ = self->_list;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		result = FALSE;
		return result;
	}
	self->_index = 0;
	self->_removed = FALSE;
	result = TRUE;
	return result;
}

static gpointer
gee_array_list_iterator_real_get (GeeIterator* base)
{
	GeeArrayListIterator * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	gpointer* _tmp3_;
	gint _tmp3__length1;
	gconstpointer _tmp4_;
	gpointer _tmp5_;
	gpointer result = NULL;
	self = (GeeArrayListIterator*) base;
	_tmp0_ = self->_list;
	_vala_assert (self->_stamp == _tmp0_->priv->_stamp, "_stamp == _list._stamp");
	_vala_assert (!self->_removed, "! _removed");
	_vala_assert (self->_index >= 0, "_index >= 0");
	_tmp1_ = self->_list;
	_vala_assert (self->_index < _tmp1_->_size, "_index < _list._size");
	_tmp2_ = self->_list;
	_tmp3_ = _tmp2_->_items;
	_tmp3__length1 = _tmp2_->_items_length1;
	_tmp4_ = _tmp3_[self->_index];
	_tmp5_ = ((_tmp4_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp4_) : ((gpointer) _tmp4_);
	result = _tmp5_;
	return result;
}

static void
gee_array_list_iterator_real_remove (GeeIterator* base)
{
	GeeArrayListIterator * self;
	GeeArrayList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	gpointer _tmp4_;
	gpointer _tmp5_;
	gint _tmp6_;
	GeeArrayList* _tmp7_;
	self = (GeeArrayListIterator*) base;
	_tmp0_ = self->_list;
	_vala_assert (self->_stamp == _tmp0_->priv->_stamp, "_stamp == _list._stamp");
	if (!self->_removed) {
		_tmp1_ = self->_index >= 0;
	} else {
		_tmp1_ = FALSE;
	}
	_vala_assert (_tmp1_, "! _removed && _index >= 0");
	_tmp2_ = self->_list;
	_vala_assert (self->_index < _tmp2_->_size, "_index < _list._size");
	_tmp3_ = self->_list;
	_tmp4_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp3_, self->_index);
	_tmp5_ = _tmp4_;
	((_tmp5_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp5_ = (self->priv->g_destroy_func (_tmp5_), NULL));
	_tmp6_ = self->_index;
	self->_index = _tmp6_ - 1;
	self->_removed = TRUE;
	_tmp7_ = self->_list;
	self->_stamp = _tmp7_->priv->_stamp;
}

static gboolean
gee_array_list_iterator_real_previous (GeeBidirIterator* base)
{
	GeeArrayListIterator * self;
	GeeArrayList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean result = FALSE;
	self = (GeeArrayListIterator*) base;
	_tmp0_ = self->_list;
	_vala_assert (self->_stamp == _tmp0_->priv->_stamp, "_stamp == _list._stamp");
	if (self->_removed) {
		_tmp1_ = self->_index >= 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		self->_removed = FALSE;
		result = TRUE;
		return result;
	}
	if (self->_index > 0) {
		gint _tmp2_;
		_tmp2_ = self->_index;
		self->_index = _tmp2_ - 1;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
gee_array_list_iterator_real_has_previous (GeeBidirIterator* base)
{
	GeeArrayListIterator * self;
	GeeArrayList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean result = FALSE;
	self = (GeeArrayListIterator*) base;
	_tmp0_ = self->_list;
	_vala_assert (self->_stamp == _tmp0_->priv->_stamp, "_stamp == _list._stamp");
	if (self->_index > 0) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if (self->_removed) {
			_tmp2_ = self->_index >= 0;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp1_ = _tmp2_;
	}
	result = _tmp1_;
	return result;
}

static gboolean
gee_array_list_iterator_real_last (GeeBidirIterator* base)
{
	GeeArrayListIterator * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp4_;
	gboolean result = FALSE;
	self = (GeeArrayListIterator*) base;
	_tmp0_ = self->_list;
	_vala_assert (self->_stamp == _tmp0_->priv->_stamp, "_stamp == _list._stamp");
	_tmp1_ = self->_list;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		result = FALSE;
		return result;
	}
	_tmp4_ = self->_list;
	self->_index = _tmp4_->_size - 1;
	result = TRUE;
	return result;
}

static void
gee_array_list_iterator_real_set (GeeListIterator* base,
                                  gconstpointer item)
{
	GeeArrayListIterator * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	gpointer* _tmp3_;
	gint _tmp3__length1;
	gpointer _tmp4_;
	GeeArrayList* _tmp5_;
	gint _tmp6_;
	self = (GeeArrayListIterator*) base;
	_tmp0_ = self->_list;
	_vala_assert (self->_stamp == _tmp0_->priv->_stamp, "_stamp == _list._stamp");
	_vala_assert (!self->_removed, "! _removed");
	_vala_assert (self->_index >= 0, "_index >= 0");
	_tmp1_ = self->_list;
	_vala_assert (self->_index < _tmp1_->_size, "_index < _list._size");
	_tmp2_ = self->_list;
	_tmp3_ = _tmp2_->_items;
	_tmp3__length1 = _tmp2_->_items_length1;
	_tmp4_ = ((item != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) item) : ((gpointer) item);
	((_tmp3_[self->_index] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp3_[self->_index] = (self->priv->g_destroy_func (_tmp3_[self->_index]), NULL));
	_tmp3_[self->_index] = _tmp4_;
	_tmp5_ = self->_list;
	_tmp5_->priv->_stamp = _tmp5_->priv->_stamp + 1;
	_tmp6_ = _tmp5_->priv->_stamp;
	self->_stamp = _tmp6_;
}

static void
gee_array_list_iterator_real_insert (GeeBidirListIterator* base,
                                     gconstpointer item)
{
	GeeArrayListIterator * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp5_;
	GeeArrayList* _tmp6_;
	self = (GeeArrayListIterator*) base;
	_tmp0_ = self->_list;
	_vala_assert (self->_stamp == _tmp0_->priv->_stamp, "_stamp == _list._stamp");
	_tmp1_ = self->_list;
	_vala_assert (self->_index < _tmp1_->_size, "_index < _list._size");
	if (self->_index == -1) {
		GeeArrayList* _tmp2_;
		_tmp2_ = self->_list;
		gee_abstract_list_insert ((GeeAbstractList*) _tmp2_, 0, item);
		self->_removed = TRUE;
	}
	if (self->_removed) {
		GeeArrayList* _tmp3_;
		_tmp3_ = self->_list;
		gee_abstract_list_insert ((GeeAbstractList*) _tmp3_, self->_index + 1, item);
	} else {
		GeeArrayList* _tmp4_;
		_tmp4_ = self->_list;
		gee_abstract_list_insert ((GeeAbstractList*) _tmp4_, self->_index, item);
	}
	_tmp5_ = self->_index;
	self->_index = _tmp5_ + 1;
	_tmp6_ = self->_list;
	self->_stamp = _tmp6_->priv->_stamp;
}

static void
gee_array_list_iterator_real_add (GeeListIterator* base,
                                  gconstpointer item)
{
	GeeArrayListIterator * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp4_;
	self = (GeeArrayListIterator*) base;
	_tmp0_ = self->_list;
	_vala_assert (self->_stamp == _tmp0_->priv->_stamp, "_stamp == _list._stamp");
	_tmp1_ = self->_list;
	_vala_assert (self->_index < _tmp1_->_size, "_index < _list._size");
	_tmp2_ = self->_list;
	gee_abstract_list_insert ((GeeAbstractList*) _tmp2_, self->_index + 1, item);
	_tmp3_ = self->_index;
	self->_index = _tmp3_ + 1;
	self->_removed = FALSE;
	_tmp4_ = self->_list;
	self->_stamp = _tmp4_->priv->_stamp;
}

static gint
gee_array_list_iterator_real_index (GeeListIterator* base)
{
	GeeArrayListIterator * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint result = 0;
	self = (GeeArrayListIterator*) base;
	_tmp0_ = self->_list;
	_vala_assert (self->_stamp == _tmp0_->priv->_stamp, "_stamp == _list._stamp");
	_vala_assert (self->_index >= 0, "_index >= 0");
	_tmp1_ = self->_list;
	_vala_assert (self->_index < _tmp1_->_size, "_index < _list._size");
	result = self->_index;
	return result;
}

static gboolean
gee_array_list_iterator_real_foreach (GeeTraversable* base,
                                      GeeForallFunc f,
                                      gpointer f_target)
{
	GeeArrayListIterator * self;
	GeeArrayList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeArrayList* _tmp9_;
	gboolean result = FALSE;
	self = (GeeArrayListIterator*) base;
	_tmp0_ = self->_list;
	_vala_assert (self->_stamp == _tmp0_->priv->_stamp, "_stamp == _list._stamp");
	if (self->_index < 0) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->_removed;
	}
	if (_tmp1_) {
		gint _tmp2_;
		_tmp2_ = self->_index;
		self->_index = _tmp2_ + 1;
	}
	while (TRUE) {
		GeeArrayList* _tmp3_;
		GeeArrayList* _tmp4_;
		gpointer* _tmp5_;
		gint _tmp5__length1;
		gconstpointer _tmp6_;
		gpointer _tmp7_;
		gint _tmp8_;
		_tmp3_ = self->_list;
		if (!(self->_index < _tmp3_->_size)) {
			break;
		}
		_tmp4_ = self->_list;
		_tmp5_ = _tmp4_->_items;
		_tmp5__length1 = _tmp4_->_items_length1;
		_tmp6_ = _tmp5_[self->_index];
		_tmp7_ = ((_tmp6_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp6_) : ((gpointer) _tmp6_);
		if (!f (_tmp7_, f_target)) {
			result = FALSE;
			return result;
		}
		_tmp8_ = self->_index;
		self->_index = _tmp8_ + 1;
	}
	_tmp9_ = self->_list;
	self->_index = _tmp9_->_size - 1;
	result = TRUE;
	return result;
}

static GeeIterator**
gee_array_list_iterator_real_tee (GeeTraversable* base,
                                  guint forks,
                                  gint* result_length1)
{
	GeeArrayListIterator * self;
	GeeIterator** result = NULL;
	self = (GeeArrayListIterator*) base;
	if (forks == ((guint) 0)) {
		GeeIterator** _tmp0_;
		GeeIterator** _tmp1_;
		gint _tmp1__length1;
		_tmp0_ = g_new0 (GeeIterator*, 0 + 1);
		_tmp1_ = _tmp0_;
		_tmp1__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp1__length1;
		}
		result = _tmp1_;
		return result;
	} else {
		GeeIterator** _result_ = NULL;
		GeeIterator** _tmp2_;
		gint _result__length1;
		gint __result__size_;
		GeeIterator** _tmp3_;
		gint _tmp3__length1;
		GeeIterator* _tmp4_;
		GeeIterator** _tmp9_;
		gint _tmp9__length1;
		_tmp2_ = g_new0 (GeeIterator*, forks + 1);
		_result_ = _tmp2_;
		_result__length1 = forks;
		__result__size_ = _result__length1;
		_tmp3_ = _result_;
		_tmp3__length1 = _result__length1;
		_tmp4_ = _g_object_ref0 ((GeeIterator*) self);
		_g_object_unref0 (_tmp3_[0]);
		_tmp3_[0] = _tmp4_;
		{
			guint i = 0U;
			i = (guint) 1;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					GeeIterator** _tmp7_;
					gint _tmp7__length1;
					GeeArrayListIterator* _tmp8_;
					if (!_tmp5_) {
						guint _tmp6_;
						_tmp6_ = i;
						i = _tmp6_ + 1;
					}
					_tmp5_ = FALSE;
					if (!(i < forks)) {
						break;
					}
					_tmp7_ = _result_;
					_tmp7__length1 = _result__length1;
					_tmp8_ = gee_array_list_iterator_new_from_iterator (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, self);
					_g_object_unref0 (_tmp7_[i]);
					_tmp7_[i] = (GeeIterator*) _tmp8_;
				}
			}
		}
		_tmp9_ = _result_;
		_tmp9__length1 = _result__length1;
		if (result_length1) {
			*result_length1 = _tmp9__length1;
		}
		result = _tmp9_;
		return result;
	}
}

static gboolean
gee_array_list_iterator_real_get_read_only (GeeIterator* base)
{
	gboolean result;
	GeeArrayListIterator* self;
	self = (GeeArrayListIterator*) base;
	result = FALSE;
	return result;
}

static gboolean
gee_array_list_iterator_real_get_valid (GeeIterator* base)
{
	gboolean result;
	GeeArrayListIterator* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	self = (GeeArrayListIterator*) base;
	if (self->_index >= 0) {
		GeeArrayList* _tmp2_;
		_tmp2_ = self->_list;
		_tmp1_ = self->_index < _tmp2_->_size;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = !self->_removed;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
gee_array_list_iterator_class_init (GeeArrayListIteratorClass * klass,
                                    gpointer klass_data)
{
	gee_array_list_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GeeArrayListIterator_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_array_list_iterator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_array_list_iterator_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_array_list_iterator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_LIST_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_LIST_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_LIST_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_LIST_ITERATOR_READ_ONLY_PROPERTY, gee_array_list_iterator_properties[GEE_ARRAY_LIST_ITERATOR_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_LIST_ITERATOR_VALID_PROPERTY, gee_array_list_iterator_properties[GEE_ARRAY_LIST_ITERATOR_VALID_PROPERTY] = g_param_spec_boolean ("valid", "valid", "valid", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static GType
gee_array_list_iterator_gee_traversable_get_g_type (GeeArrayListIterator* self)
{
	return self->priv->g_type;
}

static GBoxedCopyFunc
gee_array_list_iterator_gee_traversable_get_g_dup_func (GeeArrayListIterator* self)
{
	return self->priv->g_dup_func;
}

static GDestroyNotify
gee_array_list_iterator_gee_traversable_get_g_destroy_func (GeeArrayListIterator* self)
{
	return self->priv->g_destroy_func;
}

static void
gee_array_list_iterator_gee_traversable_interface_init (GeeTraversableIface * iface,
                                                        gpointer iface_data)
{
	gee_array_list_iterator_gee_traversable_parent_iface = g_type_interface_peek_parent (iface);
	iface->foreach = (gboolean (*) (GeeTraversable*, GeeForallFunc, gpointer)) gee_array_list_iterator_real_foreach;
	iface->tee = (GeeIterator** (*) (GeeTraversable*, guint, gint*)) gee_array_list_iterator_real_tee;
	iface->get_g_type = (GType (*) (GeeTraversable *)) gee_array_list_iterator_gee_traversable_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeTraversable *)) gee_array_list_iterator_gee_traversable_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeTraversable *)) gee_array_list_iterator_gee_traversable_get_g_destroy_func;
}

static void
gee_array_list_iterator_gee_iterator_interface_init (GeeIteratorIface * iface,
                                                     gpointer iface_data)
{
	gee_array_list_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = (gboolean (*) (GeeIterator*)) gee_array_list_iterator_real_next;
	iface->has_next = (gboolean (*) (GeeIterator*)) gee_array_list_iterator_real_has_next;
	iface->get = (gpointer (*) (GeeIterator*)) gee_array_list_iterator_real_get;
	iface->remove = (void (*) (GeeIterator*)) gee_array_list_iterator_real_remove;
	iface->get_read_only = gee_array_list_iterator_real_get_read_only;
	iface->get_valid = gee_array_list_iterator_real_get_valid;
}

static GType
gee_array_list_iterator_gee_bidir_iterator_get_g_type (GeeArrayListIterator* self)
{
	return self->priv->g_type;
}

static GBoxedCopyFunc
gee_array_list_iterator_gee_bidir_iterator_get_g_dup_func (GeeArrayListIterator* self)
{
	return self->priv->g_dup_func;
}

static GDestroyNotify
gee_array_list_iterator_gee_bidir_iterator_get_g_destroy_func (GeeArrayListIterator* self)
{
	return self->priv->g_destroy_func;
}

static void
gee_array_list_iterator_gee_bidir_iterator_interface_init (GeeBidirIteratorIface * iface,
                                                           gpointer iface_data)
{
	gee_array_list_iterator_gee_bidir_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->first = (gboolean (*) (GeeBidirIterator*)) gee_array_list_iterator_real_first;
	iface->previous = (gboolean (*) (GeeBidirIterator*)) gee_array_list_iterator_real_previous;
	iface->has_previous = (gboolean (*) (GeeBidirIterator*)) gee_array_list_iterator_real_has_previous;
	iface->last = (gboolean (*) (GeeBidirIterator*)) gee_array_list_iterator_real_last;
	iface->get_g_type = (GType (*) (GeeBidirIterator *)) gee_array_list_iterator_gee_bidir_iterator_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeBidirIterator *)) gee_array_list_iterator_gee_bidir_iterator_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeBidirIterator *)) gee_array_list_iterator_gee_bidir_iterator_get_g_destroy_func;
}

static void
gee_array_list_iterator_gee_list_iterator_interface_init (GeeListIteratorIface * iface,
                                                          gpointer iface_data)
{
	gee_array_list_iterator_gee_list_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->set = (void (*) (GeeListIterator*, gconstpointer)) gee_array_list_iterator_real_set;
	iface->add = (void (*) (GeeListIterator*, gconstpointer)) gee_array_list_iterator_real_add;
	iface->index = (gint (*) (GeeListIterator*)) gee_array_list_iterator_real_index;
}

static GType
gee_array_list_iterator_gee_bidir_list_iterator_get_g_type (GeeArrayListIterator* self)
{
	return self->priv->g_type;
}

static GBoxedCopyFunc
gee_array_list_iterator_gee_bidir_list_iterator_get_g_dup_func (GeeArrayListIterator* self)
{
	return self->priv->g_dup_func;
}

static GDestroyNotify
gee_array_list_iterator_gee_bidir_list_iterator_get_g_destroy_func (GeeArrayListIterator* self)
{
	return self->priv->g_destroy_func;
}

static void
gee_array_list_iterator_gee_bidir_list_iterator_interface_init (GeeBidirListIteratorIface * iface,
                                                                gpointer iface_data)
{
	gee_array_list_iterator_gee_bidir_list_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->insert = (void (*) (GeeBidirListIterator*, gconstpointer)) gee_array_list_iterator_real_insert;
	iface->get_g_type = (GType (*) (GeeBidirListIterator *)) gee_array_list_iterator_gee_bidir_list_iterator_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeBidirListIterator *)) gee_array_list_iterator_gee_bidir_list_iterator_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeBidirListIterator *)) gee_array_list_iterator_gee_bidir_list_iterator_get_g_destroy_func;
}

static void
gee_array_list_iterator_instance_init (GeeArrayListIterator * self,
                                       gpointer klass)
{
	self->priv = gee_array_list_iterator_get_instance_private (self);
	self->_index = -1;
	self->_removed = FALSE;
	self->_stamp = 0;
}

static void
gee_array_list_iterator_finalize (GObject * obj)
{
	GeeArrayListIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_ARRAY_LIST_TYPE_ITERATOR, GeeArrayListIterator);
	_g_object_unref0 (self->_list);
	G_OBJECT_CLASS (gee_array_list_iterator_parent_class)->finalize (obj);
}

static GType
gee_array_list_iterator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GeeArrayListIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_array_list_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeArrayListIterator), 0, (GInstanceInitFunc) gee_array_list_iterator_instance_init, NULL };
	static const GInterfaceInfo gee_traversable_info = { (GInterfaceInitFunc) gee_array_list_iterator_gee_traversable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_array_list_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gee_bidir_iterator_info = { (GInterfaceInitFunc) gee_array_list_iterator_gee_bidir_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gee_list_iterator_info = { (GInterfaceInitFunc) gee_array_list_iterator_gee_list_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gee_bidir_list_iterator_info = { (GInterfaceInitFunc) gee_array_list_iterator_gee_bidir_list_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gee_array_list_iterator_type_id;
	gee_array_list_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeArrayListIterator", &g_define_type_info, 0);
	g_type_add_interface_static (gee_array_list_iterator_type_id, GEE_TYPE_TRAVERSABLE, &gee_traversable_info);
	g_type_add_interface_static (gee_array_list_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
	g_type_add_interface_static (gee_array_list_iterator_type_id, GEE_TYPE_BIDIR_ITERATOR, &gee_bidir_iterator_info);
	g_type_add_interface_static (gee_array_list_iterator_type_id, GEE_TYPE_LIST_ITERATOR, &gee_list_iterator_info);
	g_type_add_interface_static (gee_array_list_iterator_type_id, GEE_TYPE_BIDIR_LIST_ITERATOR, &gee_bidir_list_iterator_info);
	GeeArrayListIterator_private_offset = g_type_add_instance_private (gee_array_list_iterator_type_id, sizeof (GeeArrayListIteratorPrivate));
	return gee_array_list_iterator_type_id;
}

static GType
gee_array_list_iterator_get_type (void)
{
	static volatile gsize gee_array_list_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&gee_array_list_iterator_type_id__volatile)) {
		GType gee_array_list_iterator_type_id;
		gee_array_list_iterator_type_id = gee_array_list_iterator_get_type_once ();
		g_once_init_leave (&gee_array_list_iterator_type_id__volatile, gee_array_list_iterator_type_id);
	}
	return gee_array_list_iterator_type_id__volatile;
}

static void
_vala_gee_array_list_iterator_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	GeeArrayListIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_ARRAY_LIST_TYPE_ITERATOR, GeeArrayListIterator);
	switch (property_id) {
		case GEE_ARRAY_LIST_ITERATOR_READ_ONLY_PROPERTY:
		g_value_set_boolean (value, gee_iterator_get_read_only ((GeeIterator*) self));
		break;
		case GEE_ARRAY_LIST_ITERATOR_VALID_PROPERTY:
		g_value_set_boolean (value, gee_iterator_get_valid ((GeeIterator*) self));
		break;
		case GEE_ARRAY_LIST_ITERATOR_G_TYPE:
		g_value_set_gtype (value, self->priv->g_type);
		break;
		case GEE_ARRAY_LIST_ITERATOR_G_DUP_FUNC:
		g_value_set_pointer (value, self->priv->g_dup_func);
		break;
		case GEE_ARRAY_LIST_ITERATOR_G_DESTROY_FUNC:
		g_value_set_pointer (value, self->priv->g_destroy_func);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gee_array_list_iterator_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	GeeArrayListIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_ARRAY_LIST_TYPE_ITERATOR, GeeArrayListIterator);
	switch (property_id) {
		case GEE_ARRAY_LIST_ITERATOR_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_ARRAY_LIST_ITERATOR_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_ARRAY_LIST_ITERATOR_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
gee_array_list_class_init (GeeArrayListClass * klass,
                           gpointer klass_data)
{
	gee_array_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GeeArrayList_private_offset);
	((GeeAbstractCollectionClass *) klass)->foreach = (gboolean (*) (GeeAbstractCollection*, GeeForallFunc, gpointer)) gee_array_list_real_foreach;
	((GeeAbstractCollectionClass *) klass)->iterator = (GeeIterator* (*) (GeeAbstractCollection*)) gee_array_list_real_iterator;
	((GeeAbstractListClass *) klass)->list_iterator = (GeeListIterator* (*) (GeeAbstractList*)) gee_array_list_real_list_iterator;
	((GeeAbstractBidirListClass *) klass)->bidir_list_iterator = (GeeBidirListIterator* (*) (GeeAbstractBidirList*)) gee_array_list_real_bidir_list_iterator;
	((GeeAbstractCollectionClass *) klass)->contains = (gboolean (*) (GeeAbstractCollection*, gconstpointer)) gee_array_list_real_contains;
	((GeeAbstractListClass *) klass)->index_of = (gint (*) (GeeAbstractList*, gconstpointer)) gee_array_list_real_index_of;
	((GeeAbstractListClass *) klass)->get = (gpointer (*) (GeeAbstractList*, gint)) gee_array_list_real_get;
	((GeeAbstractListClass *) klass)->set = (void (*) (GeeAbstractList*, gint, gconstpointer)) gee_array_list_real_set;
	((GeeAbstractCollectionClass *) klass)->add = (gboolean (*) (GeeAbstractCollection*, gconstpointer)) gee_array_list_real_add;
	((GeeAbstractListClass *) klass)->insert = (void (*) (GeeAbstractList*, gint, gconstpointer)) gee_array_list_real_insert;
	((GeeAbstractCollectionClass *) klass)->remove = (gboolean (*) (GeeAbstractCollection*, gconstpointer)) gee_array_list_real_remove;
	((GeeAbstractListClass *) klass)->remove_at = (gpointer (*) (GeeAbstractList*, gint)) gee_array_list_real_remove_at;
	((GeeAbstractCollectionClass *) klass)->clear = (void (*) (GeeAbstractCollection*)) gee_array_list_real_clear;
	((GeeAbstractListClass *) klass)->slice = (GeeList* (*) (GeeAbstractList*, gint, gint)) gee_array_list_real_slice;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = gee_array_list_real_get_size;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_read_only = gee_array_list_real_get_read_only;
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_array_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_array_list_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_array_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_LIST_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_LIST_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_LIST_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_LIST_SIZE_PROPERTY, gee_array_list_properties[GEE_ARRAY_LIST_SIZE_PROPERTY] = g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_LIST_READ_ONLY_PROPERTY, gee_array_list_properties[GEE_ARRAY_LIST_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gee_array_list_instance_init (GeeArrayList * self,
                              gpointer klass)
{
	self->priv = gee_array_list_get_instance_private (self);
	self->priv->_stamp = 0;
}

static void
gee_array_list_finalize (GObject * obj)
{
	GeeArrayList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_TYPE_ARRAY_LIST, GeeArrayList);
	self->_items = (_vala_array_free (self->_items, self->_items_length1, (GDestroyNotify) self->priv->g_destroy_func), NULL);
	_gee_functions_equal_data_func_closure_unref0 (self->priv->_equal_func);
	G_OBJECT_CLASS (gee_array_list_parent_class)->finalize (obj);
}

/**
 * Resizable array implementation of the {@link List} interface.
 *
 * The storage array grows automatically when needed.
 *
 * This implementation is pretty good for rarely modified data. Because they are
 * stored in an array this structure does not fit for highly mutable data. For an
 * alternative implementation see {@link LinkedList}.
 *
 * @see LinkedList
 */
static GType
gee_array_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GeeArrayListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_array_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeArrayList), 0, (GInstanceInitFunc) gee_array_list_instance_init, NULL };
	GType gee_array_list_type_id;
	gee_array_list_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_BIDIR_LIST, "GeeArrayList", &g_define_type_info, 0);
	GeeArrayList_private_offset = g_type_add_instance_private (gee_array_list_type_id, sizeof (GeeArrayListPrivate));
	return gee_array_list_type_id;
}

GType
gee_array_list_get_type (void)
{
	static volatile gsize gee_array_list_type_id__volatile = 0;
	if (g_once_init_enter (&gee_array_list_type_id__volatile)) {
		GType gee_array_list_type_id;
		gee_array_list_type_id = gee_array_list_get_type_once ();
		g_once_init_leave (&gee_array_list_type_id__volatile, gee_array_list_type_id);
	}
	return gee_array_list_type_id__volatile;
}

static void
_vala_gee_array_list_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	GeeArrayList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_ARRAY_LIST, GeeArrayList);
	switch (property_id) {
		case GEE_ARRAY_LIST_SIZE_PROPERTY:
		g_value_set_int (value, gee_abstract_collection_get_size ((GeeAbstractCollection*) self));
		break;
		case GEE_ARRAY_LIST_READ_ONLY_PROPERTY:
		g_value_set_boolean (value, gee_abstract_collection_get_read_only ((GeeAbstractCollection*) self));
		break;
		case GEE_ARRAY_LIST_G_TYPE:
		g_value_set_gtype (value, self->priv->g_type);
		break;
		case GEE_ARRAY_LIST_G_DUP_FUNC:
		g_value_set_pointer (value, self->priv->g_dup_func);
		break;
		case GEE_ARRAY_LIST_G_DESTROY_FUNC:
		g_value_set_pointer (value, self->priv->g_destroy_func);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gee_array_list_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	GeeArrayList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_ARRAY_LIST, GeeArrayList);
	switch (property_id) {
		case GEE_ARRAY_LIST_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_ARRAY_LIST_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_ARRAY_LIST_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static void
_vala_array_move (gpointer array,
                  gsize element_size,
                  gint src,
                  gint dest,
                  gint length)
{
	memmove (((char*) array) + (dest * element_size), ((char*) array) + (src * element_size), length * element_size);
	if ((src < dest) && ((src + length) > dest)) {
		memset (((char*) array) + (src * element_size), 0, (dest - src) * element_size);
	} else if ((src > dest) && (src < (dest + length))) {
		memset (((char*) array) + ((dest + length) * element_size), 0, (src - dest) * element_size);
	} else if (src != dest) {
		memset (((char*) array) + (src * element_size), 0, length * element_size);
	}
}

