# X Color Management specification

Version 0.4

DRAFT 1

## Revision History

* Revision 0.1            2008-07-21  Tomas Carnecky
                                      initial incomplete spec for 
                                      Color Management near X
* Draft for Revision 0.2  2010-05-16  Kai-Uwe Behrmann
                                      clearify XcolorRegion, add references,
                                      history, date and headers,
                                      remove XRandR, _ICC_COLOR_MANAGEMENT and
                                      _ICC_COLOR_PROFILES from this version,
                                      add _ICC_COLOR_REGIONS and
                                      _ICC_COLOR_DESKTOP
* Draft 2  Revision 0.2   2010-08-14  Kai-Uwe Behrmann
                                      add _ICC_DEVICE_PROFILE(_xxx)

* Draft 1  Revision 0.3   2011-09-11  Kai-Uwe Behrmann
                                      rename _NET prefix to _ICC

* Draft 2  Revision 0.3   2011-10-30  Kai-Uwe Behrmann
                                      describe _ICC_COLOR_DISPLAY_ADVANCED,
                                      readd _ICC_COLOR_PROFILES
                                      add color server implementation note

* Draft 1  Revision 0.4   2012-02-17  Kai-Uwe Behrmann
                                      add _ICC_COLOR_OUTPUTS
* Draft 2  Revision 0.4   2012-11-11  Kai-Uwe Behrmann
                                      clearify about opt out
* Draft 3  Revision 0.4   2012-12-20  Kai-Uwe Behrmann
                                      specify ICM _ICC_COLOR_DESKTOP capability

## Introduction

The X Color Management specification defines a protocol, which can be used by 
X11 clients to offload color correction and transformation into the 
compositing manager. The basic idea is to communicate client side informations 
to the X11 server. The regions or outputs can of this version have no ICC 
profile attached, which means a color server, typical in a compositing manager, 
shall not color manage these regions or windows. These regions or windows then
are in the responsibility of the application. This allowes for calibration and
early colour binding.
Support for client side colour space ICC profiles is possible. This allowes 
applications to do late colour binding, which is very convenient to correct
complex vector graphics or 3D scenes to multiple outputs, without the need
to understand window transformations.


## Color Profile

A single ICC color profile is described by the following C structure.

typedef struct {
        uint8_t md5[16];  /* ICC MD5 hash of the associated ICC profile */
	uint32_t size;    /* number of bytes following, in network byte order */
} XcolorProfile;

It defines a single ICC profile that can be uploaded to the compositing manager
and later referenced in color regions. The actual profile data follows directly
after the structure.


## Color Region

A color region is described by the following C structure:

typedef struct {
        uint32_t region;  /* window centric XserverRegion               */
        uint8_t md5[16];  /* ICC MD5 hash of the associated ICC profile */
} XcolorRegion;

It defines a region and the attached color profile. Color regions are attached
to windows and used by the compositing manager to apply the proper color
transformation. Windows can have an unlimited amount of regions attached, though
only the first 2 * 2^32 can be referenced.
As of this spec the md5 shall be set to zero to signal the region is already
color managed by the application. That capability is called opt out.


## Color Output

A windows profile reference is described by the following C structure:

typedef struct {
        unsigned char name[16]; /* output name                          */
        uint8_t md5[16];  /* ICC MD5 hash of the associated ICC profile */
        uint8_t dummy[16];/* reserved                                   */
} XcolorOutput;

It defines a window profile describing the windows content colour space. 
A normal window profile is referenced by each window and is used by the 
compositing manager to apply per window colour transformations. 

The name field can be zero if the referenced profile is a normal editing space 
profile.

It is allowed to reference a device link profile, which describes a
colour transform of window content to one specified output. Then the name field
must be filled.

Output names are normally deteced by the XRandR Xorg extension and literally be
used for the name field, e.g. "DP-1" In case the XRandR extension detects only 
one output, but the Xinerama extension detects multiple outputs, then the 
Xinerama screens can be named in plain Xinerama order. Xinerama screen names 
are ascii encoded numbers like "0".

The md5 shall be set to zero to signal the window is already color managed 
by the application. That capability is called opt out.


## Atoms

 _ICC_COLOR_PROFILES:

Is used to upload color profiles to the compositing manager. Clients attach a
a list of one or more XColorProfile to the root window. Compositing manager then
fetches the list and saves the profiles in an internal database and deletes the
property.
The type is XA_CARDINAL. The size value is stored in network byte order. The 
data represents a list of XcolorProfile. The memory layout is like:
first profile 
   16 byte      md5
    4 byte      size
 size bytes     profile data
second profile
   16 byte      md5
    4 byte      size
 size bytes     profile data
...


 _ICC_COLOR_REGIONS:

The atom is attached to windows and lists the XcolorRegion's defined for that
specific window. The application is responsible to update the contained 
informations, e.g. on region resize or move inside the window.

The type is XA_CARDINAL and values are stored in network byte order.
_ICC_COLOR_OUTPUTS must not be intermixed with _ICC_COLOR_REGIONS on the same
window. Intermixing shall cause the colour server to fall back to sRGB.


 _ICC_COLOR_OUTPUTS:

The atom is attached to windows and lists the XcolorOutput's defined for that
specific window. The application is responsible to update that atom in case
device link profiles are utilised and outputs change.

The type is XA_CARDINAL and values are stored in network byte order.
_ICC_COLOR_OUTPUTS must not be intermixed with _ICC_COLOR_REGIONS on the same
window. Intermixing shall cause the colour server to fall back to sRGB.


 _ICC_COLOR_TARGET:

Is attached to windows and specifies on which output the window should
look correctly. The type is XA_STRING. Deprecated. Please look at the
_ICC_COLOR_OUTPUTS atom.


 _ICC_COLOR_DISPLAY_ADVANCED:

The atom is optionaly attached to the root window. A value of "1" signals the 
colour server to use advanced CMS options like proofing. The type is XA_STRING.


 _ICC_COLOR_DESKTOP:

The atom is attached on the root window to inform about the color server.
The content is of type XA_STRING and has four sections separated by a 
empty space char ' '. 

The _ICC_COLOR_DESKTOP atom is a string with following usages:

* uniquely identify the colour server
* tell the name of the colour server
* tell the colour server is alive
* list the colour server capabilities and spec compliance

All sections are separated by one space char ' ' for easy parsing.

The first section contains the process id (pid_t) of the color server process, 
which has set the atom.
The second section contains time since epoch GMT as returned by time(NULL).
The thired section contains the bar '|' separated and surrounded

Capabilities:

* ICP  _ICC_COLOR_PROFILES XcolorRegion::md5 is handled
* ICT  _ICC_COLOR_TARGET - deprecated
* ICM  _ICC_COLOR_MANAGEMENT color server is converting
* ICR  _ICC_COLOR_REGIONS XcolorRegion is handled
* ICO  _ICC_COLOR_OUTPUTS XcolorOutput is handled
* ICA  _ICC_COLOR_DISPLAY_ADVANCED
* V0.4 indicates version compliance to the _ICC_Profile in X spec

The fourth section contains the servers name identifier.

As of this specification the third section must contain the supported 
_ICC_PROFILE in X version. The third section must contain at least the 
ICO capability specifier to show baseline support. All other capability 
specifiers are optional to the third section.

A example of a valid atom might look like:
_ICC_COLOR_DESKTOP(STRING) = "4518 1274001512 |ICA|ICR|ICO|ICP|ICM|V0.4| compicc"


 _ICC_DEVICE_PROFILE(_xxx):

The atom will hold a native ICC profile with the exposed device 
characteristics at the compositing window manager level. 
The colour server shall if no _ICC_DEVICE_PROFILE(_xxx) is set, copy the 
_ICC_PROFILE(_xxx) profiles to each equivalent _ICC_DEVICE_PROFILE(_xxx) atom.
The _ICC_PROFILE(_xxx) profiles shall be replaced by a sRGB ICC profile.
The counting in the atoms (_xxx) name section follows the rules outlined in 
the ICC Profile in X recommendation. After finishing the session the the old
state has to be recovered by copying any _ICC_DEVICE_PROFILE(_xxx) atoms 
content into the appropriate _ICC_PROFILE(_xxx) atoms and removing all
_ICC_DEVICE_PROFILE(_xxx) atoms.

The colour server must be aware about change property events indicating that
a _ICC_PROFILE(_xxx) atom has changed by a external application and needs to
move that profile to the appropriate _ICC_DEVICE_PROFILE(_xxx) atom and set
the _ICC_PROFILE(_xxx) atom to sRGB as well.
The modification of the _ICC_DEVICE_PROFILE(_xxx) atoms by external applications
is undefined.


## Baseline Implementation

_ICC_COLOR_OUTPUTS support must be implemented. That allowes applications and
toolkits to rely on a common level of support from different colour server
implementations.


## Discussion

Elder desktop applications might not be aware of the capabilities exposed 
through a implementation of this recommendation. Thus a way is needed to enshure
backward compatibility. The _ICC_DEVICE_PROFILE(_xxx) atom provides a means to
expose capable clients the desired information about the monitor characteristics
at the discussed level. The _ICC_PROFILE(_xxx) atom is maintained to enshure the
desired backward compatibility.

### Implementation Notes:

Color servers see in a X11 environment only asynchronous events. Therefore they
shall control the setup of _ICC_PROFILE(_xxx) atoms. That way they will
be able to handle XRandR output configuration and desktop geometry change events
in the correct order.

_ICC_COLOR_OUTPUTS provides a very simple mechanism for compositors to do
server side colour correction of otherwise non colour managed windows.
Supporting _ICC_COLOR_PROFILES capabilities helps applications a lot to obtain
proper multi monitor colour correction as they can render into a single 
intermediate colour space, which is then finally converted to each output by
the colour server. Therefor _ICC_COLOR_PROFILES support is highly encouraged.


## References

1. X window system (hhtp://www.x.org)
2. International Color Consortium (http://www.color.org)
3. _ICC_Profile in X (http://www.freedesktop.org/wiki/Specifications/icc_profiles_in_x_spec)
4. Xcolor reference implementation (git clone git://www.oyranos.org/git/xcolor)
5. CompIcc colour server for compiz (http://sourceforge.net/apps/mediawiki/compicc/index.php?title=Main_Page)
6. xcmsevents monitor tool (git clone git://www.oyranos.org/git/oyranos)
7. Key words for use in RFCs to Indicate Requirement Levels (http://www.ietf.org/rfc/rfc2119.txt)


2008 (c) Tomas Carnecky, 2010-2012 (c) Kai-Uwe Behrmann

