% analyze hyper results

% packages = { 'umf+amd', 'umf+met', 'paru+amd', 'paru+met', 'superlu', 'old+amd', 'old+met' } ;
packages = { 'umf+amd', 'umf+met', 'paru+amd', 'paru+met', 'superlu', 'umf+amd(o)', 'umf+met(o)', 'paru+amd(o)', 'paru+met(o)', 'superlu(o)' } ;
s =        { 'ko-',      'bo-',    'go-',      'ro-',      'co-',     'ko:',        'bo:',        'go:',         'ro:',         'co:' } ;
threads = [24 16 8 4 2 1] ;
nthreads = length (threads) ;


matrices = {
'rim',
'TSOPF_RS_b39_c30',
'twotone',
'std1_Jac2',
'mac_econ_fwd500',
'std1_Jac3',
'TSOPF_RS_b300_c1',
'lhr71',
'Zd_Jac2',
'av41092',
'Zd_Jac6',
'crashbasis',
'bbmat',
'Zd_Jac3',
'mc2depi',
'TSOPF_RS_b300_c2',
'TSOPF_RS_b678_c1',
'TSOPF_RS_b300_c3',
'Chebyshev4',
'Hamrle3',
'pre2',
'TSOPF_RS_b2052_c1',
'torso1',
'TSOPF_RS_b678_c2',
'TSOPF_RS_b2383',
'vas_stokes_4M',        % not test on hyper (too big for any solver except MUMPS)
'stokes' } ;            % not test on hyper (too big for any solver, incl MUMPS)
nmats = length (matrices) ;

%-------------------------------------------------------------------------------
% ParU results (both AMD and METIS): 2*27 = 54 results
% umfpack strategy (1:unsym, 3:sym), paru strategy (1:unsym, 3:sym),
% ordering (1:amd/colamd, 3:metis-guard on A+A' or A'A)

% ParU results, Sept 9, gcc, MKL, GNU OpenMP
paru_strategy = [
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	1
1	1	1
1	1	3
3	3	1
3	3	3
3	3	1
3	3	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	1
1	1	1
1	1	3
3	3	1
3	3	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	1
3	3	1
3	3	3
1	1	1
1	1	3
1	1	1
1	1	1
nan nan nan
nan nan nan
nan nan nan
nan nan nan ] ;

paru_sym_time = [
0.0188
0.1418
0.0286
0.1989
0.0358
0.5914
0.1220
0.3493
0.1793
1.8970
0.1238
0.3464
0.0780
0.3347
0.0834
0.8220
0.1542
0.4298
0.0683
0.0613
0.1492
0.4284
0.0659
0.7926
0.0842
0.4421
0.1575
0.4395
0.1591
2.2281
0.1752
0.7311
0.5002
0.4996
0.2816
1.2200
0.3291
0.8963
0.5428
7.5963
0.9679
26.7864
0.8598
0.8554
0.2656
1.2249
1.0066
4.3961
0.4843
0.4821
nan
nan
nan
nan ] ;
% split into AMD/COLAMD vs METIS orderings:
paru_sym_time_amd = paru_sym_time (1:2:end,:) ;
paru_sym_time_met = paru_sym_time (2:2:end,:) ;

paru_factor_time = [
0.2771	0.2771	0.1842	0.1830	0.1844	0.2763
0.0372	0.0336	0.0338	0.0432	0.0673	0.1097
0.0381	0.0369	0.0341	0.0329	0.0345	0.0395
0.0390	0.0369	0.0350	0.0369	0.0449	0.0617
0.1705	0.1666	0.1438	0.1399	0.1603	0.2101
0.2131	0.2144	0.2094	0.2068	0.2253	0.2932
0.0363	0.0388	0.0243	0.0236	0.0354	0.0563
0.0289	0.0327	0.0244	0.0319	0.0493	0.0897
1.4928	1.4515	1.4224	1.4428	1.5638	2.1561
0.4719	0.4309	0.3957	0.4899	0.8013	1.3545
0.0395	0.0322	0.0255	0.0269	0.0344	0.0531
0.0299	0.0309	0.0318	0.0322	0.0498	0.0819
0.0151	0.0143	0.0137	0.0162	0.0219	0.0315
0.0252	0.0225	0.0193	0.0268	0.0438	0.0733
0.0484	0.0437	0.0427	0.0505	0.0719	0.1131
0.0432	0.0419	0.0400	0.0471	0.0681	0.1071
0.0376	0.0306	0.0240	0.0262	0.0386	0.0645
0.0409	0.0358	0.0350	0.0385	0.0627	0.1086
1.4616	1.3943	1.3963	1.4269	1.3866	1.4868
1.3954	1.4525	1.3980	1.3796	1.3836	1.5440
0.0424	0.0393	0.0312	0.0312	0.0389	0.0638
0.0434	0.0399	0.0356	0.0419	0.0712	0.1238
0.2212	0.2123	0.2062	0.2141	0.2799	0.4548
0.5111	0.5271	0.4988	0.5160	0.5217	0.7263
3.0913	3.0480	3.0243	3.0309	3.1008	3.4258
0.9298	0.9615	0.9502	0.9462	0.9418	1.0620
0.0438	0.0339	0.0254	0.0289	0.0405	0.0681
0.0421	0.0391	0.0304	0.0385	0.0671	0.1142
0.9488	0.8974	0.8727	0.9188	1.2262	2.0023
0.2823	0.2963	0.3014	0.4011	0.6750	1.1365
0.0297	0.0287	0.0291	0.0337	0.0449	0.0634
0.0401	0.0383	0.0388	0.0533	0.0873	0.1513
0.0597	0.0539	0.0446	0.0519	0.0672	0.0975
0.0524	0.0447	0.0450	0.0519	0.0678	0.0972
0.0557	0.0496	0.0496	0.0564	0.0736	0.1024
0.0675	0.0656	0.0647	0.0854	0.1333	0.2313
1.7552	1.7305	1.7054	1.7211	1.7396	1.8182
1.7311	1.7355	1.7371	1.7348	1.7423	1.7775
7.5595	7.3556	7.1565	7.8662	11.5514	19.5613
4.9492	4.8677	4.4826	4.7103	7.8919	13.9784
12.7256	12.8808	12.4329	14.0716	17.9143	29.5506
2.7306	2.3848	2.1604	2.7516	4.4679	8.2135
0.0761	0.0604	0.0518	0.0620	0.0880	0.1337
0.0615	0.0608	0.0551	0.0617	0.0871	0.1339
1.9823	1.9346	1.9211	1.9119	1.9286	1.9765
1.4457	1.4386	1.4133	1.4269	1.4545	1.5777
0.1033	0.0773	0.0796	0.0922	0.1242	0.1812
0.2376	0.2191	0.2051	0.2534	0.3988	0.6907
27.7071	27.8728	29.3135	26.5141	27.0290	46.2995
27.5802	27.6722	30.0010	26.2470	27.0275	46.3099
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan ] ;
% split into AMD/COLAMD vs METIS orderings:
paru_factor_time_amd = paru_factor_time (1:2:end,:) ;
paru_factor_time_met = paru_factor_time (2:2:end,:) ;

paru_solve_time = [
0.0123	0.0196	0.0088	0.0082	0.0083	0.0089
0.0140	0.0128	0.0047	0.0046	0.0047	0.0048
0.0046	0.0023	0.0024	0.0025	0.0025	0.0026
0.0041	0.0040	0.0040	0.0042	0.0043	0.0043
0.0128	0.0111	0.0094	0.0095	0.0098	0.0100
0.0181	0.0141	0.0105	0.0106	0.0109	0.0115
0.0109	0.0070	0.0029	0.0028	0.0028	0.0030
0.0121	0.0115	0.0035	0.0033	0.0034	0.0036
0.1251	0.0923	0.0485	0.0455	0.0475	0.0536
0.0971	0.0968	0.0445	0.0432	0.0424	0.0446
0.0127	0.0081	0.0030	0.0029	0.0029	0.0031
0.0099	0.0079	0.0038	0.0035	0.0036	0.0037
0.0034	0.0025	0.0015	0.0015	0.0015	0.0013
0.0112	0.0107	0.0029	0.0028	0.0028	0.0030
0.0088	0.0072	0.0070	0.0071	0.0072	0.0073
0.0088	0.0075	0.0071	0.0069	0.0071	0.0070
0.0108	0.0093	0.0036	0.0036	0.0035	0.0037
0.0142	0.0097	0.0045	0.0043	0.0044	0.0045
0.0397	0.0270	0.0163	0.0163	0.0176	0.0220
0.0400	0.0276	0.0180	0.0164	0.0176	0.0221
0.0091	0.0078	0.0037	0.0036	0.0036	0.0038
0.0125	0.0103	0.0047	0.0044	0.0045	0.0048
0.0394	0.0335	0.0234	0.0241	0.0230	0.0239
0.0758	0.0566	0.0293	0.0288	0.0296	0.0320
0.0734	0.0506	0.0267	0.0257	0.0275	0.0330
0.0602	0.0445	0.0182	0.0216	0.0172	0.0195
0.0107	0.0084	0.0040	0.0039	0.0038	0.0040
0.0122	0.0090	0.0046	0.0044	0.0045	0.0048
0.1403	0.1072	0.0707	0.0701	0.0717	0.0747
0.1268	0.1129	0.0635	0.0642	0.0650	0.0667
0.0055	0.0045	0.0033	0.0036	0.0034	0.0033
0.0243	0.0211	0.0062	0.0058	0.0059	0.0065
0.0056	0.0051	0.0031	0.0027	0.0029	0.0033
0.0056	0.0074	0.0032	0.0027	0.0029	0.0033
0.0060	0.0072	0.0052	0.0056	0.0052	0.0055
0.0280	0.0259	0.0089	0.0089	0.0090	0.0097
0.0982	0.0578	0.0292	0.0250	0.0261	0.0285
0.1023	0.0619	0.0301	0.0307	0.0291	0.0319
0.5314	0.3852	0.2316	0.2394	0.2533	0.2794
0.4882	0.3885	0.2335	0.2303	0.2393	0.2511
0.4422	0.3159	0.2031	0.2171	0.2348	0.2704
0.5373	0.4351	0.1619	0.1630	0.1695	0.1816
0.0078	0.0061	0.0040	0.0040	0.0042	0.0049
0.0094	0.0061	0.0044	0.0040	0.0042	0.0050
0.0436	0.0343	0.0234	0.0226	0.0232	0.0249
0.0471	0.0359	0.0234	0.0224	0.0231	0.0244
0.0100	0.0092	0.0064	0.0057	0.0059	0.0070
0.0498	0.0285	0.0137	0.0127	0.0132	0.0153
0.0582	0.0572	0.0645	0.0588	0.0640	0.0718
0.0590	0.0601	0.0648	0.0587	0.0639	0.0716
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan ] ;
% split into AMD/COLAMD vs METIS orderings:
paru_solve_time_amd = paru_solve_time (1:2:end,:) ;
paru_solve_time_met = paru_solve_time (2:2:end,:) ;

paru_total_time_amd = repmat (paru_sym_time_amd, 1, nthreads) + ...
    paru_factor_time_amd + paru_solve_time_amd ;

paru_total_time_met = repmat (paru_sym_time_met, 1, nthreads) + ...
    paru_factor_time_met + paru_solve_time_met ;

%-------------------------------------------------------------------------------

paru_sym_time_openblas = [
0.0186
0.1421
0.0291
0.1970
0.0357
0.5874
0.1206
0.3513
0.1879
1.9105
0.1236
0.3558
0.0778
0.3479
0.0831
0.8221
0.1531
0.4159
0.0683
0.0611
0.1480
0.4300
0.0655
0.7814
0.0915
0.4500
0.1571
0.4298
0.1415
2.1859
0.1782
0.7406
0.5114
0.5122
0.2825
1.2388
0.3047
0.8836
0.5414
7.4454
0.9715
28.1742
0.8760
0.8763
0.2850
1.2456
1.0074
4.3922
0.4871
0.4890
nan
nan
nan
nan ] ;
% split into AMD/COLAMD vs METIS orderings:
paru_sym_time_amd_openblas = paru_sym_time_openblas (1:2:end,:) ;
paru_sym_time_met_openblas = paru_sym_time_openblas (2:2:end,:) ;

paru_factor_time_openblas = [
0.3266	0.3214	0.2245	0.2193	0.2143	0.3266
0.0402	0.0361	0.0426	0.0487	0.0749	0.1251
0.0343	0.0338	0.0341	0.0333	0.0357	0.0419
0.0389	0.0380	0.0352	0.0371	0.0455	0.0641
0.1681	0.1645	0.1553	0.1528	0.1677	0.2249
0.2290	0.2209	0.2158	0.2210	0.2412	0.3227
0.0397	0.0343	0.0333	0.0263	0.0394	0.0635
0.0371	0.0421	0.0278	0.0355	0.0583	0.1009
1.7141	1.6828	1.6428	1.6162	1.7563	2.3849
0.5014	0.4171	0.4075	0.5624	0.9386	1.6072
0.0412	0.0376	0.0277	0.0269	0.0389	0.0595
0.0373	0.0345	0.0262	0.0349	0.0561	0.0968
0.0145	0.0147	0.0140	0.0163	0.0228	0.0329
0.0272	0.0243	0.0206	0.0292	0.0488	0.0821
0.0445	0.0433	0.0424	0.0516	0.0763	0.1211
0.0424	0.0417	0.0415	0.0488	0.0718	0.1164
0.0400	0.0339	0.0285	0.0278	0.0433	0.0725
0.0431	0.0409	0.0382	0.0426	0.0690	0.1109
1.6727	1.6531	1.6575	1.6355	1.6497	1.7728
1.6344	1.6120	1.6462	1.6010	1.6585	1.8035
0.0495	0.0484	0.0354	0.0339	0.0431	0.0762
0.0462	0.0428	0.0410	0.0471	0.0800	0.1392
0.2131	0.2178	0.2093	0.2316	0.3057	0.4890
0.5612	0.5518	0.5471	0.5525	0.5627	0.7917
3.4981	3.4113	3.4005	3.4196	3.5073	3.7693
1.0919	1.0799	1.0843	1.0740	1.0863	1.2097
0.0412	0.0346	0.0324	0.0317	0.0449	0.0763
0.0460	0.0388	0.0344	0.0450	0.0707	0.1235
0.9227	0.9115	0.8605	0.9653	1.2779	2.0593
0.2839	0.2987	0.3143	0.4339	0.7253	1.2362
0.0305	0.0291	0.0290	0.0341	0.0462	0.0669
0.0408	0.0396	0.0411	0.0582	0.0948	0.1722
0.0547	0.0546	0.0469	0.0531	0.0704	0.1049
0.0553	0.0533	0.0472	0.0532	0.0707	0.1049
0.0511	0.0502	0.0511	0.0579	0.0764	0.1079
0.0693	0.0656	0.0695	0.0972	0.1457	0.2559
1.9251	1.8780	1.8833	1.8790	1.9119	1.9901
1.8860	1.8722	1.8740	1.8753	1.8911	1.9462
8.0475	7.9457	7.6462	8.5807	12.0955	20.9704
6.0458	5.8134	5.2633	5.5504	8.4877	15.7836
14.6951	14.7166	14.5414	15.8296	19.3959	31.3669
2.8256	2.6922	2.4178	2.9742	5.0807	9.2790
0.0673	0.0671	0.0657	0.0750	0.1022	0.1534
0.0665	0.0633	0.0651	0.0753	0.1024	0.1531
2.1857	2.1338	2.1370	2.1614	2.1475	2.1785
1.6047	1.5977	1.5814	1.5779	1.5990	1.7363
0.1067	0.0919	0.0936	0.1079	0.1406	0.2046
0.2604	0.2421	0.2280	0.3008	0.4659	0.7970
27.1948	27.1252	27.9789	28.6643	32.3551	51.6916
27.1330	27.1091	27.4539	28.5782	32.3038	51.6663
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan ] ;
% split into AMD/COLAMD vs METIS orderings:
paru_factor_time_amd_openblas = paru_factor_time_openblas (1:2:end,:) ;
paru_factor_time_met_openblas = paru_factor_time_openblas (2:2:end,:) ;

paru_solve_time_openblas = [
0.0099	0.0101	0.0099	0.0115	0.0100	0.0099
0.0072	0.0054	0.0055	0.0052	0.0052	0.0052
0.0024	0.0024	0.0026	0.0027	0.0027	0.0026
0.0043	0.0043	0.0043	0.0044	0.0044	0.0045
0.0104	0.0103	0.0103	0.0104	0.0104	0.0105
0.0121	0.0122	0.0121	0.0121	0.0122	0.0121
0.0034	0.0035	0.0035	0.0032	0.0032	0.0032
0.0057	0.0041	0.0039	0.0038	0.0039	0.0038
0.0562	0.0562	0.0561	0.0563	0.0566	0.0582
0.0461	0.0460	0.0462	0.0465	0.0468	0.0470
0.0038	0.0035	0.0033	0.0032	0.0032	0.0032
0.0049	0.0066	0.0040	0.0040	0.0040	0.0039
0.0013	0.0014	0.0015	0.0015	0.0015	0.0013
0.0072	0.0034	0.0034	0.0034	0.0034	0.0033
0.0077	0.0076	0.0076	0.0076	0.0077	0.0079
0.0077	0.0077	0.0077	0.0076	0.0077	0.0077
0.0041	0.0043	0.0041	0.0040	0.0039	0.0038
0.0052	0.0052	0.0049	0.0049	0.0049	0.0048
0.0241	0.0240	0.0241	0.0241	0.0240	0.0243
0.0242	0.0241	0.0241	0.0238	0.0239	0.0242
0.0042	0.0060	0.0041	0.0040	0.0039	0.0039
0.0062	0.0057	0.0052	0.0050	0.0051	0.0050
0.0240	0.0237	0.0240	0.0242	0.0244	0.0250
0.0315	0.0316	0.0318	0.0323	0.0324	0.0337
0.0348	0.0348	0.0348	0.0348	0.0348	0.0348
0.0204	0.0204	0.0204	0.0204	0.0203	0.0203
0.0046	0.0047	0.0045	0.0043	0.0042	0.0042
0.0053	0.0060	0.0051	0.0051	0.0050	0.0051
0.0779	0.0777	0.0788	0.0793	0.0804	0.0805
0.0671	0.0674	0.0685	0.0690	0.0700	0.0701
0.0033	0.0032	0.0033	0.0033	0.0033	0.0033
0.0072	0.0072	0.0072	0.0071	0.0071	0.0072
0.0074	0.0034	0.0034	0.0035	0.0035	0.0035
0.0033	0.0072	0.0034	0.0035	0.0034	0.0035
0.0055	0.0054	0.0054	0.0054	0.0054	0.0055
0.0105	0.0106	0.0107	0.0106	0.0106	0.0106
0.0310	0.0309	0.0310	0.0309	0.0310	0.0309
0.0345	0.0345	0.0345	0.0346	0.0345	0.0346
0.2931	0.2923	0.2928	0.2913	0.2913	0.2927
0.2631	0.2589	0.2591	0.2578	0.2606	0.2575
0.2881	0.2880	0.2879	0.2877	0.2883	0.2883
0.1876	0.1890	0.1899	0.1907	0.1913	0.1932
0.0064	0.0099	0.0051	0.0052	0.0053	0.0053
0.0110	0.0094	0.0052	0.0052	0.0052	0.0052
0.0271	0.0270	0.0270	0.0270	0.0269	0.0271
0.0262	0.0262	0.0262	0.0264	0.0265	0.0266
0.0075	0.0074	0.0072	0.0072	0.0072	0.0074
0.0213	0.0203	0.0170	0.0170	0.0168	0.0168
0.0862	0.0872	0.0826	0.0823	0.0820	0.0821
0.0839	0.0825	0.0825	0.0823	0.0820	0.0821
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan ] ;
% split into AMD/COLAMD vs METIS orderings:
paru_solve_time_amd_openblas = paru_solve_time_openblas (1:2:end,:) ;
paru_solve_time_met_openblas = paru_solve_time_openblas (2:2:end,:) ;

paru_total_time_amd_openblas = repmat (paru_sym_time_amd_openblas, 1, nthreads) + ...
    paru_factor_time_amd_openblas + paru_solve_time_amd_openblas ;

paru_total_time_met_openblas = repmat (paru_sym_time_met_openblas, 1, nthreads) + ...
    paru_factor_time_met_openblas + paru_solve_time_met_openblas ;


%-------------------------------------------------------------------------------
% UMFPACK results (Sept 8): gcc and mkl
% strategy: (1:unsym, 3:sym)
% ordering: (1:amd/colamd, 3: metis on A+A'/A'A)
umf_strategy = [
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	1
1	1	1
1	1	3
3	3	1
3	3	3
3	3	1
3	3	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	1
1	1	1
1	1	3
3	3	1
3	3	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	1
3	3	1
3	3	3
1	1	1
1	1	3
1	1	1
1	1	1
nan nan nan
nan nan nan
nan nan nan
nan nan nan ] ;
% split into AMD/COLAMD vs METIS orderings:
umf_strategy_amd = umf_strategy (1:2:end,:) ;
umf_strategy_met = umf_strategy (2:2:end,:) ;

umf_sym_time = [
0.0214
0.1423
0.0307
0.1890
0.0316
0.5745
0.1209
0.3481
0.1843
1.9439
0.1225
0.3394
0.0821
0.3245
0.0784
0.8126
0.1520
0.4117
0.0662
0.0635
0.1438
0.4243
0.0606
0.7865
0.0906
0.4647
0.1528
0.4327
0.1462
2.2628
0.1691
0.7306
0.4886
0.4921
0.2640
1.2123
0.3137
0.9861
0.4989
7.8003
0.9388
31.6451
0.8509
0.8534
0.2457
1.3505
0.9880
4.4041
0.4120
0.4130
nan
nan
nan
nan] ;
% split into AMD/COLAMD vs METIS orderings:
umf_sym_time_amd = umf_sym_time (1:2:end,:) ;
umf_sym_time_met = umf_sym_time (2:2:end,:) ;

umf_factor_time = [
0.2203	0.1742	0.1718	0.1714	0.1819	0.1961
0.1742	0.1261	0.1221	0.1146	0.1155	0.1195
0.0516	0.0507	0.0505	0.0506	0.0505	0.0505
0.1568	0.1403	0.0875	0.0886	0.0956	0.0840
0.3557	0.2565	0.2216	0.2159	0.2279	0.2528
0.4721	0.3251	0.2677	0.2780	0.3049	0.3620
0.0941	0.0703	0.0682	0.0646	0.0670	0.0722
0.1328	0.0956	0.0942	0.0879	0.0910	0.0973
3.4112	2.1860	1.5823	1.6281	1.7953	2.2353
1.8914	1.2659	1.1045	1.0190	1.0822	1.2317
0.0959	0.0700	0.0674	0.0648	0.0667	0.0712
0.1449	0.0881	0.0868	0.0810	0.0844	0.0923
0.0906	0.0706	0.0483	0.0463	0.0462	0.0457
0.1575	0.1141	0.0934	0.0863	0.0885	0.0934
0.2413	0.1382	0.1347	0.1311	0.1300	0.1275
0.2736	0.1802	0.1724	0.1670	0.1653	0.1620
0.1240	0.0814	0.0783	0.0753	0.0774	0.0824
0.1235	0.1088	0.1072	0.0999	0.1039	0.1126
1.3750	0.9240	0.7692	0.8282	0.9990	1.3542
1.3409	0.9572	0.7875	0.8289	0.9977	1.3549
0.1041	0.0820	0.0800	0.0753	0.0772	0.0822
0.1632	0.1180	0.1181	0.1084	0.1142	0.1259
0.6815	0.4289	0.3796	0.3691	0.3878	0.4255
1.0614	0.6829	0.5672	0.5317	0.5431	0.5882
2.7328	1.7269	1.4406	1.4313	1.7191	2.3423
1.4217	0.8591	0.6905	0.6390	0.7151	0.8852
0.1126	0.0839	0.0818	0.0773	0.0797	0.0846
0.1673	0.1122	0.1119	0.1052	0.1086	0.1181
2.8953	1.9743	1.6219	1.5946	1.7043	1.9436
2.2901	1.5813	1.4251	1.3595	1.3825	1.4696
0.1802	0.0985	0.0962	0.0950	0.0945	0.0934
0.3384	0.1998	0.1866	0.1732	0.1779	0.1866
0.4606	0.4540	0.4459	0.4381	0.4406	0.4241
0.4845	0.4530	0.4437	0.4387	0.4406	0.4248
0.2551	0.1609	0.1450	0.1429	0.1432	0.1410
0.4740	0.3462	0.2688	0.2519	0.2572	0.2661
1.7819	1.1102	0.8759	0.8588	0.9088	1.0355
2.6675	1.5814	1.2371	1.1752	1.2835	1.5216
18.6135	13.3581	11.0874	11.5727	13.7410	19.6022
11.5529	7.8811	6.6273	6.6634	7.6514	9.7720
21.9912	16.5104	14.2940	14.6550	17.3962	25.9899
7.4431	5.3622	4.8393	4.6095	5.1461	6.3487
0.8042	0.8393	0.7779	0.7692	0.7714	0.7289
0.7911	0.7900	0.7707	0.7657	0.7714	0.7283
1.5085	1.0530	0.9331	0.9216	0.9725	1.0540
1.7040	1.0768	0.9153	0.9285	0.9958	1.0959
0.4056	0.3004	0.2926	0.2915	0.2941	0.2934
1.1878	0.7873	0.5824	0.5670	0.6290	0.7391
27.2983	25.3362	22.9163	23.4753	26.1374	45.0625
27.3785	25.4402	22.9061	23.4437	26.1146	45.0496
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan ] ;
% split into AMD/COLAMD vs METIS orderings:
umf_factor_time_amd = umf_factor_time (1:2:end,:) ;
umf_factor_time_met = umf_factor_time (2:2:end,:) ;

umf_solve_time = [
0.0369	0.0241	0.0355	0.0377	0.0379	0.0355
0.0274	0.0172	0.0171	0.0251	0.0251	0.0251
0.0071	0.0071	0.0071	0.0071	0.0071	0.0070
0.0124	0.0117	0.0096	0.0099	0.0119	0.0101
0.0308	0.0306	0.0308	0.0308	0.0307	0.0306
0.0385	0.0392	0.0384	0.0384	0.0384	0.0384
0.0179	0.0159	0.0111	0.0158	0.0158	0.0158
0.0173	0.0172	0.0172	0.0172	0.0172	0.0172
0.1792	0.1790	0.1787	0.1795	0.1793	0.1794
0.1446	0.1446	0.1451	0.1452	0.1442	0.1438
0.0124	0.0123	0.0122	0.0122	0.0067	0.0123
0.0160	0.0137	0.0136	0.0135	0.0136	0.0136
0.0131	0.0121	0.0122	0.0121	0.0121	0.0122
0.0214	0.0212	0.0187	0.0186	0.0186	0.0185
0.0097	0.0089	0.0088	0.0088	0.0088	0.0088
0.0092	0.0090	0.0090	0.0089	0.0090	0.0091
0.0216	0.0194	0.0192	0.0192	0.0192	0.0192
0.0220	0.0218	0.0218	0.0218	0.0217	0.0217
0.0880	0.0874	0.0874	0.0876	0.0875	0.0872
0.0871	0.0878	0.0875	0.0876	0.0877	0.0879
0.0079	0.0143	0.0079	0.0078	0.0078	0.0078
0.0094	0.0167	0.0168	0.0168	0.0168	0.0167
0.0751	0.0746	0.0737	0.0739	0.0739	0.0740
0.0858	0.0858	0.0850	0.0849	0.0856	0.0856
0.1493	0.1487	0.1488	0.1489	0.1488	0.1490
0.0947	0.0941	0.0947	0.0948	0.0949	0.0944
0.0150	0.0151	0.0083	0.0082	0.0150	0.0150
0.0182	0.0246	0.0170	0.0169	0.0170	0.0170
0.1582	0.2375	0.1582	0.2374	0.2373	0.2375
0.1960	0.1963	0.1329	0.1971	0.1971	0.1307
0.0266	0.0264	0.0178	0.0264	0.0264	0.0263
0.0402	0.0393	0.0395	0.0381	0.0384	0.0383
0.0375	0.0373	0.0372	0.0377	0.0372	0.0371
0.0374	0.0373	0.0372	0.0372	0.0371	0.0371
0.0394	0.0394	0.0393	0.0392	0.0392	0.0391
0.0555	0.0554	0.0556	0.0558	0.0557	0.0558
0.1303	0.1297	0.1293	0.0867	0.1296	0.0864
0.1678	0.1672	0.1117	0.1707	0.1696	0.1121
0.9787	0.9763	0.9751	0.9759	0.9758	0.9767
0.7165	0.7159	0.7144	0.7146	0.7215	0.7151
0.7797	0.7786	0.7772	0.7781	0.8022	0.5198
0.3241	0.3252	0.3248	0.4853	0.3231	0.4861
0.0552	0.0552	0.0551	0.0550	0.0552	0.0551
0.0552	0.0551	0.0551	0.0551	0.0551	0.0550
0.1137	0.1134	0.1133	0.1133	0.1137	0.1130
0.0797	0.0799	0.0793	0.1192	0.1193	0.1192
0.0745	0.0743	0.0743	0.0743	0.0744	0.0742
0.1058	0.1078	0.1086	0.1061	0.1063	0.1064
0.5704	0.5696	0.5679	0.5697	0.5701	0.5698
0.5697	0.5679	0.5696	0.5683	0.5683	0.5681
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan ] ;
% split into AMD/COLAMD vs METIS orderings:
umf_solve_time_amd = umf_solve_time (1:2:end,:) ;
umf_solve_time_met = umf_solve_time (2:2:end,:) ;

umf_total_time_amd = repmat (umf_sym_time_amd, 1, nthreads) + ...
    umf_factor_time_amd + umf_solve_time_amd ;

umf_total_time_met = repmat (umf_sym_time_met, 1, nthreads) + ...
    umf_factor_time_met + umf_solve_time_met ;

%-------------------------------------------------------------------------------
% UMFPACK Sept 11, gcc and openblas
%-------------------------------------------------------------------------------

umf_sym_time_openblas = [
0.0206
0.1474
0.0294
0.1836
0.0305
0.5692
0.1202
0.3412
0.1836
1.9368
0.1226
0.3425
0.0790
0.3412
0.0774
0.8056
0.1519
0.4112
0.0638
0.0637
0.1433
0.4214
0.0607
0.7755
0.0894
0.4467
0.1524
0.4298
0.1559
2.2221
0.1671
0.7262
0.4894
0.4888
0.2619
1.2105
0.3150
0.9756
0.5189
7.6537
0.9448
31.3267
0.8501
0.8484
0.2467
1.3377
0.9822
4.3999
0.4093
0.4149
nan
nan
nan
nan] ;
% split into AMD/COLAMD vs METIS orderings:
umf_sym_time_amd_openblas = umf_sym_time_openblas (1:2:end,:) ;
umf_sym_time_met_openblas = umf_sym_time_openblas (2:2:end,:) ;

umf_factor_time_openblas = [
0.2087	0.2088	0.2064	0.2063	0.2078	0.2188
0.1310	0.1461	0.1243	0.1245	0.1250	0.1247
0.0505	0.0501	0.0515	0.0521	0.0501	0.0501
0.0850	0.0840	0.0840	0.0840	0.0842	0.0842
0.2644	0.2644	0.2644	0.2642	0.2645	0.2649
0.3739	0.3737	0.3740	0.3741	0.3735	0.3742
0.0759	0.0755	0.0756	0.0754	0.0755	0.0756
0.1012	0.1012	0.1011	0.1013	0.1011	0.1011
2.3409	2.3331	2.3332	2.3272	2.3382	2.3389
1.2874	1.2893	1.2853	1.2888	1.2862	1.2858
0.0740	0.0741	0.0741	0.0742	0.0741	0.0741
0.0967	0.0967	0.0968	0.0968	0.0968	0.0969
0.0470	0.0471	0.0471	0.0472	0.0470	0.0470
0.0976	0.0975	0.0982	0.0975	0.0976	0.0978
0.1312	0.1311	0.1326	0.1317	0.1310	0.1311
0.1646	0.1647	0.1644	0.1647	0.1646	0.1646
0.0864	0.0859	0.0859	0.0856	0.0859	0.0859
0.1176	0.1175	0.1176	0.1177	0.1176	0.1175
1.4454	1.4418	1.4345	1.4338	1.4333	1.4342
1.4336	1.4333	1.4336	1.4336	1.4353	1.4399
0.0859	0.0867	0.0861	0.0860	0.0858	0.0859
0.1316	0.1316	0.1316	0.1317	0.1316	0.1315
0.4504	0.4410	0.4420	0.4419	0.4453	0.4418
0.6075	0.6109	0.6090	0.6087	0.6074	0.6074
2.5026	2.4979	2.4953	2.4950	2.4991	2.4933
0.9346	0.9341	0.9356	0.9327	0.9336	0.9399
0.0883	0.0882	0.0883	0.0883	0.0882	0.0882
0.1235	0.1234	0.1236	0.1236	0.1235	0.1234
2.0451	2.0435	2.0483	2.0449	2.0631	2.0469
1.5078	1.5084	1.5087	1.5083	1.5083	1.5063
0.0960	0.0960	0.0959	0.0959	0.0959	0.0959
0.1941	0.1947	0.1945	0.1947	0.1948	0.1944
0.4298	0.4299	0.4294	0.4295	0.4311	0.4304
0.4300	0.4298	0.4298	0.4301	0.4305	0.4299
0.1453	0.1452	0.1452	0.1450	0.1454	0.1454
0.2780	0.2777	0.2777	0.2770	0.2776	0.2783
1.0901	1.0913	1.0881	1.0942	1.0876	1.0898
1.5705	1.5654	1.5676	1.5687	1.5733	1.5680
21.0123	21.0102	21.1957	20.9846	20.9745	20.9901
10.2320	10.2512	10.2365	10.2407	10.2424	10.2358
28.2134	28.2243	28.2623	28.2023	28.1826	28.2619
6.6917	6.7035	6.7186	6.6988	6.7238	6.7021
0.7313	0.7340	0.7332	0.7330	0.7346	0.7317
0.7324	0.7320	0.7309	0.7310	0.7321	0.7324
1.0848	1.0824	1.0823	1.0818	1.0819	1.0822
1.1322	1.1329	1.1312	1.1319	1.1319	1.1317
0.3011	0.3022	0.3017	0.3049	0.3031	0.3056
0.7792	0.7803	0.7830	0.7813	0.7812	0.7803
50.1631	50.0484	50.1621	50.0736	50.1413	50.1283
50.0904	50.0582	50.0675	50.1371	50.1066	50.0883
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan ] ;
% split into AMD/COLAMD vs METIS orderings:
umf_factor_time_amd_openblas = umf_factor_time_openblas (1:2:end,:) ;
umf_factor_time_met_openblas = umf_factor_time_openblas (2:2:end,:) ;

umf_solve_time_openblas = [
0.0352	0.0351	0.0352	0.0352	0.0353	0.0433
0.0174	0.0243	0.0170	0.0174	0.0171	0.0173
0.0070	0.0070	0.0071	0.0077	0.0070	0.0070
0.0147	0.0147	0.0146	0.0147	0.0147	0.0147
0.0307	0.0307	0.0306	0.0307	0.0306	0.0308
0.0385	0.0386	0.0386	0.0387	0.0386	0.0385
0.0157	0.0157	0.0157	0.0157	0.0157	0.0157
0.0172	0.0173	0.0172	0.0172	0.0172	0.0173
0.1795	0.1796	0.1795	0.1795	0.1796	0.1795
0.1456	0.1456	0.1456	0.1449	0.1457	0.1459
0.0121	0.0121	0.0120	0.0121	0.0120	0.0121
0.0135	0.0136	0.0136	0.0136	0.0134	0.0136
0.0122	0.0122	0.0121	0.0123	0.0122	0.0122
0.0186	0.0186	0.0188	0.0186	0.0186	0.0187
0.0089	0.0088	0.0089	0.0088	0.0089	0.0089
0.0090	0.0090	0.0091	0.0090	0.0090	0.0091
0.0193	0.0193	0.0193	0.0194	0.0193	0.0193
0.0217	0.0217	0.0216	0.0218	0.0217	0.0217
0.0878	0.0877	0.0877	0.0878	0.0878	0.0878
0.0878	0.0878	0.0877	0.0877	0.0877	0.0877
0.0079	0.0079	0.0078	0.0078	0.0078	0.0078
0.0167	0.0166	0.0166	0.0166	0.0166	0.0166
0.0744	0.0741	0.0742	0.0742	0.0742	0.0740
0.0860	0.0859	0.0858	0.0856	0.0850	0.0855
0.1493	0.1496	0.1492	0.1491	0.1492	0.1491
0.0947	0.0941	0.0942	0.0941	0.0944	0.0945
0.0082	0.0082	0.0082	0.0082	0.0082	0.0082
0.0169	0.0169	0.0169	0.0170	0.0169	0.0169
0.2394	0.2382	0.2387	0.2390	0.2395	0.2397
0.1982	0.1977	0.1975	0.1980	0.1975	0.1976
0.0263	0.0263	0.0263	0.0263	0.0263	0.0263
0.0382	0.0383	0.0383	0.0382	0.0383	0.0382
0.0371	0.0371	0.0371	0.0371	0.0371	0.0371
0.0371	0.0371	0.0372	0.0371	0.0371	0.0371
0.0392	0.0392	0.0391	0.0392	0.0392	0.0392
0.0558	0.0558	0.0560	0.0557	0.0557	0.0558
0.1309	0.1306	0.1305	0.1311	0.1305	0.1306
0.1663	0.1657	0.1657	0.1656	0.1655	0.1655
0.9728	0.9736	0.9750	0.9721	0.9745	0.9734
0.7245	0.7135	0.7133	0.7125	0.7110	0.7127
0.7723	0.7726	0.7713	0.7726	0.7719	0.7719
0.4832	0.4823	0.4837	0.4829	0.4847	0.4833
0.0540	0.0539	0.0539	0.0539	0.0540	0.0539
0.0538	0.0538	0.0539	0.0539	0.0538	0.0539
0.0760	0.0759	0.0759	0.0761	0.0758	0.0760
0.0793	0.0792	0.0792	0.0795	0.0796	0.0792
0.0742	0.0742	0.0744	0.0743	0.0742	0.0743
0.1064	0.1064	0.1064	0.1063	0.1060	0.1060
0.5664	0.5689	0.5675	0.5677	0.5685	0.5686
0.5667	0.5685	0.5675	0.5669	0.5666	0.5686
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan ] ;
% split into AMD/COLAMD vs METIS orderings:
umf_solve_time_amd_openblas = umf_solve_time_openblas (1:2:end,:) ;
umf_solve_time_met_openblas = umf_solve_time_openblas (2:2:end,:) ;

umf_total_time_amd_openblas = repmat (umf_sym_time_amd_openblas, 1, nthreads) + ...
    umf_factor_time_amd_openblas + umf_solve_time_amd_openblas ;

umf_total_time_met_openblas = repmat (umf_sym_time_met_openblas, 1, nthreads) + ...
    umf_factor_time_met_openblas + umf_solve_time_met_openblas ;


%-------------------------------------------------------------------------------
% SuperLU_MT results: only COLAMD ordering (Sept 10)
slu_sym_time = [
0.0264	0.0262	0.0264	0.0264	0.0262	0.0262
0.0397	0.0404	0.0409	0.0398	0.0400	0.0399
0.1221	0.1207	0.1213	0.1213	0.1215	0.1210
1.1093	1.1056	1.1061	1.1070	1.1057	1.1068
0.2321	0.2286	0.2287	0.2286	0.2282	0.2296
1.3237	1.3276	1.3257	1.3251	1.3242	1.3256
0.1590	0.1582	0.1590	0.1585	0.1572	0.1567
0.1734	0.1725	0.1727	0.1727	0.1729	0.1731
1.4610	1.4614	1.4567	1.4602	1.4604	1.4586
0.0913	0.0915	0.0911	0.0914	0.0916	0.0911
1.5893	1.5859	1.5872	1.5842	1.5830	1.5804
0.0900	0.0899	0.0893	0.0889	0.0886	0.0904
0.6903	0.6884	0.6852	0.6862	0.6854	0.6859
1.7113	1.7069	1.7103	1.7085	1.7101	1.7075
nan nan nan nan nan nan % mc2depi
0.3178	0.3157	0.3151	0.3164	0.3159	0.3171
0.9830	0.9823	0.9822	0.9809	0.9813	0.9822
0.4858	0.4842	0.4866	0.4840	0.4840	0.4844
nan nan nan nan nan nan % Chebyshev4
0.4807	0.4805	0.4822	0.4796	0.4792	0.4821
1.3628	1.3600	1.3602	1.3589	1.3596	1.3617
1.8063	1.8034	1.8083	1.8033	1.8242	1.8057
0.5568	0.5582	0.5573	0.5567	0.5580	0.5595
1.9643	1.9672	1.9683	1.9637	1.9645	1.9641
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan ] ;

slu_factor_time = [
0.3379	0.3371	0.3491	0.5219	0.8393	1.5200
0.0602	0.0560	0.0533	0.0484	0.0535	0.0672
0.4731	0.3929	0.3673	0.5813	0.9771	1.7671
0.4224	0.4773	0.4883	0.8172	1.3687	1.4098
3.6491	3.8312	4.4150	7.6899	13.8696	27.1733
0.6914	0.7803	0.7950	1.2524	2.0868	1.6503
0.0952	0.0827	0.0710	0.0604	0.0672	0.0846
0.1075	0.0992	0.1011	0.1322	0.1994	0.3343
0.4864	0.5070	0.4739	0.7193	1.2348	2.1288
2.4497	2.5865	2.7632	4.7086	7.9601	15.4931
0.4840	0.5488	0.5181	0.6722	1.0384	1.7284
0.5230	0.4529	0.3934	0.5363	0.9255	1.7032
1.7210	1.8446	1.7798	2.9366	5.4728	10.3563
0.7066	0.7789	0.7467	1.1293	1.9315	2.5476
nan nan nan nan nan nan
0.1295	0.1122	0.0974	0.0995	0.1087	0.1643
0.2249	0.2086	0.1718	0.1869	0.2446	0.3068
0.1619	0.1411	0.1319	0.1297	0.1692	0.2450
nan nan nan nan nan nan
39.7306	42.0369	48.9615	78.7416	137.8911	250.0555
75.3350	67.6701	70.1764	104.4164	176.1986	337.6257
0.3428	0.3088	0.2719	0.2933	0.4165	0.4965
3.1903	3.6176	3.7980	6.6987	12.3663	23.6245
0.3185	0.2970	0.2674	0.2673	0.3601	0.5825
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan ] ;

slu_solve_time = [
0.2128	0.1865	0.2416	0.1826	0.2160	0.2067
0.0446	0.0451	0.0491	0.0432	0.0418	0.0423
0.2862	0.2849	0.2793	0.2719	0.2659	0.2597
0.1692	0.1684	0.1659	0.1640	0.1571	0.1271
1.2053	1.1737	1.1681	1.1588	1.1487	1.1497
0.2035	0.2048	0.2055	0.2010	0.1915	0.1432
0.0496	0.0499	0.0500	0.0501	0.0507	0.0493
0.1173	0.1203	0.1137	0.1108	0.1083	0.1066
0.1893	0.1860	0.1849	0.1811	0.1780	0.1679
0.5269	0.5272	0.5843	0.5184	0.5066	0.5663
0.2140	0.1969	0.1740	0.1658	0.1925	0.1525
0.3188	0.3213	0.3127	0.3057	0.3000	0.3020
0.5248	0.5183	0.5159	0.5131	0.5117	0.5106
0.2302	0.2317	0.2314	0.2228	0.2186	0.2089
nan nan nan nan nan nan
0.1033	0.1043	0.1042	0.1040	0.1025	0.1010
0.1230	0.1232	0.1483	0.1228	0.1229	0.1217
0.1583	0.1589	0.1591	0.1572	0.1541	0.1523
nan nan nan nan nan nan
6.5950	6.5493	6.4979	6.4531	6.4305	6.4151
6.8113	6.7595	6.7060	6.6497	6.6250	6.5685
0.2253	0.2261	0.2260	0.2255	0.2265	0.2228
0.6540	0.6554	0.6468	0.6374	0.6320	0.6278
0.2474	0.3482	0.2471	0.2944	0.2929	0.2414
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan ] ;

slu_total_time = slu_sym_time + slu_factor_time + slu_solve_time ;

%-------------------------------------------------------------------------------
% SuperLU_MT results: only COLAMD ordering, gcc and openblas
slu_sym_time_openblas = [
0.0257	0.0259	0.0256	0.0256	0.0259	0.0256
0.0401	0.0395	0.0392	0.0389	0.0389	0.0389
0.1193	0.1188	0.1183	0.1185	0.1191	0.1188
1.0963	1.0990	1.0968	1.0987	1.0941	1.0944
0.2257	0.2252	0.2229	0.2211	0.2213	0.2222
1.3002	1.2997	1.2995	1.3003	1.2989	1.2999
0.1518	0.1505	0.1507	0.1503	0.1515	0.1506
0.1628	0.1638	0.1673	0.1667	0.1675	0.1662
1.4393	1.4386	1.4390	1.4377	1.4370	1.4393
0.0902	0.0899	0.0908	0.0907	0.0919	0.0904
1.5607	1.5605	1.5590	1.5597	1.5584	1.5590
0.0876	0.0881	0.0883	0.0876	0.0873	0.0879
0.6750	0.6711	0.6702	0.6692	0.6692	0.6703
1.6877	1.6856	1.6851	1.6848	1.6859	1.6843
nan nan nan nan nan nan
0.3039	0.3003	0.3012	0.2999	0.3007	0.3004
0.9634	0.9633	0.9641	0.9626	0.9635	0.9643
0.4670	0.4672	0.4676	0.4669	0.4675	0.4674
nan nan nan nan nan nan
0.4424	0.4418	0.4746	0.4754	0.4731	0.4724
1.3389	1.3363	1.3378	1.3330	1.3333	1.3344
1.7771	1.7785	1.7786	1.7759	1.7769	1.7752
0.5581	0.5601	0.5593	0.5590	0.5584	0.5581
1.9261	1.9267	1.9243	1.9274	1.9244	1.9253
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan ] ;

slu_factor_time_openblas = [
0.8896	0.8644	0.7565	0.6067	0.6216	0.9068
0.0858	0.0794	0.0699	0.0587	0.0598	0.0712
0.7778	0.7380	0.6267	0.5849	0.7838	1.2851
0.3530	0.3827	0.3843	0.5848	0.9785	1.1732
5.5771	5.2225	4.6567	6.1903	10.2462	18.8975
0.5907	0.6392	0.6077	0.9224	1.4742	1.3809
0.1040	0.0879	0.0736	0.0577	0.0612	0.0774
0.1299	0.1230	0.1092	0.1270	0.1878	0.3018
0.4154	0.4389	0.4165	0.5690	0.9914	1.7224
1.7952	1.7459	1.7199	2.5683	4.1642	7.7988
0.4225	0.4488	0.4362	0.5521	0.8429	1.4300
0.4587	0.4046	0.3224	0.3634	0.5640	0.9715
1.4034	1.4427	1.3905	2.2245	4.0727	7.6347
0.6215	0.6463	0.6500	0.8938	1.5206	2.0967
nan nan nan nan nan nan
0.1369	0.1273	0.1089	0.1021	0.1045	0.1526
0.2220	0.2014	0.1646	0.1788	0.2134	0.2527
0.1784	0.1645	0.1491	0.1389	0.1654	0.2306
nan nan nan nan nan nan
31.2232	30.4709	34.1552	51.3987	86.7975	151.2304
67.2192	55.4290	54.2953	74.9127	114.4629	210.5076
0.3262	0.2973	0.2528	0.2654	0.3669	0.3874
2.5981	2.8999	3.1480	5.4999	9.9983	18.9666
0.3258	0.2836	0.2621	0.2416	0.3084	0.4810
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan ] ;

slu_solve_time_openblas = [
0.2384	0.2106	0.2380	0.1800	0.2061	0.1793
0.0437	0.0439	0.0433	0.0429	0.0417	0.0408
0.2935	0.2850	0.2783	0.2768	0.2683	0.2660
0.1668	0.1667	0.1668	0.1626	0.1577	0.1258
1.2254	1.1756	1.1698	1.1626	1.1531	1.1473
0.2021	0.2022	0.1993	0.1981	0.1874	0.1419
0.0477	0.0475	0.0477	0.0476	0.0477	0.0474
0.1135	0.1126	0.1121	0.1092	0.1065	0.1041
0.1863	0.1853	0.1799	0.1761	0.1737	0.1650
0.5218	0.5788	0.5773	0.5189	0.5643	0.5570
0.1719	0.1699	0.1694	0.1629	0.1551	0.1495
0.3313	0.3320	0.3277	0.3195	0.3117	0.3056
0.5149	0.5138	0.5118	0.5092	0.5077	0.5063
0.2382	0.2584	0.2595	0.2207	0.2168	0.1831
nan nan nan nan nan nan
0.1010	0.1014	0.1018	0.1013	0.1002	0.0985
0.1203	0.1445	0.1205	0.1206	0.1200	0.1439
0.1552	0.1555	0.1555	0.1540	0.1510	0.1492
nan nan nan nan nan nan
6.7655	6.7095	6.6361	6.5950	6.5669	6.5550
6.8609	6.8373	6.7818	6.7568	6.8104	6.6513
0.2192	0.2196	0.2195	0.2201	0.2199	0.2172
0.6477	0.6456	0.6437	0.6348	0.6295	0.6244
0.2911	0.2910	0.2904	0.2394	0.3344	0.2832
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan
nan nan nan nan nan nan ] ;

slu_total_time_openblas = slu_sym_time_openblas + slu_factor_time_openblas + slu_solve_time_openblas ;

%-------------------------------------------------------------------------------
% MUMPS: with AMD
% threads: 1, 2, 4, 8, 16 24 (backwards from paru, umf, and superlu results)
% Hamrle3 matrix fails
mumps_sym_time_amd = [
0.0081
0.0394
0.0690
0.1950
0.4165
0.3227
0.0618
0.1136
0.3708
0.5066
0.3928
0.0369
0.0464
0.3963
0.0847
0.1250
0.3125
0.2124
1.5260
nan     % Hamrle3 fails
0.6319
0.5618
0.7963
0.6285
1.8172
] ;

mumps_factor_time_amd = [
0.0423	0.0387	0.0294	0.0287	0.0308	0.0349
0.0366	0.0300	0.0321	0.0319	0.0664	0.3937
0.7395	0.4502	0.2714	0.2194	0.2497	0.2300
1.0521	0.7029	0.3997	0.3402	0.3391	0.3252
2.5669	1.6783	1.0408	0.8702	0.9367	1.0080
1.3672	0.8369	0.5202	0.3666	0.4179	0.4403
0.0838	0.0598	0.0483	0.0441	0.0511	0.0857
0.1062	0.1017	0.0629	0.0513	0.0428	0.0405
1.4350	0.8856	0.5617	0.4229	0.4949	0.4560
0.2297	0.1611	0.1057	0.1023	0.1044	0.1381
1.6848	1.0894	0.6757	0.5182	0.5144	0.5534
0.6128	0.4252	0.2661	0.2451	0.1862	0.2397
0.8963	0.5927	0.3658	0.2585	0.3179	0.3237
1.8313	1.1269	0.6830	0.5453	0.6129	0.5470
1.4537	1.1178	0.7096	0.4607	1.1112	1.2570
0.1708	0.1230	0.0981	0.0866	0.1003	0.1620
0.4447	0.2830	0.1977	0.1539	0.1751	0.1648
0.2652	0.1923	0.1491	0.1350	0.1591	0.2539
0.8097	0.5676	0.3569	0.2612	0.2688	0.2958
nan     nan     nan     nan     nan     nan     % Hamrle3 fails
8.1909	4.7682	2.7817	1.8888	2.1582	2.0466
0.8016	0.4848	0.3310	0.2476	0.2828	0.2565
0.9362	0.7701	0.6075	0.4465	0.4359	0.3975
0.9042	0.5737	0.3964	0.3237	0.3571	0.3993
2.7026	1.5737	1.0097	1.2282	0.9862	0.8774
] ;

mumps_solve_time_amd = [
0.0050	0.0042	0.0036	0.0034	0.0075	0.0045
0.0082	0.0072	0.0076	0.0081	0.0083	0.0101
0.0240	0.0188	0.0148	0.0145	0.0162	0.0260
0.0154	0.0122	0.0160	0.0129	0.0217	0.0233
0.0749	0.0567	0.0474	0.0440	0.0641	0.0833
0.0218	0.0136	0.0121	0.0132	0.0176	0.0350
0.0077	0.0073	0.0070	0.0074	0.0073	0.0127
0.0152	0.0130	0.0112	0.0101	0.0109	0.0127
0.0192	0.0149	0.0135	0.0148	0.0163	0.0584
0.0164	0.0111	0.0094	0.0095	0.0157	0.0256
0.0199	0.0158	0.0142	0.0152	0.0195	0.0318
0.0363	0.0264	0.0210	0.0193	0.0256	0.0426
0.0234	0.0179	0.0157	0.0151	0.0166	0.0246
0.0211	0.0192	0.0152	0.0169	0.0242	0.0398
0.0733	0.0582	0.0431	0.0353	0.0374	0.0464
0.0159	0.0141	0.0146	0.0148	0.0151	0.0166
0.0215	0.0203	0.0197	0.0205	0.0314	0.0520
0.0241	0.0226	0.0221	0.0217	0.0227	0.0296
0.0401	0.0305	0.0275	0.0258	0.0301	0.0333
nan     nan     nan     nan     nan     nan     % Hamrle3 fails
0.1257	0.0962	0.0785	0.0714	0.0791	0.0903
0.0327	0.0309	0.0299	0.0325	0.0425	0.0699
0.0437	0.0373	0.0350	0.0419	0.0376	0.0524
0.0433	0.0394	0.0395	0.0385	0.0635	0.1031
0.0755	0.0708	0.0751	0.0741	0.0959	0.1118
] ;

mumps_sym_time_amd    = mumps_sym_time_amd    (:, end:-1:1) ;
mumps_factor_time_amd = mumps_factor_time_amd (:, end:-1:1) ;
mumps_solve_time_amd  = mumps_solve_time_amd  (:, end:-1:1) ;

%-------------------------------------------------------------------------------
% MUMPS: with METIS
% threads: 1, 2, 4, 8, 16 24 (backwards from paru, umf, and superlu results)
% Hamrle3 matrix fails
mumps_sym_time_met = [
0.0562
0.2394
0.5808
0.4595
1.6099
0.3731
0.1767
0.5698
0.3868
0.8651
0.3924
0.7409
0.3172
0.3816
1.5104
0.3695
0.4529
0.6191
0.7000
nan     % Hamrle3 fails
3.1429
0.7181
1.4564
0.9593
1.6071
] ;

mumps_factor_time_met = [
0.0378	0.0348	0.0284	0.0249	0.0280	0.0311
0.0499	0.0423	0.0344	0.0294	0.0369	0.0547
0.7193	0.4469	0.3061	0.2454	0.2094	0.2069
0.9143	0.5707	0.3402	0.2366	0.3182	0.3331
0.8504	0.6375	0.3984	0.2900	0.2671	0.3095
0.9509	0.5803	0.3470	0.2829	0.2885	0.3096
0.1409	0.1004	0.0592	0.0759	0.0634	0.0711
0.0884	0.0845	0.0583	0.0623	0.0440	0.0324
0.8662	0.5367	0.3249	0.3093	0.3174	0.2951
0.2175	0.1513	0.1065	0.0786	0.0781	0.1247
0.9281	0.5936	0.3631	0.3268	0.2894	0.2627
0.5244	0.3699	0.2361	0.1599	0.1646	0.1705
0.5987	0.3990	0.2475	0.2015	0.2300	0.2792
1.0276	0.6678	0.4209	0.3666	0.3193	0.3405
1.2614	0.9359	0.6036	0.5098	0.9086	0.9756
0.2779	0.1885	0.1205	0.0977	0.1682	0.2255
0.7875	0.4821	0.2934	0.2025	0.2274	0.2121
0.4686	0.3269	0.2080	0.1834	0.1842	0.3125
1.8678	1.1341	0.6789	0.5018	0.5296	0.5021
nan     nan     nan     nan     nan     nan     % Hamrle3 fails
3.6481	2.1823	1.2998	0.8850	1.0580	1.0336
1.4784	0.8903	0.5254	0.3593	0.4523	0.4939
0.8215	0.5365	0.3327	0.2946	0.3242	0.3031
1.6103	0.9660	0.5901	0.4398	0.4363	0.4769
4.9967	2.8511	1.7158	1.1941	1.2361	1.2564
] ;

mumps_solve_time_met = [
0.0047	0.0041	0.0037	0.0032	0.0052	0.0049
0.0096	0.0084	0.0073	0.0067	0.0098	0.0095
0.0307	0.0251	0.0168	0.0151	0.0242	0.0376
0.0166	0.0136	0.0121	0.0137	0.0205	0.0327
0.0592	0.0448	0.0352	0.0305	0.0295	0.0333
0.0176	0.0144	0.0128	0.0145	0.0187	0.0447
0.0088	0.0077	0.0071	0.0081	0.0085	0.0156
0.0142	0.0127	0.0111	0.0124	0.0097	0.0098
0.0180	0.0148	0.0135	0.0149	0.0197	0.0314
0.0152	0.0122	0.0105	0.0100	0.0111	0.0261
0.0184	0.0150	0.0133	0.0145	0.0189	0.0351
0.0349	0.0261	0.0206	0.0177	0.0280	0.0431
0.0192	0.0149	0.0130	0.0127	0.0179	0.0236
0.0203	0.0166	0.0145	0.0168	0.0284	0.0339
0.0809	0.0650	0.0466	0.0378	0.0373	0.0605
0.0180	0.0156	0.0146	0.0145	0.0167	0.0254
0.0245	0.0220	0.0209	0.0209	0.0235	0.0283
0.0278	0.0244	0.0228	0.0220	0.0358	0.0477
0.0423	0.0351	0.0318	0.0301	0.0381	0.0474
nan     nan     nan     nan     nan     nan     % Hamrle3 fails
0.1343	0.1035	0.0859	0.0760	0.0845	0.1068
0.0374	0.0339	0.0323	0.0322	0.0438	0.0517
0.0468	0.0407	0.0366	0.0419	0.0427	0.0602
0.0490	0.0439	0.0416	0.0401	0.0480	0.0698
0.0864	0.0780	0.0753	0.0763	0.0806	0.0947
] ;

mumps_sym_time_met    = mumps_sym_time_met    (:, end:-1:1) ;
mumps_factor_time_met = mumps_factor_time_met (:, end:-1:1) ;
mumps_solve_time_met  = mumps_solve_time_met  (:, end:-1:1) ;

%-------------------------------------------------------------------------------
% factor time

figure (1)
clf (1)

% MKL only:
packages = packages (1:5) ;

packages = { 'umf+amd', 'umf+met', 'paru+amd', 'paru+met', 'superlu' , 'mumps+amd', 'mumps+met'} ;
s =        { 'ko:',      'ko-',    'ro:',      'ro-',      'go:'     , 'bo:'      , 'bo-'      } ;

% remove the RIM matrix from the plots:
% for k = 1:(nmats-2)
for k = 2:(nmats-2)

    % no longer considering openblas
    %{
    t = {   umf_factor_time_amd(k,:),
            umf_factor_time_met(k,:),
            paru_factor_time_amd(k,:),
            paru_factor_time_met(k,:),
            slu_factor_time(k,:)
            umf_factor_time_amd_openblas(k,:),
            umf_factor_time_met_openblas(k,:),
            paru_factor_time_amd_openblas(k,:),
            paru_factor_time_met_openblas(k,:),
            slu_factor_time_openblas(k,:)
            } ;
    %}

    % just MKL:
    t = {   umf_factor_time_amd(k,:),
            umf_factor_time_met(k,:),
            paru_factor_time_amd(k,:),
            paru_factor_time_met(k,:),
            slu_factor_time(k,:),
            mumps_factor_time_amd(k,:),
            mumps_factor_time_met(k,:)
            } ;

    name = matrices {k}
%   subplot (5,5,k) ;
    subplot (6,4,k-1) ;
    hold on
    what_result = 'factor' ;
    what_result = [ ] ;
    subplot_one_matrix (matrices{k}, what_result, packages, t, threads, 1, s) ;
%   if (k == 1)
%       legend (packages, 'Location', 'NorthWestOutside') ;
%   end
end

%-------------------------------------------------------------------------------
% all time

%{
for k = 1:(nmats-2)
    t = {   umf_total_time_amd(k,:),
            umf_total_time_met(k,:),
            paru_total_time_amd(k,:),
            paru_total_time_met(k,:),
            slu_total_time(k,:) } ;
    name = matrices {k}
    plot_one_matrix (fg, matrices{k}, 'all', packages, t, threads, 1) ;
    fg = fg + 1 ;
end
%}

