#! /usr/bin/env bash
# Libvisual - The audio visualisation framework.
#
# Copyright (C) 2023 Libvisual team
#
# Authors: Sebastian Pipping <sebastian@pipping.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as
# published by the Free Software Foundation; either version 2.1
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

set -e -u -o pipefail

_BUILD_MONTH=2023-03  # for reproducible builds; bump when doing releases

help2man_args=(
    --no-info
    --name 'Command-line tool to interact with Libvisual'
    lv-tool-0.4
)
sed_args=(
    # Be robust towards version difference between local help2man and CI help2man
    -e 's,It was generated by help2man .*,It was generated by help2man.,'

    # Improve formatting of values in "--arg <value>"
    -e 's, <\([^>]\+\)>,\\ \\c\n.IR \1 ,g'

    # Fix lack of space after comma in e.g. "--input input,-i input"
    -e 's|, |,\\ |g'
)

SOURCE_DATE_EPOCH="$(date --date="${_BUILD_MONTH}-15" +%s)" \
    help2man "${help2man_args[@]}" \
    | sed "${sed_args[@]}" \
    > lv-tool-0.4.1
