// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// REQUIRES: riscv-registered-target
// RUN: %clang_cc1 -triple riscv64 -target-feature +zve64x \
// RUN:   -target-feature +xandesvpackfph -disable-O0-optnone  \
// RUN:   -emit-llvm %s -o - | opt -S -passes=mem2reg | \
// RUN:   FileCheck --check-prefix=CHECK-RV64 %s

#include <andes_vector.h>

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16mf4_tu(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x half> @llvm.riscv.nds.vfpmadt.nxv1f16.f32.i64(<vscale x 1 x half> [[MASKEDOFF:%.*]], <vscale x 1 x half> [[OP1:%.*]], float [[OP2:%.*]], i64 7, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x half> [[TMP0]]
//
vfloat16mf4_t test_nds_vfpmadt_vf_f16mf4_tu(vfloat16mf4_t maskedoff, vfloat16mf4_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_tu(maskedoff, op1, op2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16mf2_tu(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x half> @llvm.riscv.nds.vfpmadt.nxv2f16.f32.i64(<vscale x 2 x half> [[MASKEDOFF:%.*]], <vscale x 2 x half> [[OP1:%.*]], float [[OP2:%.*]], i64 7, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x half> [[TMP0]]
//
vfloat16mf2_t test_nds_vfpmadt_vf_f16mf2_tu(vfloat16mf2_t maskedoff, vfloat16mf2_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_tu(maskedoff, op1, op2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m1_tu(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x half> @llvm.riscv.nds.vfpmadt.nxv4f16.f32.i64(<vscale x 4 x half> [[MASKEDOFF:%.*]], <vscale x 4 x half> [[OP1:%.*]], float [[OP2:%.*]], i64 7, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x half> [[TMP0]]
//
vfloat16m1_t test_nds_vfpmadt_vf_f16m1_tu(vfloat16m1_t maskedoff, vfloat16m1_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_tu(maskedoff, op1, op2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m2_tu(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x half> @llvm.riscv.nds.vfpmadt.nxv8f16.f32.i64(<vscale x 8 x half> [[MASKEDOFF:%.*]], <vscale x 8 x half> [[OP1:%.*]], float [[OP2:%.*]], i64 7, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
vfloat16m2_t test_nds_vfpmadt_vf_f16m2_tu(vfloat16m2_t maskedoff, vfloat16m2_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_tu(maskedoff, op1, op2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m4_tu(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x half> @llvm.riscv.nds.vfpmadt.nxv16f16.f32.i64(<vscale x 16 x half> [[MASKEDOFF:%.*]], <vscale x 16 x half> [[OP1:%.*]], float [[OP2:%.*]], i64 7, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
vfloat16m4_t test_nds_vfpmadt_vf_f16m4_tu(vfloat16m4_t maskedoff, vfloat16m4_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_tu(maskedoff, op1, op2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m8_tu(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x half> @llvm.riscv.nds.vfpmadt.nxv32f16.f32.i64(<vscale x 32 x half> [[MASKEDOFF:%.*]], <vscale x 32 x half> [[OP1:%.*]], float [[OP2:%.*]], i64 7, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
vfloat16m8_t test_nds_vfpmadt_vf_f16m8_tu(vfloat16m8_t maskedoff, vfloat16m8_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_tu(maskedoff, op1, op2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16mf4_tum(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x half> @llvm.riscv.nds.vfpmadt.mask.nxv1f16.f32.i64(<vscale x 1 x half> [[MASKEDOFF:%.*]], <vscale x 1 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 7, i64 [[VL:%.*]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 1 x half> [[TMP0]]
//
vfloat16mf4_t test_nds_vfpmadt_vf_f16mf4_tum(vbool64_t mask, vfloat16mf4_t maskedoff, vfloat16mf4_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_tum(mask, maskedoff, op1, op2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16mf2_tum(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x half> @llvm.riscv.nds.vfpmadt.mask.nxv2f16.f32.i64(<vscale x 2 x half> [[MASKEDOFF:%.*]], <vscale x 2 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 7, i64 [[VL:%.*]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 2 x half> [[TMP0]]
//
vfloat16mf2_t test_nds_vfpmadt_vf_f16mf2_tum(vbool32_t mask, vfloat16mf2_t maskedoff, vfloat16mf2_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_tum(mask, maskedoff, op1, op2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m1_tum(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x half> @llvm.riscv.nds.vfpmadt.mask.nxv4f16.f32.i64(<vscale x 4 x half> [[MASKEDOFF:%.*]], <vscale x 4 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 7, i64 [[VL:%.*]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 4 x half> [[TMP0]]
//
vfloat16m1_t test_nds_vfpmadt_vf_f16m1_tum(vbool16_t mask, vfloat16m1_t maskedoff, vfloat16m1_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_tum(mask, maskedoff, op1, op2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m2_tum(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x half> @llvm.riscv.nds.vfpmadt.mask.nxv8f16.f32.i64(<vscale x 8 x half> [[MASKEDOFF:%.*]], <vscale x 8 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 7, i64 [[VL:%.*]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
vfloat16m2_t test_nds_vfpmadt_vf_f16m2_tum(vbool8_t mask, vfloat16m2_t maskedoff, vfloat16m2_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_tum(mask, maskedoff, op1, op2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m4_tum(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x half> @llvm.riscv.nds.vfpmadt.mask.nxv16f16.f32.i64(<vscale x 16 x half> [[MASKEDOFF:%.*]], <vscale x 16 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 16 x i1> [[MASK:%.*]], i64 7, i64 [[VL:%.*]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
vfloat16m4_t test_nds_vfpmadt_vf_f16m4_tum(vbool4_t mask, vfloat16m4_t maskedoff, vfloat16m4_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_tum(mask, maskedoff, op1, op2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m8_tum(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x half> @llvm.riscv.nds.vfpmadt.mask.nxv32f16.f32.i64(<vscale x 32 x half> [[MASKEDOFF:%.*]], <vscale x 32 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 32 x i1> [[MASK:%.*]], i64 7, i64 [[VL:%.*]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
vfloat16m8_t test_nds_vfpmadt_vf_f16m8_tum(vbool2_t mask, vfloat16m8_t maskedoff, vfloat16m8_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_tum(mask, maskedoff, op1, op2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16mf4_tumu(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x half> @llvm.riscv.nds.vfpmadt.mask.nxv1f16.f32.i64(<vscale x 1 x half> [[MASKEDOFF:%.*]], <vscale x 1 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 7, i64 [[VL:%.*]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 1 x half> [[TMP0]]
//
vfloat16mf4_t test_nds_vfpmadt_vf_f16mf4_tumu(vbool64_t mask, vfloat16mf4_t maskedoff, vfloat16mf4_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_tumu(mask, maskedoff, op1, op2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16mf2_tumu(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x half> @llvm.riscv.nds.vfpmadt.mask.nxv2f16.f32.i64(<vscale x 2 x half> [[MASKEDOFF:%.*]], <vscale x 2 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 7, i64 [[VL:%.*]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 2 x half> [[TMP0]]
//
vfloat16mf2_t test_nds_vfpmadt_vf_f16mf2_tumu(vbool32_t mask, vfloat16mf2_t maskedoff, vfloat16mf2_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_tumu(mask, maskedoff, op1, op2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m1_tumu(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x half> @llvm.riscv.nds.vfpmadt.mask.nxv4f16.f32.i64(<vscale x 4 x half> [[MASKEDOFF:%.*]], <vscale x 4 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 7, i64 [[VL:%.*]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 4 x half> [[TMP0]]
//
vfloat16m1_t test_nds_vfpmadt_vf_f16m1_tumu(vbool16_t mask, vfloat16m1_t maskedoff, vfloat16m1_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_tumu(mask, maskedoff, op1, op2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m2_tumu(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x half> @llvm.riscv.nds.vfpmadt.mask.nxv8f16.f32.i64(<vscale x 8 x half> [[MASKEDOFF:%.*]], <vscale x 8 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 7, i64 [[VL:%.*]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
vfloat16m2_t test_nds_vfpmadt_vf_f16m2_tumu(vbool8_t mask, vfloat16m2_t maskedoff, vfloat16m2_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_tumu(mask, maskedoff, op1, op2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m4_tumu(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x half> @llvm.riscv.nds.vfpmadt.mask.nxv16f16.f32.i64(<vscale x 16 x half> [[MASKEDOFF:%.*]], <vscale x 16 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 16 x i1> [[MASK:%.*]], i64 7, i64 [[VL:%.*]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
vfloat16m4_t test_nds_vfpmadt_vf_f16m4_tumu(vbool4_t mask, vfloat16m4_t maskedoff, vfloat16m4_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_tumu(mask, maskedoff, op1, op2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m8_tumu(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x half> @llvm.riscv.nds.vfpmadt.mask.nxv32f16.f32.i64(<vscale x 32 x half> [[MASKEDOFF:%.*]], <vscale x 32 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 32 x i1> [[MASK:%.*]], i64 7, i64 [[VL:%.*]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
vfloat16m8_t test_nds_vfpmadt_vf_f16m8_tumu(vbool2_t mask, vfloat16m8_t maskedoff, vfloat16m8_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_tumu(mask, maskedoff, op1, op2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16mf4_mu(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x half> @llvm.riscv.nds.vfpmadt.mask.nxv1f16.f32.i64(<vscale x 1 x half> [[MASKEDOFF:%.*]], <vscale x 1 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 7, i64 [[VL:%.*]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 1 x half> [[TMP0]]
//
vfloat16mf4_t test_nds_vfpmadt_vf_f16mf4_mu(vbool64_t mask, vfloat16mf4_t maskedoff, vfloat16mf4_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_mu(mask, maskedoff, op1, op2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16mf2_mu(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x half> @llvm.riscv.nds.vfpmadt.mask.nxv2f16.f32.i64(<vscale x 2 x half> [[MASKEDOFF:%.*]], <vscale x 2 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 7, i64 [[VL:%.*]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 2 x half> [[TMP0]]
//
vfloat16mf2_t test_nds_vfpmadt_vf_f16mf2_mu(vbool32_t mask, vfloat16mf2_t maskedoff, vfloat16mf2_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_mu(mask, maskedoff, op1, op2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m1_mu(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x half> @llvm.riscv.nds.vfpmadt.mask.nxv4f16.f32.i64(<vscale x 4 x half> [[MASKEDOFF:%.*]], <vscale x 4 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 7, i64 [[VL:%.*]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 4 x half> [[TMP0]]
//
vfloat16m1_t test_nds_vfpmadt_vf_f16m1_mu(vbool16_t mask, vfloat16m1_t maskedoff, vfloat16m1_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_mu(mask, maskedoff, op1, op2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m2_mu(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x half> @llvm.riscv.nds.vfpmadt.mask.nxv8f16.f32.i64(<vscale x 8 x half> [[MASKEDOFF:%.*]], <vscale x 8 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 7, i64 [[VL:%.*]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
vfloat16m2_t test_nds_vfpmadt_vf_f16m2_mu(vbool8_t mask, vfloat16m2_t maskedoff, vfloat16m2_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_mu(mask, maskedoff, op1, op2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m4_mu(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x half> @llvm.riscv.nds.vfpmadt.mask.nxv16f16.f32.i64(<vscale x 16 x half> [[MASKEDOFF:%.*]], <vscale x 16 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 16 x i1> [[MASK:%.*]], i64 7, i64 [[VL:%.*]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
vfloat16m4_t test_nds_vfpmadt_vf_f16m4_mu(vbool4_t mask, vfloat16m4_t maskedoff, vfloat16m4_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_mu(mask, maskedoff, op1, op2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m8_mu(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x half> @llvm.riscv.nds.vfpmadt.mask.nxv32f16.f32.i64(<vscale x 32 x half> [[MASKEDOFF:%.*]], <vscale x 32 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 32 x i1> [[MASK:%.*]], i64 7, i64 [[VL:%.*]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
vfloat16m8_t test_nds_vfpmadt_vf_f16m8_mu(vbool2_t mask, vfloat16m8_t maskedoff, vfloat16m8_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_mu(mask, maskedoff, op1, op2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16mf4_rm_tu(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x half> @llvm.riscv.nds.vfpmadt.nxv1f16.f32.i64(<vscale x 1 x half> [[MASKEDOFF:%.*]], <vscale x 1 x half> [[OP1:%.*]], float [[OP2:%.*]], i64 0, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x half> [[TMP0]]
//
vfloat16mf4_t test_nds_vfpmadt_vf_f16mf4_rm_tu(vfloat16mf4_t maskedoff, vfloat16mf4_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_tu(maskedoff, op1, op2, __RISCV_FRM_RNE, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16mf2_rm_tu(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x half> @llvm.riscv.nds.vfpmadt.nxv2f16.f32.i64(<vscale x 2 x half> [[MASKEDOFF:%.*]], <vscale x 2 x half> [[OP1:%.*]], float [[OP2:%.*]], i64 0, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x half> [[TMP0]]
//
vfloat16mf2_t test_nds_vfpmadt_vf_f16mf2_rm_tu(vfloat16mf2_t maskedoff, vfloat16mf2_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_tu(maskedoff, op1, op2, __RISCV_FRM_RNE, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m1_rm_tu(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x half> @llvm.riscv.nds.vfpmadt.nxv4f16.f32.i64(<vscale x 4 x half> [[MASKEDOFF:%.*]], <vscale x 4 x half> [[OP1:%.*]], float [[OP2:%.*]], i64 0, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x half> [[TMP0]]
//
vfloat16m1_t test_nds_vfpmadt_vf_f16m1_rm_tu(vfloat16m1_t maskedoff, vfloat16m1_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_tu(maskedoff, op1, op2, __RISCV_FRM_RNE, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m2_rm_tu(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x half> @llvm.riscv.nds.vfpmadt.nxv8f16.f32.i64(<vscale x 8 x half> [[MASKEDOFF:%.*]], <vscale x 8 x half> [[OP1:%.*]], float [[OP2:%.*]], i64 0, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
vfloat16m2_t test_nds_vfpmadt_vf_f16m2_rm_tu(vfloat16m2_t maskedoff, vfloat16m2_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_tu(maskedoff, op1, op2, __RISCV_FRM_RNE, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m4_rm_tu(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x half> @llvm.riscv.nds.vfpmadt.nxv16f16.f32.i64(<vscale x 16 x half> [[MASKEDOFF:%.*]], <vscale x 16 x half> [[OP1:%.*]], float [[OP2:%.*]], i64 0, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
vfloat16m4_t test_nds_vfpmadt_vf_f16m4_rm_tu(vfloat16m4_t maskedoff, vfloat16m4_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_tu(maskedoff, op1, op2, __RISCV_FRM_RNE, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m8_rm_tu(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x half> @llvm.riscv.nds.vfpmadt.nxv32f16.f32.i64(<vscale x 32 x half> [[MASKEDOFF:%.*]], <vscale x 32 x half> [[OP1:%.*]], float [[OP2:%.*]], i64 0, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
vfloat16m8_t test_nds_vfpmadt_vf_f16m8_rm_tu(vfloat16m8_t maskedoff, vfloat16m8_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_tu(maskedoff, op1, op2, __RISCV_FRM_RNE, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16mf4_rm_tum(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x half> @llvm.riscv.nds.vfpmadt.mask.nxv1f16.f32.i64(<vscale x 1 x half> [[MASKEDOFF:%.*]], <vscale x 1 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 0, i64 [[VL:%.*]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 1 x half> [[TMP0]]
//
vfloat16mf4_t test_nds_vfpmadt_vf_f16mf4_rm_tum(vbool64_t mask, vfloat16mf4_t maskedoff, vfloat16mf4_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_tum(mask, maskedoff, op1, op2, __RISCV_FRM_RNE, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16mf2_rm_tum(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x half> @llvm.riscv.nds.vfpmadt.mask.nxv2f16.f32.i64(<vscale x 2 x half> [[MASKEDOFF:%.*]], <vscale x 2 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 0, i64 [[VL:%.*]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 2 x half> [[TMP0]]
//
vfloat16mf2_t test_nds_vfpmadt_vf_f16mf2_rm_tum(vbool32_t mask, vfloat16mf2_t maskedoff, vfloat16mf2_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_tum(mask, maskedoff, op1, op2, __RISCV_FRM_RNE, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m1_rm_tum(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x half> @llvm.riscv.nds.vfpmadt.mask.nxv4f16.f32.i64(<vscale x 4 x half> [[MASKEDOFF:%.*]], <vscale x 4 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 0, i64 [[VL:%.*]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 4 x half> [[TMP0]]
//
vfloat16m1_t test_nds_vfpmadt_vf_f16m1_rm_tum(vbool16_t mask, vfloat16m1_t maskedoff, vfloat16m1_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_tum(mask, maskedoff, op1, op2, __RISCV_FRM_RNE, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m2_rm_tum(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x half> @llvm.riscv.nds.vfpmadt.mask.nxv8f16.f32.i64(<vscale x 8 x half> [[MASKEDOFF:%.*]], <vscale x 8 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 0, i64 [[VL:%.*]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
vfloat16m2_t test_nds_vfpmadt_vf_f16m2_rm_tum(vbool8_t mask, vfloat16m2_t maskedoff, vfloat16m2_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_tum(mask, maskedoff, op1, op2, __RISCV_FRM_RNE, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m4_rm_tum(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x half> @llvm.riscv.nds.vfpmadt.mask.nxv16f16.f32.i64(<vscale x 16 x half> [[MASKEDOFF:%.*]], <vscale x 16 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 16 x i1> [[MASK:%.*]], i64 0, i64 [[VL:%.*]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
vfloat16m4_t test_nds_vfpmadt_vf_f16m4_rm_tum(vbool4_t mask, vfloat16m4_t maskedoff, vfloat16m4_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_tum(mask, maskedoff, op1, op2, __RISCV_FRM_RNE, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m8_rm_tum(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x half> @llvm.riscv.nds.vfpmadt.mask.nxv32f16.f32.i64(<vscale x 32 x half> [[MASKEDOFF:%.*]], <vscale x 32 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 32 x i1> [[MASK:%.*]], i64 0, i64 [[VL:%.*]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
vfloat16m8_t test_nds_vfpmadt_vf_f16m8_rm_tum(vbool2_t mask, vfloat16m8_t maskedoff, vfloat16m8_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_tum(mask, maskedoff, op1, op2, __RISCV_FRM_RNE, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16mf4_rm_tumu(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x half> @llvm.riscv.nds.vfpmadt.mask.nxv1f16.f32.i64(<vscale x 1 x half> [[MASKEDOFF:%.*]], <vscale x 1 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 0, i64 [[VL:%.*]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 1 x half> [[TMP0]]
//
vfloat16mf4_t test_nds_vfpmadt_vf_f16mf4_rm_tumu(vbool64_t mask, vfloat16mf4_t maskedoff, vfloat16mf4_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_tumu(mask, maskedoff, op1, op2, __RISCV_FRM_RNE, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16mf2_rm_tumu(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x half> @llvm.riscv.nds.vfpmadt.mask.nxv2f16.f32.i64(<vscale x 2 x half> [[MASKEDOFF:%.*]], <vscale x 2 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 0, i64 [[VL:%.*]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 2 x half> [[TMP0]]
//
vfloat16mf2_t test_nds_vfpmadt_vf_f16mf2_rm_tumu(vbool32_t mask, vfloat16mf2_t maskedoff, vfloat16mf2_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_tumu(mask, maskedoff, op1, op2, __RISCV_FRM_RNE, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m1_rm_tumu(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x half> @llvm.riscv.nds.vfpmadt.mask.nxv4f16.f32.i64(<vscale x 4 x half> [[MASKEDOFF:%.*]], <vscale x 4 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 0, i64 [[VL:%.*]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 4 x half> [[TMP0]]
//
vfloat16m1_t test_nds_vfpmadt_vf_f16m1_rm_tumu(vbool16_t mask, vfloat16m1_t maskedoff, vfloat16m1_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_tumu(mask, maskedoff, op1, op2, __RISCV_FRM_RNE, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m2_rm_tumu(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x half> @llvm.riscv.nds.vfpmadt.mask.nxv8f16.f32.i64(<vscale x 8 x half> [[MASKEDOFF:%.*]], <vscale x 8 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 0, i64 [[VL:%.*]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
vfloat16m2_t test_nds_vfpmadt_vf_f16m2_rm_tumu(vbool8_t mask, vfloat16m2_t maskedoff, vfloat16m2_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_tumu(mask, maskedoff, op1, op2, __RISCV_FRM_RNE, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m4_rm_tumu(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x half> @llvm.riscv.nds.vfpmadt.mask.nxv16f16.f32.i64(<vscale x 16 x half> [[MASKEDOFF:%.*]], <vscale x 16 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 16 x i1> [[MASK:%.*]], i64 0, i64 [[VL:%.*]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
vfloat16m4_t test_nds_vfpmadt_vf_f16m4_rm_tumu(vbool4_t mask, vfloat16m4_t maskedoff, vfloat16m4_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_tumu(mask, maskedoff, op1, op2, __RISCV_FRM_RNE, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m8_rm_tumu(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x half> @llvm.riscv.nds.vfpmadt.mask.nxv32f16.f32.i64(<vscale x 32 x half> [[MASKEDOFF:%.*]], <vscale x 32 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 32 x i1> [[MASK:%.*]], i64 0, i64 [[VL:%.*]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
vfloat16m8_t test_nds_vfpmadt_vf_f16m8_rm_tumu(vbool2_t mask, vfloat16m8_t maskedoff, vfloat16m8_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_tumu(mask, maskedoff, op1, op2, __RISCV_FRM_RNE, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16mf4_rm_mu(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x half> @llvm.riscv.nds.vfpmadt.mask.nxv1f16.f32.i64(<vscale x 1 x half> [[MASKEDOFF:%.*]], <vscale x 1 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 0, i64 [[VL:%.*]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 1 x half> [[TMP0]]
//
vfloat16mf4_t test_nds_vfpmadt_vf_f16mf4_rm_mu(vbool64_t mask, vfloat16mf4_t maskedoff, vfloat16mf4_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_mu(mask, maskedoff, op1, op2, __RISCV_FRM_RNE, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16mf2_rm_mu(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x half> @llvm.riscv.nds.vfpmadt.mask.nxv2f16.f32.i64(<vscale x 2 x half> [[MASKEDOFF:%.*]], <vscale x 2 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 0, i64 [[VL:%.*]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 2 x half> [[TMP0]]
//
vfloat16mf2_t test_nds_vfpmadt_vf_f16mf2_rm_mu(vbool32_t mask, vfloat16mf2_t maskedoff, vfloat16mf2_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_mu(mask, maskedoff, op1, op2, __RISCV_FRM_RNE, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m1_rm_mu(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x half> @llvm.riscv.nds.vfpmadt.mask.nxv4f16.f32.i64(<vscale x 4 x half> [[MASKEDOFF:%.*]], <vscale x 4 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 0, i64 [[VL:%.*]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 4 x half> [[TMP0]]
//
vfloat16m1_t test_nds_vfpmadt_vf_f16m1_rm_mu(vbool16_t mask, vfloat16m1_t maskedoff, vfloat16m1_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_mu(mask, maskedoff, op1, op2, __RISCV_FRM_RNE, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m2_rm_mu(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x half> @llvm.riscv.nds.vfpmadt.mask.nxv8f16.f32.i64(<vscale x 8 x half> [[MASKEDOFF:%.*]], <vscale x 8 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 0, i64 [[VL:%.*]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
vfloat16m2_t test_nds_vfpmadt_vf_f16m2_rm_mu(vbool8_t mask, vfloat16m2_t maskedoff, vfloat16m2_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_mu(mask, maskedoff, op1, op2, __RISCV_FRM_RNE, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m4_rm_mu(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x half> @llvm.riscv.nds.vfpmadt.mask.nxv16f16.f32.i64(<vscale x 16 x half> [[MASKEDOFF:%.*]], <vscale x 16 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 16 x i1> [[MASK:%.*]], i64 0, i64 [[VL:%.*]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
vfloat16m4_t test_nds_vfpmadt_vf_f16m4_rm_mu(vbool4_t mask, vfloat16m4_t maskedoff, vfloat16m4_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_mu(mask, maskedoff, op1, op2, __RISCV_FRM_RNE, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m8_rm_mu(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x half> @llvm.riscv.nds.vfpmadt.mask.nxv32f16.f32.i64(<vscale x 32 x half> [[MASKEDOFF:%.*]], <vscale x 32 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 32 x i1> [[MASK:%.*]], i64 0, i64 [[VL:%.*]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
vfloat16m8_t test_nds_vfpmadt_vf_f16m8_rm_mu(vbool2_t mask, vfloat16m8_t maskedoff, vfloat16m8_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt_mu(mask, maskedoff, op1, op2, __RISCV_FRM_RNE, vl);
}
