/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGLengthList.h"

#include "JSSVGLength.h"
#include "JSSVGPODListCustom.h"
#include "SVGLength.h"
#include "SVGLengthList.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGLengthList);

/* Hash table */

static const HashTableValue JSSVGLengthListTableValues[3] =
{
    { "numberOfItems", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthListNumberOfItems), (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthListConstructor), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGLengthListTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSSVGLengthListTableValues, 0 };
#else
    { 4, 3, JSSVGLengthListTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSSVGLengthListConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGLengthListConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGLengthListConstructorTableValues, 0 };
#else
    { 1, 0, JSSVGLengthListConstructorTableValues, 0 };
#endif

class JSSVGLengthListConstructor : public DOMConstructorObject {
public:
    JSSVGLengthListConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSSVGLengthListConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSSVGLengthListPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGLengthListConstructor::s_info = { "SVGLengthListConstructor", 0, &JSSVGLengthListConstructorTable, 0 };

bool JSSVGLengthListConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGLengthListConstructor, DOMObject>(exec, &JSSVGLengthListConstructorTable, this, propertyName, slot);
}

bool JSSVGLengthListConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGLengthListConstructor, DOMObject>(exec, &JSSVGLengthListConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGLengthListPrototypeTableValues[8] =
{
    { "clear", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsSVGLengthListPrototypeFunctionClear), (intptr_t)0 },
    { "initialize", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsSVGLengthListPrototypeFunctionInitialize), (intptr_t)1 },
    { "getItem", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsSVGLengthListPrototypeFunctionGetItem), (intptr_t)1 },
    { "insertItemBefore", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsSVGLengthListPrototypeFunctionInsertItemBefore), (intptr_t)2 },
    { "replaceItem", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsSVGLengthListPrototypeFunctionReplaceItem), (intptr_t)2 },
    { "removeItem", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsSVGLengthListPrototypeFunctionRemoveItem), (intptr_t)1 },
    { "appendItem", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsSVGLengthListPrototypeFunctionAppendItem), (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGLengthListPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 63, JSSVGLengthListPrototypeTableValues, 0 };
#else
    { 18, 15, JSSVGLengthListPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGLengthListPrototype::s_info = { "SVGLengthListPrototype", 0, &JSSVGLengthListPrototypeTable, 0 };

JSObject* JSSVGLengthListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGLengthList>(exec, globalObject);
}

bool JSSVGLengthListPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGLengthListPrototypeTable, this, propertyName, slot);
}

bool JSSVGLengthListPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGLengthListPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGLengthList::s_info = { "SVGLengthList", 0, &JSSVGLengthListTable, 0 };

JSSVGLengthList::JSSVGLengthList(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGLengthList> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSSVGLengthList::~JSSVGLengthList()
{
    forgetDOMObject(this, impl());
    JSSVGContextCache::forgetWrapper(this);
}

JSObject* JSSVGLengthList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGLengthListPrototype(JSSVGLengthListPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSSVGLengthList::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGLengthList, Base>(exec, &JSSVGLengthListTable, this, propertyName, slot);
}

bool JSSVGLengthList::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGLengthList, Base>(exec, &JSSVGLengthListTable, this, propertyName, descriptor);
}

JSValue jsSVGLengthListNumberOfItems(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGLengthList* castedThis = static_cast<JSSVGLengthList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGLengthList* imp = static_cast<SVGLengthList*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->numberOfItems());
    return result;
}

JSValue jsSVGLengthListConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGLengthList* domObject = static_cast<JSSVGLengthList*>(asObject(slotBase));
    return JSSVGLengthList::getConstructor(exec, domObject->globalObject());
}
JSValue JSSVGLengthList::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGLengthListConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsSVGLengthListPrototypeFunctionClear(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGLengthList::s_info))
        return throwError(exec, TypeError);
    JSSVGLengthList* castedThisObj = static_cast<JSSVGLengthList*>(asObject(thisValue));
    return JSSVGPODListCustom::clear<JSSVGLengthList, SVGLength>(castedThisObj, exec, args, toSVGLength);
}

JSValue JSC_HOST_CALL jsSVGLengthListPrototypeFunctionInitialize(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGLengthList::s_info))
        return throwError(exec, TypeError);
    JSSVGLengthList* castedThisObj = static_cast<JSSVGLengthList*>(asObject(thisValue));
    return JSSVGPODListCustom::initialize<JSSVGLengthList, SVGLength>(castedThisObj, exec, args, toSVGLength);
}

JSValue JSC_HOST_CALL jsSVGLengthListPrototypeFunctionGetItem(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGLengthList::s_info))
        return throwError(exec, TypeError);
    JSSVGLengthList* castedThisObj = static_cast<JSSVGLengthList*>(asObject(thisValue));
    return JSSVGPODListCustom::getItem<JSSVGLengthList, SVGLength>(castedThisObj, exec, args, toSVGLength);
}

JSValue JSC_HOST_CALL jsSVGLengthListPrototypeFunctionInsertItemBefore(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGLengthList::s_info))
        return throwError(exec, TypeError);
    JSSVGLengthList* castedThisObj = static_cast<JSSVGLengthList*>(asObject(thisValue));
    return JSSVGPODListCustom::insertItemBefore<JSSVGLengthList, SVGLength>(castedThisObj, exec, args, toSVGLength);
}

JSValue JSC_HOST_CALL jsSVGLengthListPrototypeFunctionReplaceItem(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGLengthList::s_info))
        return throwError(exec, TypeError);
    JSSVGLengthList* castedThisObj = static_cast<JSSVGLengthList*>(asObject(thisValue));
    return JSSVGPODListCustom::replaceItem<JSSVGLengthList, SVGLength>(castedThisObj, exec, args, toSVGLength);
}

JSValue JSC_HOST_CALL jsSVGLengthListPrototypeFunctionRemoveItem(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGLengthList::s_info))
        return throwError(exec, TypeError);
    JSSVGLengthList* castedThisObj = static_cast<JSSVGLengthList*>(asObject(thisValue));
    return JSSVGPODListCustom::removeItem<JSSVGLengthList, SVGLength>(castedThisObj, exec, args, toSVGLength);
}

JSValue JSC_HOST_CALL jsSVGLengthListPrototypeFunctionAppendItem(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGLengthList::s_info))
        return throwError(exec, TypeError);
    JSSVGLengthList* castedThisObj = static_cast<JSSVGLengthList*>(asObject(thisValue));
    return JSSVGPODListCustom::appendItem<JSSVGLengthList, SVGLength>(castedThisObj, exec, args, toSVGLength);
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGLengthList* object, SVGElement* context)
{
    return getDOMObjectWrapper<JSSVGLengthList>(exec, globalObject, object, context);
}
SVGLengthList* toSVGLengthList(JSC::JSValue value)
{
    return value.inherits(&JSSVGLengthList::s_info) ? static_cast<JSSVGLengthList*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
