/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSXMLHttpRequest_h
#define JSXMLHttpRequest_h

#include "JSDOMBinding.h"
#include <runtime/JSGlobalObject.h>
#include <runtime/ObjectPrototype.h>

namespace WebCore {

class XMLHttpRequest;

class JSXMLHttpRequest : public DOMObject {
    typedef DOMObject Base;
public:
    JSXMLHttpRequest(PassRefPtr<JSC::Structure>, PassRefPtr<XMLHttpRequest>);
    virtual ~JSXMLHttpRequest();
    static JSC::JSObject* createPrototype(JSC::ExecState*);
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertySlot&);
    virtual void put(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::JSValuePtr, JSC::PutPropertySlot&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;

    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValuePtr prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType));
    }

    virtual void mark();


    // Custom attributes
    JSC::JSValuePtr responseText(JSC::ExecState*) const;

    // Custom functions
    JSC::JSValuePtr open(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValuePtr setRequestHeader(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValuePtr send(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValuePtr getResponseHeader(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValuePtr overrideMimeType(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValuePtr addEventListener(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValuePtr removeEventListener(JSC::ExecState*, const JSC::ArgList&);
    XMLHttpRequest* impl() const { return m_impl.get(); }

private:
    RefPtr<XMLHttpRequest> m_impl;
};

JSC::JSValuePtr toJS(JSC::ExecState*, XMLHttpRequest*);
XMLHttpRequest* toXMLHttpRequest(JSC::JSValuePtr);

class JSXMLHttpRequestPrototype : public JSC::JSObject {
public:
    static JSC::JSObject* self(JSC::ExecState*);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValuePtr prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType));
    }
    JSXMLHttpRequestPrototype(PassRefPtr<JSC::Structure> structure) : JSC::JSObject(structure) { }
};

// Functions

JSC::JSValuePtr jsXMLHttpRequestPrototypeFunctionOpen(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsXMLHttpRequestPrototypeFunctionSetRequestHeader(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsXMLHttpRequestPrototypeFunctionSend(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsXMLHttpRequestPrototypeFunctionAbort(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsXMLHttpRequestPrototypeFunctionGetAllResponseHeaders(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsXMLHttpRequestPrototypeFunctionGetResponseHeader(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsXMLHttpRequestPrototypeFunctionOverrideMimeType(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsXMLHttpRequestPrototypeFunctionAddEventListener(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsXMLHttpRequestPrototypeFunctionRemoveEventListener(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsXMLHttpRequestPrototypeFunctionDispatchEvent(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
// Attributes

JSC::JSValuePtr jsXMLHttpRequestOnabort(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSXMLHttpRequestOnabort(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsXMLHttpRequestOnerror(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSXMLHttpRequestOnerror(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsXMLHttpRequestOnload(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSXMLHttpRequestOnload(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsXMLHttpRequestOnloadstart(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSXMLHttpRequestOnloadstart(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsXMLHttpRequestOnprogress(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSXMLHttpRequestOnprogress(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsXMLHttpRequestOnreadystatechange(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSXMLHttpRequestOnreadystatechange(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsXMLHttpRequestReadyState(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValuePtr jsXMLHttpRequestUpload(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValuePtr jsXMLHttpRequestResponseText(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValuePtr jsXMLHttpRequestResponseXML(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValuePtr jsXMLHttpRequestStatus(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValuePtr jsXMLHttpRequestStatusText(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
// Constants

JSC::JSValuePtr jsXMLHttpRequestUNSENT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValuePtr jsXMLHttpRequestOPENED(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValuePtr jsXMLHttpRequestHEADERS_RECEIVED(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValuePtr jsXMLHttpRequestLOADING(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValuePtr jsXMLHttpRequestDONE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);

} // namespace WebCore

#endif
