/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSStorageEvent.h"

#include <wtf/GetPtr.h>

#include "DOMWindow.h"
#include "JSDOMWindow.h"
#include "KURL.h"
#include "StorageEvent.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSStorageEvent)

/* Hash table */

static const HashTableValue JSStorageEventTableValues[7] =
{
    { "key", DontDelete|ReadOnly, (intptr_t)jsStorageEventKey, (intptr_t)0 },
    { "oldValue", DontDelete|ReadOnly, (intptr_t)jsStorageEventOldValue, (intptr_t)0 },
    { "newValue", DontDelete|ReadOnly, (intptr_t)jsStorageEventNewValue, (intptr_t)0 },
    { "uri", DontDelete|ReadOnly, (intptr_t)jsStorageEventUri, (intptr_t)0 },
    { "source", DontDelete|ReadOnly, (intptr_t)jsStorageEventSource, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsStorageEventConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSStorageEventTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 31, JSStorageEventTableValues, 0 };
#else
    { 17, 15, JSStorageEventTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSStorageEventConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSStorageEventConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSStorageEventConstructorTableValues, 0 };
#else
    { 1, 0, JSStorageEventConstructorTableValues, 0 };
#endif

class JSStorageEventConstructor : public DOMObject {
public:
    JSStorageEventConstructor(ExecState* exec)
        : DOMObject(JSStorageEventConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSStorageEventPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSStorageEventConstructor::s_info = { "StorageEventConstructor", 0, &JSStorageEventConstructorTable, 0 };

bool JSStorageEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSStorageEventConstructor, DOMObject>(exec, &JSStorageEventConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSStorageEventPrototypeTableValues[2] =
{
    { "initStorageEvent", DontDelete|Function, (intptr_t)jsStorageEventPrototypeFunctionInitStorageEvent, (intptr_t)8 },
    { 0, 0, 0, 0 }
};

static const HashTable JSStorageEventPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSStorageEventPrototypeTableValues, 0 };
#else
    { 2, 1, JSStorageEventPrototypeTableValues, 0 };
#endif

const ClassInfo JSStorageEventPrototype::s_info = { "StorageEventPrototype", 0, &JSStorageEventPrototypeTable, 0 };

JSObject* JSStorageEventPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSStorageEvent>(exec);
}

bool JSStorageEventPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSStorageEventPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSStorageEvent::s_info = { "StorageEvent", &JSEvent::s_info, &JSStorageEventTable, 0 };

JSStorageEvent::JSStorageEvent(PassRefPtr<Structure> structure, PassRefPtr<StorageEvent> impl)
    : JSEvent(structure, impl)
{
}

JSObject* JSStorageEvent::createPrototype(ExecState* exec)
{
    return new (exec) JSStorageEventPrototype(JSStorageEventPrototype::createStructure(JSEventPrototype::self(exec)));
}

bool JSStorageEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSStorageEvent, Base>(exec, &JSStorageEventTable, this, propertyName, slot);
}

JSValuePtr jsStorageEventKey(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    StorageEvent* imp = static_cast<StorageEvent*>(static_cast<JSStorageEvent*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->key());
}

JSValuePtr jsStorageEventOldValue(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    StorageEvent* imp = static_cast<StorageEvent*>(static_cast<JSStorageEvent*>(asObject(slot.slotBase()))->impl());
    return jsStringOrNull(exec, imp->oldValue());
}

JSValuePtr jsStorageEventNewValue(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    StorageEvent* imp = static_cast<StorageEvent*>(static_cast<JSStorageEvent*>(asObject(slot.slotBase()))->impl());
    return jsStringOrNull(exec, imp->newValue());
}

JSValuePtr jsStorageEventUri(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    StorageEvent* imp = static_cast<StorageEvent*>(static_cast<JSStorageEvent*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->uri());
}

JSValuePtr jsStorageEventSource(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    StorageEvent* imp = static_cast<StorageEvent*>(static_cast<JSStorageEvent*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->source()));
}

JSValuePtr jsStorageEventConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSStorageEvent*>(asObject(slot.slotBase()))->getConstructor(exec);
}
JSValuePtr JSStorageEvent::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSStorageEventConstructor>(exec);
}

JSValuePtr jsStorageEventPrototypeFunctionInitStorageEvent(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSStorageEvent::s_info))
        return throwError(exec, TypeError);
    JSStorageEvent* castedThisObj = static_cast<JSStorageEvent*>(asObject(thisValue));
    StorageEvent* imp = static_cast<StorageEvent*>(castedThisObj->impl());
    const UString& typeArg = args.at(exec, 0)->toString(exec);
    bool canBubbleArg = args.at(exec, 1)->toBoolean(exec);
    bool cancelableArg = args.at(exec, 2)->toBoolean(exec);
    const UString& keyArg = args.at(exec, 3)->toString(exec);
    const UString& oldValueArg = valueToStringWithNullCheck(exec, args.at(exec, 4));
    const UString& newValueArg = valueToStringWithNullCheck(exec, args.at(exec, 5));
    const UString& uriArg = args.at(exec, 6)->toString(exec);
    DOMWindow* sourceArg = toDOMWindow(args.at(exec, 7));

    imp->initStorageEvent(typeArg, canBubbleArg, cancelableArg, keyArg, oldValueArg, newValueArg, uriArg, sourceArg);
    return jsUndefined();
}


}
