/***************************************************************************
                          sigslotview.cpp  -  description
                             -------------------
    begin                : Tue May 1 2001
    copyright            : (C) 2001 by Richard Moore
    email                : rich@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <q3objectdict.h>
#include <qobject.h>
#include <qmetaobject.h>
#include <q3strlist.h>
#include <qvariant.h>

#include <klocale.h>

#include "sigslotview.h"

SigSlotView::SigSlotView(QWidget *parent, const char *name ) : K3ListView(parent,name)
{
  addColumn( i18n( "Signals/Slots" ) );

  setRootIsDecorated( true );
  setAllColumnsShowFocus( true );
  setFullWidth( true );
}

SigSlotView::~SigSlotView()
{
}

void SigSlotView::buildList( QObject *o )
{
  QMetaObject *mo = o->metaObject();

  K3ListViewItem *sigs = new K3ListViewItem( this, "Signals" );
  Q3StrList sigList = mo->signalNames( true );
  QStrListIterator sigIt( sigList );
  char *si;
  while ( (si=sigIt.current()) != 0 ) {
    ++sigIt;
    new K3ListViewItem( sigs, si /*, "someSignal()"*/ );
  }

  K3ListViewItem *slts = new K3ListViewItem( this, "Slots" );
  Q3StrList sltList = mo->slotNames( true );
  QStrListIterator sltIt( sltList );
  char *sl;
  while ( (sl=sltIt.current()) != 0 ) {
    ++sltIt;
    new K3ListViewItem( slts, sl/*, "someSlot()"*/ );
  }

  setOpen( sigs, false );
  setOpen( slts, false );
}

void SigSlotView::setTarget( QObject *o )
{
  clear();
  buildList( o );
}

#include "sigslotview.moc"
