/*
  This file is part of the kcal library.

  Copyright (c) 2001 Cornelius Schumacher <schumacher@kde.org>
  Copyright (c) 2007 David Jarvie <software@astrojar.org.uk>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this library; see the file COPYING.LIB.  If not, write to
  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
  Boston, MA 02110-1301, USA.
*/
/**
  @file
  This file is part of the API for handling calendar data and
  defines the FreeBusyPeriod class.

  @brief
  Represents a period of time.

  @author Cornelius Schumacher \<schumacher@kde.org\>
*/

#include "freebusyperiod.h"

#include <kdebug.h>
#include <klocale.h>

using namespace KCal;

//@cond PRIVATE
class KCal::FreeBusyPeriod::Private
{
  public:
    Private() {}

    QString mSummary;
    QString mLocation;
};
//@endcond

FreeBusyPeriod::FreeBusyPeriod() : Period(), d( new KCal::FreeBusyPeriod::Private() )
{
}

FreeBusyPeriod::FreeBusyPeriod( const KDateTime &start, const KDateTime &end )
  : Period( start, end ), d( new KCal::FreeBusyPeriod::Private() )
{
}

FreeBusyPeriod::FreeBusyPeriod( const KDateTime &start, const Duration &duration )
  : Period( start, duration ), d( new KCal::FreeBusyPeriod::Private() )
{
}

FreeBusyPeriod::FreeBusyPeriod( const FreeBusyPeriod &period )
  : Period( period ), d( new KCal::FreeBusyPeriod::Private( *period.d ) )
{
}

FreeBusyPeriod::FreeBusyPeriod( const Period &period )
  : Period( period ), d( new KCal::FreeBusyPeriod::Private() )
{
}

FreeBusyPeriod::~FreeBusyPeriod()
{
  delete d;
}

FreeBusyPeriod &FreeBusyPeriod::operator=( const FreeBusyPeriod &other )
{
  Period::operator=(other);
  *d = *other.d;
  return *this;
}

QString FreeBusyPeriod::summary() const
{
  return d->mSummary;
}

void FreeBusyPeriod::setSummary( const QString &summary )
{
  d->mSummary = summary;
}

QString FreeBusyPeriod::location() const
{
  return d->mLocation;
}

void FreeBusyPeriod::setLocation( const QString &location )
{
  d->mLocation = location;
}
