.\" Copyright 1991, Network Computing Devices, Inc
.\" Copyright 1993, 1998  The Open Group
.\"
.\" Permission to use, copy, modify, distribute, and sell this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that
.\" copyright notice and this permission notice appear in supporting
.\" documentation.
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of The Open Group shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from The Open Group.
.\"
.TH XFSINFO __appmansuffix__ 2025-03-25 __xorgversion__
.SH NAME
xfsinfo \- X font server information utility
.SH SYNOPSIS
.B "xfsinfo"
[\fB\-server\fP \fIservername\fP] [\fB-help\fP|\fB-version\fP]
.SH DESCRIPTION
.B Xfsinfo
is a utility for displaying information about an X font server.
It is used to examine the capabilities of a server,
the predefined values for various parameters used
in communicating between clients and the server,
and the font catalogues and alternate servers that are available.
.SH "OPTIONS"
.TP
.B \-server \fIservername\fP
This option specifies the X font server to contact.
.I servername
must be specified in one of the formats defined in the
.I Font Server Names
section of
.BR X (__miscmansuffix__).
If not specified, the server name in the
.B FONTSERVER
environment variable is used.
.TP
.B \-help
This option prints the program usage and exits.
.TP
.B \-version
This option prints the program version and exits.
.SH HISTORY
.B Xfsinfo
was originally called
.BR fsinfo .
It was renamed to avoid a clash with the
.B fsinfo
utility from the Berkeley automounter
.BR amd .
.SH EXAMPLE
The following shows a sample produced by
.BR xfsinfo .
.PP
.nf
example% \fBxfsinfo -server hansen:7100\fP
name of server:	hansen:7100
version number:	1
vendor string:	Font Server Prototype
vendor release number:	17
maximum request size:	16384 longwords (65536 bytes)
number of catalogues:	1
	all
Number of alternate servers: 2
\&    #0	hansen:7101
\&    #1	hansen:7102
number of extensions:	0
.fi
.sp
.SH ENVIRONMENT
.TP 8
.B FONTSERVER
To get the default fontserver.
The server name must be specified in one of the formats defined in the
.I Font Server Names
section of
.BR X (__miscmansuffix__).
.SH "SEE ALSO"
.BR xfs (__appmansuffix__),
.BR fslsfonts (__appmansuffix__),
.BR X (__miscmansuffix__).
.SH AUTHOR
Dave Lemke, Network Computing Devices, Inc
