/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class JarFile
extends ZipFile {
    public static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private Manifest manifest;
    private boolean verify;
    private boolean manifestRead;

    private /* synthetic */ void finit$() {
        this.manifestRead = false;
    }

    public JarFile(String fileName) throws FileNotFoundException, IOException {
        this(fileName, true);
    }

    public JarFile(String fileName, boolean verify) throws FileNotFoundException, IOException {
        super(fileName);
        this.finit$();
        if (verify) {
            this.manifest = this.readManifest();
            this.verify();
        }
    }

    public JarFile(File file) throws FileNotFoundException, IOException {
        this(file, true);
    }

    public JarFile(File file, boolean verify) throws FileNotFoundException, IOException {
        super(file);
        this.finit$();
        if (verify) {
            this.manifest = this.readManifest();
            this.verify();
        }
    }

    public JarFile(File file, boolean verify, int mode) throws FileNotFoundException, IOException, IllegalArgumentException {
        super(file, mode);
        this.finit$();
        if (verify) {
            this.manifest = this.readManifest();
            this.verify();
        }
    }

    private void verify() {
        if (this.manifest == null) {
            this.verify = false;
            return;
        }
        this.verify = true;
    }

    private Manifest readManifest() {
        try {
            ZipEntry manEntry = super.getEntry(MANIFEST_NAME);
            if (manEntry != null) {
                InputStream in = super.getInputStream(manEntry);
                this.manifestRead = true;
                return new Manifest(in);
            }
            this.manifestRead = true;
            return null;
        }
        catch (IOException ioe) {
            this.manifestRead = true;
            return null;
        }
    }

    public Enumeration entries() throws IllegalStateException {
        return new JarEnumeration(this, super.entries());
    }

    public ZipEntry getEntry(String name) {
        ZipEntry entry = super.getEntry(name);
        if (entry != null) {
            Manifest manifest;
            JarEntry jarEntry = new JarEntry(entry);
            try {
                manifest = this.getManifest();
            }
            catch (IOException ioe) {
                manifest = null;
            }
            if (manifest != null) {
                jarEntry.attr = manifest.getAttributes(name);
            }
            return jarEntry;
        }
        return null;
    }

    public synchronized InputStream getInputStream(ZipEntry entry) throws ZipException, IOException {
        return super.getInputStream(entry);
    }

    public JarEntry getJarEntry(String name) {
        return (JarEntry)this.getEntry(name);
    }

    public Manifest getManifest() throws IOException {
        if (!this.manifestRead) {
            this.manifest = this.readManifest();
        }
        return this.manifest;
    }

    private class JarEnumeration
    implements Enumeration {
        private /* synthetic */ JarFile this$0;
        private final Enumeration entries;

        JarEnumeration(JarFile this$0, Enumeration e) {
            this.this$0 = this$0;
            this.entries = e;
        }

        public boolean hasMoreElements() {
            return this.entries.hasMoreElements();
        }

        public Object nextElement() {
            Manifest manifest;
            ZipEntry zip = (ZipEntry)this.entries.nextElement();
            JarEntry jar = new JarEntry(zip);
            try {
                manifest = this.this$0.getManifest();
            }
            catch (IOException ioe) {
                manifest = null;
            }
            if (manifest != null) {
                jar.attr = manifest.getAttributes(jar.getName());
            }
            return jar;
        }
    }
}

