/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.nio.CharBufferImpl;
import gnu.java.nio.DoubleBufferImpl;
import gnu.java.nio.FloatBufferImpl;
import gnu.java.nio.IntBufferImpl;
import gnu.java.nio.LongBufferImpl;
import gnu.java.nio.ShortBufferImpl;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBuffer;

public final class ByteBufferImpl
extends ByteBuffer {
    private boolean readOnly;

    public ByteBufferImpl(int cap, int off, int lim) {
        super(cap, lim, off, 0);
        this.backing_buffer = new byte[cap];
        this.readOnly = false;
    }

    public ByteBufferImpl(byte[] array, int offset, int length) {
        super(array.length, length, offset, 0);
        this.backing_buffer = array;
        this.readOnly = false;
    }

    public ByteBufferImpl(ByteBufferImpl copy) {
        super(copy.capacity(), copy.limit(), copy.position(), 0);
        this.backing_buffer = copy.backing_buffer;
        this.readOnly = copy.isReadOnly();
    }

    void inc_pos(int toAdd) {
        this.position(this.position() + toAdd);
    }

    private static native byte[] nio_cast(byte[] var0);

    private static native byte[] nio_cast(char[] var0);

    private static native byte[] nio_cast(short[] var0);

    private static native byte[] nio_cast(long[] var0);

    private static native byte[] nio_cast(int[] var0);

    private static native byte[] nio_cast(float[] var0);

    private static native byte[] nio_cast(double[] var0);

    ByteBufferImpl(byte[] copy) {
        super(copy.length, copy.length, 0, 0);
        this.backing_buffer = copy != null ? ByteBufferImpl.nio_cast(copy) : null;
        this.readOnly = false;
    }

    private static native byte nio_get_Byte(ByteBufferImpl var0, int var1, int var2);

    private static native void nio_put_Byte(ByteBufferImpl var0, int var1, int var2, byte var3);

    public ByteBuffer asByteBuffer() {
        ByteBufferImpl res = new ByteBufferImpl(this.backing_buffer);
        res.limit(this.limit() * 1 / 1);
        return res;
    }

    ByteBufferImpl(char[] copy) {
        super(copy.length * 2, copy.length * 2, 0, 0);
        this.backing_buffer = copy != null ? ByteBufferImpl.nio_cast(copy) : null;
        this.readOnly = false;
    }

    private static native char nio_get_Char(ByteBufferImpl var0, int var1, int var2);

    private static native void nio_put_Char(ByteBufferImpl var0, int var1, int var2, char var3);

    public CharBuffer asCharBuffer() {
        CharBufferImpl res = new CharBufferImpl(this.backing_buffer);
        res.limit(this.limit() * 2 / 1);
        return res;
    }

    ByteBufferImpl(short[] copy) {
        super(copy.length, copy.length, 0, 0);
        this.backing_buffer = copy != null ? ByteBufferImpl.nio_cast(copy) : null;
        this.readOnly = false;
    }

    private static native short nio_get_Short(ByteBufferImpl var0, int var1, int var2);

    private static native void nio_put_Short(ByteBufferImpl var0, int var1, int var2, short var3);

    public ShortBuffer asShortBuffer() {
        ShortBufferImpl res = new ShortBufferImpl(this.backing_buffer);
        res.limit(this.limit() * 2 / 1);
        return res;
    }

    ByteBufferImpl(int[] copy) {
        super(copy.length * 4, copy.length * 4, 0, 0);
        this.backing_buffer = copy != null ? ByteBufferImpl.nio_cast(copy) : null;
        this.readOnly = false;
    }

    private static native int nio_get_Int(ByteBufferImpl var0, int var1, int var2);

    private static native void nio_put_Int(ByteBufferImpl var0, int var1, int var2, int var3);

    public IntBuffer asIntBuffer() {
        IntBufferImpl res = new IntBufferImpl(this.backing_buffer);
        res.limit(this.limit() * 4 / 1);
        return res;
    }

    ByteBufferImpl(long[] copy) {
        super(copy.length * 8, copy.length * 8, 0, 0);
        this.backing_buffer = copy != null ? ByteBufferImpl.nio_cast(copy) : null;
        this.readOnly = false;
    }

    private static native long nio_get_Long(ByteBufferImpl var0, int var1, int var2);

    private static native void nio_put_Long(ByteBufferImpl var0, int var1, int var2, long var3);

    public LongBuffer asLongBuffer() {
        LongBufferImpl res = new LongBufferImpl(this.backing_buffer);
        res.limit(this.limit() * 8 / 1);
        return res;
    }

    ByteBufferImpl(float[] copy) {
        super(copy.length * 4, copy.length * 4, 0, 0);
        this.backing_buffer = copy != null ? ByteBufferImpl.nio_cast(copy) : null;
        this.readOnly = false;
    }

    private static native float nio_get_Float(ByteBufferImpl var0, int var1, int var2);

    private static native void nio_put_Float(ByteBufferImpl var0, int var1, int var2, float var3);

    public FloatBuffer asFloatBuffer() {
        FloatBufferImpl res = new FloatBufferImpl(this.backing_buffer);
        res.limit(this.limit() * 4 / 1);
        return res;
    }

    ByteBufferImpl(double[] copy) {
        super(copy.length * 8, copy.length * 8, 0, 0);
        this.backing_buffer = copy != null ? ByteBufferImpl.nio_cast(copy) : null;
        this.readOnly = false;
    }

    private static native double nio_get_Double(ByteBufferImpl var0, int var1, int var2);

    private static native void nio_put_Double(ByteBufferImpl var0, int var1, int var2, double var3);

    public DoubleBuffer asDoubleBuffer() {
        DoubleBufferImpl res = new DoubleBufferImpl(this.backing_buffer);
        res.limit(this.limit() * 8 / 1);
        return res;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public ByteBuffer slice() {
        return new ByteBufferImpl(this);
    }

    public ByteBuffer duplicate() {
        return new ByteBufferImpl(this);
    }

    public ByteBuffer asReadOnlyBuffer() {
        ByteBufferImpl a = new ByteBufferImpl(this);
        a.readOnly = true;
        return a;
    }

    public ByteBuffer compact() {
        return this;
    }

    public boolean isDirect() {
        return false;
    }

    public final byte get() {
        byte e = this.backing_buffer[this.position()];
        this.position(this.position() + 1);
        return e;
    }

    public final ByteBuffer put(byte b) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        this.backing_buffer[this.position()] = b;
        this.position(this.position() + 1);
        return this;
    }

    public final byte get(int index) {
        return this.backing_buffer[index];
    }

    public final ByteBuffer put(int index, byte b) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        this.backing_buffer[index] = b;
        return this;
    }

    public final char getChar() {
        char a = ByteBufferImpl.nio_get_Char(this, this.position(), this.limit());
        this.inc_pos(2);
        return a;
    }

    public final ByteBuffer putChar(char value) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        ByteBufferImpl.nio_put_Char(this, this.position(), this.limit(), value);
        this.inc_pos(2);
        return this;
    }

    public final char getChar(int index) {
        char a = ByteBufferImpl.nio_get_Char(this, index, this.limit());
        return a;
    }

    public final ByteBuffer putChar(int index, char value) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        ByteBufferImpl.nio_put_Char(this, index, this.limit(), value);
        return this;
    }

    public final short getShort() {
        short a = ByteBufferImpl.nio_get_Short(this, this.position(), this.limit());
        this.inc_pos(2);
        return a;
    }

    public final ByteBuffer putShort(short value) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        ByteBufferImpl.nio_put_Short(this, this.position(), this.limit(), value);
        this.inc_pos(2);
        return this;
    }

    public final short getShort(int index) {
        short a = ByteBufferImpl.nio_get_Short(this, index, this.limit());
        return a;
    }

    public final ByteBuffer putShort(int index, short value) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        ByteBufferImpl.nio_put_Short(this, index, this.limit(), value);
        return this;
    }

    public final int getInt() {
        int a = ByteBufferImpl.nio_get_Int(this, this.position(), this.limit());
        this.inc_pos(4);
        return a;
    }

    public final ByteBuffer putInt(int value) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        ByteBufferImpl.nio_put_Int(this, this.position(), this.limit, value);
        this.inc_pos(4);
        return this;
    }

    public final int getInt(int index) {
        int a = ByteBufferImpl.nio_get_Int(this, index, this.limit());
        return a;
    }

    public final ByteBuffer putInt(int index, int value) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        ByteBufferImpl.nio_put_Int(this, index, this.limit(), value);
        return this;
    }

    public final long getLong() {
        long a = ByteBufferImpl.nio_get_Long(this, this.position(), this.limit());
        this.inc_pos(8);
        return a;
    }

    public final ByteBuffer putLong(long value) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        ByteBufferImpl.nio_put_Long(this, this.position(), this.limit(), value);
        this.inc_pos(8);
        return this;
    }

    public final long getLong(int index) {
        long a = ByteBufferImpl.nio_get_Long(this, index, this.limit());
        return a;
    }

    public final ByteBuffer putLong(int index, long value) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        ByteBufferImpl.nio_put_Long(this, index, this.limit(), value);
        return this;
    }

    public final float getFloat() {
        float a = ByteBufferImpl.nio_get_Float(this, this.position(), this.limit());
        this.inc_pos(4);
        return a;
    }

    public final ByteBuffer putFloat(float value) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        ByteBufferImpl.nio_put_Float(this, this.position(), this.limit(), value);
        this.inc_pos(4);
        return this;
    }

    public final float getFloat(int index) {
        float a = ByteBufferImpl.nio_get_Float(this, index, this.limit());
        return a;
    }

    public final ByteBuffer putFloat(int index, float value) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        ByteBufferImpl.nio_put_Float(this, index, this.limit(), value);
        return this;
    }

    public final double getDouble() {
        double a = ByteBufferImpl.nio_get_Double(this, this.position(), this.limit());
        this.inc_pos(8);
        return a;
    }

    public final ByteBuffer putDouble(double value) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        ByteBufferImpl.nio_put_Double(this, this.position(), this.limit(), value);
        this.inc_pos(8);
        return this;
    }

    public final double getDouble(int index) {
        return ByteBufferImpl.nio_get_Double(this, index, this.limit());
    }

    public final ByteBuffer putDouble(int index, double value) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        ByteBufferImpl.nio_put_Double(this, index, this.limit(), value);
        return this;
    }
}

