/*
 * Copyright (C) 2002-2003 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 * Some code in here contributed by the FSF
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

#include <time.h>
#include <errno.h>
#include <grp.h>
#include <pwd.h>
#include <regex.h>
#include <dirent.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_gui.h"
#include "glade_support.h"
#include "glade_callbacks.h"

#include "constants.h"
#include "types.h"

#include "add_file.h"
#include "add_node_contents.h"
#include "callbacks.h"
#include "dummies.h"
#include "entry.h"
#include "filter.h"
#include "icons.h"
#include "gdir.h"
#include "ls.h"
#include "misc.h"
#include "treestore.h"

extern int stop;

static int read_files_d_type(GtkTreeView *treeview,
		char *path, int type, regex_t * preg, gdir_t * gdir)
{
    DIR *directory;
    int count = 0;
    int smallcount = 0;
    struct dirent *d;
    char *fullpath;
    struct stat st;

    directory = opendir(path);
    if(!directory)
	return -1;
    while((d = readdir(directory)) != NULL)
    {
	if(!strcmp(d->d_name, ".") || !strcmp(d->d_name, ".."))
	    continue;
	/* double dot files are not considered hidden in xffm */
	if(d->d_name[0] == '.' && d->d_name[1] != '.' && !SHOWS_HIDDEN(type))
	    continue;
	fullpath = mk_path(path, d->d_name);
	stat(fullpath, &st);
	if(!S_ISDIR(st.st_mode) && regexec(preg, d->d_name, 0, NULL, 0))
	    continue;
	if(gdir != NULL)
	{
	    gdir->gl[count].pathv = g_strdup(d->d_name);
	    gdir->gl[count].en = stat_entry(fullpath, type);
	}
	count++;
	if (++smallcount & 0x100) {
	  smallcount=0;
	  set_progress(treeview, -1,-1);
	}

    }
    closedir(directory);
    return (count);
}


void add_folder(GtkTreeView * treeview, GtkTreeIter * iter)
{
    DIR *directory;
    gdir_t gdir;
    regex_t *preg;
    /*char *regex; */
    tree_entry_t *en;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    tree_details_t *tree_details = get_tree_details(treeview);
    long long unsigned tama = 0;
    int j;
    time_t inicio = time(NULL);

    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if(!en)
	g_assert_not_reached();
    g_free(en->filter);
    en->filter = g_strdup(get_filter(tree_details->window));

    directory = opendir(en->path);
    if(!directory)
    {
      folder_add_error:
	reset_dummy(treeview, iter, 2);
	print_diagnostics(treeview, "xf_NOACCESS_ICON", en->path, " : ", strerror(errno), "\n", NULL);
	print_status(treeview, "xf_NOACCESS_ICON", FILENAME(en), " : ", strerror(errno), NULL);


	return;
    }
    closedir(directory);

    /* this is done in callbacks.c:
       print_status(treeview,resolve_folder_icon(en->type),en->path,NULL); */
    /*cursor_wait(treeview); */


    /* returns compiled regex and sets filter in tree_entry */
    preg = get_regex_filter(treeview, en);

    /*print_status(treeview, "xf_INFO_ICON", _("Reading directory..."), NULL);*/

    /* count step */
    gdir.pathc = read_files_d_type(treeview,en->path, en->type, preg, NULL);
    /*en->count=gdir.pathc;(this only counts files filtered thru */
    if(gdir.pathc < 0)
	g_assert_not_reached();
    /*printf("DBG:count=%d\n",gdir.gl_pathc);     */

    gtk_widget_freeze_child_notify((GtkWidget *) treeview);
    if(gdir.pathc)
    {
	gdir.gl = (dir_t *) malloc(gdir.pathc * sizeof(dir_t));
	if(!gdir.gl)
	{
	    regfree(preg);
	    goto folder_add_error;
	}
	update_dummy(treeview, iter, -1, -1);


	if(read_files_d_type(treeview,en->path, en->type, preg, &gdir) < 0)
	{
	    g_free(gdir.gl);
	    gdir.gl=NULL;
	    regfree(preg);
	    goto folder_add_error;
	}

	for(j = 0; j < gdir.pathc; j++)
	{
	    tama += gdir.gl[j].en->st->st_size;
	    en->checksum += gdir.gl[j].en->st->st_mtime;
	}
        
	print_status(treeview, "xf_INFO_ICON", 
			_("Processing directory..."), NULL);

	add_node_contents(treeview, iter, &gdir);
	gdirfree(&gdir);
    }
    else
    {
	if(IS_ROOT_TYPE(en->type) && IS_LOCAL_TYPE(en->type) && 
			en->path && strcmp(en->path, "/"))
	{
	    reset_dummy(treeview, iter, 5);
	}
	else reset_dummy(treeview, iter, 1);
    }

    SET_LOADED(en->type);

    regfree(preg);


    if(!en->tag)
	en->tag = (char *)malloc(_POSIX_PATH_MAX);

    if(stop)
    {
	SET_INCOMPLETE(en->type);
	stop = FALSE;
	sprintf(en->tag, "%s : %s", FILENAME(en),
#ifdef ECANCELED
		strerror(ECANCELED));
#else
		_("Operation canceled"));
#endif
	print_status(treeview, "xf_WARNING_ICON", en->tag, NULL);
	printf("DBG: stopped!\n");
    }
    else
    {
	UNSET_INCOMPLETE(en->type);
	hide_stop(tree_details->window);
	set_entry_tag(treeview, en, tama);
	/*printf("DBG: tag=%s\n",en->tag); */
	if (strchr(en->tag,'%'))
		print_status_tmp(treeview, resolve_icon_small(en),
			       	FILENAME(en), NULL);
	else
	print_status(treeview, resolve_folder_icon(en), en->tag, NULL);

    }
    en->load_time = time(NULL) - inicio;

    return;

}
