
/*
 * Copyright (C) 2002 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_callbacks.h"
#include "glade_gui.h"
#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "add_folder.h"
#include "refresh.h"
#include "entry.h"
#include "icons.h"
#include "input.h"
#include "menu.h"
#include "misc.h"
#include "monitor.h"
#include "remove.h"
#include "run.h"
#include "options.h"
#include "reg.h"
#include "settings.h"
#include "trash.h"
#include "treestore.h"
#include "tubo.h"
#include "widgets.h"



/****************/

extern GtkWidget *autotype_C;
extern GtkWidget *autotype_D;
extern autotype_t autotype[];
extern autotype_t autotype_dir[];
extern gchar *workdir;
extern gchar *xffm_argv0;
extern gchar *xffm_argv1;

static pid_t parent_pid;
static GtkTreeView *autotype_treeview;
static void *autotype_fork_obj=NULL;

static int auto_stderr(int n, void *data)
{
    char *line;
    if(n)
	return TRUE;		/* this would mean binary data */
    line = (char *)data;
    print_diagnostics(autotype_treeview, "xf_ERROR_ICON", line, NULL);
    return TRUE;
}

static int rwStdout (int n, void *data){
  char *line;
  static int count=0;
  if (n) return TRUE; 
  else{
	  line = (char *) data;
	  if (line[0]=='%') {
		  print_diagnostics(autotype_treeview,NULL,".",NULL);
		  if (++count == 80) {
		     print_diagnostics(autotype_treeview,NULL,"\n",NULL);
		     count=0;
		  }
	  }
	  else {
		  print_diagnostics(autotype_treeview,NULL,line,NULL);
		  count=0;
	  }
  }
  return TRUE;
}

/* function called when child is dead */
static void rwForkOver (pid_t pid)
{
  autotype_fork_obj=NULL;
  print_diagnostics(autotype_treeview,"xf_INFO_ICON",_("Command done"),"\n",NULL);
  print_status(autotype_treeview,"xf_INFO_ICON",_("Command done"),NULL);
  local_monitor(autotype_treeview,TRUE);
}

extern char **environ;

static void tubo_cmd(void *data){
	char **argv=(char **)data;
	int i=0;
	int status;
	usleep(5000);
	/*argv[i++]="sh";	argv[i++]="-c";*/
	/*for (i=0;argv[i]!=NULL;i++) fprintf(stdout,"--arg[%d]=%s\n",i,argv[i]);
	  fflush(NULL);sleep(2);*/ 
	i=fork();
	if (i<0){
		fprintf(stderr,"unable to fork\n");
	       	_exit(123);
	}
	if (!i){
           if (execvp (argv[0], argv) == -1) {
	     fprintf(stdout,"%s: %s\n",strerror(errno),argv[0]);
	     /*fprintf(stdout,"parentpid=%d\n",parent_pid);*/
	   }
	   fflush(NULL);
	   sleep(1);
	   _exit(123);
	} else usleep(5000);
	wait(&status);
	fflush(NULL);
	sleep(1);
	_exit(123);
}





/***************/


int stop = FALSE;

/***   callbacks   **/

void titles_off(GtkTreeViewColumn * column, gpointer data)
{
    GtkTreeView *treeview = (GtkTreeView *) data;
    tree_details_t *tree_details = get_tree_details(treeview);
    quick_hide((GtkButton *) tree_details->window, (gpointer) ((long)(SHOW_TITLES)));
}

void titles_toggle(GtkButton * button, gpointer user_data)
{
    unsigned l = (unsigned)((long)user_data);
    GtkTreeView *treeview = (GtkTreeView *) lookup_widget((GtkWidget *) button, "treeview");
    tree_details_t *tree_details = get_tree_details(treeview);
    if(l & 0x100)
    {
	tree_details->preferences |= (QUICK_HIDE_MASK & l);
    }
    else
    {
	tree_details->preferences &= (BIT_MASK ^ l);
    }
    hide_bars(treeview);
    /*write_xffm_config(&tree_details);*/
}

void on_stop(GtkButton * button, gpointer user_data)
{
    stop = TRUE;
    hideit((GtkWidget *) button, "stop");
    showit((GtkWidget *) button, "clear_text");
}

void on_activate_branch(GtkMenuItem * menuitem, gpointer user_data){
    unsigned l = (unsigned)((long)user_data);
    GtkTreeIter  iter;
    tree_entry_t * en;
    GtkTreeView *treeview = (GtkTreeView *) lookup_widget((GtkWidget *) menuitem, "treeview");
    switch (l){
	    case ACTIVATE_BOOK:
		    get_bookmark_root(treeview,&iter, &en);
		    break;
	    case ACTIVATE_LOCAL:
		    get_local_root(treeview,&iter, &en);
		    break;
	    case ACTIVATE_SMB:
		    get_network_root(treeview, &iter, &en);
		    break;
	    case ACTIVATE_APPS:
		    get_apps_root(treeview, &iter, &en);
		    break;
	    case ACTIVATE_TRASH:
		     get_trash_root(treeview, &iter, &en);
		     break;
#if defined(HAVE_GETMNTENT) || defined(HAVE_GETFSENT) || defined(HAVE_GETVFSENT)
	    case ACTIVATE_FSTAB:
		     get_fstab_root(treeview,&iter,&en);
		     break;
#endif
	    default: return;
    }
    {
      GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
      GtkTreePath *treepath=gtk_tree_model_get_path(treemodel, &iter);
      GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
      gtk_tree_view_expand_row(treeview, treepath, FALSE);  
      gdk_flush();
      gtk_tree_view_scroll_to_cell(treeview, treepath, NULL, TRUE, 0.0, 0.0);
      gtk_tree_selection_select_path (selection,treepath);
      gtk_tree_view_set_cursor (treeview,treepath,NULL,FALSE);
      gtk_tree_path_free(treepath);
    }    
}


void on_close_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    tree_details_t *tree_details = (tree_details_t *) user_data;
    GtkTreeModel *treemodel;

    disable_diagnostics();
    
#if defined(HAVE_GETMNTENT) || defined(HAVE_GETFSENT) || defined(HAVE_GETVFSENT)
    if (strstr(xffm_argv0,"xffstab") && xffm_argv1) {
	int fstab_mount(GtkTreeView *treeview, char *mnt_point, gboolean umnt);
	int is_mounted(char *mnt_point);
	/* if argv[1] was already mounted, this will unmount it too.*/
	chdir("/");
	if (fork()){
	   if (is_mounted(xffm_argv1)){
	     char *arguments[3];
	    /* printf("DBG:umount %s\n",xffm_argv1);*/
     	     arguments[0]="umount";
	     arguments[1]=xffm_argv1;	     
	     arguments[2]=0;
	     execvp(arguments[0],arguments);
	     _exit(123);
	   }
	  /* else printf("DBG:not mounted %s\n",xffm_argv1);*/
	} 
	
    }
#endif


    cleanup_tmpfiles();
    if (tree_details) {
      cancel_input(tree_details->treeview);
      treemodel = gtk_tree_view_get_model(tree_details->treeview);
      write_local_xffm_config(&tree_details);
      tree_details->window = NULL;
    } 
     _exit(123);
    return;
}


void on_clear_text_window(GtkButton * button, gpointer user_data)
{
    GtkTreeView *treeview = get_treeview((GtkWidget *) button);
    clear_diagnostics(treeview);
}



void on_show_text(GtkButton * button, gpointer user_data)
{
    show_text(GTK_WIDGET(button));
}


void on_hide_text(GtkButton * button, gpointer user_data)
{
    hide_text(GTK_WIDGET(button));
}


gboolean on_xffm_destroy_event(GtkWidget * widget, GdkEvent * event, gpointer user_data)
{
    on_close_activate(NULL,user_data );
    return FALSE;
}


gboolean on_xffm_delete_event(GtkWidget * widget, GdkEvent * event, gpointer user_data)
{
    on_close_activate(NULL,user_data );
    return FALSE;
}

static int
autofunction_workdir  (GtkTreeView *treeview, tree_entry_t *en,
		char *querypath) 
{
    tree_details_t *tree_details = get_tree_details(treeview);
         
  g_free(workdir);
  workdir=NULL;
  if (querypath){
      workdir=g_strdup(querypath); 
      /* remove any previous gtk loop: */ 
      cancel_input(treeview);    
      /* this starts a new gtk loop */
      show_input(treeview,WORKDIR_INPUT);
      /* on returning from the loop, tree_details->input == OTHER_INPUT
       * means it was cancelled by button press, or menu selection */
      if (tree_details->input == OTHER_INPUT) return FALSE;
      tree_details->input = OTHER_INPUT;
      if (!workdir){
	 print_status(treeview, "xf_WARNING_ICON",
		strerror(ETIMEDOUT),
			NULL);
	 return FALSE;
      }	 
  } else {
  	workdir=g_path_get_dirname (en->path);
  }
  /*print_diagnostics(treeview,"xf_INFO_ICON","chdir ",workdir,"\n",NULL);*/
  if(!workdir || chdir(workdir)<0){
	 print_status(treeview, "xf_ERROR_ICON",
			strerror(errno), NULL);
	 return FALSE;
  }
  else chdir("/");
  return TRUE;
}

/* autofunction for directories works different: 
 * directories: the path argument is relative, so we must do a chdir
 * 		to the path directory.
 * 		The output specified will carry along the fullpath for 
 * 		output. The workdir will be that where the directory 
 * 		resides. We must do a chdir here.
 * files:	the path argument is absolute. So we just do a chdir to
 * 		the specified workdir before execution.
 *
 * 		*/
static void
autofunction  (GtkTreeView *treeview, tree_entry_t *en,
		char **arguments,char *d,gboolean queued) 
{
         
  gboolean first=TRUE;
  autotype_treeview=treeview;
  print_status(treeview,"xf_INFO_ICON",
		  _("processing")," ",arguments[0],"...",NULL);
  while (1){
	if (!autotype_fork_obj){
		int i;

		parent_pid=getpid();
  		print_diagnostics(treeview,"xf_INFO_ICON","chdir ",d,"\n",NULL);
  		if (chdir(d)<0) {
	  		print_status(treeview,"xf_ERROR_ICON",strerror(errno),NULL);
	  		return;
  		}
		print_diagnostics(treeview,"xf_INFO_ICON"," ",NULL);
		for (i=0;arguments[i];i++)
		   print_diagnostics(treeview,NULL,arguments[i]," ",NULL);
		print_diagnostics(treeview,NULL,"\n",NULL);
		autotype_fork_obj=Tubo (tubo_cmd, 
				(void *)arguments, 
				rwForkOver, 
				TRUE, rwStdout, auto_stderr);
		if (!queued) autotype_fork_obj=NULL;
		break;
	} else if (first) {
		first=FALSE;
		print_diagnostics(treeview,"xf_WARNING_ICON",
				_("command queued\n"),NULL);
	}
    process_pending_gtk();

	usleep(500);
  }
  return;
}


void
on_autotype_C                          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  char *argv[64];
  char command[255];
  int offset=(int)((long)user_data);
  char *loc;
  int i=0,j; 
  tree_entry_t *en;
    GtkTreeView *treeview = get_treeview((GtkWidget *) menuitem);
    GtkTreeIter iter;
    en = get_selected_entry(treeview, &iter);

       
  /*printf("DBG:offset=%d\n",offset);*/
  if (!en || !en->path || !IS_PATH(en->type)) return;
  
  for (i=0;autotype[i].extension;i++){
       /*printf("dbg: autotype=%s,%s\n",
	  autotype[i].extension,autotype[i].command);*/
       loc=strstr(en->path,autotype[i].extension);
       if ((loc)&&(strcmp(loc,autotype[i].extension)==0)) break;
  }
  for (j=0;j<=offset;j++){
  	/*printf("DBG:command=%s\n",autotype[i+j].command);*/
  	if (autotype[i+j].command==NULL) return;
  }

  
  j=0;
  if (strstr(autotype[i+offset].command," ")){
      if (strlen(autotype[i+offset].command)>254) return;
      strcpy(command,autotype[i+offset].command);
      /* sudo-izable stuff */
      if(getenv("XFFM_USE_SUDO")&&strlen(getenv("XFFM_USE_SUDO"))&&
	 (strncmp(command,"pkg_add",strlen("pkg_add"))==0 ||
	  strncmp(command,"pkg_update",strlen("pkg_update"))==0 ||
	  strncmp(command,"burncd",strlen("rpm"))==0 ||
	  strncmp(command,"cdrecord",strlen("rpm"))==0 ||
	  strncmp(command,"rpm",strlen("rpm"))==0 ||
	  strncmp(command,"dpkg",strlen("dpkg"))==0 )
	) {
	      /* FIXME: do a check whether if the command is sudo allowed
	       * without password, if so then: */
	      argv[j++]="sudo";
	      /* when check is implemented, add env var to mcs manager
	       * (put check also in fstab.c) */
      }	      
      argv[j++]=strtok(command," ");
      do {
	      argv[j]=strtok(NULL," ");
	      if (!argv[j]) break;
	      j++;
	      if (j>=64) { argv[63]=0; break; }
      } while (1);
  } else argv[j++]=autotype[i+offset].command;
  argv[j++]=en->path;
  if (strcmp(argv[0],"burncd")==0 || strcmp(argv[1],"burncd")==0) 
	  argv[j++]="fixate";
  argv[j]=0;

  /* this function call will enter a gtk loop */ 
  if (!autofunction_workdir (treeview, en,autotype[i+offset].querypath)) {
	  return;
  }
  /*printf("DBG:");for (j=0;argv[j];j++) printf("%s ",argv[j]);printf("\n");*/
  if (autotype[i+offset].queued)
	  autofunction(treeview,en,argv,workdir, autotype[i+offset].queued);
  else runv(treeview,argv);
  return;
}


/* in this function, the first argument we add will be the output file.
 * it should be absolute, determined by the result of workdir. */

void
on_autotype_D                          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  char *argv[64];
  char command[255];
  char output[255];
  int offset=(int)((long)user_data);
  char *loc;
  int i=0,j; 
  tree_entry_t *en;
    GtkTreeView *treeview = get_treeview((GtkWidget *) menuitem);
    tree_details_t *tree_details = (tree_details_t *) get_tree_details(treeview);
    GtkTreeIter iter;
    en = get_selected_entry(treeview, &iter);

       
  /*printf("DBG:offset=%d\n",offset);*/
  if (!en || !en->path || !IS_DIR(en->type)) return;
  
  for (j=0;j<=offset;j++){
  	/*printf("DBG:command=%s\n",autotype[i+j].command);*/
  	if (autotype_dir[i+j].command==NULL) return;
  }

  
  j=0;
  if (strstr(autotype_dir[i+offset].command," ")){
      if (strlen(autotype_dir[i+offset].command)>254) return;
      strcpy(command,autotype_dir[i+offset].command);
#if 0
      /* sudo-izable stuff */
      if(getenv("XFFM_USE_SUDO")&&strlen(getenv("XFFM_USE_SUDO"))&&
	 (strncmp(command,"xx",strlen("xx"))==0 ||
	  strncmp(command,"wahtever",strlen("wthatever"))==0 )
	) {
	      /* FIXME: do a check whether if the command is sudo allowed
	       * without password, if so then: */
	      argv[j++]="sudo";
	      /* when check is implemented, add env var to mcs manager
	       * (put check also in fstab.c) */
      }	  
#endif    
      argv[j++]=strtok(command," ");

      do {
	      argv[j]=strtok(NULL," ");
	      if (!argv[j]) break;
	      j++;
	      if (j>=64) { argv[63]=0; break; }
      } while (1);
  } else argv[j++]=autotype_dir[i+offset].command;

  /* get the output directory */
  /* this function call will enter a gtk loop */ 
  if (!autofunction_workdir (treeview, en,autotype_dir[i+offset].querypath)) {
	  return;
  }

  if (autotype_dir[i+offset].extension) {
	  if (strlen(workdir)+strlen(FILENAME(en))+strlen(autotype_dir[i+offset].extension) >253) 
		  return;
	  sprintf(output,"%s/%s%s",workdir,FILENAME(en),autotype_dir[i+offset].extension);
	  argv[j++]=output;
  }
  
  /* now set the workdir (no internal gtk loop) */
  if (!autofunction_workdir (treeview, en,NULL)) return;
  
  /* for the path, since g_get_basename has to be freed, it will not work with queued commands */
  if (!strrchr(en->path,'/')){
	  printf("DBG: no separator in path!\n");
	  return;
  }

  if (!strlen(strrchr(en->path,'/')+1)) argv[j++]=strrchr(en->path,'/');
  else argv[j++]=strrchr(en->path,'/')+1;

  argv[j]=0;

  
  /*printf("DBG:");for (j=0;argv[j];j++) printf("%s ",argv[j]);printf("\n");*/
  if (autotype_dir[i+offset].queued)
	  autofunction(treeview,en,argv,workdir, autotype_dir[i+offset].queued);
  else runv(treeview,argv);
  return;
}

#if 0
{
  char *arguments[5];
  gchar *d;
    tree_entry_t *en;
    GtkTreeView *treeview = get_treeview((GtkWidget *) menuitem);
    GtkTreeIter iter;
    en = get_selected_entry(treeview, &iter);
  
       
  if (!en || !en->path || !IS_DIR(en->type)) return;
   
  /* this function call will enter a gtk loop */ 
  if (!autofunction_workdir (treeview, en,_("Output dir"))) return;

  d=g_path_get_dirname (en->path);
  

  arguments[0]="tar";
  arguments[1]="-czf";
  arguments[2]=g_strconcat(workdir,"/",
		  strrchr(en->path,'/')+1,".tar.gz",
		  NULL);
  arguments[3]=strrchr(en->path,'/')+1;
  arguments[4]=0;
  
  autofunction(treeview,en,arguments,d,TRUE);
  g_free(d);
  g_free(arguments[2]);
  return;
}
#endif


void
on_autotype_R                          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    tree_entry_t *en;
    GtkTreeView *treeview = get_treeview((GtkWidget *) menuitem);
    GtkTreeIter iter;
    tree_details_t *tree_details = get_tree_details(treeview);
    en = get_selected_entry(treeview, &iter);
    double_click_open_with(tree_details,en);
    return;
}

void
on_autotype_run                          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    tree_entry_t *en;
    GtkTreeView *treeview = get_treeview((GtkWidget *) menuitem);
    GtkTreeIter iter;
    tree_details_t *tree_details = get_tree_details(treeview);
    en = get_selected_entry(treeview, &iter);
    /*  assume in_term to be safe */
    SET_IN_TERM(en->subtype);
    double_click_run(tree_details,en);
    return;
}

void
on_preview_this_image_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GdkPixbuf *tgt;
    tree_entry_t *en;
    GtkTreeView *treeview = get_treeview((GtkWidget *) menuitem);
    GtkTreeIter iter;
    tree_details_t *tree_details = get_tree_details(treeview);
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    en = get_selected_entry(treeview, &iter);
    print_status(treeview, "xf_WARNING_ICON", 
			_("Preview"), ": ", FILENAME(en), 
			NULL);
    process_pending_gtk();

    tgt = create_preview(en->path, REAL_BIG);
    if (!tgt) print_status(treeview, "xf_ERROR_ICON", 
			strerror(EINVAL), ": ", FILENAME(en), 
			NULL);
    else {
	gtk_tree_store_set((GtkTreeStore *) treemodel, &iter, 
			PIXBUF_COLUMN, tgt, -1);	
	/*   FIXME:Should we g_object_unref the preview pixbuf 
	 *         when the node is destroyed? Or maybe just after
	 *         it is mapped to the window? */
    }
}

