/*#define DEBUG*/
/*
 * Copyright (C) 2002 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include <libxfce4util/util.h>

#include "glade_callbacks.h"
#include "glade_gui.h"
#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "add_file.h"
#include "add_folder.h"
#include "add_node_contents.h"
#include "dummies.h"
#include "entry.h"
#include "icons.h"
#include "input.h"
#include "menu.h"
#include "monitor.h"
#include "misc.h"
#include "trash.h"
#include "treestore.h"
#include "widgets.h"



extern gboolean double_treeview;
static void go_up(GtkWidget * widget);

static gboolean unsel(GtkTreeModel * treemodel, 
		GtkTreePath * treepath, 
		GtkTreeIter * iter, 
		gpointer data)
{
    GtkTreeSelection *selection = (GtkTreeSelection *)data;
    gtk_tree_selection_unselect_path (selection,treepath);
    return FALSE;
}

#if 0
void unselect_double_treeview(GtkTreeView * treeview){
    if (double_treeview ){
       GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
        /* unselect all in auxiliary treeview */
	GtkTreeView *treeview2=(GtkTreeView *)lookup_widget((GtkWidget *)treeview,"treeview2");
        GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview2);
	gtk_tree_model_foreach(treemodel,unsel,selection);
    }
}
#endif

static GList *go_list = NULL;
#define CURRENT_GO_HISTORY "xffm%cxffm.golist.2.dbh"
#if 0
void save_go_list(void)
{				
    char fname[_POSIX_PATH_MAX];
    char *p;
    int i;
    if (!go_list || !go_list->data || !strlen((char *)go_list->data))
	    return;
    p=(char *)go_list->data;
    xfce_get_userfile_r(fname, _POSIX_PATH_MAX-1, CURRENT_GO_HISTORY,
		    G_DIR_SEPARATOR); 
    /* this has a 5 to 1 weight factor versus a doubleclick goto */
    for (i=0;i<5;i++) save_to_history(fname,p);
}
#endif

static void save_to_go_history(char *p)
{				
    char fname[_POSIX_PATH_MAX];
    xfce_get_userfile_r(fname, _POSIX_PATH_MAX-1, CURRENT_GO_HISTORY,
		    G_DIR_SEPARATOR); 
    save_to_history(fname,p);
}


static char *load_go_list(GList **g)
{
    static char fname[_POSIX_PATH_MAX];
    /* get rid of obsolete file, if any */
    xfce_get_userfile_r(fname, _POSIX_PATH_MAX-1, "xffm%cxffm.golist.dbh",
		    G_DIR_SEPARATOR);
    unlink(fname);
    xfce_get_userfile_r(fname, _POSIX_PATH_MAX-1, "xffm%cxffm.golist.1.dbh",
		    G_DIR_SEPARATOR);
    unlink(fname);
    xfce_get_userfile_r(fname, _POSIX_PATH_MAX-1, CURRENT_GO_HISTORY,
		    G_DIR_SEPARATOR);

    get_history_list(g,fname,"/");
    return fname;
}

gboolean go_back_ok(GtkTreeView * treeview)
{
    tree_details_t *tree_details = get_tree_details(treeview);

    if(tree_details->gogo->previous)
	return TRUE;
    return FALSE;
}

gboolean go_forward_ok(GtkTreeView * treeview)
{
    tree_details_t *tree_details = get_tree_details(treeview);

    if(tree_details->gogo->next)
	return TRUE;
    return FALSE;
}

gboolean go_up_ok(GtkTreeView * treeview)
{
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    tree_entry_t *en;
    GtkTreeIter iter;

    if(!gtk_tree_model_get_iter_first(treemodel, &iter))
    	    return FALSE;
    gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
    if (!en|| !en->path) return FALSE;
    while(!IS_LOCAL_TYPE(en->type))
    {
	if(!gtk_tree_model_iter_next(treemodel, &iter))
    	    return FALSE;
	gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
        if (!en || !en->path) break;
    }

    if (!en || !en->path) return FALSE;
    if(strcmp(en->path, "/") != 0) return TRUE;
    return FALSE;
}



golist *pushgo(GtkTreeView * treeview, const gchar *path, golist * thisgo)
{
    golist *lastgo, *gogo;

    gogo = thisgo->next;
    while(gogo)
    {
	lastgo = gogo;
	gogo = gogo->next;
	g_free(lastgo->path);
	lastgo->path=NULL;
	g_free(lastgo);
	lastgo=NULL;
    }
    gogo = (golist *) malloc(sizeof(golist));
    if(!gogo)
	g_assert_not_reached();
    thisgo->next = gogo;
    gogo->previous = thisgo;
    gogo->next = NULL;
    gogo->path = g_strdup(path);
    if(!(gogo->path))
	g_assert_not_reached();
    /*printf("DBG: path pushed=%s\n",path); */
    save_to_go_history((char *)path);
    return gogo;
}

golist *popgo(golist * thisgo)
{
    if(thisgo->previous)
	return thisgo->previous;
    return thisgo;
}


int go_to(GtkTreeView * treeview, const gchar *path)
{
    tree_entry_t *en, *new_en;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    tree_details_t *tree_details = get_tree_details(treeview);
    GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
    GtkTreeIter iter;
    GtkTreePath *treepath;
    static gboolean redlight=FALSE;

    
	    
    if (!path) return FALSE;
    
    if(strncmp(path,"//",2)!=0 && access(path, X_OK)!=0)
    {				
	/*printf("DBG(goto.c): no access (%s)\n",path);*/
	print_diagnostics(treeview,"xf_ERROR_ICON",
			strerror(errno),": ",path,"\n",NULL);
	return FALSE;
	/*g_assert_not_reached(); */
    }
#ifdef DEBUG
    printf("DBG: going to %s\n",path);
#endif
    if (redlight) return TRUE;
    if(!set_load_wait(&tree_details)){
	printf("DBG(xffm): !set_load_wait\n");
	return FALSE;
    }
    redlight=TRUE;
    
    load_go_list(&go_list);
    go_list = g_list_prepend(go_list, g_strdup(path));
    /*save_go_list(); */


#ifdef DEBUG
	printf("DBG: doing go_to to %s...\n",path);
#endif

    if (strncmp(path,"//",2)==0){ /* a network goto */
      gchar *fullpath;
      /* format for mk_net_entry= smd://XXX@YYY: */
      get_network_root(treeview, &iter, &en);
      /* flush treeview */
      gdk_flush();
      treepath = gtk_tree_model_get_path(treemodel, &iter);
      if (getenv("SMB_USER") && strlen(getenv("SMB_USER"))){ 
	if (strchr(getenv("SMB_USER"),'%'))
          fullpath=g_strconcat("smb://",getenv("SMB_USER"),"@",path+2,":",NULL);
	else
          fullpath=g_strconcat("smb://",getenv("SMB_USER"),"%%","@",path+2,":",NULL);
      }
      else
        fullpath=g_strconcat("smb://GUEST%%@",path+2,":",NULL);
      new_en=mk_net_entry(fullpath,en->type);
      SET_XF_NETWS(new_en->subtype);
      g_free(fullpath);
      fullpath=NULL;
      
      prepend_file(treeview, &iter, new_en, (char *)path+2);
      erase_dummy(treeview, &iter);
      SET_LOADED(en->type);
    } 
    else /* a local goto */
    {	   
#ifdef DEBUG 
      printf("DBG: doing get_local_root\n");
#endif
      get_local_root(treeview, &iter, &en);
      treepath = gtk_tree_model_get_path(treemodel, &iter);

      new_en = (stat_entry((char *)path, en->type));
#ifdef DEBUG 
      printf("DBG: doing remove_folder\n");
#endif
      remove_folder(treeview, &iter);


      SET_ROOT_TYPE(new_en->type);
      SET_LOCAL_TYPE(new_en->type);
      new_en->count = -1;
      gtk_tree_store_set((GtkTreeStore *) treemodel, &iter, 
		    NAME_COLUMN, FILENAME(new_en), 
		    ENTRY_COLUMN, new_en,
		    -1);
#ifdef DEBUG
      printf("DBG: doing update_columns\n");
#endif
      update_columns(treemodel, &iter, new_en);
      /* collapse until the end so iter will not invalidate */
#ifdef DEBUG
      printf("DBG: doing gtk_tree_view_collapse_row\n");
#endif
      gtk_tree_view_collapse_row(treeview, treepath);
      destroy_entry(en);
    }
    unset_load_wait(&tree_details);
#ifdef DEBUG
    printf("DBG: doing gtk_tree_view_expand_row\n");
#endif
    gtk_tree_view_expand_row(treeview, treepath, FALSE);  
    gdk_flush();
    gtk_tree_view_scroll_to_cell(treeview, treepath, NULL, TRUE, 0.0, 0.0);
    gtk_tree_selection_select_path (selection,treepath);
    gtk_tree_view_set_cursor (treeview,treepath,NULL,FALSE);
    gtk_tree_path_free(treepath);
    turn_on(treeview);
    /*unselect_double_treeview(treeview);*/

    redlight=FALSE;
    return TRUE;
}

static void go_home(GtkWidget * widget)
{
    tree_entry_t *en;
    GtkTreeView *treeview = get_treeview(widget);
    GtkTreeIter iter;
    const gchar *home;
    tree_details_t *tree_details = (tree_details_t *) get_tree_details(treeview);

    home=get_xffm_home();
    gtk_widget_grab_focus((GtkWidget *) treeview);
    get_local_root(treeview, &iter, &en);
    if(!go_to(treeview, home)) return;
    tree_details->gogo = pushgo(treeview, home, tree_details->gogo);
    {
       GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
       GtkTreePath *treepath;
       GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
       treepath = gtk_tree_model_get_path(treemodel, &iter);
       gtk_tree_selection_select_path (selection,treepath);
       gtk_tree_view_set_cursor (treeview,treepath,NULL,FALSE);
       gtk_tree_path_free(treepath);
       turn_on(treeview);
    }
    /*unselect_double_treeview(treeview);*/
}

static void go_up(GtkWidget * widget)
{
    tree_entry_t *en, *new_en;
    GtkTreeView *treeview = get_treeview(widget);
    GtkTreeIter iter;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    tree_details_t *tree_details = get_tree_details(treeview);
    GtkTreePath *treepath;
    GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
    char *t;
    static gboolean redlight=FALSE;

    
    gtk_widget_grab_focus((GtkWidget *) treeview);

    if (redlight) return;
    if(!set_load_wait(&tree_details)) {
	printf("DBG(xffm): !set_load_wait\n");
	return;
    }
    redlight=TRUE;
    
    get_local_root(treeview, &iter, &en);

    t = strrchr(en->path, '/');
    *t = 0;
    if(strlen(en->path) == 0)
	strcpy(en->path, "/");
    new_en = stat_entry(en->path, en->type);
    SET_ROOT_TYPE(new_en->type);
    new_en->count = -1;


    treepath = gtk_tree_model_get_path(treemodel, &iter);
    remove_folder(treeview, &iter);
    gtk_tree_view_collapse_row(treeview, treepath);

    destroy_entry(en);
    gtk_tree_store_set((GtkTreeStore *) treemodel, &iter, 
		    NAME_COLUMN, FILENAME(new_en), 
		    ENTRY_COLUMN, new_en, 
		    -1);
    update_columns(treemodel, &iter, new_en);
    /* open root folder */
#ifdef DEBUG
    printf("DBG: pushing to go list->%s\n",new_en->path);
#endif
    tree_details->gogo = pushgo(treeview,(const gchar *) new_en->path, tree_details->gogo);
    unset_load_wait(&tree_details);
    gtk_tree_view_expand_row(treeview, treepath, FALSE);
    gdk_flush();
    gtk_tree_view_scroll_to_cell(treeview, treepath, NULL, TRUE, 0.0, 0.0);
    gtk_tree_selection_select_path (selection,treepath);
    gtk_tree_view_set_cursor (treeview,treepath,NULL,FALSE);
    gtk_tree_path_free(treepath);
    turn_on(treeview);
    /*unselect_double_treeview(treeview);*/
    redlight=FALSE;
}

void go_forward(GtkWidget * widget)
{
    tree_entry_t *en;
    GtkTreeIter iter;
    GtkTreeView *treeview = get_treeview(widget);
    tree_details_t *tree_details = get_tree_details(treeview);

    if(tree_details->gogo->next)
    {
	get_local_root(treeview, &iter, &en);
	tree_details->gogo = tree_details->gogo->next;
	if(!go_to(treeview, tree_details->gogo->path))
	    return;
    }
    {
       GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
       GtkTreePath *treepath;
       GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
       treepath = gtk_tree_model_get_path(treemodel, &iter);
       gtk_tree_selection_select_path (selection,treepath);
       gtk_tree_view_set_cursor (treeview,treepath,NULL,FALSE);
       gtk_tree_path_free(treepath);
       turn_on(treeview);
    }
    /*unselect_double_treeview(treeview);*/
}

void go_backward(GtkWidget * widget)
{
    tree_entry_t *en;
    GtkTreeIter iter;
    GtkTreeView *treeview = get_treeview(widget);
    tree_details_t *tree_details = get_tree_details(treeview);

    if(tree_details->gogo->previous)
    {
	get_local_root(treeview, &iter, &en);
	tree_details->gogo = tree_details->gogo->previous;
	if(!go_to(treeview, tree_details->gogo->path))
	    return;
    }
    {
       GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
       GtkTreePath *treepath;
       GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
       treepath = gtk_tree_model_get_path(treemodel, &iter);
       gtk_tree_selection_select_path (selection,treepath);
       gtk_tree_view_set_cursor (treeview,treepath,NULL,FALSE);
       gtk_tree_path_free(treepath);
       turn_on(treeview);
    }
    /*unselect_double_treeview(treeview);*/
}


GList *set_goto_combo(history_combo_info_t *combo_info)
{
    int i;
    GList *tmp;
    combo_info->active_dbh_file=load_go_list(&go_list);
    combo_info->list=go_list;
    set_limited_combo(combo_info,NULL);
    return go_list;
}

void goto_jump(GtkWidget * widget)
{
    GtkTreeView *treeview = get_treeview(widget);
    show_input(treeview, GOTO_INPUT);
}


/* callbacks */


void tb_go_up(GtkButton * button, gpointer user_data)
{
    go_up((GtkWidget *) button);
}

void on_up2_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    go_up((GtkWidget *) menuitem);
}

void on_home3_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    go_home((GtkWidget *) menuitem);
}


void tb_home(GtkButton * button, gpointer user_data)
{
    go_home((GtkWidget *) button);
}

void tb_goto(GtkButton * button, gpointer user_data)
{
    goto_jump((GtkWidget *) button);
}

void on_jump_to2_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    goto_jump((GtkWidget *) menuitem);
}

void tb_go_back(GtkButton * button, gpointer user_data)
{
    go_backward((GtkWidget *) button);
}

void on_back2_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    go_backward((GtkWidget *) menuitem);
}

void tb_go_forward(GtkButton * button, gpointer user_data)
{
    go_forward((GtkWidget *) button);
}

void on_forward2_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    go_forward((GtkWidget *) menuitem);
}



void on_goto_activate(GtkButton * button, gpointer user_data)
{
}
