/* 
 * Copyright (C) 2003 the xine project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: menu.c,v 1.13 2003/03/09 11:42:28 guenter Exp $
 *
 * main/context menu creation / handling
 */

#include "config.h"

#include <string.h>

#include "menu.h"
#include "globals.h"
#include "gtkxine.h"
#include "playlist.h"
#include "actions.h"
#include "utils.h"

/* global pointers to menus: */

GtkMenuShell *media_menu;

static GtkItemFactory *item_factory;

/*
 * context menu
 */

#if 0
static gint context_menu_cb (GtkWidget *widget, GdkEvent *event) {

  if (event->type == GDK_BUTTON_PRESS) {
    GdkEventButton *bevent = (GdkEventButton *) event; 

    if (bevent->button == 3) {
      gtk_menu_popup (GTK_MENU(widget), NULL, NULL, NULL, NULL,
		      bevent->button, bevent->time);
      /* Tell calling code that we have handled this event; the buck
       * stops here. */
      return TRUE;
    }
  }
  
  /* Tell calling code that we have not handled this event; pass it on. */
  return FALSE;
}
#endif

static void autoplay_cb (GtkWidget* widget, gpointer data) {

  char **mrls, *mrl;
  int    n, i, pos;

  mrls = gtk_xine_get_autoplay_mrls (GTK_XINE(gtx), data, &n);

  if (!mrls) {
    playlist_logo();
    display_error ("Autoplay Input Plugin Failed", 
		   "Autoplay for input plugin '%s' failed.\n"
		   "Check engine output for further details.",
		   data);
    return;
  }

  mrl = mrls[0]; i = 0; pos = -1;
  while (mrl) {

    if (pos<0)
      pos = playlist_add_mrl (mrl);
    else
      playlist_add_mrl (mrl);

    mrl = mrls[++i];
  }

  playlist_play (pos);
}

static void add_autoplay_entries (GtkMenuShell *submenu) {

  GtkWidget    *item;
  int           i;
  char        **autoplay_ids = gtk_xine_get_autoplay_input_plugin_ids (GTK_XINE(gtx));

  if (!autoplay_ids) {
    printf ("menu: warning: didn't get any autoplay entries\n");
    return;
  }

  i=0;
  while (autoplay_ids[i]) {

    item = gtk_menu_item_new_with_label (autoplay_ids[i]);
    g_signal_connect (GTK_OBJECT(item), "activate", 
			G_CALLBACK (autoplay_cb), 
			(gpointer) strdup (autoplay_ids[i]));

    gtk_menu_shell_insert (submenu, item, 6);
    gtk_widget_show(item);

    i++;
  }
}

static void vis_cb (GtkWidget* widget, gpointer data) {

  /* printf ("menu: vis_cb %s\n", data); */

  if (gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM (widget))) {
    xine_cfg_entry_t vis_entry;

    if (gtk_xine_config_lookup_entry (GTK_XINE (gtx), "misc.vis",
				      &vis_entry)) {
      vis_entry.str_value = data;
      gtk_xine_config_update_entry (GTK_XINE(gtx), &vis_entry);
    }
    gtk_xine_set_vis (GTK_XINE(gtx), data);
  }
}

static void add_vis_entries (GtkMenuShell *submenu, 
			     GtkRadioMenuItem *none_item) {

  GtkWidget         *item;
  int                i;
  const char        *vis;
  GSList            *group;
  const char *const *pol;

  vis = gtk_xine_config_register_string (GTK_XINE (gtx), "misc.vis", "none",
					 "Default visualization setting",
					 NULL, 40, NULL, NULL);

  group = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (none_item));
  if (!strcasecmp (vis, "none"))
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM(none_item), TRUE);

  pol = gtk_xine_list_post_plugins_typed (GTK_XINE (gtx),
					  XINE_POST_TYPE_AUDIO_VISUALIZATION);
    
  if (pol) {

    i = 0;
    while (pol[i]) {

      /* item = gtk_menu_item_new_with_label (pol[i]); */
      item = gtk_radio_menu_item_new_with_label (group, pol[i]);
      group = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM(item));

      g_signal_connect (GTK_OBJECT(item), "activate", 
			G_CALLBACK (vis_cb), 
			(gpointer) strdup (pol[i]));

      gtk_menu_shell_insert (submenu, item, 1);
      gtk_widget_show(item);

      if (!strcasecmp (vis, pol[i]))
	gtk_check_menu_item_set_active ( GTK_CHECK_MENU_ITEM(item), TRUE);

      i++;
    }
  }
}

static void open_cb (void) {
  action_exec ("open_show ();", NULL, NULL);
}

static void open_mrl_cb(void) {
  action_exec ("open_mrl_show ();", NULL, NULL);
}

static void preferences_cb(void) {
  action_exec ("preferences_show ();", NULL, NULL);
}

static void keybindings_cb(void) {
  action_exec ("keybindings_show ();", NULL, NULL);
}

static void exit_cb(void) {
  action_exec ("exit ();", NULL, NULL);
}

static void fullscreen_cb(void) {
  action_exec ("set_fullscreen ();", NULL, NULL);
}

static void factor_50_cb(void) {
  action_exec ("set_video_size (50);", NULL, NULL);
}

static void factor_100_cb(void) {
  action_exec ("set_video_size (100);", NULL, NULL);
}

static void factor_200_cb(void) {
  action_exec ("set_video_size (200);", NULL, NULL);
}

static void zoom_in_cb(void) {
  action_exec ("set_zoom (get_zoom()+5);", NULL, NULL);
}
static void zoom_out_cb(void) {
  action_exec ("set_zoom (get_zoom()-5);", NULL, NULL);
}

static void aspect_auto_cb(void) {
  action_exec ("set_aspect (0);", NULL, NULL);
}

static void aspect_square_cb(void) {
  action_exec ("set_aspect (1);", NULL, NULL);
}

static void aspect_4_3_cb(void) {
  action_exec ("set_aspect (2);", NULL, NULL);
}

static void aspect_16_9_cb(void) {
  action_exec ("set_aspect (3);", NULL, NULL);
}

static void aspect_dt_cb(void) {
  action_exec ("set_aspect (42);", NULL, NULL);
}

static void deinterlace_cb (gpointer callback_data,
			    guint callback_action,
			    GtkWidget *widget) {

  if (gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM (widget)))
    action_exec ("set_deinterlace (1);", NULL, NULL);
  else
    action_exec ("set_deinterlace (0);", NULL, NULL);
}

static void mediamarks_add_cb(void) {
  action_exec ("mm_add_show ();", NULL, NULL);
}

static void mediamarks_manage_cb(void) {
  action_exec ("mm_manage_show ();", NULL, NULL);
}

static void mediamarks_import_cb(void) {
  action_exec ("import_mediamarks ();", NULL, NULL);
}

static void about_cb(void) {
  action_exec ("about_show ();", NULL, NULL);
}

static void log_cb(void) {
  action_exec ("log_show ();", NULL, NULL);
}

static void stream_info_cb(void) {
  action_exec ("stream_info_show ();", NULL, NULL);
}

static void wizards_cb(void) {
  action_exec ("run_wizards ();", NULL, NULL);
}

static void snapshot_cb(void) {
  action_exec ("snapshot ();", NULL, NULL);
}

static void vis_none_cb (gpointer callback_data,
			 guint callback_action,
			 GtkWidget *widget) {
  if (gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM (widget))) {
    xine_cfg_entry_t vis_entry;

    if (gtk_xine_config_lookup_entry (GTK_XINE (gtx), "misc.vis",
				      &vis_entry)) {
      vis_entry.str_value = "none";
      gtk_xine_config_update_entry (GTK_XINE(gtx), &vis_entry);
    }
    action_exec ("set_vis (\"none\");", NULL, NULL);
  }
}

static void sub_auto_cb (gpointer callback_data,
			 guint callback_action,
			 GtkWidget *widget) {
  if (gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM (widget)))
    action_exec ("set_sub (-1);", NULL, NULL);
}

static void sub_none_cb (gpointer callback_data,
			 guint callback_action,
			 GtkWidget *widget) {
  if (gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM (widget)))
    action_exec ("set_sub (-2);", NULL, NULL);
}

static void sub_ch0_cb(gpointer callback_data,
		       guint callback_action,
		       GtkWidget *widget) {
  if (gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM (widget)))
    action_exec ("set_sub (0);", NULL, NULL);
}

static void sub_ch1_cb(gpointer callback_data,
		       guint callback_action,
		       GtkWidget *widget) {
  if (gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM (widget)))
    action_exec ("set_sub (1);", NULL, NULL);
}

static void sub_ch2_cb(gpointer callback_data,
		       guint callback_action,
		       GtkWidget *widget) {
  if (gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM (widget)))
    action_exec ("set_sub (2);", NULL, NULL);
}

static void sub_ch3_cb(gpointer callback_data,
		       guint callback_action,
		       GtkWidget *widget) {
  if (gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM (widget)))
    action_exec ("set_sub (3);", NULL, NULL);
}

static void sub_ch4_cb(gpointer callback_data,
		       guint callback_action,
		       GtkWidget *widget) {
  if (gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM (widget)))
    action_exec ("set_sub (4);", NULL, NULL);
}

static void sub_ch5_cb(gpointer callback_data,
		       guint callback_action,
		       GtkWidget *widget) {
  if (gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM (widget)))
    action_exec ("set_sub (5);", NULL, NULL);
}

static void sub_ch6_cb(gpointer callback_data,
		       guint callback_action,
		       GtkWidget *widget) {
  if (gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM (widget)))
    action_exec ("set_sub (6);", NULL, NULL);
}

static void sub_ch7_cb(gpointer callback_data,
		       guint callback_action,
		       GtkWidget *widget) {
  if (gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM (widget)))
    action_exec ("set_sub (7);", NULL, NULL);
}

static GtkItemFactoryEntry menu_items[] = {
  { "/_File",                  NULL,         NULL, 0, "<Branch>" },
  { "/File/_Open...",          "<control>O", open_cb, 0, NULL },
  { "/File/Open _MRL...",      "<control>M", open_mrl_cb, 0, NULL },
  { "/File/sep0",              NULL,         NULL, 0, "<Separator>" },
  { "/File/Preferences...",    NULL,         preferences_cb, 0, NULL },
  { "/File/Keybindings...",    NULL,         keybindings_cb, 0, NULL },
  { "/File/sep1",              NULL,         NULL, 0, "<Separator>" },
  { "/File/sep2",              NULL,         NULL, 0, "<Separator>" },
  { "/File/Snapshot...",       "<control>S", snapshot_cb, 0, NULL },
  { "/File/sep3",              NULL,         NULL, 0, "<Separator>" },
  { "/File/Quit",              "<control>Q", exit_cb, 0, NULL },
  { "/_View",                  NULL,         NULL, 0, "<Branch>" },
  { "/View/_Fullscreen mode",  "<control>F", fullscreen_cb, 0, NULL },
  { "/View/sep3",              NULL,         NULL, 0, "<Separator>" },
  { "/View/_50%",              NULL,         factor_50_cb, 0, NULL },
  { "/View/_100%",             NULL,         factor_100_cb, 0, NULL },
  { "/View/_200%",             NULL,         factor_200_cb, 0, NULL },
  { "/View/sep4",              NULL,         NULL, 0, "<Separator>" },
  { "/View/Zoom in",           NULL,         zoom_in_cb, 0, NULL },
  { "/View/Zoom out",          NULL,         zoom_out_cb, 0, NULL },
  { "/View/sep5",              NULL,         NULL, 0, "<Separator>" },
  { "/View/_DeInterlace",      "<control>I", deinterlace_cb, 0, "<CheckItem>" }, 
  { "/View/_Aspect ratio",     NULL,         NULL, 0, "<Branch>" },
  { "/View/Aspect ratio/Auto", NULL,         aspect_auto_cb, 0, NULL},
  { "/View/Aspect ratio/Square",NULL,        aspect_square_cb, 0, NULL},
  { "/View/Aspect ratio/4:3",  NULL,         aspect_4_3_cb, 0, NULL},
  { "/View/Aspect ratio/16:9", NULL,         aspect_16_9_cb, 0, NULL},
  { "/View/Aspect ratio/Don't touch", NULL,  aspect_dt_cb, 0, NULL},
  { "/View/sep6",              NULL,         NULL, 0, "<Separator>" },
  { "/View/_Visualizations",   NULL,         NULL, 0, "<Branch>" },
  { "/View/Visualizations/None", NULL,       vis_none_cb, 0, "<RadioItem>"},
  { "/View/sep7",              NULL,         NULL, 0, "<Separator>" },
  { "/View/_Subtitles",        NULL,         NULL, 0, "<Branch>" },
  { "/View/Subtitles/Auto",    NULL,         sub_auto_cb, 0, "<RadioItem>"},
  { "/View/Subtitles/None",    NULL,         sub_none_cb, 0, "/View/Subtitles/Auto"},
  { "/View/Subtitles/Channel 0", NULL,       sub_ch0_cb, 0, "/View/Subtitles/Auto"},
  { "/View/Subtitles/Channel 1", NULL,       sub_ch1_cb, 0, "/View/Subtitles/Auto"},
  { "/View/Subtitles/Channel 2", NULL,       sub_ch2_cb, 0, "/View/Subtitles/Auto"},
  { "/View/Subtitles/Channel 3", NULL,       sub_ch3_cb, 0, "/View/Subtitles/Auto"},
  { "/View/Subtitles/Channel 4", NULL,       sub_ch4_cb, 0, "/View/Subtitles/Auto"},
  { "/View/Subtitles/Channel 5", NULL,       sub_ch5_cb, 0, "/View/Subtitles/Auto"},
  { "/View/Subtitles/Channel 6", NULL,       sub_ch6_cb, 0, "/View/Subtitles/Auto"},
  { "/View/Subtitles/Channel 7", NULL,       sub_ch7_cb, 0, "/View/Subtitles/Auto"},
  { "/_Media",                 NULL,         NULL, 0, "<Branch>" },
  { "/Media/_Add Mediamark...","<control>D", mediamarks_add_cb, 0, NULL },
  { "/Media/_Manage Medimarks...","<control>B", mediamarks_manage_cb, 0, NULL },
  { "/Media/_Import Medimarks...",NULL,      mediamarks_import_cb, 0, NULL },
  { "/Media/sep8",             NULL,         NULL, 0, "<Separator>" },
  { "/_Help",                  NULL,         NULL, 0, "<LastBranch>" },
  { "/Help/About...",          NULL,         about_cb, 0, NULL },
  { "/Help/Engine _Log...",    "<control>L", log_cb, 0, NULL },
  { "/Help/Stream _Info...",   NULL,         stream_info_cb, 0, NULL },
  { "/Help/sep6",              NULL,         NULL, 0, "<Separator>" },
  { "/Help/_Re-run setup wizards...", NULL,  wizards_cb, 0, NULL },
};

GtkWidget *create_menus (GtkWidget *window) {

  GtkAccelGroup    *accel_group;
  gint              nmenu_items = sizeof (menu_items) / sizeof (menu_items[0]);
  GtkRadioMenuItem *none_item;

  accel_group = gtk_accel_group_new ();

  item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>", 
                                       accel_group);

  gtk_item_factory_create_items (item_factory, nmenu_items, menu_items, NULL);

  gtk_window_add_accel_group (GTK_WINDOW (window), accel_group);

  media_menu = GTK_MENU_SHELL (gtk_item_factory_get_widget (item_factory, "/Media"));

  add_autoplay_entries (GTK_MENU_SHELL (gtk_item_factory_get_widget (item_factory, "/File")));
  none_item = GTK_RADIO_MENU_ITEM (gtk_item_factory_get_item (item_factory, "/View/Visualizations/None"));
  add_vis_entries (GTK_MENU_SHELL (gtk_item_factory_get_widget (item_factory, "/View/Visualizations")), none_item) ;


  return gtk_item_factory_get_widget (item_factory, "<main>");
}

