/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */


#ifndef PA_FACTORY_H
#define PA_FACTORY_H

#include <klibloader.h>
class KInstance;
class KAboutData;

class PaFactory : public KLibFactory
{
	Q_OBJECT
public:
	PaFactory( QObject *parent=0, const char *name=0);
	~PaFactory();

	virtual QObject *createObject( QObject *parent=0, const char *name=0
					, const char *classname="QObject"
					, const QStringList &args = QStringList());

	static KInstance *instance();

private: 
	static KInstance *s_instance;
	static KAboutData *s_about;
};

#endif
