/***************************************************************************
                          kverbosview.h  -  description
                             -------------------
    begin                : Fre Dez 14 19:28:09 CET 2001
    copyright            : (C) 2001 by Arnold Kraschinski
    email                : arnold.k67@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KVERBOSVIEW_H
#define KVERBOSVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for Qt
#include <qwidget.h>
#include <qlernen.h>
#include <qstring.h>

// weitere include-Files fr das Programm
#include <verbspanish.h>
#include <kverbos.h>

// forward-Deklaration der Klasse. Whrend man die API-Dokumentation erstellt,
// muss diese Zeile auskommentiert werden, weil sonst der falsche Text als Beschreibung
// der Klasse erkannt wird.
//class KVerbosDoc;

/** The KVerbosView class provides the view widget for the KVerbosApp instance.	
 * The View instance inherits QWidget as a base class and represents the view object of a KTMainWindow. As KVerbosView is part of the
 * docuement-view model, it needs a reference to the document object connected with it by the KVerbosApp class to manipulate and display
 * the document structure provided by the KVerbosDoc class.
 * 	
 * Diese Klasse soll folgende Funktionen erfllen:
 *  - sie soll das momentan ausgewhlte Verb vom Dokument holen.
 *    Diese Information enthlt die spanische und deutsche Bedeutung des Verbes, die Zeit, die
 *    momentan getestet werden soll, und alle Verbformen, die zu dieser Zeit gehren.
 *  - die Klasse nimmt die Eingaben des Benutzers entgegen und prft anschlieend, ob die Ein-
 *    gaben richtig sind.
 *  - Die Informationen, wie viele Verben richtig gebt und wie viele falsch gebt wurden, soll
 *    direkt in dieser Klasse gespeichert werden und nicht im Dokument.
 *  - Die Klasse meldet an das Dokument, wenn es Zeit ist sich ein neues Verb zu suchen.
 *    Das ist in folgenden Fllen ntig:
 *          - wenn die Klasse zum ersten Mal gestartet wird und ein erstes Verb eingestellt werden
 *            soll.
 *          - wenn ein neues Dokument mit Verben geladen wird.
 *          - wenn der Benutzer die Formen richtig eingegeben hat.
 *          - wenn ihm nichts mehr einfllt und er weiter will.
 *
 * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
 * @version KDevelop version 0.4 code generation
 */
class KVerbosView : public QLernen /*QWidget*/
{
  Q_OBJECT
public:
  /** Constructor for the main view */
  KVerbosView(QWidget *parent = 0, const char *name=0);
  /** Destructor for the main view */
  ~KVerbosView();

  /** returns a pointer to the document connected to the view instance. Mind that this method requires a KVerbosApp instance as a parent
   * widget to get to the window document pointer by calling the KVerbosApp::getDocument() method.
   *
   * @see KVerbosApp#getDocument
   */
  KVerbosDoc* getDocument() const;

  /** contains the implementation for printing functionality */
  void print(QPrinter *pPrinter);
	/** This funktion erases all accents from the letters of a string
	  */
	QString deleteAccents(const QString& s) const;
	/** tell the view that the user has changed. Training results are deleted and set to the
	  * initial values. A new verb is choosen. The function returns the training result of the
	  * old user. r1 is the training results and r2 is the number of the trained verbs.
	  */
	int userChanged(int& r1, int& r2);
	
public slots:
  /** Die folgenden Slots werden aufgerufen, wenn ein Button mit einem
   *  spanischen Sonderzeichen gedrckt wird.
   *  Das Zeichen wird dann dem Eingabefeld, das den Focus hat zugefgt.
   */
  virtual void slotN();
  virtual void slotA();
  virtual void slotE();
  virtual void slotI();
  virtual void slotO();
  virtual void slotU();
  /** all the LineEdits will be cleared
    */
  virtual void slotClearAll();
  /** if the verb is already corrected (corrected == true) then the font is
    * set to the normal font
    */
  virtual void slotFont();
	/** if the time is a progressiv or a perfect form the input of the yo-Editbox
    * which contains the gerund or the partizip is copied into the others.
    */
  virtual void slotCopyText();
  /** Die Ansicht wird aufgefordert sich das aktuelle Verb vom Dokument zu holen
   *  sich eine Zeit auszuwhlen und dann das Verb in dem Fenster zum ben bereitzustellen
   */
  virtual void zeigeVerb();
  /** Es soll ein anderes Verb zum Lernen ausgewhlt werden, das momentan eingegebene wird
      nicht gewertet.
    */
  virtual void slotWeiter();
  /** The input should be corrected.
    */
  virtual void slotCorregir();
  /** The solution should be shown in the window
    */
  virtual void slotSolution();


signals:
  void numberTrainedChanged(int);
  void numberCorrectChanged(int);
  void informKFeeder(int);

private:
  /** the following variables store the information about the actual verb. The information
    * is obtained from the doc.
    */
	QString espanol;
	QString aleman;
	int zeitAuswahl;
	QString formen[7][3];
	/** tells if the actual input already has been correced by using the button */
	bool corrected;
	/** Are pointers to the GUI elements for an easier use */
	QLineEdit* formEdit[6][3];
	/** the number of verbs that habe been correct */
	int enteredCorrect;
	/** the number of all verbs that have been trained */
	int verbsTrained;
};

#endif // KVERBOSVIEW_H
