/***************************************************************************
                          keducaprefs.cpp  -  description
                             -------------------
    begin                : Sat Jun 2 2001
    copyright            : (C) 2001 by Javier Campos
    email                : javi_cms@terra.es
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "keducaprefs.h"
#include "keducaprefs.moc"

#include <klocale.h>
#include <kstandarddirs.h>
#include <kiconloader.h>
#include <kconfig.h>

#include <qlayout.h>
#include <qvbox.h>
#include <qbuttongroup.h>


KEducaPrefs::KEducaPrefs(QWidget *parent, const char *name, bool modal ) : KDialogBase(IconList, i18n("Configure"), Ok|Cancel, Ok, parent, name, modal, true)
{
    setPageGeneral();
    configRead();
}

KEducaPrefs::~KEducaPrefs(){}

/** Set page general */
void KEducaPrefs::setPageGeneral()
{
    QVBox *mainFrame = addVBoxPage( i18n("Miscellaneous"), i18n("Various Settings"), DesktopIcon("misc"));

    QButtonGroup *buttonGroup1 = new QButtonGroup( mainFrame, "ButtonGroup1" );
    buttonGroup1->setTitle( i18n( "General" ) );
    buttonGroup1->setColumnLayout(0, Qt::Vertical );
    buttonGroup1->layout()->setSpacing( 0 );
    buttonGroup1->layout()->setMargin( 0 );
    QVBoxLayout *buttonGroup1Layout = new QVBoxLayout( buttonGroup1->layout() );
    buttonGroup1Layout->setAlignment( Qt::AlignTop );
    buttonGroup1Layout->setSpacing( 6 );
    buttonGroup1Layout->setMargin( 11 );

    _resultAfterNext = new QRadioButton( buttonGroup1, "RadioButton1" );
    _resultAfterNext->setText( i18n( "Show results of the answer after press next" ) );
    buttonGroup1Layout->addWidget( _resultAfterNext );

    _resultAfterFinish = new QRadioButton( buttonGroup1, "RadioButton2" );
    _resultAfterFinish->setText( i18n( "Show results when finish the test" ) );
    buttonGroup1Layout->addWidget( _resultAfterFinish );

//	mainFrame->addWidget( buttonGroup1 );
//	QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
//	spacer->add( mainFrame );
}

/** Read settings */
void KEducaPrefs::configRead()
{
    KConfig *config = KGlobal::config();
    config->setGroup("Options");
    QSize defaultSize(500,400);
    this->resize( config->readSizeEntry("Geometry", &defaultSize ) );
    config->readBoolEntry("ResultFinish", true ) ? _resultAfterFinish->setChecked(true) : _resultAfterNext->setChecked(true);
}

/** Write settings */
void KEducaPrefs::configWrite()
{
    KConfig *config = KGlobal::config();
    config->setGroup("Options");
    config->writeEntry("Geometry", this->size() );
    config->writeEntry("ResultFinish", _resultAfterFinish->isChecked() );
    config->sync();
}

/** Push ok button */
void KEducaPrefs::slotOk()
{
    configWrite();
    this->accept();
}

