/***************************************************************************
                            KToolBarPopupAction.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KTOOLBARPOPUPACTION_H
#define KTOOLBARPOPUPACTION_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KAction.h>

/**

 This action is a normal action everywhere, except in a toolbar
 where it also has a delayed popupmenu. This action is designed
 for history actions (back/forward, undo/redo) and for any other action
 that has more detail in a toolbar than in a menu (e.g. tool chooser
 with "Other" leading to a dialog...).
 
 @short 
 This action is a normal action everywhere, except in a toolbar
 where it also has a delayed popupmenu.
*/
@class KPopupMenu; 

@class QKeySequence; 

@class KGuiItem; 
@class KShortcut; 

@interface KToolBarPopupAction : KAction 

/** 
 Create a KToolBarPopupAction, with a text, an icon, an optionnal accelerator,
 parent and name.

*/
- initWithText: (NSString *)text icon: (NSString *)icon cut: (KShortcut*)cut parent: (QObject *)parent name: (NSString *)name;
- initWithText: (NSString *)text icon: (NSString *)icon ;

/** 
 Create a KToolBarPopupAction, with a text, an icon, an accelerator,
 a slot connected to the action, parent and name.

 If you do not want or have a keyboard accelerator, set the
 @p accel param to 0.

*/
- initWithText: (NSString *)text icon: (NSString *)icon cut: (KShortcut*)cut receiver: (QObject *)receiver slot: (NSString *)slot parent: (QObject *)parent name: (NSString *)name;
- initWithText: (NSString *)text icon: (NSString *)icon cut: (KShortcut*)cut receiver: (QObject *)receiver slot: (NSString *)slot ;

/** 
 Create a KToolBarPopupAction, with a KGuiItem, an accelerator,
 a slot connected to the action, parent and name. The text and the
 icon are taken from the KGuiItem.

 If you do not want or have a keyboard accelerator, set the
 @p accel param to 0.

*/
- initWithGuiItem: (KGuiItem*)item cut: (KShortcut*)cut receiver: (QObject *)receiver slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
- (void) dealloc;
- (int) plug: (QWidget *)widget index: (int)index;
- (int) plug: (QWidget *)widget ;
- unplug: (QWidget *)widget;

/** 
 The popup menu that is shown when clicking (some time) on the toolbar
 button. You may want to plug items into it on creation, or connect to
 aboutToShow for a more dynamic menu.
     
*/
- (KPopupMenu*) popupMenu;

/** 
 Returns true if this action creates a delayed popup menu
 when plugged in a KToolbar.
     
*/
- (BOOL) delayed;

/** 
 If set to true, this action will create a delayed popup menu
 when plugged in a KToolbar. Otherwise it creates a normal popup.
 Default: delayed.
     
*/
- setDelayed: (BOOL)delayed;

/** 
 Returns true if this action creates a sticky popup menu.
 See @ref setStickyMenu.
     
*/
- (BOOL) stickyMenu;

/** 
 If set to true, this action will create a sticky popup menu
 when plugged in a KToolbar.
 "Sticky", means it's visible until a selection is made or the mouse is
 clicked elsewhere. This feature allows you to make a selection without
 having to press and hold down the mouse while making a selection.
 Only available if -delayed is true.
 Default: sticky.
     
*/
- setStickyMenu: (BOOL)sticky;
@end

/** Override these methods in subclasses of KToolBarPopupAction to customise event handling behaviour */
@protocol KToolBarPopupActionEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
