/***************************************************************************
                            kde_KUniqueApplication.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KUNIQUEAPPLICATION
#define KDE_KUNIQUEAPPLICATION

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Maintains only a single
 instance of a running application at a time.

 If another instance
 is started, it will determine (via DCOP) whether it is the first instance
 or a second instance.  If it is a second instance, it will forward on
 the information to the first instance and then quit.

 @author Preston Brown <pbrown@kde.org>
 
 @short *
 Maintains only a single
 instance of a running application at a time.
*/

/** *
 Constructor. Takes command line arguments from KCmdLineArgs

*/
kde_KUniqueApplication * kde_new_KUniqueApplication(int allowStyles, int GUIenabled, int configUnique);

/** *
 Destructor
   
*/
void kde_del_KUniqueApplication( kde_KUniqueApplication* p );

/** *
 Dispatches any incoming DCOP message for a new instance.

 If it is not a request for a new instance, return false.
 Overloaded from @ref DCOPObject to make sure that the application
 stays unique.

*/
int kde_KUniqueApplication_process(kde_KUniqueApplication* instPointer,qt_QCString* fun, qt_QByteArray* data, qt_QCString* replyType, qt_QByteArray* replyData);

/** *
 Creates a new "instance" of the application.

 Usually this will involve making some calls into the GUI portion of your
 application asking for a new window to be created, possibly with
 some data already loaded based on the arguments received.

 Command line arguments have been passed to KCmdLineArgs before this
 function is called and can be checked in the usual way.

 Note that newInstance() is called also in the first started 
 application process.

*/
int kde_KUniqueApplication_newInstance(kde_KUniqueApplication* instPointer);

/** *
 Adds command line options specific for KUniqueApplication.

 Should be called before calling KUniqueApplication constructor
 and / or start().
   
*/
void kde_KUniqueApplication_addCmdLineOptions( );

/** *
 Forks and registers with dcop.

 The command line arguments are being sent via DCOP to @ref newInstance()
 and will be received once the application enters the event loop.

 Typically this is used like:
 <pre>
 int main(int argc, char **argv) {
    KAboutData about("myappname", "myAppName", .....);
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions( myCmdOptions );
    KUniqueApplication::addCmdLineOptions();

    if (!KUniqueApplication::start()) {
       fprintf(stderr, "myAppName is already running!\n");
       exit(0);
    }
    KUniqueApplication a;
    a.exec();
 }
 </pre>
 Note that it's not necessary to call @ref start() explicitly. It will be
 called automatically before creating KUniqueApplication if it hasn't
 been called yet, without any performance impact.

*/
int kde_KUniqueApplication_start( );
void kde_KUniqueApplication_virtual_hook(kde_KUniqueApplication* instPointer,int identifier, void* data);

/** Casts a 'kde_KUniqueApplication *' to a 'kde_DCOPObject*' */
kde_DCOPObject* kde_KUniqueApplication_DCOPObject(kde_KUniqueApplication* instPointer);

/** Casts a 'kde_KUniqueApplication *' to a 'kde_KApplication*' */
kde_KApplication* kde_KUniqueApplication_KApplication(kde_KUniqueApplication* instPointer);

#endif
