#ifndef __RULES_H__
#define __RULES_H__


#include <qstring.h>
#include <qdict.h>
#include <qmap.h>

class KeyRules
{
public:

  KeyRules(QString rule="xfree86");

  const QDict<char> &models() { return _models; };
  const QDict<char> &layouts() { return _layouts; };
  const QDict<char> &options() { return _options; };
  const QDict<char> &encodings() { return _encodings; };
  const QMap<QString, unsigned int> &initialGroup() { return _initialGroup; }
    
  void parseVariants(const QStringList& vars, QDict<char>& variants);
  static QStringList rules(QString path = QString::null);
  QStringList getVariants(const QString& layout);
  unsigned int getGroup(const QString& layout);

protected:

  void loadRules(QString filename);
  void loadEncodings(QString filename);
  void loadOldLayouts(QString filename);

private:

  QDict<char> _models;
  QDict<char> _layouts;
  QDict<char> _options;
  QDict<char> _encodings;
  QMap<QString, unsigned int> _initialGroup;
  QDict<QStringList> _varLists;
  QStringList m_oldLayouts;
  QStringList m_nonLatinLayouts;
  bool m_xfree43;
};


#endif
