#ifndef KPTERMD_H
#define KPTERMD_H

#include "../config.h"

#include <qmultilineedit.h>
#include <qstringlist.h>
#include <qlayout.h>
#include <qlabel.h>

#include <klocale.h>
#include <kdialogbase.h>
#include <kpackage.h>
#include <kpPty.h>

//////////////////////////////////////////////////////////////////////////////
class kpTerm: public QMultiLineEdit
{ 
  Q_OBJECT

public:
  kpTerm(kpPty *pt, QWidget * parent=0, const char * name=0);
  void keyPressEvent ( QKeyEvent * e );
  bool run(QString cmd, QStringList &r);
  void doConnect();
  void doUnconnect();
  void insert ( const QString & str, bool mark=FALSE );
  kpPty *pty;
  void cancel();
  void done();

public slots:
  void textIn(QString);
  void slotResult(QStringList &, int);

signals:
  void keyOut(char);
  void result(QStringList &, int);

};

//////////////////////////////////////////////////////////////////////////////

class kpRun: public KDialogBase
{
  Q_OBJECT

public:
  kpRun(QWidget *parent = 0);
  bool run(QString cmd, QString title);
  void addText(QStringList ret);

public slots:
  void slotResult(QStringList &, int);
  void slotCancel();

private:
  kpTerm *term;
  QLabel *title;
};	
//////////////////////////////////////////////////////////////////////////////
#endif
