#
# procps.spec - procps RPM spec file
# Robert M. Love, 19 Sept 2002
# Last Updated 23 Nov 2002
#

Summary: System and process monitoring utilities
Name: procps
Version: 2.0.16
Release: 1
License: GPL
Group: Applications/System
Source: procps-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-root
Prereq: /bin/rm /sbin/ldconfig
BuildRequires: ncurses-devel

%description
The procps package contains a set of system utilities that provide
system information -- ps, sysctl, uptime, tload, free, w, top,
vmstat, watch, skill, snice, pgrep, pkill, pmap, and slabtop -- as 
well as the libproc library.

The package is so named because the utilities make use of the Linux
"/proc" virtual filesystem and because "ps" is the most common
utility in the package.

Install this package if you need to view information about processes
on your system.  You probably want at least the ps utility.

%prep
%setup -q

%build
make CC="gcc $RPM_OPT_FLAGS" MANDIR=%{_mandir}

%install
rm -rf %{buildroot}
mkdir -p %{buildroot}/bin %{buildroot}/usr/bin %{buildroot}/sbin
mkdir -p %{buildroot}/%{_lib} %{buildroot}%{_mandir}/{man1,man5,man8}
make DESTDIR=%{buildroot} SHLIBDIR=%{buildroot}/%{_lib} OWNERGROUP= MANDIR=%{_mandir} install

%clean
rm -rf %{buildroot}

%post
/sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(0644,root,root,755)
%doc BUGS NEWS COPYING COPYING.LIB TODO
%attr(755,root,root) /%{_lib}/libproc.so.2.0.16
%attr(555,root,root) /bin/ps
%attr(555,root,root) /sbin/sysctl
%attr(555,root,root) /usr/bin/uptime
%attr(555,root,root) /usr/bin/tload
%attr(555,root,root) /usr/bin/free
%attr(555,root,root) /usr/bin/w
%attr(555,root,root) /usr/bin/top
%attr(555,root,root) /usr/bin/vmstat
%attr(555,root,root) /usr/bin/watch
%attr(555,root,root) /usr/bin/skill
%attr(555,root,root) /usr/bin/snice
%attr(555,root,root) /usr/bin/pgrep
%attr(555,root,root) /usr/bin/pkill
%attr(555,root,root) /usr/bin/pmap
%attr(555,root,root) /usr/bin/slabtop
%attr(0644,root,root) %{_mandir}/man1/ps.1*
%attr(0644,root,root) %{_mandir}/man1/free.1*
%attr(0644,root,root) %{_mandir}/man1/skill.1*
%attr(0644,root,root) %{_mandir}/man1/snice.1*
%attr(0644,root,root) %{_mandir}/man1/pgrep.1*
%attr(0644,root,root) %{_mandir}/man1/pkill.1*
%attr(0644,root,root) %{_mandir}/man1/pmap.1*
%attr(0644,root,root) %{_mandir}/man1/tload.1*
%attr(0644,root,root) %{_mandir}/man1/top.1*
%attr(0644,root,root) %{_mandir}/man1/slabtop.1*
%attr(0644,root,root) %{_mandir}/man1/uptime.1*
%attr(0644,root,root) %{_mandir}/man1/w.1*
%attr(0644,root,root) %{_mandir}/man1/watch.1*
%attr(0644,root,root) %{_mandir}/man5/sysctl.conf.5*
%attr(0644,root,root) %{_mandir}/man8/vmstat.8*
%attr(0644,root,root) %{_mandir}/man8/sysctl.8*

%changelog
* Sat Sep 13 2003 Robert Love <rml@tech9.net>
- install slabtop(1) man page

* Thu Sep 11 2003 Chris Rivera <cmrivera@ufl.edu>
- add slabtop binary

* Sun Aug 10 2003 Robert Love <rml@tech9.net>
- install pmap(1)'s man page

* Fri Jan 10 2003 Robert Love <rml@tech9.net>
- no longer need to remove oldps, as it is no longer part of the package

* Sat Nov 23 2002 Robert Love <rml@tech9.net>
- support non-standard lib directories, e.g. for x86_64 (from Red Hat spec)
- remove unpackaged oldps and oldps.1 after build

* Sat Nov 16 2002 Robert Love <rml@tech9.net>
- remove oldps.1, too

* Thu Nov 07 2002 Robert Love <rml@tech9.net>
- remove oldps from package
- no need to create the X directories now that top.desktop is gone
 
* Tue Nov 05 2002 Robert Love <rml@tech9.net>
- add pmap and NEWS to the package install list

* Fri Oct 04 2002 Robert Love <rml@tech9.net>
- support a build root so you can build RPM without being root

* Thu Sep 19 2002 Robert Love <rml@tech9.net>
- initial packaging of 2.0.7 CVS 20020919
