/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Transforms;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.Vector;
import java2d.AnimatingControlsSurface;
import java2d.CustomControls;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TransformAnim
extends AnimatingControlsSurface {
    private static TexturePaint texture;
    private static BasicStroke bs;
    private static Font[] fonts;
    private static String[] strings;
    private static String[] imgs;
    private static Paint[] paints;
    private Vector vector = new Vector(13);
    private int numShapes;
    private int numStrings;
    private int numImages;
    protected boolean doRotate = true;
    protected boolean doTranslate = true;
    protected boolean doScale = true;
    protected boolean doShear;

    public TransformAnim() {
        this.setBackground(Color.black);
        this.setStrings(1);
        this.setImages(2);
        this.setShapes(10);
        this.setControls(new Component[]{new DemoControls(this)});
        this.setConstraints(new String[]{"East"});
    }

    public void setImages(int n) {
        if (n < this.numImages) {
            Vector vector = new Vector(this.vector.size());
            for (int i = 0; i < this.vector.size(); ++i) {
                if (!(((ObjectData)this.vector.get((int)i)).object instanceof Image)) continue;
                vector.addElement(this.vector.get(i));
            }
            this.vector.removeAll(vector);
            vector.setSize(n);
            this.vector.addAll(vector);
        } else {
            Dimension dimension = this.getSize();
            for (int i = this.numImages; i < n; ++i) {
                Image image = this.getImage(imgs[i % imgs.length]);
                ObjectData objectData = new ObjectData(image, Color.black);
                objectData.reset(dimension.width, dimension.height);
                this.vector.addElement(objectData);
            }
        }
        this.numImages = n;
    }

    public void setStrings(int n) {
        if (n < this.numStrings) {
            Vector vector = new Vector(this.vector.size());
            for (int i = 0; i < this.vector.size(); ++i) {
                if (!(((ObjectData)this.vector.get((int)i)).object instanceof TextData)) continue;
                vector.addElement(this.vector.get(i));
            }
            this.vector.removeAll(vector);
            vector.setSize(n);
            this.vector.addAll(vector);
        } else {
            Dimension dimension = this.getSize();
            for (int i = this.numStrings; i < n; ++i) {
                int n2 = i % fonts.length;
                int n3 = i % strings.length;
                TextData textData = new TextData(strings[n3], fonts[n2]);
                ObjectData objectData = new ObjectData(textData, paints[i % paints.length]);
                objectData.reset(dimension.width, dimension.height);
                this.vector.addElement(objectData);
            }
        }
        this.numStrings = n;
    }

    public void setShapes(int n) {
        if (n < this.numShapes) {
            Vector vector = new Vector(this.vector.size());
            for (int i = 0; i < this.vector.size(); ++i) {
                if (!(((ObjectData)this.vector.get((int)i)).object instanceof Shape)) continue;
                vector.addElement(this.vector.get(i));
            }
            this.vector.removeAll(vector);
            vector.setSize(n);
            this.vector.addAll(vector);
        } else {
            Dimension dimension = this.getSize();
            for (int i = this.numShapes; i < n; ++i) {
                Shape shape = null;
                switch (i % 7) {
                    case 0: {
                        shape = new GeneralPath();
                        break;
                    }
                    case 1: {
                        shape = new Rectangle2D.Double();
                        break;
                    }
                    case 2: {
                        shape = new Ellipse2D.Double();
                        break;
                    }
                    case 3: {
                        shape = new Arc2D.Double();
                        break;
                    }
                    case 4: {
                        shape = new RoundRectangle2D.Double();
                        break;
                    }
                    case 5: {
                        shape = new CubicCurve2D.Double();
                        break;
                    }
                    case 6: {
                        shape = new QuadCurve2D.Double();
                    }
                }
                ObjectData objectData = new ObjectData(shape, paints[i % paints.length]);
                objectData.reset(dimension.width, dimension.height);
                this.vector.addElement(objectData);
            }
        }
        this.numShapes = n;
    }

    public void reset(int n, int n2) {
        for (int i = 0; i < this.vector.size(); ++i) {
            ((ObjectData)this.vector.get(i)).reset(n, n2);
        }
    }

    public void step(int n, int n2) {
        for (int i = 0; i < this.vector.size(); ++i) {
            ((ObjectData)this.vector.get(i)).step(n, n2, this);
        }
    }

    public void render(int n, int n2, Graphics2D graphics2D) {
        for (int i = 0; i < this.vector.size(); ++i) {
            ObjectData objectData = (ObjectData)this.vector.get(i);
            graphics2D.setTransform(objectData.at);
            graphics2D.setPaint(objectData.paint);
            if (objectData.object instanceof Image) {
                graphics2D.drawImage((Image)objectData.object, 0, 0, this);
                continue;
            }
            if (objectData.object instanceof TextData) {
                graphics2D.setFont(((TextData)objectData.object).font);
                graphics2D.drawString(((TextData)objectData.object).string, 0, 0);
                continue;
            }
            if (objectData.object instanceof QuadCurve2D || objectData.object instanceof CubicCurve2D) {
                graphics2D.setStroke(bs);
                graphics2D.draw((Shape)objectData.object);
                continue;
            }
            if (!(objectData.object instanceof Shape)) continue;
            graphics2D.fill((Shape)objectData.object);
        }
    }

    public static void main(String[] stringArray) {
        TransformAnim.createDemoFrame(new TransformAnim());
    }

    static {
        BufferedImage bufferedImage = new BufferedImage(10, 10, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.red);
        graphics2D.fillOval(0, 0, 9, 9);
        texture = new TexturePaint(bufferedImage, new Rectangle(0, 0, 10, 10));
        bs = new BasicStroke(6.0f);
        fonts = new Font[]{new Font("Times New Roman", 0, 48), new Font("serif", 3, 24), new Font("Courier", 1, 36), new Font("Arial", 3, 64), new Font("Helvetica", 0, 52)};
        strings = new String[]{"Transformation", "Rotate", "Translate", "Shear", "Scale"};
        imgs = new String[]{"duke.gif"};
        paints = new Paint[]{Color.red, Color.blue, texture, Color.green, Color.magenta, Color.orange, Color.pink, Color.cyan, new Color(0, 255, 0, 128), new Color(0, 0, 255, 128), Color.yellow, Color.lightGray, Color.white};
    }

    static class DemoControls
    extends CustomControls
    implements ActionListener,
    ChangeListener {
        TransformAnim demo;
        JSlider shapeSlider;
        JSlider stringSlider;
        JSlider imageSlider;
        Font font = new Font("serif", 0, 10);
        JToolBar toolbar;

        public DemoControls(TransformAnim transformAnim) {
            super(transformAnim.name);
            this.demo = transformAnim;
            this.setBackground(Color.gray);
            this.setLayout(new BoxLayout(this, 1));
            this.add(Box.createVerticalStrut(5));
            JToolBar jToolBar = new JToolBar(1);
            jToolBar.setBackground(Color.gray);
            jToolBar.setFloatable(false);
            this.shapeSlider = new JSlider(0, 0, 20, transformAnim.numShapes);
            this.shapeSlider.addChangeListener(this);
            TitledBorder titledBorder = new TitledBorder(new EtchedBorder());
            titledBorder.setTitleFont(this.font);
            titledBorder.setTitle(String.valueOf(transformAnim.numShapes) + " Shapes");
            this.shapeSlider.setBorder(titledBorder);
            this.shapeSlider.setPreferredSize(new Dimension(80, 44));
            jToolBar.add(this.shapeSlider);
            jToolBar.addSeparator();
            this.stringSlider = new JSlider(0, 0, 10, transformAnim.numStrings);
            this.stringSlider.addChangeListener(this);
            titledBorder = new TitledBorder(new EtchedBorder());
            titledBorder.setTitleFont(this.font);
            titledBorder.setTitle(String.valueOf(transformAnim.numStrings) + " Strings");
            this.stringSlider.setBorder(titledBorder);
            this.stringSlider.setPreferredSize(new Dimension(80, 44));
            jToolBar.add(this.stringSlider);
            jToolBar.addSeparator();
            this.imageSlider = new JSlider(0, 0, 10, transformAnim.numImages);
            this.imageSlider.addChangeListener(this);
            titledBorder = new TitledBorder(new EtchedBorder());
            titledBorder.setTitleFont(this.font);
            titledBorder.setTitle(String.valueOf(transformAnim.numImages) + " Images");
            this.imageSlider.setBorder(titledBorder);
            this.imageSlider.setPreferredSize(new Dimension(80, 44));
            jToolBar.add(this.imageSlider);
            jToolBar.addSeparator();
            this.add(jToolBar);
            this.toolbar = new JToolBar();
            this.toolbar.setBackground(Color.gray);
            this.toolbar.setFloatable(false);
            this.addButton("T", "translate", transformAnim.doTranslate);
            this.addButton("R", "rotate", transformAnim.doRotate);
            this.addButton("SC", "scale", transformAnim.doScale);
            this.addButton("SH", "shear", transformAnim.doShear);
            this.add(this.toolbar);
        }

        public void addButton(String string, String string2, boolean bl) {
            JButton jButton = (JButton)this.toolbar.add(new JButton(string));
            jButton.setFont(this.font);
            jButton.setSelected(bl);
            jButton.setToolTipText(string2);
            jButton.setBackground(bl ? Color.green : Color.lightGray);
            jButton.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton;
            jButton.setSelected(!(jButton = (JButton)actionEvent.getSource()).isSelected());
            jButton.setBackground(jButton.isSelected() ? Color.green : Color.lightGray);
            if (jButton.getText().equals("T")) {
                this.demo.doTranslate = jButton.isSelected();
            } else if (jButton.getText().equals("R")) {
                this.demo.doRotate = jButton.isSelected();
            } else if (jButton.getText().equals("SC")) {
                this.demo.doScale = jButton.isSelected();
            } else if (jButton.getText().equals("SH")) {
                this.demo.doShear = jButton.isSelected();
            }
            if (this.demo.animating.thread == null) {
                this.demo.repaint();
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            int n = jSlider.getValue();
            TitledBorder titledBorder = (TitledBorder)jSlider.getBorder();
            if (jSlider.equals(this.shapeSlider)) {
                titledBorder.setTitle(String.valueOf(n) + " Shapes");
                this.demo.setShapes(n);
            } else if (jSlider.equals(this.stringSlider)) {
                titledBorder.setTitle(String.valueOf(n) + " Strings");
                this.demo.setStrings(n);
            } else if (jSlider.equals(this.imageSlider)) {
                titledBorder.setTitle(String.valueOf(n) + " Images");
                this.demo.setImages(n);
            }
            if (this.demo.animating.thread == null) {
                this.demo.repaint();
            }
            jSlider.repaint();
        }

        public Dimension getPreferredSize() {
            return new Dimension(80, 36);
        }

        public void run() {
            Thread thread = Thread.currentThread();
            while (this.thread == thread) {
                for (int i = 1; i < this.toolbar.getComponentCount(); ++i) {
                    try {
                        Thread.sleep(4444L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    ((JButton)this.toolbar.getComponentAtIndex(i)).doClick();
                }
            }
            this.thread = null;
        }
    }

    static class ObjectData {
        Object object;
        Paint paint;
        static final int UP = 0;
        static final int DOWN = 1;
        double x;
        double y;
        double ix = 5.0;
        double iy = 3.0;
        int rotate;
        double scale;
        double shear;
        int scaleDirection;
        int shearDirection;
        AffineTransform at = new AffineTransform();

        public ObjectData(Object object, Paint paint) {
            this.object = object;
            this.paint = paint;
            this.rotate = (int)(Math.random() * 360.0);
            this.scale = Math.random() * 1.5;
            this.scaleDirection = Math.random() > 0.5 ? 0 : 1;
            this.shear = Math.random() * 0.5;
            this.shearDirection = Math.random() > 0.5 ? 0 : 1;
        }

        public void reset(int n, int n2) {
            this.x = Math.random() * (double)n;
            this.y = Math.random() * (double)n2;
            double d = 20.0 + Math.random() * (double)((n == 0 ? 400 : n) / 4);
            double d2 = 20.0 + Math.random() * (double)((n2 == 0 ? 300 : n2) / 4);
            if (this.object instanceof Ellipse2D) {
                ((Ellipse2D)this.object).setFrame(0.0, 0.0, d, d2);
            } else if (this.object instanceof Rectangle2D) {
                ((Rectangle2D)this.object).setRect(0.0, 0.0, d, d);
            } else if (this.object instanceof RoundRectangle2D) {
                ((RoundRectangle2D)this.object).setRoundRect(0.0, 0.0, d2, d2, 20.0, 20.0);
            } else if (this.object instanceof Arc2D) {
                ((Arc2D)this.object).setArc(0.0, 0.0, d2, d2, 45.0, 270.0, 2);
            } else if (this.object instanceof QuadCurve2D) {
                ((QuadCurve2D)this.object).setCurve(0.0, 0.0, (double)n * 0.2, (double)n2 * 0.4, (double)n * 0.4, 0.0);
            } else if (this.object instanceof CubicCurve2D) {
                ((CubicCurve2D)this.object).setCurve(0.0, 0.0, 30.0, -60.0, 60.0, 60.0, 90.0, 0.0);
            } else if (this.object instanceof GeneralPath) {
                GeneralPath generalPath = new GeneralPath();
                float f = (float)d;
                generalPath.moveTo(-f / 2.0f, -f / 8.0f);
                generalPath.lineTo(f / 2.0f, -f / 8.0f);
                generalPath.lineTo(-f / 4.0f, f / 2.0f);
                generalPath.lineTo(0.0f, -f / 2.0f);
                generalPath.lineTo(f / 4.0f, f / 2.0f);
                generalPath.closePath();
                this.object = generalPath;
            }
        }

        public void step(int n, int n2, TransformAnim transformAnim) {
            this.at.setToIdentity();
            if (transformAnim.doRotate) {
                if ((this.rotate += 5) == 360) {
                    this.rotate = 0;
                }
                this.at.rotate(Math.toRadians(this.rotate), this.x, this.y);
            }
            this.at.translate(this.x, this.y);
            if (transformAnim.doTranslate) {
                this.x += this.ix;
                this.y += this.iy;
                if (this.x > (double)n) {
                    this.x = n - 1;
                    this.ix = Math.random() * (double)(-n) / 32.0 - 1.0;
                }
                if (this.x < 0.0) {
                    this.x = 2.0;
                    this.ix = Math.random() * (double)n / 32.0 + 1.0;
                }
                if (this.y > (double)n2) {
                    this.y = n2 - 2;
                    this.iy = Math.random() * (double)(-n2) / 32.0 - 1.0;
                }
                if (this.y < 0.0) {
                    this.y = 2.0;
                    this.iy = Math.random() * (double)n2 / 32.0 + 1.0;
                }
            }
            if (transformAnim.doScale && this.scaleDirection == 0) {
                double d;
                this.scale += 0.05;
                if (d > 1.5) {
                    this.scaleDirection = 1;
                }
            } else if (transformAnim.doScale && this.scaleDirection == 1) {
                double d;
                this.scale -= 0.05;
                if (d < 0.5) {
                    this.scaleDirection = 0;
                }
            }
            if (transformAnim.doScale) {
                this.at.scale(this.scale, this.scale);
            }
            if (transformAnim.doShear && this.shearDirection == 0) {
                double d;
                this.shear += 0.05;
                if (d > 0.5) {
                    this.shearDirection = 1;
                }
            } else if (transformAnim.doShear && this.shearDirection == 1) {
                double d;
                this.shear -= 0.05;
                if (d < -0.5) {
                    this.shearDirection = 0;
                }
            }
            if (transformAnim.doShear) {
                this.at.shear(this.shear, this.shear);
            }
        }
    }

    static class TextData {
        public String string;
        public Font font;

        public TextData(String string, Font font) {
            this.string = string;
            this.font = font;
        }
    }
}

