/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im;

import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import sun.awt.im.CompositionArea;
import sun.awt.im.InputMethodContext;
import sun.awt.im.InputMethodWindow;

class CompositionAreaHandler
implements InputMethodListener,
InputMethodRequests {
    private static CompositionArea compositionArea;
    private static Object compositionAreaLock;
    private static CompositionAreaHandler compositionAreaOwner;
    private AttributedCharacterIterator composedText;
    private TextHitInfo caret = null;
    private Component clientComponent = null;
    private InputMethodContext inputMethodContext;
    private static final AttributedCharacterIterator.Attribute[] IM_ATTRIBUTES;
    private static final AttributedCharacterIterator EMPTY_TEXT;

    public int getCommittedTextLength() {
        InputMethodRequests inputMethodRequests = this.getClientInputMethodRequests();
        if (inputMethodRequests != null) {
            return inputMethodRequests.getCommittedTextLength();
        }
        return 0;
    }

    public int getInsertPositionOffset() {
        InputMethodRequests inputMethodRequests = this.getClientInputMethodRequests();
        if (inputMethodRequests != null) {
            return inputMethodRequests.getInsertPositionOffset();
        }
        return 0;
    }

    static {
        compositionAreaLock = new Object();
        IM_ATTRIBUTES = new AttributedCharacterIterator.Attribute[]{TextAttribute.INPUT_METHOD_HIGHLIGHT};
        EMPTY_TEXT = new AttributedString("").getIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void closeCompositionArea() {
        if (compositionArea != null) {
            Object object = compositionAreaLock;
            synchronized (object) {
                compositionAreaOwner = null;
                compositionArea.setHandlerInfo(null, null);
                compositionArea.setText(null, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCompositionArea() {
        Object object = compositionAreaLock;
        synchronized (object) {
            compositionArea = new CompositionArea();
            if (compositionAreaOwner != null) {
                compositionArea.setHandlerInfo(compositionAreaOwner, this.inputMethodContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseCompositionArea() {
        Object object = compositionAreaLock;
        synchronized (object) {
            if (compositionAreaOwner == this) {
                compositionAreaOwner = null;
                if (compositionArea != null) {
                    compositionArea.setHandlerInfo(null, null);
                    compositionArea.setText(null, null);
                }
            }
        }
    }

    boolean isCompositionAreaVisible() {
        if (compositionArea != null) {
            Container container = compositionArea.getParent();
            while (!(container instanceof InputMethodWindow)) {
                container = container.getParent();
            }
            return container.isVisible();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void grabCompositionArea(boolean bl2) {
        Object object = compositionAreaLock;
        synchronized (object) {
            if (compositionAreaOwner != this) {
                compositionAreaOwner = this;
                if (compositionArea != null) {
                    compositionArea.setHandlerInfo(this, this.inputMethodContext);
                }
                if (bl2) {
                    if (this.composedText != null && compositionArea == null) {
                        this.createCompositionArea();
                    }
                    if (compositionArea != null) {
                        compositionArea.setText(this.composedText, this.caret);
                    }
                }
            }
        }
    }

    void setClientComponent(Component component) {
        this.clientComponent = component;
    }

    public void caretPositionChanged(InputMethodEvent inputMethodEvent) {
        if (compositionArea != null) {
            compositionArea.setCaret(inputMethodEvent.getCaret());
        }
        inputMethodEvent.consume();
    }

    public void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
        AttributedCharacterIterator attributedCharacterIterator = inputMethodEvent.getText();
        int n2 = inputMethodEvent.getCommittedCharacterCount();
        this.composedText = null;
        this.caret = null;
        if (attributedCharacterIterator != null && n2 < attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex()) {
            if (compositionArea == null) {
                this.createCompositionArea();
            }
            AttributedString attributedString = new AttributedString(attributedCharacterIterator, attributedCharacterIterator.getBeginIndex() + n2, attributedCharacterIterator.getEndIndex(), IM_ATTRIBUTES);
            attributedString.addAttribute(TextAttribute.FONT, compositionArea.getFont());
            this.composedText = attributedString.getIterator();
            this.caret = inputMethodEvent.getCaret();
        }
        if (compositionArea != null) {
            compositionArea.setText(this.composedText, this.caret);
        }
        if (n2 > 0) {
            this.inputMethodContext.dispatchCommittedText((Component)inputMethodEvent.getSource(), attributedCharacterIterator, n2);
            if (this.isCompositionAreaVisible()) {
                compositionArea.updateWindowLocation();
            }
        }
        inputMethodEvent.consume();
    }

    void processInputMethodEvent(InputMethodEvent inputMethodEvent) {
        if (inputMethodEvent.getID() == 1100) {
            this.inputMethodTextChanged(inputMethodEvent);
        } else {
            this.caretPositionChanged(inputMethodEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextHitInfo getLocationOffset(int n2, int n3) {
        Object object = compositionAreaLock;
        synchronized (object) {
            if (compositionAreaOwner == this && this.isCompositionAreaVisible()) {
                return compositionArea.getLocationOffset(n2, n3);
            }
            return null;
        }
    }

    InputMethodRequests getClientInputMethodRequests() {
        if (this.clientComponent != null) {
            return this.clientComponent.getInputMethodRequests();
        }
        return null;
    }

    CompositionAreaHandler(InputMethodContext inputMethodContext) {
        this.inputMethodContext = inputMethodContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getTextLocation(TextHitInfo textHitInfo) {
        Object object = compositionAreaLock;
        synchronized (object) {
            if (compositionAreaOwner == this && this.isCompositionAreaVisible()) {
                return compositionArea.getTextLocation(textHitInfo);
            }
            if (this.composedText != null) {
                return new Rectangle(0, 0, 0, 10);
            }
            InputMethodRequests inputMethodRequests = this.getClientInputMethodRequests();
            if (inputMethodRequests != null) {
                return inputMethodRequests.getTextLocation(textHitInfo);
            }
            return new Rectangle(0, 0, 0, 10);
        }
    }

    public AttributedCharacterIterator getCommittedText(int n2, int n3, AttributedCharacterIterator.Attribute[] attributeArray) {
        InputMethodRequests inputMethodRequests = this.getClientInputMethodRequests();
        if (inputMethodRequests != null) {
            return inputMethodRequests.getCommittedText(n2, n3, attributeArray);
        }
        return EMPTY_TEXT;
    }

    public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributeArray) {
        InputMethodRequests inputMethodRequests = this.getClientInputMethodRequests();
        if (inputMethodRequests != null) {
            return inputMethodRequests.cancelLatestCommittedText(attributeArray);
        }
        return null;
    }

    public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributeArray) {
        InputMethodRequests inputMethodRequests = this.getClientInputMethodRequests();
        if (inputMethodRequests != null) {
            return inputMethodRequests.getSelectedText(attributeArray);
        }
        return EMPTY_TEXT;
    }
}

