/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractDataLine;
import com.sun.media.sound.AbstractLine;
import java.util.Vector;
import javax.sound.sampled.Control;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;

abstract class AbstractMixer
extends AbstractLine
implements Mixer {
    protected static final int PCM = 0;
    protected static final int ULAW = 1;
    protected static final int ALAW = 2;
    private final Mixer.Info mixerInfo;
    protected Line.Info[] sourceLineInfo;
    protected Line.Info[] targetLineInfo;
    private boolean started = false;
    private boolean manuallyOpened = false;
    protected Vector sourceLines = new Vector();
    protected Vector targetLines = new Vector();

    public synchronized void close() {
        if (this.isOpen()) {
            int n2;
            Line[] lineArray = this.getSourceLines();
            for (n2 = 0; n2 < lineArray.length; ++n2) {
                lineArray[n2].close();
            }
            lineArray = this.getTargetLines();
            for (n2 = 0; n2 < lineArray.length; ++n2) {
                lineArray[n2].close();
            }
            this.implClose();
            this.setOpen(false);
        }
        this.manuallyOpened = false;
    }

    protected abstract void implClose();

    protected abstract void implOpen() throws LineUnavailableException;

    protected abstract void implStart();

    protected abstract void implStop();

    public synchronized void open() throws LineUnavailableException {
        this.open(true);
    }

    protected synchronized void open(boolean bl2) throws LineUnavailableException {
        if (!this.isOpen()) {
            this.implOpen();
            this.setOpen(true);
            if (bl2) {
                this.manuallyOpened = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Line[] getSourceLines() {
        Line[] lineArray;
        Vector vector = this.sourceLines;
        synchronized (vector) {
            lineArray = new Line[this.sourceLines.size()];
            for (int i2 = 0; i2 < lineArray.length; ++i2) {
                lineArray[i2] = (Line)this.sourceLines.elementAt(i2);
            }
        }
        return lineArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Line[] getTargetLines() {
        Line[] lineArray;
        Vector vector = this.targetLines;
        synchronized (vector) {
            lineArray = new Line[this.targetLines.size()];
            for (int i2 = 0; i2 < lineArray.length; ++i2) {
                lineArray[i2] = (Line)this.targetLines.elementAt(i2);
            }
        }
        return lineArray;
    }

    protected synchronized void close(Line line) {
        if (this.equals(line)) {
            return;
        }
        this.sourceLines.removeElement(line);
        this.targetLines.removeElement(line);
        if (this.sourceLines.isEmpty() && this.targetLines.isEmpty() && !this.manuallyOpened) {
            this.close();
        }
    }

    protected synchronized void open(Line line) throws LineUnavailableException {
        if (this.equals(line)) {
            return;
        }
        if (this.isSourceLine(line.getLineInfo())) {
            if (!this.sourceLines.contains(line)) {
                this.open(false);
                this.sourceLines.addElement(line);
            }
        } else if (this.isTargetLine(line.getLineInfo()) && !this.targetLines.contains(line)) {
            this.open(false);
            this.targetLines.addElement(line);
        }
    }

    protected synchronized void start(Line line) {
        if (this.equals(line)) {
            return;
        }
        if (!this.started) {
            this.implStart();
            this.started = true;
        }
    }

    protected synchronized void stop(Line line) {
        if (this.equals(line)) {
            return;
        }
        Vector vector = (Vector)this.sourceLines.clone();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            AbstractDataLine abstractDataLine;
            if (!(vector.elementAt(i2) instanceof AbstractDataLine) || !(abstractDataLine = (AbstractDataLine)vector.elementAt(i2)).isStartedRunning() || abstractDataLine.equals(line)) continue;
            return;
        }
        Vector vector2 = (Vector)this.targetLines.clone();
        for (int i3 = 0; i3 < vector2.size(); ++i3) {
            AbstractDataLine abstractDataLine;
            if (!(vector2.elementAt(i3) instanceof AbstractDataLine) || !(abstractDataLine = (AbstractDataLine)vector2.elementAt(i3)).isStartedRunning() || abstractDataLine.equals(line)) continue;
            return;
        }
        this.started = false;
        this.implStop();
    }

    public void unsynchronize(Line[] lineArray) {
        throw new IllegalArgumentException("Synchronization not supported by this mixer.");
    }

    public void synchronize(Line[] lineArray, boolean bl2) {
        throw new IllegalArgumentException("Synchronization not supported by this mixer.");
    }

    public boolean isSynchronizationSupported(Line[] lineArray, boolean bl2) {
        return false;
    }

    public Line.Info[] getSourceLineInfo() {
        Line.Info[] infoArray = new Line.Info[this.sourceLineInfo.length];
        System.arraycopy(this.sourceLineInfo, 0, infoArray, 0, this.sourceLineInfo.length);
        return infoArray;
    }

    public Line.Info[] getTargetLineInfo() {
        Line.Info[] infoArray = new Line.Info[this.targetLineInfo.length];
        System.arraycopy(this.targetLineInfo, 0, infoArray, 0, this.targetLineInfo.length);
        return infoArray;
    }

    public abstract int getMaxLines(Line.Info var1);

    public boolean isLineSupported(Line.Info info) {
        int n2;
        for (n2 = 0; n2 < this.sourceLineInfo.length; ++n2) {
            if (!info.matches(this.sourceLineInfo[n2])) continue;
            return true;
        }
        for (n2 = 0; n2 < this.targetLineInfo.length; ++n2) {
            if (!info.matches(this.targetLineInfo[n2])) continue;
            return true;
        }
        return false;
    }

    boolean isSourceLine(Line.Info info) {
        for (int i2 = 0; i2 < this.sourceLineInfo.length; ++i2) {
            if (!info.matches(this.sourceLineInfo[i2])) continue;
            return true;
        }
        return false;
    }

    boolean isTargetLine(Line.Info info) {
        for (int i2 = 0; i2 < this.targetLineInfo.length; ++i2) {
            if (!info.matches(this.targetLineInfo[i2])) continue;
            return true;
        }
        return false;
    }

    public Mixer.Info getMixerInfo() {
        return this.mixerInfo;
    }

    public abstract Line getLine(Line.Info var1) throws LineUnavailableException;

    Line.Info getLineInfo(Line.Info info) {
        int n2;
        if (info == null) {
            return null;
        }
        for (n2 = 0; n2 < this.sourceLineInfo.length; ++n2) {
            if (!info.matches(this.sourceLineInfo[n2])) continue;
            return this.sourceLineInfo[n2];
        }
        for (n2 = 0; n2 < this.targetLineInfo.length; ++n2) {
            if (!info.matches(this.targetLineInfo[n2])) continue;
            return this.targetLineInfo[n2];
        }
        return null;
    }

    public Line.Info[] getSourceLineInfo(Line.Info info) {
        int n2;
        Vector vector = new Vector();
        for (n2 = 0; n2 < this.sourceLineInfo.length; ++n2) {
            if (!info.matches(this.sourceLineInfo[n2])) continue;
            vector.addElement(this.sourceLineInfo[n2]);
        }
        Line.Info[] infoArray = new Line.Info[vector.size()];
        for (n2 = 0; n2 < infoArray.length; ++n2) {
            infoArray[n2] = (Line.Info)vector.elementAt(n2);
        }
        return infoArray;
    }

    public Line.Info[] getTargetLineInfo(Line.Info info) {
        int n2;
        Vector vector = new Vector();
        for (n2 = 0; n2 < this.targetLineInfo.length; ++n2) {
            if (!info.matches(this.targetLineInfo[n2])) continue;
            vector.addElement(this.targetLineInfo[n2]);
        }
        Line.Info[] infoArray = new Line.Info[vector.size()];
        for (n2 = 0; n2 < infoArray.length; ++n2) {
            infoArray[n2] = (Line.Info)vector.elementAt(n2);
        }
        return infoArray;
    }

    protected AbstractMixer(Mixer.Info info, Control[] controlArray, Line.Info[] infoArray, Line.Info[] infoArray2) {
        super(new Line.Info(Mixer.class), null, controlArray);
        this.mixer = this;
        if (controlArray == null) {
            controlArray = new Control[]{};
        }
        this.mixerInfo = info;
        this.sourceLineInfo = infoArray;
        this.targetLineInfo = infoArray2;
    }
}

