/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.DefaultSynthStyle;
import com.sun.java.swing.plaf.gtk.GTKColorType;
import com.sun.java.swing.plaf.gtk.GTKStyle;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthStyleFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.plaf.ColorUIResource;

class GTKStyleFactory
extends SynthStyleFactory {
    public static final int WIDGET = 0;
    public static final int WIDGET_CLASS = 1;
    public static final int CLASS = 2;
    private static final Map GTK_CLASS_MAP;
    private static final Map REGION_MAP;
    private List _widgetStyles;
    private List _widgetClassStyles;
    private List _classStyles;
    private boolean _isLabel;
    private BakedArrayList _labelStyleList;
    private Map _mergedStyleMap;
    private SynthStyle _defaultStyle;
    private GTKStyle _tooltipStyle;
    private Map _resolvedStyles;
    private BakedArrayList _tmpList = new BakedArrayList(5);
    private StringBuffer _tmpPath;
    private int[] _depth;

    static {
        REGION_MAP = new HashMap();
        REGION_MAP.put(Region.ARROW_BUTTON, "GtkButton");
        REGION_MAP.put(Region.BUTTON, "GtkButton");
        REGION_MAP.put(Region.CHECK_BOX, "GtkCheckButton");
        REGION_MAP.put(Region.CHECK_BOX_MENU_ITEM, "GtkCheckMenuItem");
        REGION_MAP.put(Region.COLOR_CHOOSER, "GtkColorSelectionDialog");
        REGION_MAP.put(Region.COMBO_BOX, "GtkCombo");
        REGION_MAP.put(Region.DESKTOP_ICON, "GtkLabel");
        REGION_MAP.put(Region.EDITOR_PANE, "GtkTextView");
        REGION_MAP.put(Region.FORMATTED_TEXT_FIELD, "GtkEntry");
        REGION_MAP.put(Region.INTERNAL_FRAME, "GtkFrame");
        REGION_MAP.put(Region.INTERNAL_FRAME_TITLE_PANE, "GtkLabel");
        REGION_MAP.put(Region.LABEL, "GtkLabel");
        REGION_MAP.put(Region.LIST, "GtkTreeView");
        REGION_MAP.put(Region.MENU, "GtkMenuItem");
        REGION_MAP.put(Region.MENU_BAR, "GtkMenuBar");
        REGION_MAP.put(Region.MENU_ITEM, "GtkMenuItem");
        REGION_MAP.put(Region.MENU_ITEM_ACCELERATOR, "GtkLabel");
        REGION_MAP.put(Region.OPTION_PANE, "GtkMessageDialog");
        REGION_MAP.put(Region.PANEL, "GtkContainer");
        REGION_MAP.put(Region.PASSWORD_FIELD, "GtkEntry");
        REGION_MAP.put(Region.POPUP_MENU, "GtkMenu");
        REGION_MAP.put(Region.POPUP_MENU_SEPARATOR, "GtkSeparatorMenuItem");
        REGION_MAP.put(Region.PROGRESS_BAR, "GtkProgressBar");
        REGION_MAP.put(Region.RADIO_BUTTON, "GtkRadioButton");
        REGION_MAP.put(Region.RADIO_BUTTON_MENU_ITEM, "GtkRadioMenuItem");
        REGION_MAP.put(Region.ROOT_PANE, "GtkContainer");
        REGION_MAP.put(Region.SCROLL_BAR, "GtkScrollbar");
        REGION_MAP.put(Region.SCROLL_BAR_TRACK, "GtkScrollbar");
        REGION_MAP.put(Region.SCROLL_BAR_THUMB, "GtkScrollbar");
        REGION_MAP.put(Region.SCROLL_PANE, "GtkScrolledWindow");
        REGION_MAP.put(Region.SEPARATOR, "GtkSeparator");
        REGION_MAP.put(Region.SLIDER, "GtkScale");
        REGION_MAP.put(Region.SLIDER_TRACK, "GtkScale");
        REGION_MAP.put(Region.SLIDER_THUMB, "GtkScale");
        REGION_MAP.put(Region.SPINNER, "GtkSpinButton");
        REGION_MAP.put(Region.SPLIT_PANE, "GtkPaned");
        REGION_MAP.put(Region.SPLIT_PANE_DIVIDER, "GtkPaned");
        REGION_MAP.put(Region.TABBED_PANE, "GtkNotebook");
        REGION_MAP.put(Region.TABBED_PANE_TAB_AREA, "GtkNotebook");
        REGION_MAP.put(Region.TABBED_PANE_CONTENT, "GtkNotebook");
        REGION_MAP.put(Region.TABBED_PANE_TAB, "GtkNotebook");
        REGION_MAP.put(Region.TABLE, "GtkTreeView");
        REGION_MAP.put(Region.TABLE_HEADER, "GtkButton");
        REGION_MAP.put(Region.TEXT_AREA, "GtkTextView");
        REGION_MAP.put(Region.TEXT_FIELD, "GtkEntry");
        REGION_MAP.put(Region.TEXT_PANE, "GtkTextView");
        REGION_MAP.put(Region.TOGGLE_BUTTON, "GtkToggleButton");
        REGION_MAP.put(Region.TOOL_BAR, "GtkToolbar");
        REGION_MAP.put(Region.TOOL_BAR_DRAG_WINDOW, "GtkToolbar");
        REGION_MAP.put(Region.TOOL_BAR_SEPARATOR, "GtkSeparator");
        REGION_MAP.put(Region.TOOL_TIP, "GtkWindow");
        REGION_MAP.put(Region.TREE, "GtkTreeView");
        REGION_MAP.put(Region.TREE_CELL, "GtkTreeView");
        REGION_MAP.put(Region.VIEWPORT, "GtkViewport");
        GTK_CLASS_MAP = new HashMap();
        GTK_CLASS_MAP.put("GtkFrame", "GtkBin");
        GTK_CLASS_MAP.put("GtkProgress", "GtkWidget");
        GTK_CLASS_MAP.put("GtkViewport", "GtkBin");
        GTK_CLASS_MAP.put("GtkMessageDialog", "GtkDialog");
        GTK_CLASS_MAP.put("GtkCombo", "GtkHBox");
        GTK_CLASS_MAP.put("GtkHBox", "GtkBox");
        GTK_CLASS_MAP.put("GtkBox", "GtkContainer");
        GTK_CLASS_MAP.put("GtkTooltips", "GtkObject");
        GTK_CLASS_MAP.put("GtkToolbar", "GtkContainer");
        GTK_CLASS_MAP.put("GtkLabel", "GtkMisc");
        GTK_CLASS_MAP.put("GtkMisc", "GtkWidget");
        GTK_CLASS_MAP.put("GtkTreeView", "GtkContainer");
        GTK_CLASS_MAP.put("GtkTextView", "GtkContainer");
        GTK_CLASS_MAP.put("GtkNotebook", "GtkContainer");
        GTK_CLASS_MAP.put("GtkSeparatorMenuItem", "GtkMenuItem");
        GTK_CLASS_MAP.put("GtkSpinButton", "GtkEntry");
        GTK_CLASS_MAP.put("GtkSeparator", "GtkWidget");
        GTK_CLASS_MAP.put("GtkScale", "GtkRange");
        GTK_CLASS_MAP.put("GtkRange", "GtkWidget");
        GTK_CLASS_MAP.put("GtkPaned", "GtkContainer");
        GTK_CLASS_MAP.put("GtkScrolledWindow", "GtkBin");
        GTK_CLASS_MAP.put("GtkScrollbar", "GtkRange");
        GTK_CLASS_MAP.put("GtkProgressBar", "GtkProgress");
        GTK_CLASS_MAP.put("GtkRadioButton", "GtkCheckButton");
        GTK_CLASS_MAP.put("GtkRadioMenuItem", "GtkCheckMenuItem");
        GTK_CLASS_MAP.put("GtkCheckMenuItem", "GtkMenuItem");
        GTK_CLASS_MAP.put("GtkMenuItem", "GtkItem");
        GTK_CLASS_MAP.put("GtkItem", "GtkBin");
        GTK_CLASS_MAP.put("GtkMenu", "GtkMenuShell");
        GTK_CLASS_MAP.put("GtkMenuBar", "GtkMenuShell");
        GTK_CLASS_MAP.put("GtkMenuShell", "GtkContainer");
        GTK_CLASS_MAP.put("GtkEntry", "GtkWidget");
        GTK_CLASS_MAP.put("GtkColorSelectionDialog", "GtkDialog");
        GTK_CLASS_MAP.put("GtkDialog", "GtkWindow");
        GTK_CLASS_MAP.put("GtkWindow", "GtkBin");
        GTK_CLASS_MAP.put("GtkCheckButton", "GtkToggleButton");
        GTK_CLASS_MAP.put("GtkToggleButton", "GtkButton");
        GTK_CLASS_MAP.put("GtkButton", "GtkBin");
        GTK_CLASS_MAP.put("GtkBin", "GtkContainer");
        GTK_CLASS_MAP.put("GtkContainer", "GtkWidget");
        GTK_CLASS_MAP.put("GtkWidget", "GtkObject");
        GTK_CLASS_MAP.put("GtkObject", "GObject");
    }

    GTKStyleFactory() {
        this(null);
    }

    private GTKStyle getToolTipStyle() {
        if (this._tooltipStyle == null) {
            Color[] colorArray = new Color[GTKColorType.MAX_COUNT];
            colorArray[GTKColorType.BACKGROUND.getID()] = new ColorUIResource(0xFFFFC0);
            colorArray[GTKColorType.FOREGROUND.getID()] = new ColorUIResource(0);
            this._tooltipStyle = new GTKStyle(new GTKStyle.GTKStateInfo[]{new GTKStyle.GTKStateInfo(1, null, null, null, colorArray, null)}, null, null, -1, -1, null);
        }
        return this._tooltipStyle;
    }

    GTKStyleFactory(GTKStyle gTKStyle) {
        this._resolvedStyles = new HashMap();
        this._tmpPath = new StringBuffer();
        this._mergedStyleMap = new HashMap();
        this._defaultStyle = gTKStyle == null ? new GTKStyle() : gTKStyle;
        this._labelStyleList = new BakedArrayList(2);
    }

    static final boolean isLabelBearing(Region region) {
        return region == Region.BUTTON || region == Region.CHECK_BOX || region == Region.CHECK_BOX_MENU_ITEM || region == Region.MENU || region == Region.MENU_ITEM || region == Region.RADIO_BUTTON || region == Region.RADIO_BUTTON_MENU_ITEM || region == Region.TABBED_PANE_TAB || region == Region.TOGGLE_BUTTON || region == Region.TOOL_TIP;
    }

    private SynthStyle getCachedStyle(List list) {
        if (list.size() == 0) {
            return null;
        }
        return (SynthStyle)this._resolvedStyles.get(list);
    }

    private SynthStyle mergeStyles(List list) {
        int n2 = list.size();
        if (n2 == 0) {
            return null;
        }
        if (n2 == 1) {
            return (SynthStyle)((DefaultSynthStyle)list.get(0)).clone();
        }
        DefaultSynthStyle defaultSynthStyle = (DefaultSynthStyle)list.get(n2 - 1);
        defaultSynthStyle = (DefaultSynthStyle)defaultSynthStyle.clone();
        for (int i2 = n2 - 2; i2 >= 0; --i2) {
            defaultSynthStyle = ((DefaultSynthStyle)list.get(i2)).addTo(defaultSynthStyle);
        }
        return defaultSynthStyle;
    }

    private void cacheStyle(List list, SynthStyle synthStyle) {
        BakedArrayList bakedArrayList = new BakedArrayList(list);
        this._resolvedStyles.put(bakedArrayList, synthStyle);
    }

    private Object getSuperclass(Object object) {
        return GTKStyleFactory.gtkSuperclass((String)object);
    }

    public synchronized void addStyle(DefaultSynthStyle defaultSynthStyle, String string, int n2) throws PatternSyntaxException {
        int n3 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n3 * 2);
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '*') {
                stringBuffer.append(".*");
                continue;
            }
            if (c2 == '?') {
                stringBuffer.append('.');
                continue;
            }
            if (Character.isLetterOrDigit(c2)) {
                stringBuffer.append(c2);
                continue;
            }
            stringBuffer.append('\\');
            stringBuffer.append(c2);
        }
        string = stringBuffer.toString();
        switch (n2) {
            case 0: {
                if (this._widgetStyles == null) {
                    this._widgetStyles = new ArrayList(1);
                }
                this._widgetStyles.add(StyleAssociation.createStyleAssociation(string, defaultSynthStyle));
                break;
            }
            case 1: {
                if (this._widgetClassStyles == null) {
                    this._widgetClassStyles = new ArrayList(1);
                }
                this._widgetClassStyles.add(StyleAssociation.createStyleAssociation(string, defaultSynthStyle));
                break;
            }
            case 2: {
                if (this._classStyles == null) {
                    this._classStyles = new ArrayList(1);
                }
                this._classStyles.add(StyleAssociation.createStyleAssociation(string, defaultSynthStyle));
                break;
            }
            default: {
                throw new IllegalArgumentException("type must be one of CLASS, WIDGET_CLASS or WIDGET");
            }
        }
    }

    static String gtkClassFor(Region region) {
        String string = (String)REGION_MAP.get(region);
        if (string == null) {
            return "XXX";
        }
        return string;
    }

    private String getRootPaneParentType(Component component) {
        Container container = component.getParent();
        if (container instanceof Frame) {
            return "GtkWindow";
        }
        if (container instanceof Dialog) {
            return "GtkDialog";
        }
        if (container instanceof Window) {
            return "GtkWindow";
        }
        if (container instanceof JInternalFrame) {
            return "GtkFrame";
        }
        return null;
    }

    private String getClassName(Object object) {
        return (String)object;
    }

    static String gtkSuperclass(String string) {
        return (String)GTK_CLASS_MAP.get(string);
    }

    private void _getPath(StringBuffer stringBuffer, int n2, Component component, Region region) {
        if (component instanceof JComponent) {
            boolean bl2;
            boolean bl3 = bl2 = region != null && region.isSubregion();
            if (bl2) {
                this._getPath(stringBuffer, n2, component, null);
            } else {
                this._getPath(stringBuffer, n2, component.getParent(), region);
            }
            String string = null;
            if (n2 == 0 && !bl2) {
                string = component.getName();
            }
            if (string == null) {
                if (bl2) {
                    string = this.getName(component, region);
                } else {
                    Region region2 = SynthLookAndFeel.getRegion((JComponent)component);
                    if (region2 != null) {
                        string = this.getName(component, region2);
                    }
                }
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(string);
        }
    }

    private void getClassMatches(List list, JComponent jComponent, Region region) {
        if (this._depth == null) {
            this._depth = new int[4];
        }
        int[] nArray = this._depth;
        int n2 = 0;
        int n3 = list.size();
        block0: for (int i2 = this._classStyles.size() - 1; i2 >= 0; --i2) {
            StyleAssociation styleAssociation = (StyleAssociation)this._classStyles.get(i2);
            Object object = this.getClass(jComponent, region);
            while (object != null) {
                if (styleAssociation.matches(this.getClassName(object))) {
                    int n4 = 0;
                    while ((object = this.getSuperclass(object)) != null) {
                        ++n4;
                    }
                    if (n2 == 0) {
                        nArray[0] = n4;
                        list.add(styleAssociation.getStyle());
                    } else {
                        int n5;
                        for (n5 = 0; n5 < n2 && n4 < nArray[n5]; ++n5) {
                        }
                        list.add(n5 + n3, styleAssociation.getStyle());
                        if (n2 + 1 == nArray.length) {
                            int[] nArray2 = new int[nArray.length * 2];
                            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                            this._depth = nArray2;
                            nArray = nArray2;
                        }
                        if (n5 < n2) {
                            System.arraycopy(nArray, 0, nArray, 0, n5);
                            System.arraycopy(nArray, n5, nArray, n5 + 1, n2 - n5);
                        }
                        nArray[n5] = n4;
                    }
                    ++n2;
                    continue block0;
                }
                object = this.getSuperclass(object);
            }
        }
    }

    private void getMatchingStyles(List list, JComponent jComponent, Region region) {
        if (jComponent != null && (jComponent.getParent() != null || jComponent.getName() == "TableHeader.renderer")) {
            if (this._widgetStyles != null) {
                this.getMatches(this.getPath(0, jComponent, region), this._widgetStyles, list, jComponent, region);
            }
            if (this._widgetClassStyles != null) {
                this.getMatches(this.getPath(1, jComponent, region), this._widgetClassStyles, list, jComponent, region);
            }
            if (this._classStyles != null) {
                this.getClassMatches(list, jComponent, region);
            }
        }
        if (region == Region.TOOL_TIP) {
            list.add(this.getToolTipStyle());
        }
        list.add(this._defaultStyle);
    }

    private SynthStyle _getStyle(JComponent jComponent, Region region) {
        BakedArrayList bakedArrayList = this._tmpList;
        bakedArrayList.clear();
        this.getMatchingStyles(bakedArrayList, jComponent, region);
        bakedArrayList.bake();
        SynthStyle synthStyle = this.getCachedStyle(bakedArrayList);
        if (synthStyle == null && (synthStyle = this.mergeStyles(bakedArrayList)) != null) {
            this.cacheStyle(bakedArrayList, synthStyle);
        }
        return synthStyle;
    }

    public synchronized SynthStyle getStyle(JComponent jComponent, Region region) {
        SynthStyle synthStyle = this._getStyle(jComponent, region);
        if (GTKStyleFactory.isLabelBearing(region)) {
            synthStyle = this.getMergedStyle(jComponent, region, synthStyle);
        }
        return synthStyle;
    }

    private CharSequence getPath(int n2, Component component, Region region) {
        this._tmpPath.setLength(0);
        if (n2 == 0 && region == Region.TOOL_TIP) {
            if (component.getName() == null) {
                this._tmpPath.append("gtk-tooltips");
            } else {
                this._tmpPath.append(component.getName());
            }
        } else {
            this._getPath(this._tmpPath, n2, component, region);
        }
        if (this._isLabel) {
            if (this._tmpPath.length() > 0) {
                this._tmpPath.append('.');
            }
            this._tmpPath.append(this.getName(component, Region.LABEL));
        }
        return this._tmpPath;
    }

    protected Object getClass(JComponent jComponent, Region region) {
        String string;
        if (this._isLabel) {
            region = Region.LABEL;
        } else if (region == Region.ROOT_PANE && (string = this.getRootPaneParentType(jComponent)) != null) {
            return string;
        }
        string = GTKStyleFactory.gtkClassFor(region);
        if (string == "GtkLabel" && jComponent.getName() == "TableHeader.renderer") {
            return "GtkButton";
        }
        return string;
    }

    private String getName(Component component, Region region) {
        String string;
        if (region == Region.ROOT_PANE && component != null && (string = this.getRootPaneParentType(component)) != null) {
            return string;
        }
        return GTKStyleFactory.gtkClassFor(region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SynthStyle getMergedStyle(JComponent jComponent, Region region, SynthStyle synthStyle) {
        GTKStyle gTKStyle;
        try {
            this._isLabel = true;
            gTKStyle = (GTKStyle)this._getStyle(jComponent, region);
        }
        finally {
            this._isLabel = false;
        }
        this._labelStyleList.clear();
        this._labelStyleList.add(synthStyle);
        this._labelStyleList.add(gTKStyle);
        this._labelStyleList.bake();
        GTKStyle gTKStyle2 = (GTKStyle)this._mergedStyleMap.get(this._labelStyleList);
        if (gTKStyle2 == null) {
            gTKStyle2 = (GTKStyle)((DefaultSynthStyle)synthStyle).clone();
            gTKStyle2.addLabelProperties(gTKStyle);
            this._mergedStyleMap.put(this._labelStyleList, gTKStyle2);
            this._labelStyleList = new BakedArrayList(2);
        }
        return gTKStyle2;
    }

    private void getMatches(CharSequence charSequence, List list, List list2, JComponent jComponent, Region region) {
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            StyleAssociation styleAssociation = (StyleAssociation)list.get(i2);
            if (!styleAssociation.matches(charSequence)) continue;
            list2.add(styleAssociation.getStyle());
        }
    }

    private static class BakedArrayList
    extends ArrayList {
        private int hashCode;

        public int hashCode() {
            return this.hashCode;
        }

        void bake() {
            this.hashCode = 1;
            for (int i2 = this.size() - 1; i2 >= 0; --i2) {
                this.hashCode = 31 * this.hashCode + this.get(i2).hashCode();
            }
        }

        BakedArrayList(int n2) {
            super(n2);
        }

        public boolean equals(Object object) {
            BakedArrayList bakedArrayList = (BakedArrayList)object;
            int n2 = this.size();
            if (bakedArrayList.size() != n2) {
                return false;
            }
            while (n2-- > 0) {
                if (this.get(n2).equals(bakedArrayList.get(n2))) continue;
                return false;
            }
            return true;
        }

        BakedArrayList(List list) {
            this(list.size());
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.add(list.get(i2));
            }
            this.bake();
        }
    }

    private static class StyleAssociation {
        private SynthStyle _style;
        private Pattern _pattern;
        private Matcher _matcher;

        public SynthStyle getStyle() {
            return this._style;
        }

        public boolean matches(CharSequence charSequence) {
            if (this._matcher == null) {
                this._matcher = this._pattern.matcher(charSequence);
            } else {
                this._matcher.reset(charSequence);
            }
            return this._matcher.matches();
        }

        public String getText() {
            return this._pattern.pattern();
        }

        StyleAssociation(String string, SynthStyle synthStyle) throws PatternSyntaxException {
            this._style = synthStyle;
            this._pattern = Pattern.compile(string);
        }

        public static StyleAssociation createStyleAssociation(String string, SynthStyle synthStyle) throws PatternSyntaxException {
            return new StyleAssociation(string, synthStyle);
        }
    }
}

