/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.tools.doclets.Configuration;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.StringTokenizer;

public class SourceToHTMLConverter {
    protected static final String BGCOLOR = "white";
    protected static final String LINE_NO_COLOR = "green";
    protected static final int NUM_BLANK_LINES = 60;

    protected static String getFooter() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < 60) {
            stringBuffer.append("\n");
            ++n;
        }
        stringBuffer.append("</PRE>\n</BODY>\n</HTML>\n");
        return stringBuffer.toString();
    }

    protected static String getHeader() {
        String string = "<HTML>\n";
        string = string + "<BODY BGCOLOR=\"white\">\n";
        string = string + "<PRE>\n";
        return string;
    }

    protected static String getHTMLLineNo(int n) {
        StringBuffer stringBuffer = new StringBuffer("<FONT color=\"green\">");
        if (n < 10) {
            stringBuffer.append("00" + new Integer(n).toString());
        } else if (n < 100) {
            stringBuffer.append("0" + new Integer(n).toString());
        } else {
            stringBuffer.append(new Integer(n).toString());
        }
        stringBuffer.append("</FONT>    ");
        return stringBuffer.toString();
    }

    protected static String getAnchor(Doc doc) {
        return "    <a name=\"" + SourceToHTMLConverter.getAnchorName(doc) + "\"></a>";
    }

    public static String getAnchorName(Doc doc) {
        return "line." + doc.position().line();
    }

    public static String getPackagePath(PackageDoc packageDoc) {
        if (packageDoc == null) {
            return "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(packageDoc.name(), ".");
        String string = "";
        while (stringTokenizer.hasMoreTokens()) {
            string = string + stringTokenizer.nextToken() + File.separator;
        }
        return string;
    }

    protected static String format(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = -1;
        while ((n = stringBuffer.indexOf("<", n + 1)) != -1) {
            stringBuffer.replace(n, n + 1, "&lt;");
        }
        return stringBuffer.toString();
    }

    private static void replaceTabs(Configuration configuration, StringBuffer stringBuffer) {
        int n;
        while ((n = stringBuffer.indexOf("\t")) != -1) {
            StringBuffer stringBuffer2 = new StringBuffer();
            int n2 = n;
            do {
                stringBuffer2.append(" ");
            } while (++n2 % configuration.linksourcetab != 0);
            stringBuffer.replace(n, n + 1, stringBuffer2.toString());
        }
    }

    protected static StringBuffer addLineNumbers(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", true);
        int n = 1;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!string2.equals("\n")) {
                stringBuffer.append(SourceToHTMLConverter.getHTMLLineNo(n) + string2 + stringTokenizer.nextToken());
            } else {
                stringBuffer.append(SourceToHTMLConverter.getHTMLLineNo(n) + string2);
            }
            ++n;
        }
        return stringBuffer;
    }

    protected static void addToHash(Doc[] docArray, HashMap hashMap) {
        if (docArray == null) {
            return;
        }
        int n = 0;
        while (n < docArray.length) {
            hashMap.put(new Integer(docArray[n].position().line()), SourceToHTMLConverter.getAnchor(docArray[n]));
            ++n;
        }
    }

    public static void convertClass(Configuration configuration, ClassDoc classDoc, String string) {
        if (classDoc == null || string == null) {
            return;
        }
        SourcePosition sourcePosition = classDoc.position();
        if (sourcePosition == null) {
            return;
        }
        File file = sourcePosition.file();
        if (file == null) {
            return;
        }
        try {
            String string2;
            LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));
            int n = 1;
            StringBuffer stringBuffer = new StringBuffer();
            while ((string2 = lineNumberReader.readLine()) != null) {
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append(SourceToHTMLConverter.format(string2));
                stringBuffer2.append("<a name=\"line." + Integer.toString(n) + "\"></a>");
                stringBuffer2.append("\n");
                SourceToHTMLConverter.replaceTabs(configuration, stringBuffer2);
                stringBuffer.append(stringBuffer2.toString());
                ++n;
            }
            stringBuffer = SourceToHTMLConverter.addLineNumbers(stringBuffer.toString());
            stringBuffer.insert(0, SourceToHTMLConverter.getHeader());
            stringBuffer.append(SourceToHTMLConverter.getFooter());
            File file2 = new File(string);
            file2.mkdirs();
            File file3 = new File(file2, classDoc.name() + ".html");
            configuration.message.notice("doclet.Generating_0", file3.getPath());
            FileOutputStream fileOutputStream = new FileOutputStream(file3);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
            bufferedWriter.write(stringBuffer.toString());
            bufferedWriter.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void convertPackage(Configuration configuration, PackageDoc packageDoc, String string) {
        if (packageDoc == null || string == null) {
            return;
        }
        string = string + File.separator + SourceToHTMLConverter.getPackagePath(packageDoc);
        ClassDoc[] classDocArray = packageDoc.allClasses();
        int n = 0;
        while (n < classDocArray.length) {
            SourceToHTMLConverter.convertClass(configuration, classDocArray[n], string);
            ++n;
        }
    }

    public static void convertRoot(Configuration configuration, RootDoc rootDoc, String string) {
        if (rootDoc == null || string == null) {
            return;
        }
        PackageDoc[] packageDocArray = rootDoc.specifiedPackages();
        int n = 0;
        while (n < packageDocArray.length) {
            SourceToHTMLConverter.convertPackage(configuration, packageDocArray[n], string);
            ++n;
        }
        ClassDoc[] classDocArray = rootDoc.specifiedClasses();
        int n2 = 0;
        while (n2 < classDocArray.length) {
            SourceToHTMLConverter.convertClass(configuration, classDocArray[n2], string + File.separator + SourceToHTMLConverter.getPackagePath(classDocArray[n2].containingPackage()));
            ++n2;
        }
    }
}

