/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui.player;

import com.sun.javaws.Resources;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.ui.general.GeneralUtilities;
import com.sun.javaws.ui.player.BookmarkEntry;
import com.sun.javaws.ui.player.Player;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

class BookmarkEntryEditor {
    private JDialog _editor;
    private AbstractTableModel _dataModel;
    private JTable _tableView;
    private ArrayList _bookmarkEntryList;

    private void removeBookmarkEntry() {
        int[] nArray = this._tableView.getSelectedRows();
        String[] stringArray = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            stringArray[n] = (String)this._tableView.getValueAt(nArray[n], 0);
            if (Globals.TracePlayer) {
                Debug.println("remove: " + stringArray[n]);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            this._bookmarkEntryList.remove(Player.getPlayer().getBookmarkIndex(stringArray[n2]));
            ++n2;
        }
        this._tableView.clearSelection();
        this._dataModel.fireTableDataChanged();
    }

    BookmarkEntryEditor(Frame frame) {
        this._editor = GeneralUtilities.createDialog(frame, Resources.getString("player.htmlEntryEditorTitle"), true);
        this._bookmarkEntryList = Player.getPlayer().getBookmarkEntryList();
        Container container = this._editor.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        JButton jButton = new JButton(Resources.getString("player.htmlEntryEditorCloseButton"));
        JButton jButton2 = new JButton(Resources.getString("player.htmlEntryEditorRemoveButton"));
        jPanel.add((Component)jButton, "East");
        jPanel.add((Component)jButton2, "West");
        jPanel.setBorder(BorderFactory.createEmptyBorder(8, 2, 6, 2));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BookmarkEntryEditor.this._editor.dispose();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BookmarkEntryEditor.this.removeBookmarkEntry();
            }
        });
        jButton.requestFocus();
        this._editor.getRootPane().setDefaultButton(jButton);
        container.add((Component)jPanel, "South");
        JScrollPane jScrollPane = this.createBookmarkEntryTable(this._editor);
        container.add((Component)jScrollPane, "Center");
        this._editor.setBounds(0, 0, 400, 400);
        GeneralUtilities.placeWindow(this._editor);
        this._editor.show();
    }

    private Object getBookmarkEntryName(int n) {
        return ((BookmarkEntry)this._bookmarkEntryList.get(n)).getName();
    }

    private Object getBookmarkEntryURL(int n) {
        return ((BookmarkEntry)this._bookmarkEntryList.get(n)).getUrl();
    }

    private JScrollPane createBookmarkEntryTable(final Component component) {
        final String[] stringArray = new String[]{Resources.getString("player.htmlEntryEditorEntryName"), Resources.getString("player.htmlEntryEditorEntryUrl")};
        this._dataModel = new AbstractTableModel(){

            public int getColumnCount() {
                return 2;
            }

            public int getRowCount() {
                return BookmarkEntryEditor.this._bookmarkEntryList.size();
            }

            public boolean isCellEditable(int n, int n2) {
                return n2 == 0;
            }

            public Object getValueAt(int n, int n2) {
                switch (n2) {
                    case 0: {
                        return BookmarkEntryEditor.this.getBookmarkEntryName(n);
                    }
                }
                return BookmarkEntryEditor.this.getBookmarkEntryURL(n);
            }

            public void setValueAt(Object object, int n, int n2) {
                String string = (String)BookmarkEntryEditor.this.getBookmarkEntryName(n);
                if (string.equals(object)) {
                    return;
                }
                if (((String)object).trim().equals("")) {
                    Player.showInvalidInputDialog(component, Resources.getString("player.htmlEntryMissingName"), Resources.getString("player.htmlEntryRenameEntry"));
                    return;
                }
                if (Player.getPlayer().getBookmarkIndex((String)object) != -1) {
                    String string2 = Resources.getString("player.htmlEntryRenameAlreadyExist", string);
                    Player.showInvalidInputDialog(component, string2, Resources.getString("player.htmlEntryRenameError"));
                    return;
                }
                if (Globals.TracePlayer) {
                    Debug.println("put: " + object + " " + BookmarkEntryEditor.this.getBookmarkEntryURL(n));
                }
                BookmarkEntry bookmarkEntry = new BookmarkEntry((String)object, (String)BookmarkEntryEditor.this.getBookmarkEntryURL(n));
                BookmarkEntryEditor.this._bookmarkEntryList.set(n, bookmarkEntry);
                this.fireTableRowsUpdated(n, n);
            }

            public String getColumnName(int n) {
                return stringArray[n];
            }
        };
        this._tableView = new JTable(this._dataModel);
        JScrollPane jScrollPane = new JScrollPane(this._tableView);
        return jScrollPane;
    }
}

