/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.proxy;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;

public class NSRegistry {
    private static final int magic = 1986282561;
    private RandomAccessFile in = null;
    private int rootOffset;
    private int majorVersion;
    private int minorVersion;

    private int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.in.read();
        if ((n4 | (n3 = this.in.read()) | (n2 = this.in.read()) | (n = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (n << 24) + (n2 << 16) + (n3 << 8) + (n4 << 0);
    }

    private int readUnsignedShort() throws IOException {
        int n;
        int n2 = this.in.read();
        if ((n2 | (n = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (n << 8) + (n2 << 0);
    }

    private long readUnsignedInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.in.read();
        if ((n4 | (n3 = this.in.read()) | (n2 = this.in.read()) | (n = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (n << 24) + (n2 << 16) + (n3 << 8) + (n4 << 0);
    }

    private short readShort() throws IOException {
        int n;
        int n2 = this.in.read();
        if ((n2 | (n = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n << 8) + (n2 << 0));
    }

    void close() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.in = null;
        }
    }

    private void dump() {
        try {
            this.dump("", this.rootOffset);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private Record readRecord(long l) throws IOException {
        this.in.seek(l);
        if ((long)this.readInt() != l) {
            throw new IOException("invalid offset for record [" + l + "]");
        }
        Record record = new Record();
        record.name = this.readInt();
        record.namelen = this.readUnsignedShort();
        record.type = this.readUnsignedShort();
        record.left = this.readInt();
        record.down = this.readInt();
        record.value = this.readInt();
        record.valuelen = this.readUnsignedInt();
        record.valuebuf = this.readUnsignedInt();
        return record;
    }

    public String toString() {
        String string = this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
        string = this.in != null ? string + "[version " + this.majorVersion + "." + this.minorVersion + "]" : string + "[closed]";
        return string;
    }

    private String readString(long l, long l2) throws IOException {
        this.in.seek(l);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while ((long)n < l2) {
            stringBuffer.append((char)this.in.read());
            ++n;
        }
        return stringBuffer.toString();
    }

    private void dump(String string, int n) throws IOException {
        Record record = this.readRecord(n);
        System.out.println(string + this.readString(record.name, record.namelen - 1));
        int n2 = record.down;
        while (n2 != 0) {
            this.dump(string + "    ", n2);
            n2 = this.readRecord((long)((long)n2)).left;
        }
        int n3 = record.value;
        while (n3 != 0) {
            Record record2 = this.readRecord(n3);
            String string2 = this.readString(record2.name, record2.namelen - 1);
            String string3 = this.readString(record2.value, record2.valuelen - 1L);
            System.out.println(string + "[" + string2 + " = " + string3 + "]");
            n3 = record2.left;
        }
    }

    NSRegistry open(File file) {
        if (this.in != null) {
            return this;
        }
        try {
            this.in = new RandomAccessFile(file, "r");
            if (this.readInt() != 1986282561) {
                throw new IOException("not a valid Netscape Registry File");
            }
            this.majorVersion = this.readUnsignedShort();
            this.minorVersion = this.readUnsignedShort();
            this.in.skipBytes(4);
            this.rootOffset = this.readInt();
            return this;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    String get(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        try {
            return this.get(this.readRecord(this.rootOffset), stringTokenizer);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private String get(Record record, StringTokenizer stringTokenizer) throws IOException {
        String string = stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreTokens()) {
            int n = record.down;
            while (n != 0) {
                Record record2 = this.readRecord(n);
                if (string.equals(this.readString(record2.name, record2.namelen - 1))) {
                    return this.get(record2, stringTokenizer);
                }
                n = record2.left;
            }
            return null;
        }
        int n = record.value;
        while (n != 0) {
            Record record3 = this.readRecord(n);
            if (string.equals(this.readString(record3.name, record3.namelen - 1))) {
                return this.readString(record3.value, record3.valuelen - 1L);
            }
            n = record3.left;
        }
        return null;
    }

    private static final class Record {
        int name;
        int namelen;
        int type;
        int left;
        int down;
        int value;
        long valuelen;
        long valuebuf;

        private Record() {
        }

        public boolean isEntry() {
            return !this.isKey();
        }

        public boolean isKey() {
            return (this.type & 0x10) != 0;
        }
    }
}

