/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2001 by Leonardo Skorianez
    email                : lsk@if.ufrj.br
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#include "pmquickcolor.h"

#include "pmoutputdevice.h"
#include "pmxmlhelper.h"
#include "pmquickcoloredit.h"
#include "pmmemento.h"

#include <kdebug.h>
#include "pmglobals.h"

#include <klocale.h>

const PMColor colorDefault = PMColor( 1.0, 1.0, 1.0, 0.0, 0.0 );

PMQuickColor::PMQuickColor( )
      : Base( )
{
   m_color = colorDefault;
}

PMQuickColor::~PMQuickColor( )
{
}

QString PMQuickColor::description( ) const
{
   return i18n( "quick color" );
}

void PMQuickColor::serialize( PMOutputDevice& dev ) const
{
   dev.writeLine( "quick_color " + m_color.serialize( ) );
}

void PMQuickColor::serialize( QDomElement& e, QDomDocument& /*doc*/ ) const
{
   e.setAttribute( "quickcolor", m_color.serializeXML( ) );
}

void PMQuickColor::readAttributes( const PMXMLHelper& h )
{
   m_color = h.colorAttribute( "quickcolor", colorDefault );
}

bool PMQuickColor::isA( PMObjectType t ) const
{
   if( t == PMTQuickColor )
      return true;
   return Base::isA( t );
}

void PMQuickColor::setColor( const PMColor& c )
{
   if( c != m_color )
   {
      if( m_pMemento )
      {
         m_pMemento->addData( PMTQuickColor, PMColorID, m_color );
         m_pMemento->setViewStructureChanged( );
      }
      m_color = c;
   }
}

PMDialogEditBase* PMQuickColor::editWidget( QWidget* parent ) const
{
   return new PMQuickColorEdit( parent );
}

void PMQuickColor::restoreMemento( PMMemento* s )
{
   PMMementoDataIterator it( s );
   PMMementoData* data;

   for( ; it.current( ); ++it )
   {
      data = it.current( );
      if( data->objectType( ) == PMTQuickColor )
      {
         switch( data->valueID( ) )
         {
            case PMColorID:
               setColor( data->colorData( ) );
               break;
            default:
               kdError( PMArea ) << "Wrong ID in PMQuickColor::restoreMemento\n";
               break;
         }
      }
   }
   Base::restoreMemento( s );
}
