//-*-C++-*-
/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2001 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#ifndef PMINSERTERRORS_H
#define PMINSERTERRORS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "pmcompositeobject.h"

/**
 * Container class for insert errors. All objects can be inserted as childs.
 */
class PMInsertErrors : public PMCompositeObject
{
   typedef PMCompositeObject Base;
public:
   /** Creates an empty PMInsertErrors */
   PMInsertErrors( );
   /** deletes the scene and all objects */
   virtual ~PMInsertErrors( );
   /** */
   virtual bool isA( PMObjectType t ) const;

   /** Returns a new PMInsertErrors */
   virtual PMObject* newObject( ) const { return new PMInsertErrors( ); }
   /** */
   virtual QString className( ) const { return QString( "inserterrors" ); }
   /** */
   virtual QString description( ) const;
   /** */
   virtual PMObjectType type( ) const { return PMTInsertErrors; }
   /** */
   virtual bool canInsert( PMObjectType, const PMObject*, const PMObjectList* = 0 ) const
   {
      return true;
   }   
   /**  */
   virtual QString pixmap( ) const { return QString( "pminserterrors" ); }
};

#endif
