//-*-C++-*-
/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2001 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#ifndef PMCSG_H
#define PMCGS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "pmsolidobject.h"

/**
 * Class for povray csg objects.
 */ 

class PMCSG : public PMSolidObject
{
   typedef PMSolidObject Base;
public:
   /** The type of the csg object */
   enum PMCSGType { CSGUnion, CSGIntersection, CSGDifference, CSGMerge };
   /** Creates an empty PMCSG union */
   PMCSG( );
   /** Creates an empty PMCSG object with type t */
   PMCSG( const PMCSGType t );
   /** deletes the PMCSG object */
   virtual ~PMCSG( );

   /** */
   virtual PMObject* newObject( ) const { return new PMCSG( ); }
   /** */
   virtual QString className( ) const { return QString( "csg" ); }
   /** */
   virtual QString description( ) const;
   /** */
   virtual PMObjectType type( ) const { return PMTCSG; }
   /** */
   virtual bool isA( PMObjectType t ) const;

   /** */
   virtual bool canInsert( PMObjectType t, const PMObject* after,
                           const PMObjectList* objectsBetween = 0 ) const;
   /** */
   virtual int canInsert( const QValueList<PMObjectType>& list,
                          const PMObject* after ) const;
   /** */
   virtual int canInsert( const PMObjectList& list,
                          const PMObject* after ) const;
   /** */
   virtual void serialize( PMOutputDevice& dev ) const;
   /** */
   virtual void serialize( QDomElement& e, QDomDocument& doc ) const;
   /** */
   virtual void readAttributes( const PMXMLHelper& h );

   /** Returns a new @ref PMCSGEdit */
   virtual PMDialogEditBase* editWidget( QWidget* parent ) const;
   /** Returns the name of the pixmap that is displayed in the tree view
    * and dialog view */
   virtual QString pixmap( ) const;

   /** Returns the type of the csg */
   PMCSGType csgType( ) const { return m_type; }
   /** Sets the type of the csg */
   void setCSGType( const PMCSGType t );
   
   /** */
   virtual void restoreMemento( PMMemento* s );
private:
   void countChild( PMObjectType t, bool& texturesBefore, bool& objectsBehind,
                    bool afterInsertPoint ) const;
   bool canInsert( PMObjectType t, bool texturesBefore, bool objectsBehind ) const;
   /** IDs for @ref PMMementoData */
   enum PMCSGMementoID { PMTypeID };
   PMCSGType m_type;
};

#endif
