/***************************************************************************
                          kmathtoolview.h  -  description
                             -------------------
    begin                : Fre Apr 12 2002
    copyright            : (C) 2002 by Birgit Schulz
    email                : B.Schulz@Superlehrer.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMATHTOOLVIEW_H
#define KMATHTOOLVIEW_H

#include "factors.h"
#include "startwidget.h"
#include "lines.h"
#include "areaperimeter1.h"
#include "parabolas.h"

#include <qwidget.h>
#include <qwidgetstack.h>

/**
  *@author Birgit Schulz
  */

class KMathToolView : public QWidgetStack  
    {
        Q_OBJECT
    public:
        KMathToolView(QWidget *parent=0, const char *name=0);
        ~KMathToolView();
        
    private:
        StartWidget *m_poStartWidget;
        Factors *m_poFactors;
        Lines *m_poLines;
        AreaPerimeter1 *m_poAreaPerimeter;
        Parabolas *m_poParabolas;

        
    public slots:    
        void slotShowFactorsFactorize();
        void slotShowFactorsFactors();
        void slotShowFactorsFindHCF();
        void slotShowFactorsFindLCM();
        void slotShowFactorsProvePrime();
        void slotShowFactorsFindPrime();

        void slotShowLinesAxisSection();
        void slotShowLinesOnePoint();
        void slotShowLinesTwoPoints();
        void slotShowLinesSection();

        void slotShowParabolaAxisSection();
        void slotShowParabolaEquationWith3Points();
        void slotShowParabolaEquationWithScheitel();
        void slotShowParabolaEquationWithScheitelAndPoint();
        void slotShowParabolaFindScheitel();
        void slotShowParabolaLineSection();
        void slotShowParabolaParabolaSection();


        void slotShowAreaSquare();
        void slotShowAreaRectangle();
        void slotShowAreaCircle();
        

    
	};

#endif
