/***************************************************************************
                          geopoint.cpp  -  description
                             -------------------
    begin                : Sun Oct 29 2000
    copyright            : (C) 2000 by Marc Bartsch
    email                : marc.bartsch@topmail.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "geopoint.h"

GeoPoint::GeoPoint( QPoint *pt ): GeoObjects()
{
  kapp->config()->setGroup( "Sizes" );
	size = kapp->config()->readNumEntry( "PointSize", MinimumPointSize );

 	isMovable = false;
	acceptsQPoint = false;
	acceptsGeoPoint = false;
	canBeDestroyed = false;

	isTrace = false;
//  kapp->config()->setGroup( "Colors" );
//	color = kapp->config()->readColorEntry( "Draw" );
  zOrder = 1;
	identificator = "GeoPoint";
	ID = ID_geoPoint;

	if ( pt != 0 )
	{
		coords.set( *pt );
		MetricsCenter::mapCanvasToCanvasAttachToGrid( coords );

		if ( ( size % 2 ) == 0 )
			size += 1;

		int x = coords.getI_X() - ( ( size - 1 ) / 2 );
		int y = coords.getI_Y() - ( ( size - 1 ) / 2 );

  	surroundingRect = QRect ( x, y, size, size );
  	initComplete = true;
	}

	position = 1;
}

GeoPoint::~GeoPoint()
{
}

void GeoPoint::paint( QPainter *p )
{
	if ( initComplete )
	{
  	// Prepare pen.
  	p->setPen( QPen( color, 1, Qt::SolidLine ) );
   	p->setBrush( color );

  	// Draw trace first
  	if ( getTrace() )
  	{
  	 	p->setBrush( Qt::lightGray );
  		p->setPen( QPen( Qt::lightGray, 1, Qt::SolidLine ) );
    	QRect *actual;

  		for ( actual = trace.first(); actual; actual = trace.next() )
  		{
  			p->drawEllipse( *actual );
  		}
  		p->setPen( QPen( color, 1, Qt::SolidLine ) );
   		p->setBrush( Qt::white );
  	}

  	// If a point is chosen, it is drawn in yellow.
  	if ( isChosen )
   	{
  		p->setPen( QPen( Qt::black, 1, Qt::SolidLine ) );
     	p->setBrush( QColor( 255, 192, 0 ) );
   	}

   	if ( getMovable() )
   	{
   		p->drawEllipse( surroundingRect );
   	}	
   	else
   	{
     	p->drawRect( surroundingRect );
   	}
	}
}

bool GeoPoint::contains( QPoint *pt )
{
	return surroundingRect.contains( *pt );
}

void GeoPoint::move( QPoint* )
{
}

void GeoPoint::move()
{
}

void GeoPoint::getObjectOverlay( QList <QRect> & list )
{
	list.append( new QRect( surroundingRect ) );
}

void GeoPoint::writeToFile( KSimpleConfig *config )
{
	config->writeEntry( "Geo", ID );
	config->writeEntry( "Color", getColor() );
	config->writeEntry( "Size", size );

	Coordinates coord1;
	coord1 = getCoordinates();
	MetricsCenter::mapCanvasToGrid( coord1 );
	config->writeEntry( "QPointX",  coord1.getD_X() );
	config->writeEntry( "QPointY",  coord1.getD_Y() );
	config->writeEntry( "Position", position );
}

void GeoPoint::readFromFile( KSimpleConfig *config )
{
	color = config->readColorEntry( "Color" );

	QString strX, strY;
	strX = config->readEntry( "QPointX" );
	strY = config->readEntry( "QPointY" );
	double x = strX.toDouble();
	double y = strY.toDouble();
	coords.set( x, y );
  MetricsCenter::mapGridToCanvas( coords );

	setSize( config->readNumEntry( "Size", MinimumPointSize ) );
	strX = config->readEntry( "Position" );
	position = strX.toDouble();
	initComplete = true;
}

