namespace Binge.Generators.CSharp.Qt
{
	using System;
	using System.Collections;
	using Binge.Bits;
	using Binge.Generators.CSharp;

	public class Converter: Binge.Generators.CSharp.Converter
	{
		private Hashtable types;

		public Converter (): base ()
		{
			types = new Hashtable ();

			types.Add ("QByteArray", "byte[]");
			types.Add ("QBitArray", "byte[]");
			types.Add ("HANDLE", "uint");
			types.Add ("HBITMAP", "uint");
			types.Add ("HCURSOR", "uint");
			types.Add ("HDC", "uint");
			types.Add ("HFONT", "uint");
			types.Add ("HPALETTE", "uint");
			types.Add ("HRGN", "uint");
			types.Add ("Display", "IntPtr");
			types.Add ("Q_REFCOUNT bool", "bool");
			types.Add ("EventRef", "IntPtr");
			types.Add ("MSG", "IntPtr");
			types.Add ("XEvent", "IntPtr");
			types.Add ("QWSEvent", "IntPtr");
			types.Add ("GDHandle", "IntPtr");
			types.Add ("QRgb", "int");
			types.Add ("QWSDecoration", "IntPtr");
			types.Add ("QTextParag", "IntPtr");
			types.Add ("Qt.HANDLE", "IntPtr");
			types.Add ("QUObject", "IntPtr");
			types.Add ("QGfx", "IntPtr");
			types.Add ("QRESULT", "long");
			types.Add ("QUnknownInterface", "IntPtr");
			types.Add ("QPtrCollection.Item", "int");
			types.Add ("type", "IntPtr");
			types.Add ("array_data", "IntPtr");
			types.Add ("bitarr_data", "IntPtr");
			types.Add ("Offset", "int");
			types.Add ("Q_INT16", "short");
			types.Add ("Q_INT32", "int");
			types.Add ("Q_INT8", "char");
			types.Add ("Q_LONG", "long");
			types.Add ("Q_PACKED", "uint");
			types.Add ("Q_UINT16", "ushort");
			types.Add ("Q_UINT32", "uint");
			types.Add ("Q_UINT8", "char");
			types.Add ("Q_ULONG", "long");
			types.Add ("QStyleHintReturn", "IntPtr");
			types.Add ("QFileInfoList", "IntPtr");
			types.Add ("QDomNodePrivate", "IntPtr");
			types.Add ("GUID", "System.Guid");
			types.Add ("FILE", "string");
			types.Add ("EncoderFn", "int");
			types.Add ("DecoderFn", "int");
			types.Add ("QDiskFont", "IntPtr");
			types.Add ("pointer", "IntPtr");
			types.Add ("T", "IntPtr");
			types.Add ("T1", "IntPtr");
			types.Add ("T2", "IntPtr");
			types.Add ("Iterator", "IntPtr");
			types.Add ("iterator", "IntPtr");
			types.Add ("_iterator", "IntPtr");
			types.Add ("reference", "IntPtr");
			types.Add ("_reference", "IntPtr");
			types.Add ("ConstIterator", "int");
			types.Add ("QWSDisplay", "IntPtr");
			types.Add ("CGContextRef", "IntPtr");
			types.Add ("WId", "uint");
			types.Add ("QWidgetMapper", "IntPtr");
			types.Add ("size_type", "int");
			types.Add ("Item", "IntPtr");
			types.Add ("image_io_handler", "int");
			types.Add ("QCOORD", "short");
			types.Add ("key_type", "IntPtr");
			types.Add ("K", "IntPtr");
			types.Add ("NodePtr", "int");
			types.Add ("QTextFormat", "IntPtr");
			types.Add ("QTextDocument", "IntPtr");
			types.Add ("QTextCursor", "IntPtr");
			types.Add ("_NPStream", "IntPtr");
			types.Add ("PID", "long");
			types.Add ("Region", "int");
			types.Add ("RgnHandle", "IntPtr");
			types.Add ("QRemoteInterface", "IntPtr");
			types.Add ("mode_t", "int");
			types.Add ("QSqlFieldInfo", "IntPtr");
			types.Add ("QSqlRecordInfo", "IntPtr");
			types.Add ("QSqlRecordPrivate", "IntPtr");
			types.Add ("QTSMFI", "int");
			types.Add ("Widget", "QWidget");
			types.Add ("WidgetClass", "int");
			types.Add ("ArgList", "int");
			types.Add ("Cardinal", "int");
			types.Add ("XrmOptionDescRec", "IntPtr");
			types.Add ("size_t", "int");
			types.Add ("ULONG_MAX", "UInt64.MaxValue");

			// Enums
			types.Add ("Event", "QAccessible.Event");
			types.Add ("Role", "QAccessible.Role");
			types.Add ("NavDirection", "QAccessible.NavDirection");
			types.Add ("Text", "QAccessible.Text");
			types.Add ("ColorSpec", "QApplication.ColorSpec");
			types.Add ("ToggleState", "QButton.ToggleState");
			types.Add ("RttiValues", "QCanvasItem.RttiValues");
			types.Add ("FrameAnimationType", "QCanvasSprite.FrameAnimationType");
			types.Add ("Category", "QChar.Category");
			types.Add ("Decomposition", "QChar.Decomposition");
			types.Add ("Joining", "QChar.Joining");
			types.Add ("CombiningClass", "QChar.CombiningClass");
			types.Add ("Spec", "QColor.Spec");
			types.Add ("ColorRole", "QColorGroup.ColorRole");
			types.Add ("Boundary", "QDataBrowser.Boundary");
			types.Add ("ByteOrder", "QDataStream.ByteOrder");
			types.Add ("Refresh", "QDataTable.Refresh");
			types.Add ("Order", "QDateEdit.Order");
			types.Add ("DialogCode", "QDialog.DialogCode");
			types.Add ("FilterSpec", "QDir.FilterSpec");
			types.Add ("SortSpec", "QDir.SortSpec");
			types.Add ("RecordType", "QDns.RecordType");
			types.Add ("HandlePosition", "QDockArea.HandlePosition");
			types.Add ("Place", "QDockWindow.Place");
			types.Add ("CloseMode", "QDockWindow.CloseMode");
			types.Add ("NodeType", "QDomNode.NodeType");
			types.Add ("DragMode", "QDragObject.DragMode");
			types.Add ("Action", "QDropEvent.Action");
			types.Add ("ViewMode", "QFileDialog.ViewMode");
			types.Add ("PreviewMode", "QFileDialog.PreviewMode");
			types.Add ("PermissionSpec", "QFileInfo.PermissionSpec");
			types.Add ("StyleStrategy", "QFont.StyleStrategy");
			types.Add ("Weight", "QFont.Weight");
			types.Add ("Script", "QFont.Script");
			types.Add ("Shadow", "QFrame.Shadow");
			types.Add ("FormatOption", "QGL.FormatOption");
			types.Add ("Corner", "QGridLayout.Corner");
			types.Add ("Size", "QIconSet.Size");
			types.Add ("Arrangement", "QIconView.Arrangement");
			types.Add ("ItemTextPos", "QIconView.ItemTextPos");
			types.Add ("Endian", "QImage.Endian");
			types.Add ("ScaleMode", "QImage.ScaleMode");
			types.Add ("PaintDeviceFlags", "QInternal.PaintDeviceFlags");
			types.Add ("Rules", "QJpUnicodeConv.Rules");
			types.Add ("SegmentStyle", "QLCDNumber.SegmentStyle");
			types.Add ("LayoutMode", "QListBox.LayoutMode");
			types.Add ("WidthMode", "QListView.WidthMode");
			types.Add ("RenameAction", "QListView.RenameAction");
			types.Add ("DockWindows", "QMainWindow.DockWindows");
			types.Add ("Color", "QMapNodeBase.Color");
			types.Add ("Separator", "QMenuBar.Separator");
			types.Add ("Icon", "QMessageBox.Icon");
			types.Add ("Access", "QMetaData.Access");
			types.Add ("Flags", "QMetaProperty.Flags");
			types.Add ("Status", "QMovie.Status");
			types.Add ("InstanceMode", "QNPInstance.InstanceMode");
			types.Add ("StreamMode", "QNPInstance.StreamMode");
			types.Add ("Operation", "QNetworkProtocol.Operation");
			types.Add ("ConnectionState", "QNetworkProtocol.ConnectionState");
			types.Add ("DisposalMethod", "QPNGImageWriter.DisposalMethod");
			types.Add ("PDevCmd", "QPaintDevice.PDevCmd");
			types.Add ("CoordinateMode", "QPainter.CoordinateMode");
			types.Add ("TextDirection", "QPainter.TextDirection");
			types.Add ("ColorGroup", "QPalette.ColorGroup");
			types.Add ("Optimization", "QPixmap.Optimization");
			types.Add ("Edge", "QPolygonScanner.Edge");
			types.Add ("PrinterMode", "QPrinter.PrinterMode");
			types.Add ("PageSize", "QPrinter.PageSize");
			types.Add ("PageOrder", "QPrinter.PageOrder");
			types.Add ("PaperSource", "QPrinter.PaperSource");
			types.Add ("Communication", "QProcess.Communication");
			types.Add ("RegionType", "QRegion.RegionType");
			types.Add ("ResizePolicy", "QScrollView.ResizePolicy");
			types.Add ("ScrollBarMode", "QScrollView.ScrollBarMode");
			types.Add ("RestartHint", "QSessionManager.RestartHint");
			types.Add ("System", "QSettings.System");
			types.Add ("SizeType", "QSizePolicy.SizeType");
			types.Add ("ExpandData", "QSizePolicy.ExpandData");
			types.Add ("TickSetting", "QSlider.TickSetting");
			types.Add ("Op", "QSql.Op");
			types.Add ("Location", "QSql.Location");
			types.Add ("Confirm", "QSql.Confirm");
			types.Add ("DriverFeature", "QSqlDriver.DriverFeature");
			types.Add ("SectionFlags", "QString.SectionFlags");
			types.Add ("PrimitiveElement", "QStyle.PrimitiveElement");
			types.Add ("StyleFlags", "QStyle.StyleFlags");
			types.Add ("SFlags", "QStyle.StyleFlags");
			types.Add ("ControlElement", "QStyle.ControlElement");
			types.Add ("SubRect", "QStyle.SubRect");
			types.Add ("ComplexControl", "QStyle.ComplexControl");
			types.Add ("SubControl", "QStyle.SubControl");
			types.Add ("SCFlags", "QStyle.SubControl");
			types.Add ("PixelMetric", "QStyle.PixelMetric");
			types.Add ("ContentsType", "QStyle.ContentsType");
			types.Add ("StylePixmap", "QStyle.StylePixmap");
			types.Add ("StyleOptionDefault", "QStyleOption.StyleOptionDefault");
			types.Add ("AdditionalStyleValues", "QStyleSheetItem.AdditionalStyleValues");
			types.Add ("DisplayMode", "QStyleSheetItem.DisplayMode");
			types.Add ("WhiteSpaceMode", "QStyleSheetItem.WhiteSpaceMode");
			types.Add ("Margin", "QStyleSheetItem.Margin");
			types.Add ("ListStyle", "QStyleSheetItem.ListStyle");
			types.Add ("FocusStyle", "QTable.FocusStyle");
			types.Add ("EditMode", "QTable.EditMode");
			types.Add ("EditType", "QTableItem.EditType");
			types.Add ("TabletDevice", "QTabletEvent.TabletDevice");
			types.Add ("KeyboardAction", "QTextEdit.KeyboardAction");
			types.Add ("CursorAction", "QTextEdit.CursorAction");
			types.Add ("SaveMode", "QTranslator.SaveMode");
			types.Add ("Prefix", "QTranslatorMessage.Prefix");
			types.Add ("FocusPolicy", "QWidget.FocusPolicy");
			types.Add ("BackgroundOrigin", "QWidget.BackgroundOrigin");
			types.Add ("ButtonState", "Qt.ButtonState");
			types.Add ("AlignmentFlags", "Qt.AlignmentFlags");
			types.Add ("TextFlags", "Qt.TextFlags");
			types.Add ("WidgetState", "Qt.WidgetState");
			types.Add ("WState", "Qt.WidgetState");
			types.Add ("WidgetFlags", "Qt.WidgetFlags");
			types.Add ("WFlags", "Qt.WidgetFlags");
			types.Add ("ImageConversionFlags", "Qt.ImageConversionFlags");
			types.Add ("BGMode", "Qt.BGMode");
			types.Add ("PaintUnit", "Qt.PaintUnit");
			types.Add ("GUIStyle", "Qt.GUIStyle");
			types.Add ("Modifier", "Qt.Modifier");
			types.Add ("Key", "Qt.Key");
			types.Add ("ArrowType", "Qt.ArrowType");
			types.Add ("RasterOp", "Qt.RasterOp");
			types.Add ("PenStyle", "Qt.PenStyle");
			types.Add ("PenCapStyle", "Qt.PenCapStyle");
			types.Add ("PenJoinStyle", "Qt.PenJoinStyle");
			types.Add ("BrushStyle", "Qt.BrushStyle");
			types.Add ("WindowsVersion", "Qt.WindowsVersion");
			types.Add ("UIEffect", "Qt.UIEffect");
			types.Add ("CursorShape", "Qt.CursorShape");
			types.Add ("TextFormat", "Qt.TextFormat");
			types.Add ("Dock", "Qt.Dock");
			types.Add ("DateFormat", "Qt.DateFormat");
			types.Add ("BackgroundMode", "Qt.BackgroundMode");
			types.Add ("StringComparisonMode", "Qt.StringComparisonMode");
			types.Add ("ComparisonFlags", "Qt.StringComparisonMode");

			// Interfaces
			types.Add ("QPaintDevice", "IQPaintDevice");
		}

		string Map (string str)
		{
			return types.Contains (str) ?
				types[str] as string : null;
		}

		public override void Convert (Interface iface)
		{
			base.Convert (iface);
		}

		public override void Convert (Class klass)
		{
			base.Convert (klass);
		}

		public override void Convert (Binge.Bits.Enum enm)
		{
			base.Convert (enm);
		}

		public override void Convert (Field field)
		{
			base.Convert (field);
			string t = Map (field.NativeType);
			if (t != null)
				field.TargetType = t;
		}

		public override void Convert (Property prop)
		{
			base.Convert (prop);
		}

		void Convert (Parameter param)
		{
			string t = Map (param.NativeType);
			if (t != null)
				param.TargetType = t;
		}

		void Convert (MethodBase method)
		{

			Convert (method.Returns);
			ConvertOverloads (method);

			foreach (Parameter param in method.Parameters)
				Convert (param);
		}

		void ConvertOverloads (MethodBase method)
		{
			// Convert param defaults for CSharpQt

			foreach (MethodBase m in method.Overloads)
			{
				foreach (Parameter p in m.CallParameters)
				{
					switch (p.Default)
					{
						case "0":
							p.Default = "null";
							break;
						case "TRUE":
							p.Default = "true";
							break;
						case "FALSE":
							p.Default = "false";
							break;
						default:
							break;

					}
				}
			}
		}

		public override void Convert (Constructor ctor)
		{
			base.Convert (ctor);
			Convert (ctor as MethodBase);
		}

		public override void Convert (Destructor dtor)
		{
			base.Convert (dtor);
			Convert (dtor as MethodBase);
		}

		public override void Convert (Method method)
		{
			base.Convert (method);
			Convert (method as MethodBase);
		}
	}
}
