// QWidgetStack.cs - A Qt to C# binding.
//
// Copyright (C) 2002  Adam Treat (manyoso@yahoo.com)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// Generated File.  Do Not Modify.

namespace Qt {

	using Qt;
	using System;
	using System.Collections;
	using System.Runtime.InteropServices;

	public class QWidgetStack : QFrame, IDisposable {

		private ArrayList widgets;

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_new_QWidgetStack (IntPtr parent, string name);
		public QWidgetStack (QWidget parent, string name) : this (QNull.Instance)
		{
			if ((qparent = parent) != null)
				qparent.AddChild (this);
			rawObject = qt_new_QWidgetStack (parent != null ? parent.RawObject : IntPtr.Zero, name);
			RegisterObject (this);
		}

		public QWidgetStack () : this (new QWidget ()) {}

		public QWidgetStack (QWidget parent) : this (parent, "") {}

		internal QWidgetStack (IntPtr ptr) : this (QNull.Instance)
		{
			rawObject = ptr;
			RegisterObject(this);
		}

		internal QWidgetStack (QNull dummy) : base (QNull.Instance)
		{
			widgets = new ArrayList ();
		}

		~QWidgetStack ()
		{
			Dispose (false);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern void qt_del_QWidgetStack (IntPtr raw);
		internal override void Delete ()
		{
			if (deleted) return;

			qt_del_QWidgetStack (rawObject);
			deleted = true;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern int qt_QWidgetStack_addWidget (IntPtr raw, IntPtr arg1, int arg2);
		public int AddWidget (QWidget arg1, int arg2)
		{
			if (! widgets.Contains (arg1)) widgets.Add (arg1);
			return qt_QWidgetStack_addWidget (RawObject, arg1.RawObject, arg2);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern void qt_QWidgetStack_removeWidget (IntPtr raw, IntPtr arg1);
		public void RemoveWidget (QWidget arg1)
		{
			widgets.Remove (arg1);
			qt_QWidgetStack_removeWidget (RawObject, arg1.RawObject);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QWidgetStack_sizeHint (IntPtr raw);
		public QSize SizeHint ()
		{
			return LookupObject (qt_QWidgetStack_sizeHint (RawObject), typeof(QSize)) as QSize;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QWidgetStack_minimumSizeHint (IntPtr raw);
		public QSize MinimumSizeHint ()
		{
			return LookupObject (qt_QWidgetStack_minimumSizeHint (RawObject), typeof(QSize)) as QSize;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern void qt_QWidgetStack_show (IntPtr raw);
		public void Show ()
		{
			qt_QWidgetStack_show (RawObject);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QWidgetStack_widget (IntPtr raw, int arg1);
		public QWidget Widget (int arg1)
		{
			return LookupObject (qt_QWidgetStack_widget (RawObject, arg1), typeof(QWidget)) as QWidget;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern int qt_QWidgetStack_id (IntPtr raw, IntPtr arg1);
		public int Id (QWidget arg1)
		{
			return qt_QWidgetStack_id (RawObject, arg1.RawObject);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QWidgetStack_visibleWidget (IntPtr raw);
		public QWidget VisibleWidget ()
		{
			return LookupObject (qt_QWidgetStack_visibleWidget (RawObject), typeof(QWidget)) as QWidget;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern void qt_QWidgetStack_setFrameRect (IntPtr raw, IntPtr arg1);
		public void SetFrameRect (QRect arg1)
		{
			qt_QWidgetStack_setFrameRect (RawObject, arg1.RawObject);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern void qt_QWidgetStack_raiseWidget (IntPtr raw, int arg1);
		public void RaiseWidget (int arg1)
		{
			qt_QWidgetStack_raiseWidget (RawObject, arg1);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern void qt_QWidgetStack_raiseWidget1 (IntPtr raw, IntPtr arg1);
		public void RaiseWidget (QWidget arg1)
		{
			qt_QWidgetStack_raiseWidget1 (RawObject, arg1.RawObject);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern void qt_QWidgetStack_frameChanged (IntPtr raw);
		protected void FrameChanged ()
		{
			qt_QWidgetStack_frameChanged (RawObject);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern void qt_QWidgetStack_setChildGeometries (IntPtr raw);
		protected void SetChildGeometries ()
		{
			qt_QWidgetStack_setChildGeometries (RawObject);
		}

		public int AddWidget (QWidget arg1)
		{
			return AddWidget(arg1, (int) -1);
		}

		// Begin interface methods.

	}
}
