/***************************************************************************
* $Id: ButtonsGroups.java,v 1.1 2002/02/25 12:09:00 rdale Exp $
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/
import org.kde.qt.*;

class ButtonsGroups extends QWidget
{
protected QCheckBox state;
protected QRadioButton rb21, rb22, rb23;




/*
  Constructor
 *
  Creates all child widgets of the ButtonGroups window
 */

public ButtonsGroups( )
{
	this(null, null);
}

public ButtonsGroups( QWidget parent, String name )
{
    super( parent, name );
    // Create Widgets which allow easy layouting
    QVBoxLayout vbox = new QVBoxLayout( this );
    QHBoxLayout box1 = new QHBoxLayout( vbox );
    QHBoxLayout box2 = new QHBoxLayout( vbox );

    // ------- first group

    // Create an exclusive button group
    QButtonGroup bgrp1 = new QButtonGroup( 1, QGroupBox.Horizontal, "Button Group 1 (exclusive)", this);
    box1.addWidget( bgrp1 );
    bgrp1.setExclusive( true );

    // insert 3 radiobuttons
    QRadioButton rb11 = new QRadioButton( "&Radiobutton 1", bgrp1 );
    rb11.setChecked( true );
    new QRadioButton( "R&adiobutton 2", bgrp1 );
    new QRadioButton( "Ra&diobutton 3", bgrp1 );

    // ------- second group

    // Create a non-exclusive buttongroup
    QButtonGroup bgrp2 = new QButtonGroup( 1, QGroupBox.Horizontal, "Button Group 2 (non-exclusive)", this );
    box1.addWidget( bgrp2 );
    bgrp2.setExclusive( false );

    // insert 3 checkboxes
    new QCheckBox( "&Checkbox 1", bgrp2 );
    QCheckBox cb12 = new QCheckBox( "C&heckbox 2", bgrp2 );
    cb12.setChecked( true );
    QCheckBox cb13 = new QCheckBox( "Triple &State Button", bgrp2 );
    cb13.setTristate( true );
    cb13.setChecked( true );

    // ------------ third group

    // create a buttongroup which is exclusive for radiobuttons and non-exclusive for all other buttons
    QButtonGroup bgrp3 = new QButtonGroup( 1, QGroupBox.Horizontal, "Button Group 3 (Radiobutton-exclusive)", this );
    box2.addWidget( bgrp3 );
    bgrp3.setRadioButtonExclusive( true );

    // insert three radiobuttons
    rb21 = new QRadioButton( "Rad&iobutton 1", bgrp3 );
    rb22 = new QRadioButton( "Radi&obutton 2", bgrp3 );
    rb23 = new QRadioButton( "Radio&button 3", bgrp3 );
    rb23.setChecked( true );

    // insert a checkbox...
    state = new QCheckBox( "E&nable Radiobuttons", bgrp3 );
    state.setChecked( true );
    // ...and connect its SIGNAL clicked() with the SLOT slotChangeGrp3State()
    connect( state, SIGNAL(" clicked()"), this, SLOT(" slotChangeGrp3State()") );

    // ------------ fourth group

    // create a groupbox which layouts its childs in a columns
    QGroupBox bgrp4 = new QButtonGroup( 1, QGroupBox.Horizontal, "Groupbox with normal buttons", this );
    box2.addWidget( bgrp4 );

    // insert three pushbuttons...
    new QPushButton( "&Push Button", bgrp4 );
    QPushButton tb2 = new QPushButton( "&Toggle Button", bgrp4 );
    QPushButton tb3 = new QPushButton( "&Flat Button", bgrp4 );

    // ... and make the second one a toggle button
    tb2.setToggleButton( true );
    tb2.setOn( true );

    // ... and make the third one a flat button
    tb3.setFlat(true);
}

/*
  SLOT slotChangeGrp3State()
 *
  enables/disables the radiobuttons of the third buttongroup
 */

public void slotChangeGrp3State()
{
    rb21.setEnabled( state.isChecked() );
    rb22.setEnabled( state.isChecked() );
    rb23.setEnabled( state.isChecked() );
}
}
