/***************************************************************************
                            MidiMapper.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef MIDIMAPPER_H
#define MIDIMAPPER_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 A Midi Mapper class which defines the way MIDI events are translated
 (or "mapped") to different ones. This way, when two MIDI devices "talk"
 in a somehow different way, they can still communicate.

 When the user has an external keyboard that is not compatible with the
 General Midi standard, he can use a MIDI mapper file to play files
 as if the synthesizer was GM compatible.

 Please see the KMid documentation 
 ( http://www.arrakis.es/~rlarrosa/kmid.html ) for information on the
 format of a MIDI mapper definition file, and how they work.

 I created this class because I had one of those non-GM keyboards, 
 so it can do everything I needed it to do for my keyboard to work
 exactly as a GM synth, and a few more things. Currently, it's the most
 featured MIDI mapper available.

 The usage of this class is quite simple, just create an object with
 a correct filename in the constructor and then use this object as
 parameter for @ref -[DeviceManager setMidiMap].

 @author Antonio Larrosa Jimenez <larrosa@kde.org>  
 
 @version 0.9.5 17/01/2000

 @short Midi Mapper.
*/
@interface  MidiMapper : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 Constructor. Loads a MIDI Mapper definition from a file.

*/
- initWithText: (NSString *)name;

/** 
 Destructor.
     
*/
- (void) dealloc;

/** 
 Loads a MIDI Mapper definition file (you don't need to use this if you
 used a correct filename in constructor). 
     
*/
- loadFile: (NSString *)name;

/** 
 Returns the status of the object.
     
*/
- (int) ok;

/**  
 Returns the channel which chn should be mapped to.
     
*/
- (unsigned char) channel: (unsigned char)chn;

/**  
 Returns the patch which pgm used on channel chn should be mapped to.
     
*/
- (unsigned char) patch: (unsigned char)chn pgm: (unsigned char)pgm;

/**  
 Returns the key that key note playing a pgm patch on channel chn should
 be mapped to.
     
*/
- (unsigned char) key: (unsigned char)chn pgm: (unsigned char)pgm note: (unsigned char)note;

/** 
 Returns the value which the pitch bender on channel chn should be
 mapped to.
     
*/
- pitchBender: (unsigned char)chn lsb: (unsigned char)lsb msb: (unsigned char)msb;

/** 
 Returns the value which a given controller and its value should
 be mapped to when played on channel chn.
     
*/
- controller: (unsigned char)chn ctl: (unsigned char)ctl v: (unsigned char)v;

/** 
 Returns the path and name of the file which the object loaded the
 mapper from.
     
*/
- (NSString *) filename;
@end

#endif
